﻿-- Addon: WoWpoPolsku-UI (version: 1.04) 2018.03.16
-- Description: AddOn displays translated UI in Polish.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- WWW: http://wowpopolsku.pl

-- General Variables
local UiT_version="1.04";
-- fonty z polskimi znakami diakrytycznymi (także innych narodów)
local UiT_Font = "Interface\\AddOns\\WoWpoPolsku_UI\\Fonts\\frizquadratatt_pl.ttf";
local StartCollection = 0;
local StartTalent = 0;
local UiT = CreateFrame("Frame");


function UiT_OnEvent()

   local _font1, _size1, _31 = getglobal("GameTooltipTextLeft1"):GetFont();
   local _font2, _size2, _32 = getglobal("GameTooltipTextLeft2"):GetFont();
   getglobal("GameTooltipTextLeft1"):SetFont(UiT_Font, _size1);
   getglobal("GameTooltipTextLeft2"):SetFont(UiT_Font, _size2);
   
-- "Information about your character, including equipment, combat statistics, and reputation."
   CharacterMicroButton.newbieText = "Informacje o twojej postaci, w tym o sprzęcie, statystykach walki i reputacji.";

-- "The array of talents available to enhance and specialize your character."
   TalentMicroButton.newbieText = "Szereg talentów dostępnych do wzmocnienia i specjalizacji swojej postaci.";
-- "This feature becomes available at level 10."  
   TalentMicroButton.disabledTooltip = "Ta funkcja staje się dostępna od poziomu 10.";
  
-- "View information about your achievements and statistics."
   AchievementMicroButton.newbieText = "Wyświetl informacje o swoich osiągnięciach i statystykach.";
-- "This feature becomes available at level 10."  
   AchievementMicroButton.disabledTooltip = "Ta funkcja staje się dostępna od poziomu 10.";
  
-- "A list of all the active quests you currently have. You can have up to 25 active quests at one time."
   QuestLogMicroButton.newbieText = "Lista wszystkich aktywnych zadań, które aktualnie posiadasz. Możesz mieć do 25 aktywnych zadań naraz.";

-- "Allows you to find a guild."
   GuildMicroButton.newbieText = "Pozwala ci znaleźć gildię.";
-- "Starter Edition accounts cannot perform that action"
   GuildMicroButton.disabledTooltip = "Konta w Wersji dla Początkujących nie mogą wykonać tej czynności";
  
-- "A tool to find a group to complete a dungeon."
   LFDMicroButton.newbieText = "Narzędzie do znalezienia grupy, aby razem ukończyć loch.";
-- "This feature becomes available at level 10."
   LFDMicroButton.disabledTooltip = "Ta funkcja staje się dostępna od poziomu 10.";
  
-- "View all the mounts and pets you have. Also allows you to manage your pets' abilities if you are a Pet Trainer."
   CollectionsMicroButton.newbieText = "Zobacz wszystkie wierzchowce i zwierzęta, które masz. Pozwala także zarządzać umiejętnościami zwierząt, jeśli jesteś trenerem zwierząt.";
-- CollectionsMicroButton.disabledTooltip;
  
-- "View information about Cataclysm dungeon and raid bosses, including their abilities and treasure."
   EJMicroButton.newbieText = "Zobacz informacje o lochach i bossach rajdowych Cataclysm, w tym ich zdolnościach i skarbach.";
-- "This feature's not yet available."
   EJMicroButton.disabledTooltip = "Ta funkcja nie jest jeszcze dostępna.";
  
-- "Starter Edition accounts cannot perform that action"
   StoreMicroButton.disabledTooltip = "Konta w Wersji dla Początkujących nie mogą wykonać tej czynności";
  
-- "Game Menu |cffffd200(Escape)|r"
   MainMenuMicroButton.tooltipText = string.gsub(MainMenuMicroButton.tooltipText, "Game Menu", "Menu Gry");
-- "Modify your settings, change your hotkeys or exit the game."
   MainMenuMicroButton.newbieText = "Zmodyfikuj ustawienia, zmień skróty klawiszowe lub wyjdź z gry.";
   
   GameMenuButtonHelp.Text:SetText("Pomoc");
   GameMenuButtonOptions.Text:SetText("Opcje systemowe");
   GameMenuButtonUIOptions.Text:SetText("Ustawienia UI");
   GameMenuButtonKeybindings.Text:SetText("Klawiszologia");
   GameMenuButtonMacros.Text:SetText("Makra");
   GameMenuButtonAddons.Text:SetText("Dodatki");
   GameMenuButtonLogout.Text:SetText("Wyloguj");
   GameMenuButtonQuit.Text:SetText("Wyjście z gry");
   local _font3, _size3, _33 = GameMenuButtonQuit.Text:GetFont();
   GameMenuButtonQuit.Text:SetFont(UiT_Font, _size3);
   GameMenuButtonContinue.Text:SetText("Powrót do gry");
   local _font4, _size4, _34 = GameMenuButtonContinue.Text:GetFont();
   GameMenuButtonContinue.Text:SetFont(UiT_Font, _size4);
   GameMenuButtonStore.Text:SetText("Sklep");
   GameMenuButtonWhatsNew.Text:SetText("Co nowego");
   GameMenuButtonRatings.Text:SetText("Klasyfikacja");

   CharacterFrameTab1Text:SetText("Postać");
   local _font5, _size5, _35 = CharacterFrameTab1Text:GetFont();
   CharacterFrameTab1Text:SetFont(UiT_Font, _size5);
   CharacterFrameTab2Text:SetText("Reputacja");
   CharacterStatsPane.AttributesCategory.Title:SetText("Atrybuty");
   CharacterStatsPane.EnhancementsCategory.Title:SetText("Ulepszenia");
   ReputationFrameFactionLabel:SetText("Frakcja");
   local _font6, _size6, _36 = ReputationFrameFactionLabel:GetFont();
   ReputationFrameFactionLabel:SetFont(UiT_Font, _size6);
   ReputationFrameStandingLabel:SetText("Poziom");
   
   ObjectiveTrackerBlocksFrame.QuestHeader.Text:SetText("Zadania");
   QuestFrameAcceptButtonText:SetText("Akceptuj");
   QuestFrameCompleteQuestButtonText:SetText("Zakończ zadanie");
   local _font7, _size7, _37 = QuestFrameCompleteQuestButtonText:GetFont();
   QuestFrameCompleteQuestButtonText:SetFont(UiT_Font, _size7);
  
   VideoOptionsFrameOkayText:SetText("Gotowe");
   VideoOptionsFrameCancelText:SetText("Anuluj");
   VideoOptionsFrameDefaultsText:SetText("Ust. zalecane");
   
   AddonListTitleText:SetText("Lista dodatków (AddOn)");
   AddonListEnableAllButtonText:SetText("Włącz wszystkie");
   AddonListEnableAllButtonText:SetFont(UiT_Font, _size7);
   AddonListDisableAllButtonText:SetText("Wyłącz wszystkie");
   AddonListDisableAllButtonText:SetFont(UiT_Font, _size7);
   AddonListCancelButtonText:SetText("Anuluj");
   
   ChatFrame1TabText:SetText("Okno czatu");
   ChatFrame2TabText:SetText("Okno walki");
--   DropDownList1MenuBackdrop:HookScript("OnShow", UiT_onChatBackFrame);
   
   ChatConfigFrameDefaultButtonText:SetText("Ust. domyślne");
   local _font8, _size8, _38 = ChatConfigFrameDefaultButtonText:GetFont();
   ChatConfigFrameDefaultButtonText:SetFont(UiT_Font, _size8);
   ChatConfigFrameRedockButtonText:SetText("Resetuj pozycje czatu");
   ChatConfigFrameOkayButtonText:SetText("Gotowe");
   ChatConfigCategoryFrameTitle:SetText("Kategorie:");
   ChatConfigCategoryFrameButton1NormalText:SetText("Czat");
   ChatConfigCategoryFrameButton3NormalText:SetText("Kanały globalne");
   local _font9, _size9, _39 = ChatConfigCategoryFrameButton3NormalText:GetFont();
   ChatConfigCategoryFrameButton3NormalText:SetFont(UiT_Font, _size9);
   ChatConfigCategoryFrameButton4NormalText:SetText("Inne");
   ChatConfigChatSettingsLeftTitle:SetText("Wiadomość od gracza");
   local _font10, _size10, _310 = ChatConfigChatSettingsLeftTitle:GetFont();
   ChatConfigChatSettingsLeftTitle:SetFont(UiT_Font, _size10);
   ChatConfigChatSettingsLeftColorHeader:SetText("Kolor");
   ChatConfigChatSettingsLeftClassColorHeader:SetText("Pokaż kolor klasy");
   local _font11, _size11, _311 = ChatConfigChatSettingsLeftClassColorHeader:GetFont();
   ChatConfigChatSettingsLeftClassColorHeader:SetFont(UiT_Font, _size11);
   ChatConfigChatSettingsClassColorLegendTitle:SetText("Kolory klas:");
   ChatConfigChannelSettingsLeftTitle:SetText("Kanały:");
   ChatConfigChannelSettingsLeftTitle:SetFont(UiT_Font, _size10);
   ChatConfigChannelSettingsLeftColorHeader:SetText("Kolor");
   ChatConfigChannelSettingsLeftClassColorHeader:SetText("Pokaż kolor klasy");
   ChatConfigChannelSettingsLeftClassColorHeader:SetFont(UiT_Font, _size11);
   ChatConfigChannelSettingsClassColorLegendTitle:SetText("Kolory klas:");
   ChatConfigOtherSettingsCombatTitle:SetText("Walka");
   ChatConfigOtherSettingsSystemTitle:SetText("Inne");
   ChatConfigOtherSettingsCreatureTitle:SetText("Wiadomości Kreatur");
   local _font12, _size12, _312 = ChatConfigOtherSettingsCreatureTitle:GetFont();
   ChatConfigOtherSettingsCreatureTitle:SetFont(UiT_Font, _size12);
   
   FriendsFrameAddFriendButtonText:SetText("Dodaj przyjaciela");
   FriendsFrameSendMessageButtonText:SetText("Wyślij wiadomość");
   FriendsFrameSendMessageButtonText:SetFont(UiT_Font, _size3);
   FriendsFrameIgnorePlayerButtonText:SetText("Zignoruj gracza");
   FriendsFrameUnsquelchButtonText:SetText("Usuń gracza");
   FriendsFrameUnsquelchButtonText:SetFont(UiT_Font, _size3);
   QuickJoinFrameText:SetText("Prośba o dołączenie");
   QuickJoinFrameText:SetFont(UiT_Font, _size3);
   ChannelFrameNewButtonText:SetText("Dodaj");
   FriendsFrameTab1Text:SetText("Przyjaciele");
   FriendsFrameTab2Text:SetText("KTO");
   FriendsFrameTab3Text:SetText("Czat");
   FriendsFrameTab4Text:SetText("Rajd");
   FriendsFrameTitleText:SetText("Lista przyjaciół");
   local _font13, _size13, _313 = FriendsFrameTitleText:GetFont();
   FriendsFrameTitleText:SetFont(UiT_Font, _size13);
   FriendsTabHeaderTab1Text:SetText("Przyjaciele");
   FriendsTabHeaderTab2Text:SetText("Połącz szybko");
   local _font14, _size14, _314 = FriendsTabHeaderTab2Text:GetFont();
   FriendsTabHeaderTab2Text:SetFont(UiT_Font, _size14);
   FriendsTabHeaderTab3Text:SetText("Ignorowane");
   
   ContainerFrame1Name:SetText("Plecak");
   TimeManagerAlarmEnabledButtonText:SetText("Włącz budzik");
   local _font15, _size15, _315 = TimeManagerAlarmEnabledButtonText:GetFont();
   TimeManagerAlarmEnabledButtonText:SetFont(UiT_Font, _size15);
   TimeManagerAlarmMessageLabel:SetText("Tekst alarmu:");
   TimeManagerAlarmTimeLabel:SetText("Czas alarmu:");
   TimeManagerLocalTimeCheckText:SetText("Użyj czasu lokalnego");
   TimeManagerLocalTimeCheckText:SetFont(UiT_Font, _size15);
   TimeManagerMilitaryTimeCheckText:SetText("Tryb 24-godzinny");
   TimeManagerStopwatchFrameText:SetText("Pokaż stoper");
   TimeManagerStopwatchFrameText:SetFont(UiT_Font, _size15);
   StopwatchTitle:SetText("Stoper");
   
end


function UiT_onChatBackFrame()
   local _font1, _size1, _31 = DropDownList1Button1NormalText:GetFont();
   DropDownList1Button1NormalText:SetText("Odblokuj okno");
   DropDownList1Button1NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button2NormalText:SetText("Bądź nieinteraktywny");
   DropDownList1Button2NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button3NormalText:SetText("Zmień nazwę okna");
   DropDownList1Button3NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button3:HookScript("OnClick", UiT_onDropDownList1Button3);
   DropDownList1Button4NormalText:SetText("Utwórz nowe okno");
   DropDownList1Button4NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button4:HookScript("OnClick", UiT_onDropDownList1Button4);
   DropDownList1Button5NormalText:SetText("Wyświetl");
   DropDownList1Button5NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button6NormalText:SetText("Wielkość czcionki");
   DropDownList1Button6NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button7NormalText:SetText("Tło");
   DropDownList1Button7NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button6:HookScript("OnClick", UiT_onDropDownList1Button7);  -- okno walki
   DropDownList1Button7:HookScript("OnClick", UiT_onDropDownList1Button7);	-- okno czatu
   DropDownList1Button8NormalText:SetText("Filtry");
   DropDownList1Button8NormalText:SetFont(UiT_Font, _size1);
   DropDownList1Button9NormalText:SetText("Ustawienia");
   DropDownList1Button9NormalText:SetFont(UiT_Font, _size1);
end


function UiT_onDropDownList1Button3()
--   StaticPopup1Text:SetText("Wprowadź nową nazwę okna czatu");
--   local _font2, _size2, _32 = StaticPopup1Text:GetFont();
--   StaticPopup1Text:SetFont(UiT_Font, _size2);
   StaticPopup1Button1Text:SetText("Akceptuj");
   StaticPopup1Button2Text:SetText("Anuluj");
end


function UiT_onDropDownList1Button4()
--   StaticPopup1Text:SetText("Wprowadź nazwę nowego okna czatu");
--   local _font2, _size2, _32 = StaticPopup1Text:GetFont();
--   StaticPopup1Text:SetFont(UiT_Font, _size2);
   StaticPopup1Button1Text:SetText("Akceptuj");
   StaticPopup1Button2Text:SetText("Anuluj");
end


function UiT_onDropDownList1Button7()
   ColorPickerOkayButtonText:SetText("Gotowe");
   ColorPickerCancelButtonText:SetText("Anuluj");
end


function UiT_onCharacterMicroButton()    -- "Character Info |cffffd200(C)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Informacje o postaci |cffffd200("..GetBindingText(GetBindingKey("TOGGLECHARACTER0"))..")|r");
  GameTooltip:Show();
end


function UiT_onSpellbookMicroButton()    -- "Spellbook & Abilities |cffffd200(P)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Księga czarów i zdolności |cffffd200("..GetBindingText(GetBindingKey("TOGGLESPELLBOOK"))..")|r");
  GameTooltip:Show();
end


function UiT_onTalentMicroButton()       -- "Specialization & Talents |cffffd200(N)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Specjalizacja i talenty |cffffd200("..GetBindingText(GetBindingKey("TOGGLETALENTS"))..")|r");
  getglobal("GameTooltipTextLeft2"):SetText("Ta funkcja staje się dostępna od poziomu 10.");
  GameTooltip:Show();
end


function UiT_onAchievementMicroButton()  -- "Achievements |cffffd200(Y)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Osiągnięcia |cffffd200("..GetBindingText(GetBindingKey("TOGGLEACHIEVEMENT"))..")|r");
  GameTooltip:Show();
end


function UiT_onQuestLogMicroButton()     -- "Quest Log |cffffd200(L)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Dziennik zadań |cffffd200("..GetBindingText(GetBindingKey("TOGGLEQUESTLOG"))..")|r");
  GameTooltip:Show();
end


function UiT_onGuildMicroButton()        -- "Guild Finder |cffffd200(J)|r"
  local quildName = GetGuildInfo("player");
  if (quildName == nil) then
     getglobal("GameTooltipTextLeft1"):SetText("Wyszukiwanie Gildii |cffffd200("..GetBindingText(GetBindingKey("TOGGLEGUILDTAB"))..")|r");
  else
     getglobal("GameTooltipTextLeft1"):SetText("Gildia |cffffd200("..GetBindingText(GetBindingKey("TOGGLEGUILDTAB"))..")|r");
  end  
  getglobal("GameTooltipTextLeft2"):SetText("Konta w Wersji dla Początkujących nie mogą wykonać tej czynności");
  GameTooltip:Show();
end


function UiT_onLFDMicroButton()          -- "Group Finder |cffffd200(I)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Wyszukiwarka Grup |cffffd200("..GetBindingText(GetBindingKey("TOGGLEGROUPFINDER"))..")|r");
  getglobal("GameTooltipTextLeft2"):SetText("Ta funkcja staje się dostępna od poziomu 10.");
  GameTooltip:Show();
end


function UiT_onCollectionsMicroButton()  -- "Collections"
  getglobal("GameTooltipTextLeft1"):SetText("Kolekcje");
  GameTooltip:Show();
end


function UiT_onEJMicroButton()           -- "Adventure Guide |cffffd200(SHIFT-J)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Przewodnik przygód |cffffd200("..GetBindingText(GetBindingKey("TOGGLEENCOUNTERJOURNAL"))..")|r");
  getglobal("GameTooltipTextLeft2"):SetText("Ta funkcja nie jest jeszcze dostępna.");
  GameTooltip:Show();
end


function UiT_onStoreMicroButton()        -- "Shop"
  getglobal("GameTooltipTextLeft1"):SetText("Sklep");
  getglobal("GameTooltipTextLeft2"):SetText("Konta w Wersji dla Początkujących nie mogą wykonać tej czynności");
  GameTooltip:Show();
end


function UiT_onMainMenuMicroButton()  -- "Game Menu |cffffd200(Escape)|r"
  getglobal("GameTooltipTextLeft1"):SetText("Menu Gry |cffffd200("..GetBindingText(GetBindingKey("TOGGLEEGAMEMENU"))..")|r");
  GameTooltip:Show();
end


local UiT_waitTable = {};
local UiT_waitFrame = nil;
function UiT_wait(delay, func, ...)
  if(type(delay)~="number" or type(func)~="function") then
    return false;
  end
  if(UiT_waitFrame == nil) then
    UiT_waitFrame = CreateFrame("Frame","UiT_WaitFrame", UIParent);
    UiT_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #UiT_waitTable;
      local i = 1;
      while(i<=count) do
        local waitRecord = tremove(UiT_waitTable,i);
        local d = tremove(waitRecord,1);
        local f = tremove(waitRecord,1);
        local p = tremove(waitRecord,1);
        if(d>elapse) then
          tinsert(UiT_waitTable,i,{d-elapse,f,p});
          i = i + 1;
        else
          count = count - 1;
          f(unpack(p));
        end
      end
    end);
  end
  tinsert(UiT_waitTable,{delay,func,{...}});
  return true;
end


function UiT_onSpellBookFrame()
  SpellBookFrameTabButton1Text:SetText("Zaklęcia");
  local _font1, _size1, _31 = SpellBookFrameTabButton1Text:GetFont();
  SpellBookFrameTabButton1Text:SetFont(UiT_Font, _size1);
  SpellBookFrameTabButton2Text:SetText("Umiejętności");
  local _font2, _size2, _32 = SpellBookFrameTabButton2Text:GetFont();
  SpellBookFrameTabButton2Text:SetFont(UiT_Font, _size2);
  SpellBookFrameTabButton3Text:SetText("Zwierzak");
  SpellBookFrameTitleText:SetText("Księga czarów i umiejętności");  
  local _font3, _size3, _33 = SpellBookFrameTitleText:GetFont();
  SpellBookFrameTitleText:SetFont(UiT_Font, _size2);
  if (SpellBookProfessionFrame:IsVisible()) then
     if (not UiT_wait(0.5,UiT_Professions)) then
     --- opóźnienie 0.5 sek.
     end
  end
  if (SpellBookSpellIconsFrame:IsVisible()) then
     if (not UiT_wait(0.5,UiT_SpellIcons)) then
     --- opóźnienie 0.5 sek.
     end
  end 
end


function UiT_SpellIcons()
  SpellBookFrameTitleText:SetText("Księga czarów");  
end


function UiT_Professions()
  SpellBookFrameTitleText:SetText("Umiejętności");
end


--function UiT_onTalentFrame()
--  PlayerTalentFrameTab1Text:SetText("Specjalizaja");
--  PlayerTalentFrameTab2Text:SetText("Talenty");
--  PlayerTalentFrameSpecializationLearnButtonText:SetText("Aktywuj");
--  PlayerTalentFrameTitleText:SetText("Specjalizacja i talenty");
--end


function UiT_onQuestMapFrame()
  QuestMapFrame.DetailsFrame.BackButton:SetText("Wstecz");
  QuestMapFrame.DetailsFrame.AbandonButton:SetText("Zrezygnuj");
  QuestMapFrame.DetailsFrame.ShareButton:SetText("Podziel sie");
  --if (IsQuestWatched(GetQuestLogSelection())) then				-- nazwa przycisku zmienia się co chwila
  --   QuestMapFrame.DetailsFrame.TrackButton:SetText("Przestań śledzić");
  --else
  --   QuestMapFrame.DetailsFrame.TrackButton:SetText("Śledź zadania");
  --end 
end


function UiT_onQuestAbandonFrame()
  if (StaticPopup1.which=="ABANDON_QUEST") then
    local oryg_pyt=StaticPopup1Text:GetText();
    oryg_pyt = string.gsub(oryg_pyt, "Abandon", "Zrezygnuj z");
    StaticPopup1Text:SetText(oryg_pyt);
    StaticPopup1Button1Text:SetText("Tak");
    StaticPopup1Button2Text:SetText("Nie");
  end
end


function UiT_onCollectionButtonClick()
  if  ((CollectionsJournal) and (StartCollection==0)) then
     StartCollection = 1;
	 CollectionsJournalTitleText:SetText("Kolekcje");
     local _font0, _size0, _30 = CollectionsJournalTitleText:GetFont();
	 CollectionsJournalTitleText:SetFont(UiT_Font, _size0);
     MountJournal.MountCount.Label:SetText("Liczba wierzchowców");
	 MountJournalSearchBox.Instructions:SetText("Szukaj");
	 MountJournalFilterButtonText:SetText("Filtr");
	 MountJournalMountButtonText:SetText("Dosiadaj");
	 PetJournal.PetCount.Label:SetText("Liczba zwierzaków");
	 PetJournalSearchBox.Instructions:SetText("Szukaj");
	 PetJournalFilterButtonText:SetText("Filtr");
	 PetJournalSummonButtonText:SetText("Przywołaj");
     local _font1, _size1, _31 = PetJournalSummonButtonText:GetFont();
	 PetJournalSummonButtonText:SetFont(UiT_Font, _size1);
	 HeirloomsJournalSearchBox.Instructions:SetText("Szukaj");
	 HeirloomsJournalFilterButtonText:SetText("Filtr");
	 ToyBox.searchBox.Instructions:SetText("Szukaj");
	 ToyBoxFilterButtonText:SetText("Filtr");
	 CollectionsJournalTab1:SetText("Wierzchowce");
	 CollectionsJournalTab2:SetText("Zwierzak");
	 CollectionsJournalTab3:SetText("Zabawki");
	 CollectionsJournalTab4:SetText("Pamiątki");
     local _font2, _size2, _32 = CollectionsJournalTab4Text:GetFont();
	 CollectionsJournalTab4Text:SetFont(UiT_Font, _size2);
	 CollectionsJournalTab5:SetText("Wygląd");
     local _font3, _size3, _33 = CollectionsJournalTab5Text:GetFont();
	 CollectionsJournalTab5Text:SetFont(UiT_Font, _size3);
	 WardrobeCollectionFrameSearchBox.Instructions:SetText("Szukaj");
	 WardrobeCollectionFrame.FilterButton:SetText("Filtr");
	 WardrobeCollectionFrameTab1:SetText("Przedmioty");
	 WardrobeCollectionFrameTab2:SetText("Zestawy");
	 CollectionsJournalTab1:HookScript("OnClick", UiT_onCollection1Frame);
	 CollectionsJournalTab2:HookScript("OnClick", UiT_onCollection2Frame);
	 CollectionsJournalTab3:HookScript("OnClick", UiT_onCollection3Frame);
	 CollectionsJournalTab4:HookScript("OnClick", UiT_onCollection4Frame);
	 CollectionsJournalTab5:HookScript("OnClick", UiT_onCollection5Frame);
  end
end


function UiT_onCollection1Frame()
  MountJournalMountButtonText:SetText("Dosiadaj");
  CollectionsJournalTitleText:SetText("Wierzchowce");
end


function UiT_onCollection2Frame()
  CollectionsJournalTitleText:SetText("Zwierzak");
end


function UiT_onCollection3Frame()
  CollectionsJournalTitleText:SetText("Zabawki");
end


function UiT_onCollection4Frame()
  CollectionsJournalTitleText:SetText("Pamiątki");
end


function UiT_onCollection5Frame()
  CollectionsJournalTitleText:SetText("Wygląd");
end


function UiT_onTalentButtonClick()
  if  ((PlayerTalentFrame) and (StartTalent==0)) then
     StartTalent = 1;
     PlayerTalentFrameTitleText:SetText("Specjalizacja i Talenty");
     PlayerTalentFrameTab1Text:SetText("Specjalizacja");
     PlayerTalentFrameTab2Text:SetText("Talenty");
     PlayerTalentFrameTab3Text:SetText("Talenty Honoru");
     PlayerTalentFrameTab4Text:SetText("Zwierzak");
     PlayerTalentFrameSpecializationLearnButtonText:SetText("Aktywuj");
     PlayerTalentFrame:HookScript("OnShow", UiT_onTalentShow);
  end
end


function UiT_onTalentShow()			-- wypisz tytuł okna z opóźnieniem 0.2 sek
  if (not UiT_wait(0.2,UiT_ShowTalentTitle)) then
  --- opóźnienie 0.2 sek.
  end
end


function UiT_ShowTalentTitle()
  PlayerTalentFrameTitleText:SetText("Specjalizacja i Talenty");
end


function UiT_UpdateMicroButtons()
  if (TalentMicroButton:GetButtonState()=="PUSHED") then
     UiT_onTalentButtonClick();
  end
end


function UiT_onVideoFrame()
  VideoOptionsFrameCategoryFrameButton1Text:SetText("Grafika");
  VideoOptionsFrameCategoryFrameButton2Text:SetText("Zaawansowane");
  VideoOptionsFrameCategoryFrameButton3Text:SetText("Sieć");
  local _font1, _size1, _31 = VideoOptionsFrameCategoryFrameButton3Text:GetFont();
  VideoOptionsFrameCategoryFrameButton3Text:SetFont(UiT_Font, _size1);
  VideoOptionsFrameCategoryFrameButton4Text:SetText("Języki");
  VideoOptionsFrameCategoryFrameButton4Text:SetFont(UiT_Font, _size1);
  VideoOptionsFrameCategoryFrameButton5Text:SetText("Dźwięk");
  VideoOptionsFrameCategoryFrameButton5Text:SetFont(UiT_Font, _size1);
  
  Display_DisplayHeader:SetText("Ekran");
  Display_DisplayModeDropDownLabel:SetText("Tryb ekranu");
  local _fontL, _sizeL, _3L = Display_DisplayModeDropDownLabel:GetFont();
  Display_DisplayModeDropDownLabel:SetFont(UiT_Font, _sizeL);
  Display_ResolutionDropDownLabel:SetText("Rozdzielczość");
  Display_ResolutionDropDownLabel:SetFont(UiT_Font, _sizeL);
  Display_RefreshDropDownLabel:SetText("Częst. odświeżania");
  Display_RefreshDropDownLabel:SetFont(UiT_Font, _sizeL);
  Display_PrimaryMonitorDropDownLabel:SetText("Monitor");
  Display_PrimaryMonitorDropDownLabel:SetFont(UiT_Font, _sizeL);
  Display_AntiAliasingDropDownLabel:SetText("Wygładzanie krawędzi");
  Display_AntiAliasingDropDownLabel:SetFont(UiT_Font, _sizeL);
  Display_VerticalSyncDropDownLabel:SetText("Synchronizacja pionowa");
  Display_VerticalSyncDropDownLabel:SetFont(UiT_Font, _sizeL);
  
  GraphicsButtonText:SetText("Ust. bazowe");
  RaidButtonText:SetText("Rajd i Pole bitwy");
  Display_EnableRaidSettingsText:SetText("Włącz ustawienia Rajdu i Pola bitwy");
  local _font4, _size4, _34 = Display_EnableRaidSettingsText:GetFont();
  Display_EnableRaidSettingsText:SetFont(UiT_Font, _size4);
  Graphics_Quality_Title:SetText("Jakość grafiki");
  local _font5, _size5, _35 = Graphics_Quality_Title:GetFont();
  Graphics_Quality_Title:SetFont(UiT_Font, _size5);
  Graphics_TexturesHeader:SetText("Tekstury");
  Graphics_TextureResolutionDropDownLabel:SetText("Rozdzielczość tekstur");
  Graphics_TextureResolutionDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_FilteringDropDownLabel:SetText("Filtrowanie tekstur");
  Graphics_FilteringDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_ProjectedTexturesDropDownLabel:SetText("Projekcje tekstur");
  Graphics_ProjectedTexturesDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_EnvironmentHeader:SetText("Otoczenie");
  Graphics_ViewDistanceSliderLabel:SetText("Widok oddalenia");
  Graphics_ViewDistanceSliderLabel:SetFont(UiT_Font, _sizeL);
  Graphics_EnvironmentalDetailSliderLabel:SetText("Szczegóły otoczenia");
  Graphics_EnvironmentalDetailSliderLabel:SetFont(UiT_Font, _sizeL);
  Graphics_GroundClutterSliderLabel:SetText("Zamazanie gruntu");
  Graphics_GroundClutterSliderLabel:SetFont(UiT_Font, _sizeL);
  Graphics_EffectsHeader:SetText("Efekty");
  Graphics_ShadowsDropDownLabel:SetText("Jakość cieni");
  Graphics_ShadowsDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_LiquidDetailDropDownLabel:SetText("Szczegóły wody");
  Graphics_LiquidDetailDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_SunshaftsDropDownLabel:SetText("Promienie słoneczne");
  Graphics_SunshaftsDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_ParticleDensityDropDownLabel:SetText("Gęstość cząsteczek");
  Graphics_ParticleDensityDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_SSAODropDownLabel:SetText("SSAO");
  Graphics_SSAODropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_DepthEffectsDropDownLabel:SetText("Efekty głębokości");
  Graphics_DepthEffectsDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_LightingQualityDropDownLabel:SetText("Jakość oświetlenia");
  Graphics_LightingQualityDropDownLabel:SetFont(UiT_Font, _sizeL);
  Graphics_OutlineModeDropDownLabel:SetText("Tryb konspektu");
  Graphics_OutlineModeDropDownLabel:SetFont(UiT_Font, _sizeL);
  
  RaidGraphics_Quality_Title:SetText("Jakość grafiki");
  local _font6, _size6, _36 = RaidGraphics_Quality_Title:GetFont();
  RaidGraphics_Quality_Title:SetFont(UiT_Font, _size6);
  RaidGraphics_TexturesHeader:SetText("Tekstury");
  RaidGraphics_TextureResolutionDropDownLabel:SetText("Rozdzielczość tekstur");
  RaidGraphics_TextureResolutionDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_FilteringDropDownLabel:SetText("Filtrowanie tekstur");
  RaidGraphics_FilteringDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_ProjectedTexturesDropDownLabel:SetText("Projekcje tekstur");
  RaidGraphics_ProjectedTexturesDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_EnvironmentHeader:SetText("Otoczenie");
  RaidGraphics_ViewDistanceSliderLabel:SetText("Widok oddalenia");
  RaidGraphics_ViewDistanceSliderLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_EnvironmentalDetailSliderLabel:SetText("Szczegóły otoczenia");
  RaidGraphics_EnvironmentalDetailSliderLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_GroundClutterSliderLabel:SetText("Zamazanie gruntu");
  RaidGraphics_GroundClutterSliderLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_EffectsHeader:SetText("Efekty");
  RaidGraphics_ShadowsDropDownLabel:SetText("Jakość cieni");
  RaidGraphics_ShadowsDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_LiquidDetailDropDownLabel:SetText("Szczegóły wody");
  RaidGraphics_LiquidDetailDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_SunshaftsDropDownLabel:SetText("Promienie słoneczne");
  RaidGraphics_SunshaftsDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_ParticleDensityDropDownLabel:SetText("Gęstość cząsteczek");
  RaidGraphics_ParticleDensityDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_SSAODropDownLabel:SetText("SSAO");
  RaidGraphics_SSAODropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_DepthEffectsDropDownLabel:SetText("Efekty głębokości");
  RaidGraphics_DepthEffectsDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_LightingQualityDropDownLabel:SetText("Jakość oświetlenia");
  RaidGraphics_LightingQualityDropDownLabel:SetFont(UiT_Font, _sizeL);
  RaidGraphics_OutlineModeDropDownLabel:SetText("Tryb konspektu");
  RaidGraphics_OutlineModeDropDownLabel:SetFont(UiT_Font, _sizeL);
  VideoOptionsFrameApplyText:SetText("Zastosuj");
  
  Advanced_DisplayHeader:SetText("Zaawansowane");
  Advanced_BufferingDropDownLabel:SetText("Potrójne buforowanie");
  Advanced_BufferingDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_LagDropDownLabel:SetText("Zmniejsz opóźnienie wej.");
  Advanced_LagDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_HardwareCursorDropDownLabel:SetText("Kursor sprzętowy");
  Advanced_HardwareCursorDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_MultisampleAntiAliasingDropDownLabel:SetText("MSAA");
  Advanced_MultisampleAntiAliasingDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_MultisampleAlphaTestLabel:SetText("MS Alpha-Test");
  Advanced_MultisampleAlphaTestLabel:SetFont(UiT_Font, _sizeL);
  Advanced_PostProcessAntiAliasingDropDownLabel:SetText("Post-Proces AA");
  Advanced_PostProcessAntiAliasingDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_ResampleQualityDropDownLabel:SetText("Jakość próbek 2");
  Advanced_ResampleQualityDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_GraphicsAPIDropDownLabel:SetText("Interfejs graficzny");
  Advanced_GraphicsAPIDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_PhysicsInteractionDropDownLabel:SetText("Interakcja z fizyką");
  Advanced_PhysicsInteractionDropDownLabel:SetFont(UiT_Font, _sizeL);
  Advanced_UIScaleSliderText:SetText("Skala UI");
--  Advanced_MaxFPSSliderText:SetText("Max ForeGrounf FPS");
--  Advanced_MaxFPSBKSliderText:SetText("Max Background FPS");
  Advanced_ShowHDModelsText:SetText("Pokaż nowe modele postaci");
  local _fontB, _sizeB, _3B = Advanced_ShowHDModelsText:GetFont();
  Advanced_ShowHDModelsText:SetFont(UiT_Font, _sizeB);
  Advanced_RenderScaleSliderText:SetText("Skala renderowania");
  Advanced_UIScaleSliderLow:SetText("niska");
  Advanced_UIScaleSliderHigh:SetText("wysoka");
  
  NetworkOptionsPanelDisplayHeader:SetText("Sieć");
  local _fontH, _sizeH, _3H = VideoOptionsFrameCategoryFrameButton5Text:GetFont();
  NetworkOptionsPanelDisplayHeader:SetFont(UiT_Font, _sizeH);
  NetworkOptionsPanelOptimizeSpeedText:SetText("Zoptymalizuj sieć pod kątem szybkości");
  local _fontC, _sizeC, _3C = NetworkOptionsPanelOptimizeSpeedText:GetFont();
  NetworkOptionsPanelOptimizeSpeedText:SetFont(UiT_Font, _sizeC);
  NetworkOptionsPanelUseIPv6Text:SetText("Włącz IPv6, gdy jest dostępny");
  NetworkOptionsPanelUseIPv6Text:SetFont(UiT_Font, _sizeC);
  NetworkOptionsPanelAdvancedCombatLoggingText:SetText("Zaawansowane logowanie bojowe");
  NetworkOptionsPanelAdvancedCombatLoggingText:SetFont(UiT_Font, _sizeC);
  
  InterfaceOptionsLanguagesPanelDisplayHeader:SetText("Języki");
  InterfaceOptionsLanguagesPanelDisplayHeader:SetFont(UiT_Font, _sizeH);
  InterfaceOptionsLanguagesPanelLocaleDropDownLabel:SetText("Tekst");
  InterfaceOptionsLanguagesPanelLocaleDropDownLabel:SetFont(UiT_Font, _sizeB);
  InterfaceOptionsLanguagesPanelAudioLocaleDropDownLabel:SetText("Głos");
  InterfaceOptionsLanguagesPanelAudioLocaleDropDownLabel:SetFont(UiT_Font, _sizeB);
  
  AudioOptionsSoundPanelDisplayHeader:SetText("Dźwięk");
  AudioOptionsSoundPanelDisplayHeader:SetFont(UiT_Font, _sizeH);
  AudioOptionsSoundPanelEnableSoundText:SetText("Włącz dźwięk");
  local _font2, _size2, _32 = AudioOptionsSoundPanelEnableSoundText:GetFont();
  AudioOptionsSoundPanelEnableSoundText:SetFont(UiT_Font, _size2);
  
  AudioOptionsSoundPanelPlaybackTitle:SetText("Podkład muzyczny");
  AudioOptionsSoundPanelPlaybackTitle:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelSoundEffectsText:SetText("Efekty dźwiękowe");
  local _font3, _size3, _33 = AudioOptionsSoundPanelSoundEffectsText:GetFont();
  AudioOptionsSoundPanelSoundEffectsText:SetFont(UiT_Font, _size3);
  AudioOptionsSoundPanelPetSoundsText:SetText("Włącz dźwięki zwierzaka");
  AudioOptionsSoundPanelPetSoundsText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelEmoteSoundsText:SetText("Dźwięki emocji");
  AudioOptionsSoundPanelEmoteSoundsText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelMusicText:SetText("Muzyka");
  AudioOptionsSoundPanelMusicText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelLoopMusicText:SetText("Zapętlij muzykę");
  AudioOptionsSoundPanelLoopMusicText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelPetBattleMusicText:SetText("Muzyka bojowa zwierzaka");
  AudioOptionsSoundPanelPetBattleMusicText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelAmbientSoundsText:SetText("Dźwięki otoczenia");
  AudioOptionsSoundPanelAmbientSoundsText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelDialogSoundsText:SetText("Dialog");
  AudioOptionsSoundPanelDialogSoundsText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelErrorSpeechText:SetText("Wypowiadaj Błąd");
  AudioOptionsSoundPanelErrorSpeechText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelSoundInBGText:SetText("Dźwięk na Polu Bitwy");
  AudioOptionsSoundPanelSoundInBGText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelReverbText:SetText("Włącz pogłos");
  AudioOptionsSoundPanelReverbText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelHRTFText:SetText("Filtrowanie odległości");
  AudioOptionsSoundPanelHRTFText:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelEnableDSPsText:SetText("Głosy Rycerza Śmierci");
  AudioOptionsSoundPanelEnableDSPsText:SetFont(UiT_Font, _size2);
  
  AudioOptionsSoundPanelHardwareTitle:SetText("Sprzęt");
  AudioOptionsSoundPanelHardwareTitle:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelHardwareDropDownLabel:SetText("Wyjście dźwięku gry");
  local _font7, _size7, _37 = AudioOptionsSoundPanelHardwareDropDownLabel:GetFont();
  AudioOptionsSoundPanelHardwareDropDownLabel:SetFont(UiT_Font, _size7);
  AudioOptionsSoundPanelSoundChannelsDropDownLabel:SetText("Kanały dźwiękowe");
  AudioOptionsSoundPanelSoundChannelsDropDownLabel:SetFont(UiT_Font, _size7);
  AudioOptionsSoundPanelSoundCacheSizeDropDownLabel:SetText("Rozmiar pam.podr.dźwięku");
  AudioOptionsSoundPanelSoundCacheSizeDropDownLabel:SetFont(UiT_Font, _size7);
  
  AudioOptionsSoundPanelVolumeTitle:SetText("Głośność");
  AudioOptionsSoundPanelVolumeTitle:SetFont(UiT_Font, _size2);
  AudioOptionsSoundPanelMasterVolumeText:SetText("Głośność całkowita");
  AudioOptionsSoundPanelMasterVolumeText:SetFont(UiT_Font, _size7);
  AudioOptionsSoundPanelSoundVolumeLabel:SetText("Dźwięk");
  AudioOptionsSoundPanelSoundVolumeLabel:SetFont(UiT_Font, _sizeL);
  AudioOptionsSoundPanelMusicVolumeLabel:SetText("Muzyka");
  AudioOptionsSoundPanelMusicVolumeLabel:SetFont(UiT_Font, _sizeL);
  AudioOptionsSoundPanelAmbienceVolumeLabel:SetText("Otoczenie");
  AudioOptionsSoundPanelAmbienceVolumeLabel:SetFont(UiT_Font, _sizeL);
  AudioOptionsSoundPanelDialogVolumeLabel:SetText("Dialog");
  AudioOptionsSoundPanelDialogVolumeLabel:SetFont(UiT_Font, _sizeL);
  AudioOptionsSoundPanelSoundVolumeLow:SetText("nisko");
  AudioOptionsSoundPanelSoundVolumeHigh:SetText("wysoko");
  
end


function UiT_onMacroFrame()
  MacroFrameTab1Text:SetText("Makra globalne");
  MacroFrameTab2Text:SetText("Makra postaci "..UnitName("player"));
  MacroEditButtonText:SetText("Zmień nazwe/ikonę");
  local _font1, _size1, _31 = MacroEditButtonText:GetFont();
  MacroEditButtonText:SetFont(UiT_Font, _size1);
  MacroSaveButtonText:SetText("Zapisz");
  MacroCancelButtonText:SetText("Anuluj");
  MacroDeleteButtonText:SetText("Skasuj");
  MacroNewButtonText:SetText("Nowy");
  MacroExitButtonText:SetText("Wyjście");
  MacroExitButtonText:SetFont(UiT_Font, _size1);
  MacroFrameEnterMacroText:SetText("Wpisz komendy makra:");
  MacroFrameText:HookScript("OnUpdate", UiT_MacroChatLimitUpdate);
end


function UiT_MacroChatLimitUpdate()
  if (MacroFrameCharLimitText:GetText()) then
     MacroFrameCharLimitText:SetText(string.gsub(MacroFrameCharLimitText:GetText(), "Characters Used", "znaków wykorzystano"));
  end
end


function UiT_onInterfaceOptionsFrame()
  InterfaceOptionsFrameCategoriesButton1Text:SetText("Sterowanie");
  InterfaceOptionsFrameCategoriesButton2Text:SetText("Walka");
  InterfaceOptionsFrameCategoriesButton3Text:SetText("Wyświetlanie");
  local _font1, _size1, _31 = InterfaceOptionsFrameCategoriesButton3Text:GetFont();
  InterfaceOptionsFrameCategoriesButton3Text:SetFont(UiT_Font, _size1);
  InterfaceOptionsFrameCategoriesButton4Text:SetText("Społeczność");
  InterfaceOptionsFrameCategoriesButton4Text:SetFont(UiT_Font, _size1);
  InterfaceOptionsFrameCategoriesButton5Text:SetText("Paski akcji");
  InterfaceOptionsFrameCategoriesButton6Text:SetText("Nazwy");
  InterfaceOptionsFrameCategoriesButton7Text:SetText("Kamera");
  InterfaceOptionsFrameCategoriesButton8Text:SetText("Myszka");
  InterfaceOptionsFrameCategoriesButton9Text:SetText("Dostępność");
  InterfaceOptionsFrameCategoriesButton9Text:SetFont(UiT_Font, _size1);
  InterfaceOptionsFrameCategoriesButton10Text:SetText("Profile Rajdu");
  InterfaceOptionsFrameDefaultsText:SetText("Domyślne");
  local _font2, _size2, _32 = InterfaceOptionsFrameDefaultsText:GetFont();
  InterfaceOptionsFrameDefaultsText:SetFont(UiT_Font, _size2);
  InterfaceOptionsFrameOkayText:SetText("Gotowe");
  InterfaceOptionsFrameCancelText:SetText("Anuluj");
  
  InterfaceOptionsControlsPanelTitle:SetText("Sterowanie");
  InterfaceOptionsControlsPanelSubText:SetText("Są to ogólne kontrolki związane z rozgrywką, które wpływają na to, jak twoja postać wchodzi w interakcje z obiektami i innymi graczami w świecie gry.");
  local _font3, _size3, _33 = InterfaceOptionsFrameDefaultsText:GetFont();
  InterfaceOptionsControlsPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsControlsPanelStickyTargetingText:SetText("Kierowanie nieprzerwane");
  InterfaceOptionsControlsPanelAutoDismountText:SetText("Auto zsiadanie w locie");
  InterfaceOptionsControlsPanelAutoClearAFKText:SetText("Automatyczne anulowanie trybu AFK");
  InterfaceOptionsControlsPanelAutoLootCorpseText:SetText("Automatyczne zbieranie łupu");
  InterfaceOptionsControlsPanelAutoLootKeyDropDownLabel:SetText("Klawisz pojedyńczego zbierania łupu");
  local _font4, _size4, _34 = InterfaceOptionsControlsPanelAutoLootKeyDropDownLabel:GetFont();
  InterfaceOptionsControlsPanelAutoLootKeyDropDownLabel:SetFont(UiT_Font, _size4);
  InterfaceOptionsControlsPanelInteractOnLeftClickText:SetText("Interakcja po kliknięciu lewym przyciskiem myszy");
  local _font5, _size5, _35 = InterfaceOptionsControlsPanelInteractOnLeftClickText:GetFont();
  InterfaceOptionsControlsPanelInteractOnLeftClickText:SetFont(UiT_Font, _size5);
  InterfaceOptionsControlsPanelLootAtMouseText:SetText("Okno łupu w pozycji myszki");
  
  InterfaceOptionsCombatPanelTitle:SetText("Walka");
  InterfaceOptionsCombatPanelSubText:SetText("Opcje te wpływają na zachowania postaci w walce oraz pozwalają zmienić sposób wyświetlania walki w interfejsie użytkownika.");
  InterfaceOptionsCombatPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsCombatPanelTargetOfTargetText:SetText("Przełącza wyświetlanie celu z twojego celu");
  InterfaceOptionsCombatPanelTargetOfTargetText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCombatPanelFlashLowHealthWarningText:SetText("Nie mrugaj ekranem, gdy mało życia");
  InterfaceOptionsCombatPanelFlashLowHealthWarningText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCombatPanelLossOfControlText:SetText("Ostrzeżenie o utracie kontroli");
  InterfaceOptionsCombatPanelLossOfControlText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCombatPanelEnableFloatingCombatTextText:SetText("Przewijanie tekstu walki");
  InterfaceOptionsCombatPanelSpellAlertOpacitySliderText:SetText("Powiadom o wymaganym zaklęciu");
  InterfaceOptionsCombatPanelSpellAlertOpacitySliderText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCombatPanelSpellAlertOpacitySliderLow:SetText("Wył.");
  InterfaceOptionsCombatPanelSpellAlertOpacitySliderHigh:SetText("Wysoki");
  InterfaceOptionsCombatPanelFocusCastKeyDropDownLabel:SetText("Klawisz rzucania czaru na celu");
  InterfaceOptionsCombatPanelSelfCastKeyDropDownLabel:SetText("Klawisz automatycznego czaru na siebie");
  InterfaceOptionsCombatPanelAutoSelfCastText:SetText("Rzucaj automatycznie czary na siebie");
  
  InterfaceOptionsDisplayPanelTitle:SetText("Wyświetlanie");
  local _font6, _size6, _36 = InterfaceOptionsDisplayPanelTitle:GetFont();
  InterfaceOptionsDisplayPanelTitle:SetFont(UiT_Font, _size6);
  InterfaceOptionsDisplayPanelSubText:SetText("Te opcje wpływają na to, czy interfejs użytkownika i elementy postaci są ukryte lub wyświetlane.");
  InterfaceOptionsDisplayPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsDisplayPanelOutlineDropDownLabel:SetText("Tryb konspektu");
  InterfaceOptionsDisplayPanelSelfHighlightDropDownLabel:SetText("Uwydatnij siebie na rajdzie");
  InterfaceOptionsDisplayPanelDisplayDropDownLabel:SetText("Tekst statusu");
  InterfaceOptionsDisplayPanelChatBubblesDropDownLabel:SetText("Pokaż dymki graczy w oknie Czat");
  InterfaceOptionsDisplayPanelChatBubblesDropDownLabel:SetFont(UiT_Font, _size4);
  InterfaceOptionsDisplayPanelRotateMinimapText:SetText("Obracaj Minimapą");
  InterfaceOptionsDisplayPanelRotateMinimapText:SetFont(UiT_Font, _size5);
  InterfaceOptionsDisplayPanelAJAlertsText:SetText("Ukryj alarm przewodnika przygodowego");
  InterfaceOptionsDisplayPanelShowTutorialsText:SetText("Poradniki");
  InterfaceOptionsDisplayPanelResetTutorialsText:SetText("Wyzeruj poradniki");

  InterfaceOptionsSocialPanelTitle:SetText("Społeczność");
  InterfaceOptionsSocialPanelTitle:SetFont(UiT_Font, _size6);
  InterfaceOptionsSocialPanelSubText:SetText("Te opcje pozwalają kontrolować i modyfikować interakcje z innymi graczami, z którymi spotkasz się w Świecie WoW'a.");
  InterfaceOptionsSocialPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsSocialPanelProfanityFilterText:SetText("Filtr językowy");
  InterfaceOptionsSocialPanelProfanityFilterText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelSpamFilterText:SetText("Filtr antyspamowy");
  InterfaceOptionsSocialPanelGuildMemberAlertText:SetText("Alert o członku gildii");
  InterfaceOptionsSocialPanelGuildMemberAlertText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelBlockTradesText:SetText("Blokuj oferty handlu");
  InterfaceOptionsSocialPanelBlockGuildInvitesText:SetText("Blokuj zaproszenia do gildii");
  InterfaceOptionsSocialPanelBlockChatChannelInvitesText:SetText("Blokuj zaproszenia na kanale czatu");
  InterfaceOptionsSocialPanelShowAccountAchievmentsText:SetText("Zgłaszaj tylko osiągnięcia postaci");
  InterfaceOptionsSocialPanelShowAccountAchievmentsText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelOnlineFriendsText:SetText("Znajomi Online");
  InterfaceOptionsSocialPanelOfflineFriendsText:SetText("Znajomi Offline");
  InterfaceOptionsSocialPanelBroadcastsText:SetText("Aktualizacje transmisji");
  InterfaceOptionsSocialPanelAutoAcceptQuickJoinRequestsText:SetText("Automatyczne akceptowanie szybkich żądań");
  InterfaceOptionsSocialPanelAutoAcceptQuickJoinRequestsText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelFriendRequestsText:SetText("Wymagaj realne ID lub Znacznik przyjaciela");
  InterfaceOptionsSocialPanelShowToastWindowText:SetText("Pokaż okno toastu");
  InterfaceOptionsSocialPanelShowToastWindowText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelEnableTwitterText:SetText("Włącz funkcjonalność Twittera");
  InterfaceOptionsSocialPanelEnableTwitterText:SetFont(UiT_Font, _size5);
  InterfaceOptionsSocialPanelChatStyleLabel:SetText("Styl okna czatu");
  InterfaceOptionsSocialPanelTimestampsLabel:SetText("Znacznik czasu w czacie");
  InterfaceOptionsSocialPanelWhisperModeLabel:SetText("Nowy szept");
--  InterfaceOptionsSocialPanelRedockChatText:SetText("Resetuj pozycję okna czat");
--  InterfaceOptionsSocialPanelTwitterLoginButton:SetText("Zaloguj");

  InterfaceOptionsActionBarsPanelTitle:SetText("Paski akcji");
  InterfaceOptionsActionBarsPanelSubText:SetText("Paski akcji są bankami skrótów klawiszowych, które pozwalają na szybki dostęp do umiejętności i przedmiotów z ekwipunku. Tutaj możesz aktywować dodatkowe paski akcji i kontrolować ich zachowania.");
  InterfaceOptionsActionBarsPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsActionBarsPanelBottomLeftText:SetText("Dolne lewe paski");
  InterfaceOptionsActionBarsPanelBottomRightText:SetText("Dolne prawe paski");
  InterfaceOptionsActionBarsPanelRightText:SetText("Prawe paski");
  InterfaceOptionsActionBarsPanelRightTwoText:SetText("Prawe drugie paski");
  InterfaceOptionsActionBarsPanelLockActionBarsText:SetText("Zablokuj paski akcji");
  InterfaceOptionsActionBarsPanelPickupActionKeyDropDownLabel:SetText("Podnieś klucz akcji");
  InterfaceOptionsActionBarsPanelPickupActionKeyDropDownLabel:SetFont(UiT_Font, _size4);
  InterfaceOptionsActionBarsPanelAlwaysShowActionBarsText:SetText("Zawsze pokazuj paski akcji");
  InterfaceOptionsActionBarsPanelCountdownCooldownsText:SetText("Pokazuj czas odnowienia czaru");
  
  InterfaceOptionsNamesPanelTitle:SetText("Nazwy");
  InterfaceOptionsNamesPanelSubText:SetText("Te opcje pozwalają kontrolować, które nazwy są widoczne w polu gry podczas gry.");
  InterfaceOptionsNamesPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsNamesPanelMyNameText:SetText("Moja nazwa postaci");
  InterfaceOptionsNamesPanelNonCombatCreatureText:SetText("Stworki i towarzysze");
  InterfaceOptionsNamesPanelFriendlyPlayerNamesText:SetText("Przyjaźni gracze");
  InterfaceOptionsNamesPanelFriendlyPlayerNamesText:SetFont(UiT_Font, _size5);
  InterfaceOptionsNamesPanelFriendlyMinionsText:SetText("Stworki");
  InterfaceOptionsNamesPanelUnitNameplatesTitle:SetText("Tabliczki z nazwami jednostek");
  InterfaceOptionsNamesPanelUnitNameplatesPersonalResourceText:SetText("Wyświetlanie zasobów osobistych");
  InterfaceOptionsNamesPanelUnitNameplatesPersonalResourceText:SetFont(UiT_Font, _size5);
  InterfaceOptionsNamesPanelUnitNameplatesPersonalResourceOnEnemyText:SetText("Pokaż specjalne zasoby na celach");
  InterfaceOptionsNamesPanelUnitNameplatesPersonalResourceOnEnemyText:SetFont(UiT_Font, _size5);
  InterfaceOptionsNamesPanelUnitNameplatesMakeLargerText:SetText("Duże tabliczki z nazwami");
  InterfaceOptionsNamesPanelUnitNameplatesMakeLargerText:SetFont(UiT_Font, _size5);
  InterfaceOptionsNamesPanelUnitNameplatesAggroFlashText:SetText("Migaj przy utracie zagrożenia");
  InterfaceOptionsNamesPanelUnitNameplatesAggroFlashText:SetFont(UiT_Font, _size5);
  InterfaceOptionsNamesPanelUnitNameplatesShowAllText:SetText("Zawsze pokazuj tabliczki z nazwami");
--  InterfaceOptionsNamesPanelUnitNameplatesEnemiesText:SetText("Jednostki wroga (V)");
  InterfaceOptionsNamesPanelUnitNameplatesEnemyMinionsText:SetText("Stworki");
  InterfaceOptionsNamesPanelUnitNameplatesEnemyMinusText:SetText("Mniejsze");
--  InterfaceOptionsNamesPanelUnitNameplatesFriendsText:SetText("Przyjaźni gracze (SHIFT-V)");
  InterfaceOptionsNamesPanelUnitNameplatesFriendlyMinionsText:SetText("Stworki");
  InterfaceOptionsNamesPanelEnemyPlayerNamesText:SetText("Wrogowie");
  InterfaceOptionsNamesPanelEnemyMinionsText:SetText("Stworki");
  InterfaceOptionsNamesPanelUnitNameplatesMotionDropDownLabel:SetText("Typ tabliczki z nazwą");
  InterfaceOptionsNamesPanelUnitNameplatesMotionDropDownLabel:SetFont(UiT_Font, _size4);
  InterfaceOptionsNamesPanelNPCNamesDropDownLabel:SetText("Nazwy NPC");
  
  InterfaceOptionsCameraPanelTitle:SetText("Kamera");
  InterfaceOptionsCameraPanelSubText:SetText("Te opcje pozwalają modyfikować zachowanie kamery w grze.");
  InterfaceOptionsCameraPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsCameraPanelWaterCollisionText:SetText("Kolizja z wodą");
  InterfaceOptionsCameraPanelWaterCollisionText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCameraPanelFollowSpeedSliderText:SetText("Autom. prędkość podążania");
  InterfaceOptionsCameraPanelFollowSpeedSliderText:SetFont(UiT_Font, _size5);
  InterfaceOptionsCameraPanelFollowSpeedSliderLow:SetText("Powoli");
  InterfaceOptionsCameraPanelFollowSpeedSliderHigh:SetText("Szybko");
  InterfaceOptionsCameraPanelStyleDropDownLabel:SetText("Styl podążania za kamerą");
  InterfaceOptionsCameraPanelStyleDropDownLabel:SetFont(UiT_Font, _size4);
  
  InterfaceOptionsMousePanelTitle:SetText("Myszka");
  InterfaceOptionsMousePanelSubText:SetText("Te opcje pozwalają zmienić sposób zachowania myszy w grze.");
  InterfaceOptionsMousePanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsMousePanelInvertMouseText:SetText("Odwróć przyciski myszki");
  InterfaceOptionsMousePanelInvertMouseText:SetFont(UiT_Font, _size5);
  InterfaceOptionsMousePanelEnableMouseSpeedText:SetText("Włącz ustawianie czułości myszki");
  InterfaceOptionsMousePanelEnableMouseSpeedText:SetFont(UiT_Font, _size5);
  InterfaceOptionsMousePanelClickToMoveText:SetText("Przesuwanie postaci kliknięciem myszki");
  InterfaceOptionsMousePanelClickToMoveText:SetFont(UiT_Font, _size5);
  InterfaceOptionsMousePanelClickMoveStyleDropDownLabel:SetText("Styl kamery w tym trybie");
  InterfaceOptionsMousePanelMouseLookSpeedSliderText:SetText("Prędkość przy widoku z myszki");
  InterfaceOptionsMousePanelMouseLookSpeedSliderText:SetFont(UiT_Font, _size5);
  InterfaceOptionsMousePanelMouseLookSpeedSliderLow:SetText("Powoli");
  InterfaceOptionsMousePanelMouseLookSpeedSliderHigh:SetText("Szybko");
  InterfaceOptionsMousePanelMouseSensitivitySliderText:SetText("Czułość myszki");
  InterfaceOptionsMousePanelMouseSensitivitySliderText:SetFont(UiT_Font, _size5);
  InterfaceOptionsMousePanelMouseSensitivitySliderLow:SetText("Niska");
  InterfaceOptionsMousePanelMouseSensitivitySliderHigh:SetText("Wysoka");
  
  InterfaceOptionsAccessibilityPanelTitle:SetText("Dostępność");
  InterfaceOptionsAccessibilityPanelTitle:SetFont(UiT_Font, _size6);
  InterfaceOptionsAccessibilityPanelSubText:SetText("Te opcje mogą poprawić łatwość odbioru informacji w grze.");
  InterfaceOptionsAccessibilityPanelSubText:SetFont(UiT_Font, _size3);
  InterfaceOptionsAccessibilityPanelMovePadText:SetText("Pokaż panel ruchu");
  InterfaceOptionsAccessibilityPanelMovePadText:SetFont(UiT_Font, _size5);
  InterfaceOptionsAccessibilityPanelCinematicSubtitlesText:SetText("Napisy filmowe");
  InterfaceOptionsAccessibilityPanelColorblindModeText:SetText("Włącz tryb blokady kolorów w interfejsie użytkownika");
  InterfaceOptionsAccessibilityPanelColorblindModeText:SetFont(UiT_Font, _size5);
  InterfaceOptionsAccessibilityPanel.ColorblindFiltersTitle:SetText("Filtry blokady kolorów");
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.Instructions:SetText("Wypróbuj każdy filtr kolorów, aby zobaczyć, który z nich wygląda najlepiej dla ciebie");
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.Instructions:SetFont(UiT_Font, _size5);
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.HostileLabel:SetText("Wrogi");
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.NeutralLabel:SetText("Neutralny");
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.FriendlyLabel:SetText("Przyjazny");
  InterfaceOptionsAccessibilityPanel.ColorblindFilterExamples.ItemQualityText:SetText("Rodzaj przedmiotów");
  InterfaceOptionsAccessibilityPanelColorblindStrengthSliderText:SetText("Dostosuj siłę koloru");
  InterfaceOptionsAccessibilityPanelColorblindStrengthSliderText:SetFont(UiT_Font, _size5);
  InterfaceOptionsAccessibilityPanelColorFilterDropDownLabel:SetText("Filtr blokady kolorów");
  
  CompactUnitFrameProfilesTitle:SetText("Profile Rajdu");
  CompactUnitFrameProfilesRaidStylePartyFramesText:SetText("Użyj ramek typu Raid");
  CompactUnitFrameProfilesRaidStylePartyFramesText:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesSaveButtonText:SetText("Zapisz");
  CompactUnitFrameProfilesDeleteButtonText:SetText("Skasuj");
  CompactUnitFrameProfilesGeneralOptionsFrameResetPositionButtonText:SetText("Zresetuj pozycję");
  CompactUnitFrameProfilesGeneralOptionsFrameResetPositionButtonText:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameKeepGroupsTogetherLabel:SetText("Trzymaj razem grupy graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameSortByDropdownLabel:SetText("Sortuj wg.");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayIncomingHealsLabel:SetText("Wyświetlaj przychodzące leczenia");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayIncomingHealsLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayPowerBarLabel:SetText("Wyświetlaj paski życia");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayPowerBarLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayAggroHighlightLabel:SetText("Wyświetlaj wyróżnienie zagrożenia");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayAggroHighlightLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayPetsLabel:SetText("Wyświetlaj zwierzaki");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayPetsLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayMainTankAndAssistLabel:SetText("Wyświetlaj głównego atakującego i asystę");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayMainTankAndAssistLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayBorderLabel:SetText("Wyświetlaj obramowanie");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayBorderLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameShowDebuffsLabel:SetText("Pokazuj Debuffy");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayOnlyDispellableDebuffsLabel:SetText("Wyświetlaj tylko niecelowe Debuffy");
  CompactUnitFrameProfilesGeneralOptionsFrameDisplayOnlyDispellableDebuffsLabel:SetFont(UiT_Font, _size5);
  CompactUnitFrameProfilesGeneralOptionsFrameHealthTextDropdownLabel:SetText("Wyświetlaj tekst leczenia");
  CompactUnitFrameProfilesGeneralOptionsFrameHealthTextDropdownLabel:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderLabel:SetText("Wysokość ramki");
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderLabel:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderLow:SetText("niska");
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderLow:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderHigh:SetText("wysoka");
  CompactUnitFrameProfilesGeneralOptionsFrameHeightSliderHigh:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderLabel:SetText("Szerokość ramki");
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderLabel:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderLow:SetText("wąska");
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderLow:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderHigh:SetText("szeroka");
  CompactUnitFrameProfilesGeneralOptionsFrameWidthSliderHigh:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameUseClassColorsLabel:SetText("Wyświetlaj kolory klas");
  CompactUnitFrameProfilesGeneralOptionsFrameUseClassColorsLabel:SetFont(UiT_Font, _size4);
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivateLabel:SetText("Aktywuj automatycznie przy:");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate2PlayersLabel:SetText("Grupie 2 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate3PlayersLabel:SetText("Grupie 3 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate5PlayersLabel:SetText("Grupie 5 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate10PlayersLabel:SetText("Grupie 10 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate15PlayersLabel:SetText("Grupie 15 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate25PlayersLabel:SetText("Grupie 25 graczy");
  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivate40PlayersLabel:SetText("Grupie 40 graczy");
--  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivateSpec1Label:SetText("Zabójca");
--  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivateSpec2Label:SetText("Banita");
--  CompactUnitFrameProfilesGeneralOptionsFrameAutoActivateSpec3Label:SetText("Subtelny");
end


function UiT_onKeybindingFrame()
  KeyBindingFrame.header.text:SetText("Klawiszologia");
  KeyBindingFrame.cancelButton.Text:SetText("Anuluj");
  KeyBindingFrame.okayButton.Text:SetText("Gotowe");
  KeyBindingFrame.unbindButton.Text:SetText("Rozłącz klawisz");
  local _font1, _size1, _31 = KeyBindingFrame.unbindButton.Text:GetFont();
  KeyBindingFrame.unbindButton.Text:SetFont(UiT_Font, _size1);
  KeyBindingFrame.defaultsButton.Text:SetText("Przywróć domyślne");
  KeyBindingFrame.defaultsButton.Text:SetFont(UiT_Font, _size1);
  KeyBindingFrameText:SetText(" Specyficzne ustawienia dla postaci");
  KeyBindingFrameCategoryListButton1Text:SetText("Klawisze ruchu");
  KeyBindingFrameCategoryListButton2Text:SetText("Okno czatu");
  KeyBindingFrameCategoryListButton3Text:SetText("Pasek podst. akcji");
  local _font2, _size2, _32 = KeyBindingFrameCategoryListButton3Text:GetFont();
  KeyBindingFrameCategoryListButton3Text:SetFont(UiT_Font, _size2);
  KeyBindingFrameCategoryListButton4Text:SetText("Pasek dodatk. akcji");
  KeyBindingFrameCategoryListButton4Text:SetFont(UiT_Font, _size2);
  KeyBindingFrameCategoryListButton5Text:SetText("Namierzanie");
  KeyBindingFrameCategoryListButton6Text:SetText("Panel interfejsu");
  KeyBindingFrameCategoryListButton7Text:SetText("Różne");
  KeyBindingFrameCategoryListButton7Text:SetFont(UiT_Font, _size2);
  KeyBindingFrameCategoryListButton8Text:SetText("Kamera");
  KeyBindingFrameCategoryListButton9Text:SetText("Oznaczanie celu");
  KeyBindingFrameCategoryListButton10Text:SetText("Kontrola pojazdów");
  KeyBindingFrame.commandLabel:SetText("Komenda");
  KeyBindingFrame.key1Label:SetText("Klawisz 1");
  KeyBindingFrame.key2Label:SetText("Klawisz 2");
  
  KeyBindingFrameCategoryListButton1:HookScript("OnClick", UiT_KeyBindingGroup1);
  KeyBindingFrameCategoryListButton2:HookScript("OnClick", UiT_KeyBindingGroup2);
  KeyBindingFrameCategoryListButton3:HookScript("OnClick", UiT_KeyBindingGroup3);
  KeyBindingFrameCategoryListButton4:HookScript("OnClick", UiT_KeyBindingGroup4);
  KeyBindingFrameCategoryListButton5:HookScript("OnClick", UiT_KeyBindingGroup5);
  KeyBindingFrameCategoryListButton6:HookScript("OnClick", UiT_KeyBindingGroup6);
  KeyBindingFrameCategoryListButton7:HookScript("OnClick", UiT_KeyBindingGroup7);
  KeyBindingFrameCategoryListButton8:HookScript("OnClick", UiT_KeyBindingGroup8);
  KeyBindingFrameCategoryListButton9:HookScript("OnClick", UiT_KeyBindingGroup9);
  KeyBindingFrameCategoryListButton10:HookScript("OnClick", UiT_KeyBindingGroup10);
  if (KeyBindingFrameCategoryListButton1.highlight) then
     UiT_KeyBindingGroup1();
  elseif (KeyBindingFrameCategoryListButton2.highlight) then
     UiT_KeyBindingGroup2();
  elseif (KeyBindingFrameCategoryListButton3.highlight) then
     UiT_KeyBindingGroup3();
  elseif (KeyBindingFrameCategoryListButton4.highlight) then
     UiT_KeyBindingGroup4();
  elseif (KeyBindingFrameCategoryListButton5.highlight) then
     UiT_KeyBindingGroup5();
  elseif (KeyBindingFrameCategoryListButton6.highlight) then
     UiT_KeyBindingGroup6();
  elseif (KeyBindingFrameCategoryListButton7.highlight) then
     UiT_KeyBindingGroup7();
  elseif (KeyBindingFrameCategoryListButton8.highlight) then
     UiT_KeyBindingGroup8();
  elseif (KeyBindingFrameCategoryListButton9.highlight) then
     UiT_KeyBindingGroup9();
  elseif (KeyBindingFrameCategoryListButton10.highlight) then
     UiT_KeyBindingGroup10();
  end
end
  
  
function UiT_KeyBindingGroup1()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Poruszaj się i steruj");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Pójdź naprzód");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Pójdź do tyłu");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Obróć się w lewo");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Obróć się w prawo");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Przesuń się w lewo");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Przesuń się w prawo");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Skocz");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Siądź / Pójdż w dół");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Wyciągnij / Schowaj broń");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Przełącz auto-bieg");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Start auto-bieg");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Stop auto-bieg");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Ustaw się w górę");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Ustaw się w dół");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Przełącznik bieg / marsz");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Podążaj za celem");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
end

function UiT_KeyBindingGroup2()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Otwórz okno czatu");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Otwórz czat ze Slash'em");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Strona czatu w górę");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Strona czatu w dół");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Skocz na koniec czatu");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Odpowiedz na czacie");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Opowiedz szeptem");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Stona Logu Walki w górę");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Strona Logu Walki w dół");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Skocz na koniec Logu Walki");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
end

function UiT_KeyBindingGroup3()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Klawisz akcji 1");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Klawisz akcji 2");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Klawisz akcji 3");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Klawisz akcji 4");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Klawisz akcji 5");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Klawisz akcji 6");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Klawisz akcji 7");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Klawisz akcji 8");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Klawisz akcji 9");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Klawisz akcji 10");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Klawisz akcji 11");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Klawisz akcji 12");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Klawisz ekstra akcji 1");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Klawisz akcji spec. 1");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Klawisz akcji spec. 2");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Klawisz akcji spec. 3");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Klawisz akcji spec. 4");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding18.description:SetText("Klawisz akcji spec. 5");
  KeyBindingFrameKeyBinding18.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding19.description:SetText("Klawisz akcji spec. 6");
  KeyBindingFrameKeyBinding19.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding20.description:SetText("Klawisz akcji spec. 7");
  KeyBindingFrameKeyBinding20.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding21.description:SetText("Klawisz akcji spec. 8");
  KeyBindingFrameKeyBinding21.description:SetFont(UiT_Font, _size3);
--  KeyBindingFrameScrollFrameScrollBar  (pasek przewijania przywraca oryg.) 
end

function UiT_KeyBindingGroup4()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Klawisz dolny lewy akcji 1");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Klawisz dolny lewy akcji 2");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Klawisz dolny lewy akcji 3");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Klawisz dolny lewy akcji 4");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Klawisz dolny lewy akcji 5");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Klawisz dolny lewy akcji 6");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Klawisz dolny lewy akcji 7");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Klawisz dolny lewy akcji 8");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Klawisz dolny lewy akcji 9");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Klawisz dolny lewy akcji 10");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Klawisz dolny lewy akcji 11");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Klawisz dolny lewy akcji 12");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Klawisz dolny prawy akcji 1");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Klawisz dolny prawy akcji 2");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Klawisz dolny prawy akcji 3");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Klawisz dolny prawy akcji 4");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding18.description:SetText("Klawisz dolny prawy akcji 5");
  KeyBindingFrameKeyBinding18.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding19.description:SetText("Klawisz dolny prawy akcji 6");
  KeyBindingFrameKeyBinding19.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding20.description:SetText("Klawisz dolny prawy akcji 7");
  KeyBindingFrameKeyBinding20.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding21.description:SetText("Klawisz dolny prawy akcji 8");
  KeyBindingFrameKeyBinding21.description:SetFont(UiT_Font, _size3);
--  KeyBindingFrameScrollFrameScrollBar  (pasek przewijania przywraca oryg.) 
end

function UiT_KeyBindingGroup5()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Wybierz najbliższego wroga");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Wybierz poprzedniego wroga");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Skanuj wrogie cele (trzymaj)");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Najbliższy przyjaciel");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Poprzedni przyjaciel");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Najbliższy wrogi gracz");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Poprzedni wrogi gracz");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Najbliższy przyjazny gracz");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Poprzedni przyjazny gracz");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Wybierz siebie");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Uczestnik 1 Party");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Uczestnik 2 Party");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Uczestnik 3 Party");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Uczestnik 4 Party");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Wybierz zwierzę");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Zwierzę 1 z Party");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Zwierzę 2 z Party");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding18.description:SetText("Zwierzę 3 z Party");
  KeyBindingFrameKeyBinding18.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding19.description:SetText("Zwierzę 4 z Party");
  KeyBindingFrameKeyBinding19.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding20.description:SetText("Wybierz ostatniego wroga");
  KeyBindingFrameKeyBinding20.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding21.description:SetText("Wybierz ostatni cel");
  KeyBindingFrameKeyBinding21.description:SetFont(UiT_Font, _size3);
--  KeyBindingFrameScrollFrameScrollBar  (pasek przewijania przywraca oryg.) 
end

function UiT_KeyBindingGroup6()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Pokaż Menu Główne");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Pokaż plecak główny");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Pokaż torbę 1");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Pokaż torbę 2");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Pokaż torbę 3");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Pokaż torbę 4");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Otwórz wszystkie torby");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Otwórz panel postaci");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Otwórz panel reputacji");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Otwórz okienko pieniędzy");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Otwórz książkę czarów");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Otwórz książkę profesji");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Otwórz księgę zwierzaka");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Otwórz panel talentów");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding18.description:SetText("Otwórz panel kolecji");
  KeyBindingFrameKeyBinding18.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding19.description:SetText("Otwórz ramkę statystyk");
  KeyBindingFrameKeyBinding19.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding21.description:SetText("Otwórz listę zadań");
  KeyBindingFrameKeyBinding21.description:SetFont(UiT_Font, _size3);
--  KeyBindingFrameScrollFrameScrollBar  (pasek przewijania przywraca oryg.) 
end

function UiT_KeyBindingGroup7()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Zatrzymaj czarowanie");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Przestań atakować");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Zsiądź z wierzchowca");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Powiększ MiniMapę");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Zmniejsz MiniMapę");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Przełącz muzykę");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Przełącz dzwięk");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Głośność większa");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Głośność mniejsza");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Włącz automatyczne wyciszanie");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Wywołaj UI");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Wywołaj ekran FPS");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Zapisz obraz ekranu");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Porównanie przedniotów");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Wywołaj ustawienia grafiki");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Wywołaj samopodświetlenie");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Wywołaj tryb okienkowy");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
end

function UiT_KeyBindingGroup8()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Następny widok");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Poprzedni widok");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Przybliż zoom");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Oddal zoom");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Przywołaj widok 1");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Przywołaj widok 2");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Przywołaj widok 3");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Przywołaj widok 4");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Przywołaj widok 5");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding10.description:SetText("Zapisz widok 1");
  KeyBindingFrameKeyBinding10.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding11.description:SetText("Zapisz widok 2");
  KeyBindingFrameKeyBinding11.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding12.description:SetText("Zapisz widok 3");
  KeyBindingFrameKeyBinding12.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding13.description:SetText("Zapisz widok 4");
  KeyBindingFrameKeyBinding13.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding14.description:SetText("Zapisz widok 5");
  KeyBindingFrameKeyBinding14.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding15.description:SetText("Skasuj widok 1");
  KeyBindingFrameKeyBinding15.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding16.description:SetText("Skasuj widok 2");
  KeyBindingFrameKeyBinding16.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding17.description:SetText("Skasuj widok 3");
  KeyBindingFrameKeyBinding17.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding18.description:SetText("Skasuj widok 4");
  KeyBindingFrameKeyBinding18.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding19.description:SetText("Skasuj widok 5");
  KeyBindingFrameKeyBinding19.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding20.description:SetText("Odwróć kamerę");
  KeyBindingFrameKeyBinding20.description:SetFont(UiT_Font, _size3);
end

function UiT_KeyBindingGroup9()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Przypisz Czaszkę do celu");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Przypisz Krzyżyk do celu");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Przypisz Kwadrat do celu");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Przypisz Księżyc do celu");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Przypisz Trójkąt do celu");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Przypisz Diament do celu");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Przypisz Okrąg do celu");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Przypisz Gwiazdę do celu");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Wyzeruj ikony przypisane do celu");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
end

function UiT_KeyBindingGroup10()  
  local _font3, _size3, _33 = KeyBindingFrameKeyBinding1.description:GetFont();
  KeyBindingFrameKeyBinding1.description:SetText("Opuść pojazd");
  KeyBindingFrameKeyBinding1.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding2.description:SetText("Poprzednie miejsce");
  KeyBindingFrameKeyBinding2.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding3.description:SetText("Nestępne miejsce");
  KeyBindingFrameKeyBinding3.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding4.description:SetText("Cel w górę");
  KeyBindingFrameKeyBinding4.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding5.description:SetText("Cel w dół");
  KeyBindingFrameKeyBinding5.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding6.description:SetText("Zwiększanie celu");
  KeyBindingFrameKeyBinding6.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding7.description:SetText("Zmniejszanie celu");
  KeyBindingFrameKeyBinding7.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding8.description:SetText("Przybliżenie kamery");
  KeyBindingFrameKeyBinding8.description:SetFont(UiT_Font, _size3);
  KeyBindingFrameKeyBinding9.description:SetText("Oddalenie kamery");
  KeyBindingFrameKeyBinding9.description:SetFont(UiT_Font, _size3);
end


function UiT_onFriendTab1Frame()
  FriendsFrameTitleText:SetText("Lista przyjaciół");
  local _font1, _size1, _31 = FriendsFrameTitleText:GetFont();
  FriendsFrameTitleText:SetFont(UiT_Font, _size1);
  FriendsTabHeaderTab1Text:SetText("Przyjaciele");
  FriendsTabHeaderTab2Text:SetText("Połącz szybko");
  local _font14, _size14, _314 = FriendsTabHeaderTab2Text:GetFont();
  FriendsTabHeaderTab2Text:SetFont(UiT_Font, _size14);
  FriendsTabHeaderTab3Text:SetText("Ignorowane");
end

function UiT_onFriendTab2Frame()
  FriendsFrameTitleText:SetText("Lista KTO");
end

function UiT_onFriendTab3Frame()
  FriendsFrameTitleText:SetText("Kanały Czatu");
  local _font1, _size1, _31 = FriendsFrameTitleText:GetFont();
  FriendsFrameTitleText:SetFont(UiT_Font, _size1);
end

function UiT_onFriendTab4Frame()
  FriendsFrameTitleText:SetText("Rajd");
end


UiT = CreateFrame("Frame");
UiT:SetScript("OnEvent", UiT_OnEvent);
UiT:RegisterEvent("PLAYER_ENTERING_WORLD");

CharacterMicroButton:HookScript("OnEnter", UiT_onCharacterMicroButton);
SpellbookMicroButton:HookScript("OnEnter", UiT_onSpellbookMicroButton);
TalentMicroButton:HookScript("OnEnter", UiT_onTalentMicroButton);
hooksecurefunc("UpdateMicroButtons", UiT_UpdateMicroButtons);
--TalentMicroButton:HookScript("OnClick", UiT_onTalentButtonClick);
AchievementMicroButton:HookScript("OnEnter", UiT_onAchievementMicroButton);
QuestLogMicroButton:HookScript("OnEnter", UiT_onQuestLogMicroButton);
GuildMicroButton:HookScript("OnEnter", UiT_onGuildMicroButton);
LFDMicroButton:HookScript("OnEnter", UiT_onLFDMicroButton);
CollectionsMicroButton:HookScript("OnEnter", UiT_onCollectionsMicroButton);
CollectionsMicroButton:HookScript("OnClick", UiT_onCollectionButtonClick);
EJMicroButton:HookScript("OnEnter", UiT_onEJMicroButton);
StoreMicroButton:HookScript("OnEnter", UiT_onStoreMicroButton);
MainMenuMicroButton:HookScript("OnEnter", UiT_onMainMenuMicroButton);

SpellBookFrame:HookScript("OnShow", UiT_onSpellBookFrame);
SpellBookSpellIconsFrame:HookScript("OnShow", UiT_onSpellBookFrame);
SpellBookProfessionFrame:HookScript("OnShow", UiT_onSpellBookFrame);
SpellBookSkillLineTab1:HookScript("OnClick", UiT_onSpellBookFrame);
SpellBookSkillLineTab2:HookScript("OnClick", UiT_onSpellBookFrame);
SpellBookSkillLineTab3:HookScript("OnClick", UiT_onSpellBookFrame);
SpellBookSkillLineTab4:HookScript("OnClick", UiT_onSpellBookFrame);
SpellBookNextPageButton:HookScript("OnClick", UiT_onSpellBookFrame);
SpellBookPrevPageButton:HookScript("OnClick", UiT_onSpellBookFrame);

QuestMapFrame.DetailsFrame:HookScript("OnShow", UiT_onQuestMapFrame);
QuestMapFrame.DetailsFrame.AbandonButton:HookScript("OnClick", UiT_onQuestAbandonFrame);

VideoOptionsFrame:HookScript("OnShow", UiT_onVideoFrame);

GameMenuButtonMacros:HookScript("OnClick", UiT_onMacroFrame);

InterfaceOptionsFrame:HookScript("OnShow", UiT_onInterfaceOptionsFrame);

GameMenuButtonKeybindings:HookScript("OnClick", UiT_onKeybindingFrame);

FriendsFrameTab1:HookScript("OnClick", UiT_onFriendTab1Frame);
FriendsFrameTab2:HookScript("OnClick", UiT_onFriendTab2Frame);
FriendsFrameTab3:HookScript("OnClick", UiT_onFriendTab3Frame);
FriendsFrameTab4:HookScript("OnClick", UiT_onFriendTab4Frame);



DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-UI ver. "..UiT_version.." - aktywny");
