﻿-- Addon: WoWpoPolsku_Tooltips (version: 10.03) 2023.07.22
-- Description: AddOn displays translated description in GameTooltip frame.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)

-- General Variables
local _G = _G;    -- aby przespieszyć dostęp do tablicy _G
local ST_version = GetAddOnMetadata("WoWpoPolsku_Tooltips", "Version");
local ST_miasto = "";      -- miejsce powrotu przedmiotu Heartstone
local ST_GameGossip_Show = false;
local ST_width2 = math.floor(UIParent:GetWidth() / 2 + 0.5);
local ST_height2 = math.floor(UIParent:GetHeight() / 2 + 0.5);
local ST_GameTooltip_x; ST_GameTooltip_y = 0;
local ST_last_open, ST_curr_time = GetTime();

-- fonty z polskimi znakami diakrytycznymi
local ST_Font = "Interface\\AddOns\\WoWpoPolsku_Tooltips\\Fonts\\frizquadratatt_pl.ttf";


function DodajMalpe(text)
   local txt = string.gsub(text," ","@",1);  -- zamień pierwszą spacja na @
   if (string.find(txt,"@")==nil) then       -- nie dodał żadnego znaku @
      txt = txt..'@';                        -- dodaj @ na końcu tekstu
   end
   return txt;   
end


function pairsByKeys (t)
   local a = {}
   for n in pairs(t) do table.insert(a, n) end
   table.sort(a, function(a, b) return a > b end)
   local i = 0      -- iterator variable
   local iter = function ()   -- iterator function
      i = i + 1
      if a[i] == nil then return nil
         else return a[i], t[a[i]]
      end
   end
   return iter
end


function ST_split(str, c)     -- rozdziela tekst do tablicy wg. separatora "c" (explode)
   local aCount = 0;
   local array = {};
   local a = string.find(str, c);
   while a do
      aCount = aCount + 1;
      array[aCount] = string.sub(str, 1, a-1);
      str = string.sub(str, a+1);
      a = string.find(str, c);
   end
   aCount = aCount + 1;
   array[aCount] = str;
   return array;
end


function Przetlumacz(tekst)
   local txt = tekst;
   pomoc8, _ = string.find(txt,"%(");       -- linia zawiera nawiasy, np. jest to lista składników itp.
   if (string.sub(txt,1,9)=='Reagents:') then
      txt = string.gsub(txt, 'Reagents:', 'Składniki:@');
   end
      for st_t_en, st_t_pl in pairsByKeys(ST_Info) do
         txt = string.gsub(txt, st_t_en, st_t_pl);
      end
   return txt;
end


function OkreslKodKoloru(k1,k2,k3)  -- określa kod koloru wyświetlonego tekstu
   kol1=('%.0f'):format(k1);
   kol2=('%.0f'):format(k2);
   kol3=('%.0f'):format(k3);
   c_out=kol1..","..kol2..","..kol3;
   if (kol1=="1" and kol2=="1" and kol3=="1") then
      c_out='c1';
   elseif (kol1=="1" and kol2=="0" and kol3=="0") then
      c_out='c2';
   elseif (kol1=="1" and kol2=="1" and kol3=="0") then
      c_out='c3';
   elseif (kol1=="0" and kol2=="1" and kol3=="0") then
      c_out='c4';
   elseif (kol1=="1" and kol2=="0" and kol3=="1") then
      c_out='c5';
   end
   return c_out;   
end


function ST_SetFont(element)     -- ustawia wielkość czcionki elementu
  if (ST_PM["fontsize"]=="13") then
     getglobal(element):SetFont(ST_Font, 13);     
  elseif (ST_PM["fontsize"]=="14") then
     getglobal(element):SetFont(ST_Font, 14);     
  elseif (ST_PM["fontsize"]=="15") then
     getglobal(element):SetFont(ST_Font, 15);     
  elseif (ST_PM["fontsize"]=="16") then
     getglobal(element):SetFont(ST_Font, 16);     
  elseif (ST_PM["fontsize"]=="17") then
     getglobal(element):SetFont(ST_Font, 17);     
  elseif (ST_PM["fontsize"]=="18") then
     getglobal(element):SetFont(ST_Font, 18);     
  elseif (ST_PM["fontsize"]=="19") then
     getglobal(element):SetFont(ST_Font, 19);     
  elseif (ST_PM["fontsize"]=="20") then
     getglobal(element):SetFont(ST_Font, 20);     
  elseif (ST_PM["fontsize"]=="12") then
     getglobal(element):SetFont(ST_Font, 12);     
  elseif (ST_PM["fontsize"]=="11") then
     getglobal(element):SetFont(ST_Font, 11);     
  elseif (ST_PM["fontsize"]=="10") then
     getglobal(element):SetFont(ST_Font, 10);     
  end
end


function ST_SlashCommand(msg)    -- obsługa koment z linii chatu (tylko włącza lub wyłącza dodatek)
  -- check the command
  if (msg) then
     local ST_command = string.lower(msg);                -- normalizacja, tylko małe litery
     if ((ST_command=="on") or (ST_command=="1")) then    -- włącz przełącznik aktywności
        ST_PM["active"]="1";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Tooltips "..ST_Messages.is_now_active);
     elseif ((ST_command=="off") or (ST_command=="0")) then
        ST_PM["active"]="0";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Tooltips "..ST_Messages.is_now_not_active);
     else
        Settings.OpenToCategory("WoWpoPolsku-Tooltips");
     end   
  end
end


function ST_CheckVars()       -- inicjalizacja zmiennych dodatku)
  if (not ST_PM) then
     ST_PM = {};
  end
  if (not ST_PS) then
     ST_PS = {};
  end
  if (not ST_PH) then
     ST_PH = {};
  end
  if (not ST_PI) then
     ST_PI = {};
  end
  -- initialize check options
  if (not ST_PM["active"] ) then    -- dodatek aktywny
     ST_PM["active"] = "1";   
  end
  if (not ST_PM["title"] ) then     -- pokaż tłumaczenie tytułu
     ST_PM["title"] = "1";   
  end
  if (not ST_PM["item"] ) then      -- pokaż tłumaczenia przedmiotów
     ST_PM["item"] = "1";   
  end
  if (not ST_PM["spell"] ) then     -- pokaż tłumaczenia spelli
     ST_PM["spell"] = "1";   
  end
  if (not ST_PM["talent"] ) then    -- pokaż tłumaczenia talentów
     ST_PM["talent"] = "1";   
  end
  if (not ST_PM["close"] ) then     -- zamknij oryginalne tooltip okno
     ST_PM["close"] = "0";   
  end
  if (not ST_PM["showID"] ) then    -- pokaż ID przedmiotu,spellu,talentu
     ST_PM["showID"] = "1";   
  end
  if (not ST_PM["fixed"] ) then     -- pokaż tłumaczenie elementów stałych
     ST_PM["fixed"] = "0";   
  end
  if (not ST_PM["saveNW"] ) then    -- zapisz nieprzetłumaczone
     ST_PM["saveNW"] = "0";   
  end
  if (not ST_PM["setsize"] ) then   -- uaktywnij zmiany wielkości czcionki
     ST_PM["setsize"] = "0";   
  end
  if (not ST_PM["fontsize"] ) then  -- wielkość czcionki
     ST_PM["fontsize"] = "13";   
  end
end
  
  
function ST_SetCheckButtonState()         -- ustawia aktualne parametry przy wywołaniu BlizzardOptions
  STRCheckButton0:SetValue(ST_PM["active"]=="1");
  STRCheckButton1:SetValue(ST_PM["title"]=="1");
  STRCheckButton2:SetValue(ST_PM["item"]=="1");
  STRCheckButton3:SetValue(ST_PM["showID"]=="1");
  STRCheckButton5:SetValue(ST_PM["saveNW"]=="1");
  STRCheckButton6:SetValue(ST_PM["fixed"]=="1");
  STRCheckButton8:SetValue(ST_PM["spell"]=="1");
  STRCheckButton9:SetValue(ST_PM["talent"]=="1");
  STRCheckButton7:SetValue(ST_PM["close"]=="1");
  STRCheckSize:SetValue(ST_PM["setsize"]=="1");
  local fontsize = tonumber(ST_PM["fontsize"]);
  STRslider:SetValue(fontsize);
  if (ST_PM["setsize"]=="1") then
     STOpis1:SetFont(ST_Font, fontsize);
  else   
     STOpis1:SetFont(ST_Font, 13);
  end
end


function ST_BlizzardOptions()       -- ustawienia dodatku w BlizzardOptions

-- Create main frame for information text
local STROptions = CreateFrame("FRAME", "WoWpoPolskuTooltipsOptions");
STROptions.refresh = function (self) ST_SetCheckButtonState() end;
STROptions.name = "WoWpoPolsku-Tooltips";
InterfaceOptions_AddCategory(STROptions);

local STROptionsHeader = STROptions:CreateFontString(nil, "ARTWORK");
STROptionsHeader:SetFontObject(GameFontNormalLarge);
STROptionsHeader:SetJustifyH("LEFT"); 
STROptionsHeader:SetJustifyV("TOP");
STROptionsHeader:ClearAllPoints();
STROptionsHeader:SetPoint("TOPLEFT", 16, -16);
STROptionsHeader:SetText("WoWpoPolsku-Tooltips, ver. "..ST_version.." ("..ST_base..") by Platine © 2021-2022");

local SpellOptionsDate = STROptions:CreateFontString(nil, "ARTWORK");
SpellOptionsDate:SetFontObject(GameFontNormalLarge);
SpellOptionsDate:SetJustifyH("LEFT"); 
SpellOptionsDate:SetJustifyV("TOP");
SpellOptionsDate:ClearAllPoints();
SpellOptionsDate:SetPoint("TOPRIGHT", STROptionsHeader, "TOPRIGHT", 0, -22);
SpellOptionsDate:SetText("Data bazy tłumaczeń: "..ST_date);
SpellOptionsDate:SetFont(ST_Font, 16);

local STRCheckButton0 = CreateFrame("CheckButton", "STRCheckButton0", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton0.CheckBox:SetScript("OnClick", function(self) if (ST_PM["active"]=="1") then ST_PM["active"]="0" else ST_PM["active"]="1" end; end);
STRCheckButton0.CheckBox:SetPoint("TOPLEFT", STROptionsHeader, "BOTTOMLEFT", 0, -30);
STRCheckButton0:SetPoint("TOPLEFT", STROptionsHeader, "BOTTOMLEFT", 40, -30);
STRCheckButton0.Text:SetFont(ST_Font, 13);
STRCheckButton0.Text:SetText(ST_Interface.active);     -- dodatek aktywny

local STROptionsMode = STROptions:CreateFontString(nil, "ARTWORK");
STROptionsMode:SetFontObject(GameFontWhite);
STROptionsMode:SetJustifyH("LEFT"); 
STROptionsMode:SetJustifyV("TOP");
STROptionsMode:ClearAllPoints();
STROptionsMode:SetPoint("TOPLEFT", STRCheckButton0, "BOTTOMLEFT", 0, -10);
STROptionsMode:SetFont(ST_Font, 13);
STROptionsMode:SetText(ST_Interface.mode);            -- ustawienia dodatku

local STRCheckButton1 = CreateFrame("CheckButton", "STRCheckButton1", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton1.CheckBox:SetScript("OnClick", function(self) if (ST_PM["title"]=="1") then ST_PM["title"]="0" else ST_PM["title"]="1" end; end);
STRCheckButton1.CheckBox:SetPoint("TOPLEFT", STROptionsMode, "BOTTOMLEFT", 0, -5);
STRCheckButton1:SetPoint("TOPLEFT", STROptionsMode, "BOTTOMLEFT", 40, -5);
STRCheckButton1.Text:SetFont(ST_Font, 13);
STRCheckButton1.Text:SetText(ST_Interface.title);     -- przetłumacz tytuły

local STRCheckButton3 = CreateFrame("CheckButton", "STRCheckButton3", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton3.CheckBox:SetScript("OnClick", function(self) if (ST_PM["showID"]=="1") then ST_PM["showID"]="0" else ST_PM["showID"]="1" end; end);
STRCheckButton3.CheckBox:SetPoint("TOPLEFT", STRCheckButton1.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton3:SetPoint("TOPLEFT", STRCheckButton1.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton3.Text:SetFont(ST_Font, 13);
STRCheckButton3.Text:SetText(ST_Interface.showID);     -- pokaż nr ID przedmiotu, umiejętności, talentu

local STRCheckButton5 = CreateFrame("CheckButton", "STRCheckButton5", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton5.CheckBox:SetScript("OnClick", function(self) if (ST_PM["saveNW"]=="1") then ST_PM["saveNW"]="0" else ST_PM["saveNW"]="1" end; end);
STRCheckButton5.CheckBox:SetPoint("TOPLEFT", STRCheckButton3.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton5:SetPoint("TOPLEFT", STRCheckButton3.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton5.Text:SetFont(ST_Font, 13);
STRCheckButton5.Text:SetText(ST_Interface.saveNW);     -- zapisz nieprzetłumaczone teksty

local STRCheckSize = CreateFrame("CheckButton", "STRCheckSize", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckSize.CheckBox:SetScript("OnClick", function(self) if (ST_PM["setsize"]=="1") then ST_PM["setsize"]="0" else ST_PM["setsize"]="1" end; end);
STRCheckSize.CheckBox:SetPoint("TOPLEFT", STRCheckButton5.CheckBox, "BOTTOMLEFT", 0, -10);
STRCheckSize:SetPoint("TOPLEFT", STRCheckButton5.CheckBox, "BOTTOMLEFT", 40, -10);
STRCheckSize.Text:SetFont(ST_Font, 13);
STRCheckSize.Text:SetText("aktywnuj funkcję zmiany wielkości czcionki");   

local STRslider = CreateFrame("Slider", "STRslider", STROptions, "OptionsSliderTemplate");
STRslider:SetPoint("TOPLEFT", STRCheckSize, "BOTTOMLEFT", 10, -20);
STRslider:SetMinMaxValues(10, 20);
STRslider.minValue, STRslider.maxValue = STRslider:GetMinMaxValues();
STRslider.Low:SetText(STRslider.minValue);
STRslider.High:SetText(STRslider.maxValue);
getglobal(STRslider:GetName() .. 'Text'):SetText('Wielkość czcionki');
getglobal(STRslider:GetName() .. 'Text'):SetFont(ST_Font, 13);
STRslider:SetValue(tonumber(ST_PM["fontsize"]));
STRslider:SetValueStep(1);
STRslider:SetScript("OnValueChanged", function(self,event,arg1) 
                                      ST_PM["fontsize"]=string.format("%d",event); 
                                      STRsliderVal:SetText(ST_PM["fontsize"]);
									           STOpis1:SetFont(ST_Font, event);
                                      end);
STRsliderVal = STROptions:CreateFontString(nil, "ARTWORK");
STRsliderVal:SetFontObject(GameFontNormal);
STRsliderVal:SetJustifyH("CENTER");
STRsliderVal:SetJustifyV("TOP");
STRsliderVal:ClearAllPoints();
STRsliderVal:SetPoint("CENTER", STRslider, "CENTER", 0, -12);
STRsliderVal:SetFont(ST_Font, 13);
STRsliderVal:SetText(ST_PM["fontsize"]);   

STOpis1 = STROptions:CreateFontString(nil, "ARTWORK");
STOpis1:SetFontObject(GameFontNormalLarge);
STOpis1:SetJustifyH("LEFT");
STOpis1:SetJustifyV("TOP");
STOpis1:ClearAllPoints();
STOpis1:SetPoint("TOPLEFT", STRslider, "BOTTOMLEFT", 200, 30);
local fontsize = tonumber(ST_PM["fontsize"]);
if (ST_PM["setsize"]=="1") then
   STOpis1:SetFont(ST_Font, fontsize);
else
   STOpis1:SetFont(ST_Font, 13);
end
STOpis1:SetText("Przykładowy tekst wielkości czcionki");

local STROptionsPrevent = STROptions:CreateFontString(nil, "ARTWORK");
STROptionsPrevent:SetFontObject(GameFontWhite);
STROptionsPrevent:SetJustifyH("LEFT"); 
STROptionsPrevent:SetJustifyV("TOP");
STROptionsPrevent:ClearAllPoints();
STROptionsPrevent:SetPoint("TOPLEFT", STRslider, "BOTTOMLEFT", -85, -30);
STROptionsPrevent:SetFont(ST_Font, 13);
STROptionsPrevent:SetText("UWAGA: tłumaczenia wyświetlane są teraz w oddzielnym oknie, obok okna z tekstem angielskim");

local STRCheckButton6 = CreateFrame("CheckButton", "STRCheckButton6", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton6.CheckBox:SetScript("OnClick", function(self) if (ST_PM["fixed"]=="1") then ST_PM["fixed"]="0" else ST_PM["fixed"]="1" end; end);
STRCheckButton6.CheckBox:SetPoint("TOPLEFT", STROptionsPrevent, "BOTTOMLEFT", -5, -10);
STRCheckButton6:SetPoint("TOPLEFT", STROptionsPrevent, "BOTTOMLEFT", 35, -10);
STRCheckButton6.Text:SetFont(ST_Font, 13);
STRCheckButton6.Text:SetText("włącz tłumaczenia elementów stałych");     -- włacz tłumaczenie danych stałych

local STRCheckButton2 = CreateFrame("CheckButton", "STRCheckButton2", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton2.CheckBox:SetScript("OnClick", function(self) if (ST_PM["item"]=="1") then ST_PM["item"]="0" else ST_PM["item"]="1" end; end);
STRCheckButton2.CheckBox:SetPoint("TOPLEFT", STRCheckButton6.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton2:SetPoint("TOPLEFT", STRCheckButton6.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton2.Text:SetFont(ST_Font, 13);
STRCheckButton2.Text:SetText("włącz tłumaczenia przedmiotów");

local STRCheckButton8 = CreateFrame("CheckButton", "STRCheckButton8", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton8.CheckBox:SetScript("OnClick", function(self) if (ST_PM["spell"]=="1") then ST_PM["spell"]="0" else ST_PM["spell"]="1" end; end);
STRCheckButton8.CheckBox:SetPoint("TOPLEFT", STRCheckButton2.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton8:SetPoint("TOPLEFT", STRCheckButton2.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton8.Text:SetFont(ST_Font, 13);
STRCheckButton8.Text:SetText("włącz tłumaczenia spelli");

local STRCheckButton9 = CreateFrame("CheckButton", "STRCheckButton9", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton9.CheckBox:SetScript("OnClick", function(self) if (ST_PM["talent"]=="1") then ST_PM["talent"]="0" else ST_PM["talent"]="1" end; end);
STRCheckButton9.CheckBox:SetPoint("TOPLEFT", STRCheckButton8.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton9:SetPoint("TOPLEFT", STRCheckButton8.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton9.Text:SetFont(ST_Font, 13);
STRCheckButton9.Text:SetText("włącz tłumaczenia talentów");   

local STRCheckButton7 = CreateFrame("CheckButton", "STRCheckButton7", STROptions, "SettingsCheckBoxControlTemplate");
STRCheckButton7.CheckBox:SetScript("OnClick", function(self) if (ST_PM["close"]=="1") then ST_PM["close"]="0" else ST_PM["close"]="1" end; end);
STRCheckButton7.CheckBox:SetPoint("TOPLEFT", STRCheckButton9.CheckBox, "BOTTOMLEFT", 0, 0);
STRCheckButton7:SetPoint("TOPLEFT", STRCheckButton9.CheckBox, "BOTTOMLEFT", 40, 0);
STRCheckButton7.Text:SetFont(ST_Font, 13);
STRCheckButton7.Text:SetText("zamknij oryginalne okno tooltip");

--local IOF_Height = InterfaceOptionsFrame:GetHeight();
--   if (IOF_Height>658) then

   local STRText0 = STROptions:CreateFontString(nil, "ARTWORK");
   STRText0:SetFontObject(GameFontWhite);
   STRText0:SetJustifyH("LEFT");
   STRText0:SetJustifyV("TOP");
   STRText0:ClearAllPoints();
   STRText0:SetPoint("TOPLEFT", STROptionsPrevent, "BOTTOMLEFT", 330, -50);
   STRText0:SetFont(ST_Font, 13);
   STRText0:SetText(ST_Messages.info_text1);

   local STRText7 = STROptions:CreateFontString(nil, "ARTWORK");
   STRText7:SetFontObject(GameFontWhite);
   STRText7:SetJustifyH("LEFT");
   STRText7:SetJustifyV("TOP");
   STRText7:ClearAllPoints();
   STRText7:SetPoint("TOPLEFT", STRText0, "BOTTOMLEFT", 0, -5);
   STRText7:SetFont(ST_Font, 13);
   STRText7:SetText("/st   "..ST_Messages.type_command0);

   local STRText1 = STROptions:CreateFontString(nil, "ARTWORK");
   STRText1:SetFontObject(GameFontWhite);
   STRText1:SetJustifyH("LEFT");
   STRText1:SetJustifyV("TOP");
   STRText1:ClearAllPoints();
   STRText1:SetPoint("TOPLEFT", STRText7, "BOTTOMLEFT", 0, -5);
   STRText1:SetFont(ST_Font, 13);
   STRText1:SetText("/st 1  "..ST_Messages.info_or.."  /st on   "..ST_Messages.type_command1);

   local STRText2 = STROptions:CreateFontString(nil, "ARTWORK");
   STRText2:SetFontObject(GameFontWhite);
   STRText2:SetJustifyH("LEFT");
   STRText2:SetJustifyV("TOP");
   STRText2:ClearAllPoints();
   STRText2:SetPoint("TOPLEFT", STRText1, "BOTTOMLEFT", 0, -5);
   STRText2:SetFont(ST_Font, 13);
   STRText2:SetText("/st 0  "..ST_Messages.info_or.."  /st off   "..ST_Messages.type_command2);

--end

local STRWWW1 = STROptions:CreateFontString(nil, "ARTWORK");
STRWWW1:SetFontObject(GameFontWhite);
STRWWW1:SetJustifyH("LEFT");
STRWWW1:SetJustifyV("TOP");
STRWWW1:ClearAllPoints();
STRWWW1:SetPoint("BOTTOMLEFT", 16, 16);
STRWWW1:SetFont(ST_Font, 13);
STRWWW1:SetText("Odwiedź stronę WWW dodatku:");
  
local STRWWW2 = CreateFrame("EditBox", "STRWWW2", STROptions, "InputBoxTemplate");
STRWWW2:ClearAllPoints();
STRWWW2:SetPoint("TOPLEFT", STRWWW1, "TOPRIGHT", 10, 4);
STRWWW2:SetHeight(20);
STRWWW2:SetWidth(200);
STRWWW2:SetAutoFocus(false);
STRWWW2:SetFontObject(GameFontGreen);
STRWWW2:SetText("https://wowpopolsku.pl");
STRWWW2:SetCursorPosition(0);
STRWWW2:SetScript("OnEnter", function(self)
   GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
   getglobal("GameTooltipTextLeft1"):SetFont(ST_Font, 13);
   GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
   GameTooltip:Show() --Show the tooltip
   end);
STRWWW2:SetScript("OnLeave", function(self)
   GameTooltip:Hide() --Hide the tooltip
   end);
STRWWW2:SetScript("OnTextChanged", function(self) STRWWW2:SetText("https://wowpopolsku.pl"); end);

  local STRdiscord2 = CreateFrame("EditBox", "STRWWW2", STROptions, "InputBoxTemplate");
  STRdiscord2:ClearAllPoints();
  STRdiscord2:SetPoint("BOTTOMLEFT", STRWWW2, "TOPLEFT", 0, 5);
  STRdiscord2:SetHeight(20);
  STRdiscord2:SetWidth(200);
  STRdiscord2:SetAutoFocus(false);
  STRdiscord2:SetFontObject(GameFontGreen);
  STRdiscord2:SetText("https://discord.gg/s5rKEJMukA");
  STRdiscord2:SetCursorPosition(0);
  STRdiscord2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(ST_Font, 13);
     GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  STRdiscord2:SetScript("OnLeave", function(self)
	  GameTooltip:Hide() --Hide the tooltip
     end);
  STRdiscord2:SetScript("OnTextChanged", function(self) STRdiscord2:SetText("https://discord.gg/s5rKEJMukA"); end);

  local STRdiscord1 = STROptions:CreateFontString(nil, "ARTWORK");
  STRdiscord1:SetFontObject(GameFontWhite);
  STRdiscord1:SetJustifyH("LEFT");
  STRdiscord1:SetJustifyV("TOP");
  STRdiscord1:ClearAllPoints();
  STRdiscord1:SetPoint("TOPRIGHT", STRdiscord2, "TOPLEFT", -10, -4);
  STRdiscord1:SetFont(ST_Font, 13);
  STRdiscord1:SetText("Discord:");
end


local function StringHash(text)        -- funkcja tworząca HashCode podanego tekstu (usuwa także zbędne dane z tekstu)
  local counter = 1;
  local pomoc = 0;
  text = string.gsub(text,"|cFFFFFFFF","");
  text = string.gsub(text,"|r","");
  text = string.gsub(text,"\r","");
  text = string.gsub(text,"\n","");
  text = string.gsub(text,"(%d),(%d)","%1%2");      -- usuń przecinek między cyframi (odstęp tysięczny)
  text = string.gsub(text,"0","");
  text = string.gsub(text,"1","");
  text = string.gsub(text,"2","");
  text = string.gsub(text,"3","");
  text = string.gsub(text,"4","");
  text = string.gsub(text,"5","");
  text = string.gsub(text,"6","");
  text = string.gsub(text,"7","");
  text = string.gsub(text,"8","");
  text = string.gsub(text,"9","");
  local len = string.len(text);
  for i = 1, len, 3 do 
    counter = math.fmod(counter*8161, 4294967279);  -- 2^32 - 17: Prime!
    pomoc = (string.byte(text,i)*16776193);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+1) or (len-i+256))*8372226);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+2) or (len-i+256))*3932164);
    counter = counter + pomoc;
  end
  return math.fmod(counter, 4294967291) -- 2^32 - 5: Prime (and different from the prime in the loop)
end


-- Przygotowuje tłumaczenie właściwe: zamienia $x w tłumaczeniu na odpowiednie liczby z oryginału
function ST_TranslatePrepare(ST_origin, ST_tlumacz)
   local tlumaczenie = string.gsub(ST_tlumacz,"$B","\n");
   tlumaczenie = string.gsub(tlumaczenie,"$b","\n");
   tlumaczenie = string.gsub(tlumaczenie, '$L', ST_miasto);          -- miasto lokalizacji do Kamienia Powrotu
   local wartab = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};         -- max. 20 liczb całkowutych w tekście
   local arg0 = 0;
   ST_origin = string.gsub(ST_origin,"(%d),(%d)","%1%2");            -- usuń przecinek tysięczny przy liczbach
   for w in string.gmatch(ST_origin, "%d+") do
      arg0 = arg0 + 1;
      wartab[arg0] = w;      -- tu mamy kolejne cyfry z oryginału
   end;
   if (arg0>19) then
      tlumaczenie=string.gsub(tlumaczenie, "$20", wartab[20]);
   end
   if (arg0>18) then
      tlumaczenie=string.gsub(tlumaczenie, "$19", wartab[19]);
   end
   if (arg0>17) then
      tlumaczenie=string.gsub(tlumaczenie, "$18", wartab[18]);
   end
   if (arg0>16) then
      tlumaczenie=string.gsub(tlumaczenie, "$17", wartab[17]);
   end
   if (arg0>15) then
      tlumaczenie=string.gsub(tlumaczenie, "$16", wartab[16]);
   end
   if (arg0>14) then
      tlumaczenie=string.gsub(tlumaczenie, "$15", wartab[15]);
   end
   if (arg0>13) then
      tlumaczenie=string.gsub(tlumaczenie, "$14", wartab[14]);
   end
   if (arg0>12) then
      tlumaczenie=string.gsub(tlumaczenie, "$13", wartab[13]);
   end
   if (arg0>11) then
      tlumaczenie=string.gsub(tlumaczenie, "$12", wartab[12]);
   end
   if (arg0>10) then
      tlumaczenie=string.gsub(tlumaczenie, "$11", wartab[11]);
   end
   if (arg0>9) then
      tlumaczenie=string.gsub(tlumaczenie, "$10", wartab[10]);
   end
   if (arg0>8) then
      tlumaczenie=string.gsub(tlumaczenie, "$9", wartab[9]);
   end
   if (arg0>7) then
      tlumaczenie=string.gsub(tlumaczenie, "$8", wartab[8]);
   end
   if (arg0>6) then
      tlumaczenie=string.gsub(tlumaczenie, "$7", wartab[7]);
   end
   if (arg0>5) then
      tlumaczenie=string.gsub(tlumaczenie, "$6", wartab[6]);
   end
   if (arg0>4) then
      tlumaczenie=string.gsub(tlumaczenie, "$5", wartab[5]);
   end
   if (arg0>3) then
      tlumaczenie=string.gsub(tlumaczenie, "$4", wartab[4]);
   end
   if (arg0>2) then
      tlumaczenie=string.gsub(tlumaczenie, "$3", wartab[3]);
   end
   if (arg0>1) then
      tlumaczenie=string.gsub(tlumaczenie, "$2", wartab[2]);
   end
   if (arg0>0) then
      tlumaczenie=string.gsub(tlumaczenie, "$1", wartab[1]);
   end
   return tlumaczenie
end


-- Funkcja przegląda wyświetlane itemy,spelle i talenty w oknie Tooltip
function ST_GameTooltip_ShowItemSpell(obj)        
--print("Obsługa w ShowItemSpell");

   local ST_ID = 0;
   local ST_prefix = "?";
   local ST_itemName, ST_itemLink = obj:GetItem();    -- sprawdzamy co wywołało tooltip: item czy spell/talent
   local ST_spellName, ST_spellID = obj:GetSpell();
   if ((ST_itemName) or (ST_spellName)) then                         
      if (ST_itemName) then                              -- mamy do czynienia z itemem
         local ST_itemID, ST_itemType, ST_itemSubType = GetItemInfoInstant(ST_itemLink);
         if (not ST_itemID) then
            return;
         end
         ST_prefix = "i";
         ST_ID = ST_itemID;
      end

      if (ST_spellName) then                             -- jest to spell (lub talent)
         ST_prefix = "s";
         if (ClassTalentFrame and ClassTalentFrame:IsVisible() and string.sub(ClassTalentFrameTitleText:GetText(),1,6)=="Talent") then
            local PTFleft = ClassTalentFrame:GetLeft();
            local PTFright = ClassTalentFrame:GetRight();
            local PTFbootom = ClassTalentFrame:GetBottom();
            local PTFtop = ClassTalentFrame:GetTop();
            local x,y = GetCursorPosition();
            if (x>PTFleft and x<PTFright and y>PTFbootom and y<PTFtop) then
               ST_prefix = "t";
            end
         end
         ST_ID = ST_spellID;
      end

      local leftText = {};    -- inicjacja tablic na odczytane oryginalne dane
      local leftColR = {};
      local leftColG = {};
      local leftColB = {};
      local leftSize = {};
      
      local rightText = {};
      local rightColR = {};
      local rightColG = {};
      local rightColB = {};
      local rightSize = {};

      local numLines = obj:NumLines();      -- liczba linii w oryginalnym GameTooltip
      
      -- zapisz wszystkie linie oryginalnej ramki GameTooltip
      for i = 1, numLines, 1 do
         leftText[i] = _G[obj:GetName().."TextLeft"..i]:GetText();
         leftColR[i], leftColG[i], leftColB[i] = _G[obj:GetName().."TextLeft"..i]:GetTextColor();
         _font1, leftSize[i], _1 = _G[obj:GetName().."TextLeft"..i]:GetFont();       -- odczytaj aktualną czcionkę i rozmiar    
         if (_G[obj:GetName().."TextRight"..i]) then          -- jeśli istnieje prawy tekst
            rightText[i] = _G[obj:GetName().."TextRight"..i]:GetText();
            rightColR[i], rightColG[i], rightColB[i] = _G[obj:GetName().."TextRight"..i]:GetTextColor();
            _font1, rightSize[i], _1 = _G[obj:GetName().."TextRight"..i]:GetFont();     -- odczytaj aktualną czcionkę i rozmiar
         end
      end

      local ST_kodKoloru, ST_pomoc0, ST_pomoc1, ST_pomoc2, ST_pomoc3, ST_pomoc4, ST_pomoc5, ST_pomoc6, ST_pomoc7, ST_pomoc8;
      local ST_leftText, ST_rightText, ST_leftTextR, ST_leftTextG, ST_leftTextB, ST_info, ST_tlumaczenie, ST_hash, ST_origin;
      local ST_info, ST_tlumaczenie, ST_hash, ST_origin;
      local _font1, _size1, _1, p1, p2;
      local ST_orygText = {};
      local ST_nh = 0;                       -- nowy Hash ?
      local oddzielna = true;
      
      -- pierwsza linia z tytułem przedmiotu,spella,talentu
      ST_objName = _G[obj:GetName().."TextLeft1"]:GetText();
      
      ST_MyGameTooltip:SetOwner(WorldFrame, "ANCHOR_NONE" );
      ST_MyGameTooltip:ClearAllPoints();
      ST_GameTooltip_x, ST_GameTooltip_y = obj:GetCenter();   -- koordynaty środka ramki GameTooltip
      local ST_GTownerName = obj:GetOwner():GetName();        -- nazwa przycisku, do którego jest opis
--print(ST_GTownerName);      

      if ((ST_PM["close"]=="1") and ST_GTownerName) then                   -- będziemy zamykać oryginalne okno Tooltip
         if (ST_GameTooltip_x > ST_width2) then       -- na prawo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPRIGHT", obj, "TOPRIGHT", 0, 0);             -- wpinamy się w górny, prawy róg oryginalnego okna
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMRIGHT", obj, "BOTTOMRIGHT", 0, 0);       -- wpinamy się w dolny, prawy róg oryginalnego okna
            end
         else                                         -- na lewo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPLEFT", obj, "TOPLEFT", 0, 0);               -- wpinamy się w górny, lewy róg oryginalnego okna
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMLEFT", obj, "BOTTOMLEFT", 0, 0);         -- wpinamy się w dolny, lewy róg oryginalnego okna
            end
         end
      else                                            -- nie będziemy zamykać oryginalnego okna Tooltip
         if (ST_GameTooltip_x > ST_width2) then       -- na prawo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPRIGHT", obj, "BOTTOMRIGHT", 0, 0);          -- pod oryginalnym oknem do prawego boku
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMRIGHT", obj, "TOPRIGHT", 0, 0);          -- nad oryginalnym oknem do prawego boku
            end
         else                                         -- na lewo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPLEFT", obj, "BOTTOMLEFT", 0, 0);            -- pod oryginalnym oknem do lewego boku
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMLEFT", obj, "TOPLEFT", 0, 0);            -- nad oryginalnym oknem do lewego boku
            end
         end
      end
         
      ST_MyGameTooltip:ClearLines();
      ST_MyGameTooltip:AddLine(ST_objName,leftColR[1],leftColG[1],leftColB[1]);  -- wersja angielska tytułu
      _G["ST_MyGameTooltipTextLeft1"]:SetFont(ST_Font, leftSize[1]);
      if ((ST_PM["title"]=="1") and (ST_TooltipsTI[ST_objName])) then            -- jest zezwolenie na tłumaczenie tytułu
         local ST_titleLG = ST_split(ST_TooltipsTI[ST_objName],"##");
         if (ST_titleLG[1] and (string.len(ST_titleLG[1])>1)) then
            _G["ST_MyGameTooltipTextLeft1"]:SetText(ST_titleLG[1]);   
         end
      end

      for i = 2, numLines, 1 do
         -- tu mamy blok funkcji dokonującej tłumaczenia
         ST_kodKoloru = OkreslKodKoloru(leftColR[i], leftColG[i], leftColB[i]);
         ST_pomoc1, _ = string.find(leftText[i],"Use: ");         -- w linii jest słowo: Use: 
         ST_pomoc2, _ = string.find(leftText[i],"+");             -- w linii jest znak: + czyli sa to statystyki do zbroji
         ST_pomoc3, _ = string.find(leftText[i],"Item Level");
         ST_pomoc4, _ = string.find(leftText[i],"Mining;");
         ST_pomoc5, _ = string.find(leftText[i],'"Used ');        -- w linii jest słowo: Used 
         ST_pomoc6, _ = string.find(leftText[i],'"%) Set: ');     -- w linii jest sekwencja: %) Set: 
         ST_pomoc7, _ = string.find(leftText[i],"->");
         ST_pomoc8, _ = string.find(leftText[i],"#rezerwa#");
         if ( (string.sub(leftText[i],1,1)~="\n") and leftText[i] and (string.len(leftText[i])>1) ) then
            if (((ST_kodKoloru=="c3" or ST_kodKoloru=="c4") and (ST_pomoc2==nil) and (ST_pomoc3==nil)) or ST_pomoc1 or ST_pomoc5 or ST_pomoc6) then  -- tu jest tekst wyszczególniony
               if (ST_ID and (ST_prefix == "i") and (ST_ID == 6948)) then  -- wyjątek na Kamień Powrotu
                  ST_pomoc5, _ = string.find(leftText[i]," Speak");        -- znajdź kropkę kończącą pierwsze zdanie
                  ST_miasto = string.sub(leftText[i],21,ST_pomoc5-2);
                  ST_pomoc6, _ = string.find(leftText[i],' Min Cooldown)');
                  if (ST_pomoc6) then              -- mamy 2 wersję tekstu z Cooldown
                     ST_hash = 1336493626;
                  else                             -- 1 wersja tekstu (bez Cooldown)
                     ST_hash = 3076025968;
                  end
               else
                  ST_hash = StringHash(leftText[i]);
               end
               if (ST_TooltipsHS[ST_hash]) then
                  ST_tlumaczenie = ST_TooltipsHS[ST_hash];
                  ST_tlumaczenie = ST_TranslatePrepare(leftText[i], ST_tlumaczenie);
                  leftText[i] = ST_tlumaczenie;
               else
                  ST_nh = 1;              -- nowy Hash
                  table.insert(ST_orygText,leftText[i]);
               end
            elseif (leftText[i] and (ST_pomoc7==nil) and (ST_PM["fixed"]=="1")) then    -- jest zezwolenie na tłumaczenie danych stałych
               ST_info = Przetlumacz(leftText[i]);                                 -- przetłumacz teksty stałe
               if ((ST_info == leftText[i]) and (string.len(leftText[i])>2) and (string.sub(leftText[i],1,2)~="|T")) then  -- nic nie przetłumaczono
--                  if (ST_kodKoloru ~= "c3") then
                     ST_PI[ST_info]=leftText[i];         -- zapisz
--                  end
               else
                  leftText[i] = ST_info;
               end
            end
         end
         if (rightText[i] and (ST_PM["fixed"]=="1")) then          -- jest zezwolenie na tłumaczenie danych stałych
            ST_info = Przetlumacz(rightText[i]);
            if ((ST_info == rightText[i]) and (string.len(rightText[i])>2) and (string.sub(rightText[i],1,2)~="|T")) then  -- nic nie przetłumaczono
               ST_PI[ST_info]=rightText[i];        -- zapisz
            else
               rightText[i] = ST_info;
            end               
         end
      
      -- koniec bloku funkcji dokonującej tłumaczenia - zapisz tłumaczenia do okna z tłumaczeniami
         if (rightText[i]) then     -- jest prawa linia
            ST_MyGameTooltip:AddDoubleLine(leftText[i], rightText[i], leftColR[i], leftColG[i], leftColB[i], rightColR[i], rightColG[i], rightColB[i]);
            _G["ST_MyGameTooltipTextLeft"..i]:SetFont(ST_Font, leftSize[i]);
            _G["ST_MyGameTooltipTextRight"..i]:SetFont(ST_Font, rightSize[i]);
         else                       -- tylko lewa linia
            ST_MyGameTooltip:AddLine(leftText[i], leftColR[i], leftColG[i], leftColB[i], 1, true);
            _G["ST_MyGameTooltipTextLeft"..i]:SetFont(ST_Font, leftSize[i]);
         end
         
      end
      
      if ((ST_PM["close"]=="1") and ST_GTownerName) then    
         obj:GetOwner():SetScript("OnLeave", function() ST_MyGameTooltip:Hide(); end);     -- Hide() kasuje Ownera
         obj:Hide();          -- zamyka oryginalna ramkę Tooltip
      else
         obj:SetScript("OnHide", function() ST_MyGameTooltip:Hide(); end);        
      end

      if (ST_PM["showID"]=="1") then            -- czy dodawać ID itemu ?
         numLines = ST_MyGameTooltip:NumLines();           -- aktualna liczba linii w MyGameTooltip
         if (numLines > 0 and _G["ST_MyGameTooltipTextLeft"..numLines]:GetText()~=" ") then
            ST_MyGameTooltip:AddLine(" ",0,0,0);           -- dodaj odstęp przed linią z ID
         end
         local tyt = "";
         local typName = "";
         if (ST_prefix == "i") then
            typName = "Item";
         elseif (ST_prefix == "s") then
            typName = "Spell";
         elseif (ST_prefix == "t") then
            typName = "Talent";
         end
         if (ST_hash) then
            tyt = "Hash: "..tostring(ST_hash);
            if (ST_ID) then
               ST_MyGameTooltip:AddDoubleLine(typName.." ID: "..tostring(ST_ID),tyt,0,1,1,0,1,1);
            else
               ST_MyGameTooltip:AddDoubleLine(typName,tyt,0,1,1,0,1,1);
            end
         else   
            if (ST_ID) then
               ST_MyGameTooltip:AddLine(typName.." ID: "..tostring(ST_ID),0,1,1);
            else
               ST_MyGameTooltip:AddLine(typName,0,1,1);
            end
         end
         numLines = ST_MyGameTooltip:NumLines();      -- Aktualna liczba linii w ST_MyGameTooltip
         _G["ST_MyGameTooltipTextLeft"..numLines]:SetFont(ST_Font, 12);	   -- wielkość 12
         _G["ST_MyGameTooltipTextRight"..numLines]:SetFont(ST_Font, 12);	-- wielkość 12
      end

      ST_MyGameTooltip:Show();      -- odśwież wyświetloną ramkę (zrobi także resize)
      
      if (obj:IsVisible()) then       -- sprawdź, czy okna się nie nakładają (jedno nad drugim)
         local _1,ST_oryg_y0 = obj:GetCenter();
         local ST_oryg_y1 = obj:GetTop();
         local ST_oryg_y2 = obj:GetBottom();
         local _2,ST_ramka_y0 = ST_MyGameTooltip:GetCenter();
         local ST_ramka_y1 = ST_MyGameTooltip:GetTop();
         local ST_ramka_y2 = ST_MyGameTooltip:GetBottom();
         if (((ST_ramka_y1 > ST_oryg_y2) and (ST_ramka_y0 < ST_oryg_y0)) or ((ST_oryg_y1 - ST_ramka_y2 < -2) and (ST_ramka_y0 > ST_oryg_y0))) then     -- ramki nakładaja się - wyświetl obok siebie
            if (ST_GameTooltip_x < ST_width2) then                                        -- oryginalna ramka jest w lewej części ekranu
               ST_MyGameTooltip:SetPoint("TOPLEFT", obj, "TOPRIGHT", 0, 0);               -- wyświetlaj na prawo od oryginalnego Tooltip
            else
               ST_MyGameTooltip:SetPoint("TOPRIGHT", obj, "TOPLEFT", 0, 0);               -- wyświetlaj na leawo od oryginalnego Tooltip
            end
            ST_MyGameTooltip:Show();   -- wyświetla ramkę (zrobi także resize)
         end
      end
      
      if ((ST_PM["saveNW"]=="1") and (ST_ID)) then      -- jest zezwolenie na zapis
         if (ST_itemType and not ST_TooltipsID[ST_prefix..tostring(ST_ID)]) then   -- brak tłumaczenia w bazie
            ST_PS[ST_prefix..tostring(ST_ID)]="Item@"..ST_objName.."@"..ST_itemType.."@"..ST_itemSubType;
         end
         if (ST_orygText or (ST_nh==1)) then
            for _, ST_origin in ipairs(ST_orygText) do   
               ST_hash = StringHash(ST_origin);
               if (not ST_TooltipsHS[ST_hash]) then
                  ST_origin = string.gsub(ST_origin,"(%d),(%d)","%1%2");      -- usuń przecinek między cyframi (odstęp tysięczny)
                  ST_origin = string.gsub(ST_origin,"\r","");
                  ST_origin = string.gsub(ST_origin,"\n","$B");
                  ST_PH[ST_hash]=ST_prefix..tostring(ST_ID).."@"..ST_origin;
               end
            end
         end
      end
      
   end     
end      -- function
    

-- funkcja wywoływana po wyświetleniu się oryginalnego okienka Tooltip
GameTooltip:HookScript('OnShow', function(self, ...)        -- do obsługi BuffButtonX
--print("Jestem w OnShow");
   if (ST_PM["active"]=="1") then          -- dodatek aktywny
      self:SetScript("OnHide", nil);             -- wyłączenie zdarzenia na GameTooltip
      ST_curr_time = GetTime();
           
      if (ST_MyGameTooltip:IsVisible()) then     -- nasze okno z tłumaczeniami jest już otwarte
         if (ST_curr_time > ST_last_open + 10) then   -- okno otwarte przez conajmniej 10 sekund
            ST_MyGameTooltip:Hide();
         else
            return;
         end
      end
   
      ST_last_open = GetTime();
      local numLines = self:NumLines();
      if (numLines == 1) then     -- GameTooltip zawiera tylko 1 linijkę opisu - pomijamy
         return;
      end
   
      ST_GameTooltip_x, ST_GameTooltip_y = self:GetCenter();      -- koordynaty środka ramki GameTooltip
      local ST_itemNameX, ST_itemLink = self:GetItem();
      local ST_spellNameX, ST_spellID = self:GetSpell();
      if ((ST_itemNameX) or (ST_spellNameX)) then
         ST_GameTooltip_ShowItemSpell(self);
         return;
      end

      if (self:GetOwner():GetName()=="UIParent") then       -- najechano myszką na gracza lub NPC
         return;
      end
--print("Obsługa w OnShow");
      -- tu jeszcze obsługa buffów i debuffów oraz ramek, w których nie udało się określić ID
      local ST_BFisOver = BuffFrame.AuraContainer:IsMouseOver();
      local ST_DFisOver = DebuffFrame.AuraContainer:IsMouseOver();
      if (MountJournal and MountJournal:IsVisible()) then
         ST_MOisOver = MountJournal:IsMouseOver();
      end
      if (SpellFrame and SpellFrame:IsVisible()) then
         ST_SPisOver = SpellFrame:IsMouseOver();
      end

      local ST_kodKoloru, ST_pomoc0, ST_pomoc1, ST_pomoc2, ST_pomoc3, ST_pomoc4, ST_pomoc5, ST_pomoc6, ST_pomoc7, ST_pomoc8;
      local ST_leftText, ST_rightText, ST_leftTextR, ST_leftTextG, ST_leftTextB, ST_info, ST_tlumaczenie, ST_hash, ST_origin;
      local _font1, _size1, _1, ST_title, ST_titleLG, ST_newID;
      local ST_orygText = {};
      local ST_nh = 0;                       -- nowy Hash ?
      
      ST_title = _G[self:GetName().."TextLeft1"]:GetText();
      local ST_prefix = "h"..ST_title;    -- typ hash z buffButton
      if (ST_TooltipsTI[ST_title]) then   -- jest tłumaczenie tytułu w bazie
         local ST_spliter = ST_split(ST_TooltipsTI[ST_title],"##");           -- nazwa_EN = nazwa_LG##xID
         ST_titleLG = ST_spliter[1];      -- przetłumaczona nazwa
         ST_prefix = ST_spliter[2];       -- ID elementu
      end
      local leftColR, leftColG, leftColB = _G[self:GetName().."TextLeft1"]:GetTextColor();
      ST_MyGameTooltip:SetOwner(WorldFrame, "ANCHOR_NONE" );
      ST_MyGameTooltip:ClearAllPoints();
      if (ST_MOisOver) then            -- Mount frame
         ST_MyGameTooltip:SetPoint("TOPLEFT", self:GetOwner(), "TOPRIGHT", 0, 0);       -- obok przycisku na prawo
      elseif ((ST_BFisOver or ST_DFisOver) and (ST_PM["close"]=="1")) then              -- Buffy i Debuffy
         ST_MyGameTooltip:SetPoint("TOPRIGHT", self:GetOwner(), "BOTTOMLEFT", 0, 0);    -- pod przyciskiem na lewo
      elseif ((self:GetOwner()) and (ST_PM["close"]=="1")) then                         -- będzie wyświetlane w miejscu oryginalnego okna
         ST_MyGameTooltip:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", 0, 0);           -- miejsce oryginalnego okna do prawego, dolnego
      else
         if (ST_GameTooltip_x > ST_width2) then       -- na prawo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPRIGHT", self, "BOTTOMRIGHT", 0, 0);             -- pod oryginalnym oknem do prawego boku
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT", 0, 0);             -- nad oryginalnym oknem do prawego boku
            end
         else                                         -- na lewo od środka ekranu
            if (ST_GameTooltip_y > ST_height2) then   -- w górę od środka ekranu
               ST_MyGameTooltip:SetPoint("TOPLEFT", self, "BOTTOMLEFT", 0, 0);               -- pod oryginalnym oknem do lewego boku
            else   
               ST_MyGameTooltip:SetPoint("BOTTOMLEFT", self, "TOPLEFT", 0, 0);               -- nad oryginalnym oknem do lewego boku
            end
         end
      end
      ST_MyGameTooltip:ClearLines();
      ST_MyGameTooltip:AddLine(ST_title,leftColR,leftColG,leftColB);
      if (ST_PM["title"]=="1") then          -- jest zezwolenie na tłumaczenie tytułu
         if (ST_titleLG and (string.len(ST_titleLG)~="?")) then                     -- jest tłumaczenie tytułu w bazie
            local _font2, _size2, _2 = _G["GameTooltipTextLeft1"]:GetFont();     -- odczytaj aktualną czcionkę i rozmiar
            _G["ST_MyGameTooltipTextLeft1"]:SetText(ST_titleLG);
            _G["ST_MyGameTooltipTextLeft1"]:SetFont(ST_Font, _size2);
         else
            ST_PS[ST_prefix]="Title@"..ST_title;
         end
      end
         
      for i = 2, numLines, 1 do
         ST_leftText = _G[self:GetName().."TextLeft"..i]:GetText();
         ST_hash = StringHash(ST_leftText);
         leftColR, leftColG, leftColB = _G[self:GetName().."TextLeft"..i]:GetTextColor();
         ST_MyGameTooltip:AddLine(ST_leftText,leftColR,leftColG,leftColB,1,true);
         if (ST_TooltipsHS[ST_hash]) then        -- mamy przetłumaczony ten Hash
            ST_tlumaczenie = ST_TooltipsHS[ST_hash];
            ST_tlumaczenie = ST_TranslatePrepare(ST_leftText, ST_tlumaczenie);
            _font1, _size1, _1 = _G[self:GetName().."TextLeft"..i]:GetFont();    -- odczytaj aktualną czcionkę i rozmiar
            _G["ST_MyGameTooltipTextLeft"..i]:SetText(ST_tlumaczenie);
            _G["ST_MyGameTooltipTextLeft"..i]:SetFont(ST_Font, _size1);
         else
            ST_nh = 1;              -- nowy Hash
            table.insert(ST_orygText,ST_leftText);
         end
      end
      
      if (ST_PM["showID"]=="1" and ST_hash) then                     -- pokaż nr Hasha
         ST_MyGameTooltip:AddLine(" ",0,0,0);                        -- dodaj odstęp przed ID
         local typName, typ, numID;
         tyt = "Hash: "..tostring(ST_hash);
         if (string.sub(ST_prefix,1,1)=="h") then
            ST_MyGameTooltip:AddDoubleLine(" ",tyt,0,1,1,0,1,1);
         else
            if (string.sub(ST_prefix,1,1)=="i") then
               typName = "Item ID: "..string.sub(ST_prefix,2);
            elseif (string.sub(ST_prefix,1,1)=="s") then
               typName = "Spell ID: "..string.sub(ST_prefix,2);
            elseif (string.sub(ST_prefix,1,1)=="t") then
               typName = "Talent ID: "..string.sub(ST_prefix,2);
            else
               typName = "";
            end
            ST_MyGameTooltip:AddDoubleLine(typName,tyt,0,1,1,0,1,1);
         end
         _G["ST_MyGameTooltipTextLeft"..ST_MyGameTooltip:NumLines()]:SetFont(ST_Font, 12);      -- wielkość 12
         _G["ST_MyGameTooltipTextRight"..ST_MyGameTooltip:NumLines()]:SetFont(ST_Font, 12);	   -- wielkość 12
      end

      if ((ST_PM["close"]=="1") and self:GetOwner()) then    
         self:GetOwner():SetScript("OnLeave", function() ST_MyGameTooltip:Hide(); end);     -- uwaga - Hide() kasuje Ownera
         self:Hide();            -- oryginalny Tooltip jest zamykany
      else
         self:SetScript("OnHide", function() ST_MyGameTooltip:Hide(); end);        
      end
      
      ST_MyGameTooltip:Show();   -- wyświetla ramkę (zrobi także resize)
      
      if ((self:IsVisible()) and (not ST_MOisOver)) then       -- sprawdź, czy okna się nie nakładają (jedno nad drugim)
         local _1,ST_oryg_y0 = self:GetCenter();
         local ST_oryg_y1 = self:GetTop();
         local ST_oryg_y2 = self:GetBottom();
         local _2,ST_ramka_y0 = ST_MyGameTooltip:GetCenter();
         local ST_ramka_y1 = ST_MyGameTooltip:GetTop();
         local ST_ramka_y2 = ST_MyGameTooltip:GetBottom();
         if (((ST_ramka_y1 > ST_oryg_y2) and (ST_ramka_y0 < ST_oryg_y0)) or ((ST_oryg_y1 - ST_ramka_y2 < -2) and (ST_ramka_y0 > ST_oryg_y0))) then     -- ramki nakładaja się - wyświetl obok siebie
            if (ST_GameTooltip_x < ST_width2) then                                        -- oryginalna ramka jest w lewej części ekranu
               ST_MyGameTooltip:SetPoint("TOPLEFT", self, "TOPRIGHT", 0, 0);              -- wyświetlaj na prawo od oryginalnego Tooltip
            else
               ST_MyGameTooltip:SetPoint("TOPRIGHT", self, "TOPLEFT", 0, 0);              -- wyświetlaj na leawo od oryginalnego Tooltip
            end
            ST_MyGameTooltip:Show();   -- wyświetla ramkę (zrobi także resize)
         end
      end
      
      if ((ST_orygText or (ST_nh==1)) and (ST_PM["saveNW"]=="1")) then
         for _, ST_origin in ipairs(ST_orygText) do   
            ST_hash = StringHash(ST_origin);
            if (not ST_TooltipsHS[ST_hash]) then
               ST_origin = string.gsub(ST_origin,"(%d),(%d)","%1%2");      -- usuń przecinek między cyframi (odstęp tysięczny)
               ST_origin = string.gsub(ST_origin,"\r","");
               ST_origin = string.gsub(ST_origin,"\n","$B");
               ST_PH[ST_hash]=ST_prefix.."@"..ST_origin;
            end
         end
      end

   end
   
end );      


ST_MyGameTooltip = CreateFrame( "GameTooltip", "ST_MyGameTooltip", UIParent, "GameTooltipTemplate" );
ST_MyGameTooltip:SetOwner(WorldFrame, "ANCHOR_NONE" );

SlashCmdList["WOWPOPOLSKU_TOOLTIPS"] = function(msg) ST_SlashCommand(msg); end
SLASH_WOWPOPOLSKU_TOOLTIPS1 = "/wowpopolsku-tooltips";
SLASH_WOWPOPOLSKU_TOOLTIPS2 = "/st";
ST_CheckVars();
ST_BlizzardOptions();

DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Tooltips ver. "..ST_version.." - "..ST_Messages.loaded);

local STR = CreateFrame("Frame");
STR.WelcomePanel = CreateFrame("Frame", nil, UIParent, "UIPanelDialogTemplate");
STR.WelcomePanel:SetWidth(600);
STR.WelcomePanel:SetHeight(300);
STR.WelcomePanel:ClearAllPoints();
STR.WelcomePanel:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
STR.WelcomePanel:SetFrameStrata("TOOLTIP");
STR.WelcomePanel.Title:SetText("WoWpoPolsku - Tooltips");
STR.WelcomePanel.Text = STR.WelcomePanel:CreateFontString(nil, "ARTWORK");
STR.WelcomePanel.Text:SetFontObject(GameFontWhite);
STR.WelcomePanel.Text:SetJustifyH("LEFT"); 
STR.WelcomePanel.Text:SetJustifyV("TOP");
STR.WelcomePanel.Text:ClearAllPoints();
STR.WelcomePanel.Text:SetPoint("TOPLEFT", STR.WelcomePanel, "TOPLEFT", 20, -40);
STR.WelcomePanel.Text:SetWidth(570);
STR.WelcomePanel.Text:SetText("UWAGA użytkownicy dodatku |cffff00ffWoWpoPolsku - Tooltips|r!\n\nDodatek |cffff00ffWoWpoPolsku - Tooltips|r nie będzie już więcej utrzymywany.\n\nAle w jego miejsce uruchamiamy zupełnie nowy, zintegrowany dodatek\n|cff00ffffAll-in-One|r zawierający w jednym dodatku wszystkie dostępne dodatki w ramach projektu |cff00ffffWoWpoPolsku|r.\n\nNazwa tego jednego dodatku, to po prostu: |cffff00ffWoWpoPolsku|r\n\nZapraszamy już dziś do pobrania nowego dodatku.\n\n\n|cffff00ffPlatine|r - autor");
STR.WelcomePanel.Text:SetFont(ST_Font, 15);
STR.WelcomePanel.Button = CreateFrame("Button",nil, STR.WelcomePanel, "UIPanelButtonTemplate");
STR.WelcomePanel.Button:SetWidth(160);
STR.WelcomePanel.Button:SetHeight(20);
STR.WelcomePanel.Button:SetText("OK - przeczytano");
STR.WelcomePanel.Button:ClearAllPoints();
STR.WelcomePanel.Button:SetPoint("BOTTOMLEFT", STR.WelcomePanel, "BOTTOMLEFT", STR.WelcomePanel:GetWidth()/2-STR.WelcomePanel.Button:GetWidth()/2, 10);
STR.WelcomePanel.Button:Show();
STR.WelcomePanel.Button:SetScript("OnClick", function() STR.WelcomePanel:Hide(); end);
STR.WelcomePanel:Show();
