﻿-- Addon: WoWpoPolsku_Quests (wersja: 8.18) 2022.10.14
-- Opis: AddOn wyświetla przetłumaczone questy w języku polskim.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- Addon project page: https://wowpopolsku.pl

-- Zmienne lokalne
local QTR_version = GetAddOnMetadata("WoWpoPolsku_Quests", "Version");
local QTR_onDebug = false;      
local QTR_name = UnitName("player");
local QTR_class= UnitClass("player");
local QTR_race = UnitRace("player");
local QTR_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local QTR_waitTable = {};
local QTR_waitFrame = nil;
local QTR_MessOrig = {
      details    = "Description", 
      objectives = "Objectives", 
      rewards    = "Rewards", 
      itemchoose1= "You will be able to choose one of these rewards:", 
      itemchoose2= "Choose one of these rewards:", 
      itemreceiv1= "You will also receive:", 
      itemreceiv2= "You receiving the reward:", 
      learnspell = "Learn Spell:", 
      reqmoney   = "Required Money:", 
      reqitems   = "Required items:", 
      experience = "Experience:", 
      currquests = "Current Quests", 
      avaiquests = "Available Quests", };
local QTR_quest_EN = {
      id = 0,
      title = "",
      details = "",
      objectives = "",
      progress = "",
      completion = "",
      itemchoose = "",
      itemreceive = "", };      
local QTR_quest_LG = {
      id = 0,
      title = "",
      details = "",
      objectives = "",
      progress = "",
      completion = "",
      itemchoose = "",
      itemreceive = "", };      
local QTR_Reklama = {
      ON = "Reklamuj dodatek na czacie kanału nr:",
      PERIOD= "Okres czasu pomiędzy kolejnymi reklamami:",
      CHOICE= "Który tekst wyświetlać? (gdy zaznaczysz oba, to naprzemian):",
      OTHER1= "tłumacz w dodatku QuestGuru ",
      OTHER2= "tłumacz w dodatku Immersion ",
      OTHER3= "tłumacz w dodatku Storyline ",
      ACTIV1= "(aktywny)",
      ACTIV2= "(nieaktywny)",
      WWW1  = "Odwiedź stronę WWW dodatku:",
      WWW2  = "https://wowpopolsku.pl",
      WWW3  = "kliknij i wciśnij Ctrl+C aby skopiować do schowka",
      TEXT1 = "WoWpoPolsku-Quests - addon that displays the translated quests (wowpopolsku.pl)",
      TEXT2 = "WoWpoPolsku-Quests - dodatek wyświetlający questy po polsku (wowpopolsku.pl)", };
local last_time = GetTime();
local last_text = 0;
local curr_trans = "1";
local curr_goss = "X";
local curr_hash = 0;
local QTR_first_show = 0;
local aktShow = 0;      -- liczba aktualnie przypisanych zdarzeń OnShow do NPE_PointerFrame
local tutShow = 0;      -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local Original_Font1 = "Fonts\\MORPHEUS.ttf";
local Original_Font2 = "Fonts\\FRIZQT__.ttf";
local QTR_FrameOnLine, QTR_FrameOnLineButton, QTR_FrameOnLineHash;
local Tut_ID = 0;
local Tut_race = string.gsub(strupper(QTR_race)," ","");
local Tut_class= string.gsub(strupper(QTR_class)," ","");
if (Tut_class == "DEATHKNIGHT") then
   Tut_race = "DEATHKNIGHT";
end
local time_ver = GetTime() - 15*60;
local Players_ver = {};           -- wersje dodatku innych graczy
local Players_ver_Count = 0;
local Version_max = {ADDON_VER=string.sub(QTR_version,1,1)..string.sub(QTR_version,-2), 
                     ALERT_ID=0,                                ADDON_COUNT=0,  ADDON_ALERT=0,
                     BASE_VER=QTR_base,   BASE_DATE=QTR_date,   BASE_COUNT=0,   BASE_ALERT=0,
                     GOSSIP_VER=GS_base,  GOSSIP_DATE=GS_date,  GOSSIP_COUNT=0, GOSSIP_ALERT=0, };
local p_race = {
      ["Blood Elf"] = { M1="Krwawy Elf", D1="krwawego elfa", C1="krwawemu elfowi", B1="krwawego elfa", N1="krwawym elfem", K1="krwawym elfie", W1="Krwawy Elfie", M2="Krwawa Elfka", D2="krwawej elfki", C2="krwawej elfce", B2="krwawą elfkę", N2="krwawą elfką", K2="krwawej elfce", W2="Krwawa Elfko" }, 
      ["Dark Iron Dwarf"] = { M1="Krasnolud Ciemnego Żelaza", D1="krasnoluda Ciemnego Żelaza", C1="krasnoludowi Ciemnego Żelaza", B1="krasnoluda Ciemnego Żelaza", N1="krasnoludem Ciemnego Żelaza", K1="krasnoludzie Ciemnego Żelaza", W1="Krasnoludzie Ciemnego Żelaza", M2="Krasnoludka Ciemnego Żelaza", D2="krasnoludki Ciemnego Żelaza", C2="krasnoludce Ciemnego Żelaza", B2="krasnoludkę Ciemnego Żelaza", N2="krasnoludką Ciemnego Żelaza", K2="krasnoludce Ciemnego Żelaza", W2="Krasnoludko Ciemnego Żelaza" },
      ["Draenei"] = { M1="Draenei", D1="draeneia", C1="draeneiowi", B1="draeneia", N1="draeneiem", K1="draeneiu", W1="Draeneiu", M2="Draeneika", D2="draeneiki", C2="draeneice", B2="draeneikę", N2="draeneiką", K2="draeneice", W2="Draeneiko" },
      ["Dwarf"] = { M1="Krasnolud", D1="krasnoluda", C1="krasnoludowi", B1="krasnoluda", N1="krasnoludem", K1="krasnoludzie", W1="Krasnoludzie", M2="Krasnoludka", D2="krasnoludki", C2="krasnoludce", B2="krasnoludkę", N2="krasnoludką", K2="krasnoludce", W2="Krasnoludko" },
      ["Gnome"] = { M1="Gnom", D1="gnoma", C1="gnomowi", B1="gnoma", N1="gnomem", K1="gnomie", W1="Gnomie", M2="Gnomka", D2="gnomki", C2="gnomce", B2="gnomkę", N2="gnomką", K2="gnomce", W2="Gnomko" },
      ["Goblin"] = { M1="Goblin", D1="goblina", C1="goblinowi", B1="goblina", N1="goblinem", K1="goblinie", W1="Goblinie", M2="Goblinka", D2="goblinki", C2="goblince", B2="goblinkę", N2="goblinką", K2="goblince", W2="Goblinko" },
      ["Highmountain Tauren"] = { M1="Tauren z Wysokiej Góry", D1="taurena z Wysokiej Góry", C1="taurenowi z Wysokiej Góry", B1="taurena z Wysokiej Góry", N1="taurenen z Wysokiej Góry", K1="taurenie z Wysokiej Góry", W1="Taurenie z Wysokiej Góry", M2="Taurenka z Wysokiej Góry", D2="taurenki z Wysokiej Góry", C2="taurence z Wysokiej Góry", B2="taurenkę z Wysokiej Góry", N2="taurenką z Wysokiej Góry", K2="taurence z Wysokiej Góry", W2="Taurenko z Wysokiej Góry" },
      ["Human"] = { M1="Człowiek", D1="człowieka", C1="człowiekowi", B1="człowieka", N1="człowiekiem", K1="człowieku", W1="Człowieku", M2="Człowiek", D2="człowieka", C2="człowiekowi", B2="człowieka", N2="człowiekiem", K2="człowieku", W2="Człowieku" },
      ["Kul Tiran"] = { M1="Kul Tiran", D1="Kul Tirana", C1="Kul Tiranowi", B1="Kul Tirana", N1="Kul Tiranem", K1="Kul Tiranie", W1="Kul Tiranie", M2="Kul Tiranka", D2="Kul Tiranki", C2="Kul Tirance", B2="Kul Tirankę", N2="Kul Tiranką", K2="Kul Tirance", W2="Kul Tiranko" },
      ["Lightforged Draenei"] = { M1="Świetlisty Draenei", D1="świetlistego draeneia", C1="świetlistemu draeneiowi", B1="świetlistego draeneia", N1="świetlistym draeneiem", K1="świetlistym draeneiu", W1="Świetlisty Draeneiu", M2="Świetlista Draeneika", D2="świetlistej draeneiki", C2="świetlistej draeneice", B2="świetlistą draeneikę", N2="świetlistą draeneiką", K2="świetlistej draeneice", W2="Świetlista Draeneiko" },
      ["Mag'har Orc"] = { M1="Ork z Mag'har", D1="orka z Mag'har", C1="orkowi z Mag'har", B1="orka z Mag'har", N1="orkiem z Mag'har", K1="orku z Mag'har", W1="Orku z Mag'har", M2="Orczyca z Mag'har", D2="orczycy z Mag'har", C2="orczycy z Mag'har", B2="orczycę z Mag'har", N2="orczycą z Mag'har", K2="orczyce z Mag'har", W2="Orczyco z Mag'har" },
      ["Nightborne"] = { M1="Dziecię Nocy", D1="dziecięcia nocy", C1="dziecięciu nocy", B1="dziecię nocy", N1="dziecięcem nocy", K1="dziecięciu nocy", W1="Dziecię Nocy", M2="Dziecię Nocy", D2="dziecięcia nocy", C2="dziecięciu nocy", B2="dziecię nocy", N2="dziecięcem nocy", K2="dziecięciu nocy", W2="Dziecię Nocy" },
      ["Night Elf"] = { M1="Nocny Elf", D1="nocnego elfa", C1="nocnemu elfowi", B1="nocnego elfa", N1="nocnym elfem", K1="nocnym elfie", W1="Nocny Elfie", M2="Nocna Elfka", D2="nocnej elfki", C2="nocnej elfce", B2="nocną elfkę", N2="nocną elfką", K2="nocnej elfce", W2="Nocna Elfko" },
      ["Orc"] = { M1="Ork", D1="orka", C1="orkowi", B1="orka", N1="orkiem", K1="orku", W1="Orku", M2="Orczyca", D2="orczycy", C2="orczycy", B2="orczycę", N2="orczycą", K2="orczycy", W2="Orczyco" },
      ["Pandaren"] = { M1="Pandaren", D1="pandarena", C1="pandarenowi", B1="pandarena", N1="pandarenem", K1="pandarenie", W1="Pandarenie", M2="Pandarenka", D2="pandarenki", C2="pandarence", B2="pandarenkę", N2="pandarenką", K2="pandarence", W2="Pandarenko" },
      ["Tauren"] = { M1="Tauren", D1="taurena", C1="taurenowi", B1="taurena", N1="taurenem", K1="taurenie", W1="Taurenie", M2="Taurenka", D2="taurenki", C2="taurence", B2="taurenkę", N2="taurenką", K2="taurence", W2="Taurenko" },
      ["Troll"] = { M1="Troll", D1="trolla", C1="trollowi", B1="trolla", N1="trollem", K1="trollu", W1="Trollu", M2="Trollica", D2="trollicy", C2="trollicy", B2="trollicę", N2="trollicą", K2="trollicy", W2="Trollico" },
      ["Undead"] = { M1="Nieumarły", D1="nieumarłego", C1="nieumarłemu", B1="nieumarłego", N1="nieumarłym", K1="nieumarłym", W1="Nieumarły", M2="Nieumarła", D2="nieumarłej", C2="nieumarłej", B2="nieumarłą", N2="nieumarłą", K2="nieumarłej", W2="Nieumarła" },
      ["Void Elf"] = { M1="Elf Pustki", D1="elfa Pustki", C1="elfowi Pustki", B1="elfa Pustki", N1="elfem Pustki", K1="elfie Pustki", W1="Elfie Pustki", M2="Elfka Pustki", D2="elfki Pustki", C2="elfce Pustki", B2="elfkę Pustki", N2="elfką Pustki", K2="elfce Pustki", W2="Elfko Pustki" },
      ["Worgen"] = { M1="Worgen", D1="worgena", C1="worgenowi", B1="worgena", N1="worgenem", K1="worgenie", W1="Worgenie", M2="Worgenka", D2="worgenki", C2="worgence", B2="worgenkę", N2="worgenką", K2="worgence", W2="Worgenko" },
      ["Zandalari Troll"] = { M1="Troll Zandalari", D1="trolla Zandalari", C1="trollowi Zandalari", B1="trolla Zandalari", N1="trollem Zandalari", K1="trollu Zandalari", W1="Trollu Zandalari", M2="Trollica Zandalari", D2="trollicy Zandalari", C2="trollicy Zandalari", B2="trollicę Zandalari", N2="trollicą Zandalari", K2="trollicy Zandalari", W2="Trollico Zandalari" }, }
local p_class = {
      ["Death Knight"] = { M1="Rycerz Śmierci", D1="rycerz śmierci", C1="rycerzowi śmierci", B1="rycerza śmierci", N1="rycerzem śmierci", K1="rycerzu śmierci", W1="Rycerzu Śmierci", M2="Rycerz Śmierci", D2="rycerz śmierci", C2="rycerzowi śmierci", B2="rycerza śmierci", N2="rycerzem śmierci", K2="rycerzu śmierci", W2="Rycerzu Śmierci" },
      ["Demon Hunter"] = { M1="Łowca demonów", D1="łowcy demonów", C1="łowcy demonów", B1="łowcę demonów", N1="łowcą demonów", K1="łowcy demonów", W1="Łowco demonów", M2="Łowczyni demonów", D2="łowczyni demonów", C2="łowczyni demonów", B2="łowczynię demonów", N2="łowczynią demonów", K2="łowczyni demonów", W2="Łowczyni demonów" },
      ["Druid"] = { M1="Druid", D1="druida", C1="druidowi", B1="druida", N1="druidem", K1="druidzie", W1="Druidzie", M2="Druidka", D2="druidki", C2="druidce", B2="druikę", N2="druidką", K2="druidce", W2="Druidko" },
      ["Hunter"] = { M1="Łowca", D1="łowcy", C1="łowcy", B1="łowcę", N1="łowcą", K1="łowcy", W1="Łowco", M2="Łowczyni", D2="łowczyni", C2="łowczyni", B2="łowczynię", N2="łowczynią", K2="łowczyni", W2="Łowczyni" },
      ["Mage"] = { M1="Czarodziej", D1="czarodzieja", C1="czarodziejowi", B1="czarodzieja", N1="czarodziejem", K1="czarodzieju", W1="Czarodzieju", M2="Czarodziejka", D2="czarodziejki", C2="czarodziejce", B2="czarodziejkę", N2="czarodziejką", K2="czarodziejce", W2="Czarodziejko" },
      ["Monk"] = { M1="Mnich", D1="mnicha", C1="mnichowi", B1="mnicha", N1="mnichem", K1="mnichu", W1="Mnichu", M2="Mniszka", D2="mniszki", C2="mniszce", B2="mniszkę", N2="mniszką", K2="mniszce", W2="Mniszko" },
      ["Paladin"] = { M1="Paladyn", D1="paladyna", C1="paladynowi", B1="paladyna", N1="paladynem", K1="paladynie", W1="Paladynie", M2="Paladynka", D2="paladynki", C2="paladynce", B2="paladynkę", N2="paladynką", K2="paladynce", W2="Paladynko" },
      ["Priest"] = { M1="Kapłan", D1="kapłana", C1="kapłanowi", B1="kapłana", N1="kapłanem", K1="kapłanie", W1="Kapłanie", M2="Kapłanka", D2="kapłanki", C2="kapłance", B2="kapłankę", N2="kapłanką", K2="kapłance", W2="Kapłanko" },
      ["Rogue"] = { M1="Łotrzyk", D1="łotrzyka", C1="łotrzykowi", B1="łotrzyka", N1="łotrzykiem", K1="łotrzyku", W1="Łotrzyku", M2="Łotrzyca", D2="łotrzycy", C2="łotrzycy", B2="łotrzycę", N2="łotrzycą", K2="łotrzycy", W2="Łotrzyco" },
      ["Shaman"] = { M1="Szaman", D1="szamana", C1="szamanowi", B1="szamana", N1="szamanem", K1="szamanie", W1="Szamanie", M2="Szamanka", D2="szamanki", C2="szamance", B2="szamankę", N2="szamanką", K2="szamance", W2="Szamanko" },
      ["Warlock"] = { M1="Czarnoksiężnik", D1="czarnoksiężnika", C1="czarnoksiężnikowi", B1="czarnoksiężnika", N1="czarnoksiężnikiem", K1="czarnoksiężniku", W1="Czarnoksiężniku", M2="Czarownica", D2="czarownicy", C2="czarownicy", B2="czarownicę", N2="czarownicą", K2="czarownicy", W2="Czarownico" },
      ["Warrior"] = { M1="Wojownik", D1="wojownika", C1="wojownikowi", B1="wojownika", N1="wojownikiem", K1="wojowniku", W1="Wojowniku", M2="Wojowniczka", D2="wojowniczki", C2="wojowniczce", B2="wojowniczkę", N2="wojowniczką", K2="wojowniczce", W2="Wojowniczko" }, }
if (p_race[QTR_race]) then      
   player_race = { M1=p_race[QTR_race].M1, D1=p_race[QTR_race].D1, C1=p_race[QTR_race].C1, B1=p_race[QTR_race].B1, N1=p_race[QTR_race].N1, K1=p_race[QTR_race].K1, W1=p_race[QTR_race].W1, M2=p_race[QTR_race].M2, D2=p_race[QTR_race].D2, C2=p_race[QTR_race].C2, B2=p_race[QTR_race].B2, N2=p_race[QTR_race].N2, K2=p_race[QTR_race].K2, W2=p_race[QTR_race].W2 };
else   
   player_race = { M1=QTR_race, D1=QTR_race, C1=QTR_race, B1=QTR_race, N1=QTR_race, K1=QTR_race, W1=QTR_race, M2=QTR_race, D2=QTR_race, C2=QTR_race, B2=QTR_race, N2=QTR_race, K2=QTR_race, W2=QTR_race };
   print ("|cff55ff00QTR - nowa rasa: "..QTR_race);
end
if (p_class[QTR_class]) then
   player_class = { M1=p_class[QTR_class].M1, D1=p_class[QTR_class].D1, C1=p_class[QTR_class].C1, B1=p_class[QTR_class].B1, N1=p_class[QTR_class].N1, K1=p_class[QTR_class].K1, W1=p_class[QTR_class].W1, M2=p_class[QTR_class].M2, D2=p_class[QTR_class].D2, C2=p_class[QTR_class].C2, B2=p_class[QTR_class].B2, N2=p_class[QTR_class].N2, K2=p_class[QTR_class].K2, W2=p_class[QTR_class].W2 };
else
   player_class = { M1=QTR_class, D1=QTR_class, C1=QTR_class, B1=QTR_class, N1=QTR_class, K1=QTR_class, W1=QTR_class, M2=QTR_class, D2=QTR_class, C2=QTR_class, B2=QTR_class, N2=QTR_class, K2=QTR_class, W2=QTR_class };
   print ("|cff55ff00QTR - nowa klasa: "..QTR_class);
end



local function StringHash(text)           -- funkcja tworząca Hash (32-bitowa liczba) podanego tekstu
  local counter = 1;
  local pomoc = 0;
  local dlug = string.len(text);
  for i = 1, dlug, 3 do 
    counter = math.fmod(counter*8161, 4294967279);  -- 2^32 - 17: Prime!
    pomoc = (string.byte(text,i)*16776193);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+1) or (dlug-i+256))*8372226);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+2) or (dlug-i+256))*3932164);
    counter = counter + pomoc;
  end
  return math.fmod(counter, 4294967291) -- 2^32 - 5: Prime (and different from the prime in the loop)
end


-- Zmienne programowe zapisane na stałe na komputerze
function QTR_CheckVars()
  if (not QTR_PS) then
     QTR_PS = {};
  end
  if (not QTR_SAVED) then
     QTR_SAVED = {};
  end
  if (not QTR_MISSING) then
     QTR_MISSING = {};
  end
  if (not QTR_GOSSIP) then
     QTR_GOSSIP = {};
  end
  if (not QTR_GOSSIP_TR) then
     QTR_GOSSIP_TR = {};
  end
  if (not QTR_TUTORIAL) then
     QTR_TUTORIAL = {};
  end
  -- inicjalizacja: tłumaczenia włączone
  if (not QTR_PS["active"]) then
     QTR_PS["active"] = "1";
  end
  -- inicjalizacja: tłumaczenie tytułu questu włączone
  if (not QTR_PS["transtitle"] ) then
     QTR_PS["transtitle"] = "0";   
  end
  -- komunikaty głosowe
  if (not QTR_PS["voices"] ) then
     QTR_PS["voices"] = "0";   
  end
  -- zmienna specjalna dostępności funkcji GetQuestID 
  if ( QTR_PS["isGetQuestID"] ) then
     isGetQuestID=QTR_PS["isGetQuestID"];
  end;
  -- okresowe wyświetlanie reklam o dodatku 
  if (not QTR_PS["reklama"] ) then
     QTR_PS["reklama"] = "0";
     QTR_PS["period"] = 20;
     QTR_PS["text1"] = "0";
     QTR_PS["text2"] = "1";
     QTR_PS["channel"] = "0";
  end;
  if (not QTR_PS["other1"] ) then
     QTR_PS["other1"] = "1";
  end;
  if (not QTR_PS["other2"] ) then
     QTR_PS["other2"] = "1";
  end;
  if (not QTR_PS["other3"] ) then
     QTR_PS["other3"] = "1";
  end;
  if (not QTR_PS["channel"] ) then
     QTR_PS["channel"] = "0";
  end;
   -- zapis wersji patcha Wow'a
--  if (not QTR_PS["patch"]) then
     QTR_PS["patch"] = GetBuildInfo();    -- zapisz za każdym razem, bo może masz mową wersję
--  end
  -- jeszcze nazwa gracza w przepadkach / per character
  if (not QTR_PC) then
     QTR_PC = {};
  end
  if (not QTR_PC["name1"] ) then
     QTR_PC["name1"] = QTR_name;
  end;
  if (not QTR_PC["name2"] ) then
     QTR_PC["name2"] = QTR_name.."a";
  end;
  if (not QTR_PC["name3"] ) then
     QTR_PC["name3"] = QTR_name.."owi";
  end;
  if (not QTR_PC["name4"] ) then
     QTR_PC["name4"] = QTR_name.."a";
  end;
  if (not QTR_PC["name5"] ) then
     QTR_PC["name5"] = QTR_name.."em";
  end;
  if (not QTR_PC["name6"] ) then
     QTR_PC["name6"] = QTR_name.."ie";
  end;
  if (not QTR_PC["name7"] ) then
     QTR_PC["name7"] = QTR_name;
  end;
  if (not QTR_PS["gossip"] ) then
     QTR_PS["gossip"] = "1";   
  end
  if (not QTR_PS["gossiponline"] ) then
     QTR_PS["gossiponline"] = "0";   
  end
  if (not QTR_PS["tutorial"] ) then
     QTR_PS["tutorial"] = "1";   
  end
  QTR_GS = {};       -- tablica na teksty oryginalne
end


-- Sprawdza dostępność funkcji specjalnej Wow'a: GetQuestID()
function DetectEmuServer()
  QTR_PS["isGetQuestID"]="0";
  isGetQuestID="0";
  -- funkcja GetQuestID() występuje tylko na serwerach Blizzarda
  if ( GetQuestID() ) then
     QTR_PS["isGetQuestID"]="1";
     isGetQuestID="1";
  end
end


-- Obsługa komend slash
function QTR_SlashCommand(msg)
   if (msg=="on" or msg=="ON") then
      if (QTR_PS["active"]=="1") then
         print ("QTR - tłumaczenie są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenie.");
         QTR_PS["active"] = "1";
         QTR_ToggleButton0:Enable();
         QTR_ToggleButton1:Enable();
         QTR_ToggleButton2:Enable();
         if (isQuestGuru()) then
            QTR_ToggleButton3:Enable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Enable();
         end
         QTR_Translate_On(1);
      end
   elseif (msg=="off" or msg=="OFF") then
      if (QTR_PS["active"]=="0") then
         print ("QTR - tłumaczenia są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia.");
         QTR_PS["active"] = "0";
         QTR_ToggleButton0:Disable();
         QTR_ToggleButton1:Disable();
         QTR_ToggleButton2:Disable();
         if (isQuestGuru()) then
            QTR_ToggleButton3:Disable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Disable();
         end
         QTR_Translate_Off(1);
      end
   elseif (msg=="title on" or msg=="TITLE ON" or msg=="title 1") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenie tytułów jest włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenie tytułów.");
         QTR_PS["transtitle"] = "1";
         QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
      end
   elseif (msg=="title off" or msg=="TITLE OFF" or msg=="title 0") then
      if (QTR_PS["transtilte"]=="0") then
         print ("QTR - tłumaczenie tytułów jest wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenie tytułów.");
         QTR_PS["transtitle"] = "0";
         QuestInfoTitleHeader:SetFont(Original_Font1, 18);
      end
   elseif (msg=="title" or msg=="TITLE") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenie tytułów jest włączone.");
      else
         print ("QTR - tłumaczenie tytułów jest wyłączone.");
      end
   elseif (msg=="") then
      InterfaceOptionsFrame_Show();
      InterfaceOptionsFrame_OpenToCategory("WoWpoPolsku-Quests");
   else
      print ("QTR - menu szybkich komend addonu:");
      print ("      /qtr on  - włącza tłumaczenia");
      print ("      /qtr off - wyłącza tłumaczenia");
      print ("      /qtr title on  - włącza tłumaczenie tytułu");
      print ("      /qtr title off - wyłącza tłumaczenie tytułu");
   end
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


function QTR_SetCheckButtonState()
  QTRCheckButton0:SetChecked(QTR_PS["active"]=="1");
  QTRCheckButton3:SetChecked(QTR_PS["transtitle"]=="1");
  QTRCheckButton4:SetChecked(QTR_PS["voices"]=="1");
  QTRCheckButton5:SetChecked(QTR_PS["reklama"]=="1");
  QTRCheckText1:SetChecked(QTR_PS["text1"]=="1");
  QTRCheckText2:SetChecked(QTR_PS["text2"]=="1");
  QTRCheckOther1:SetChecked(QTR_PS["other1"]=="1");
  QTRCheckOther2:SetChecked(QTR_PS["other2"]=="1");
  QTRCheckOther3:SetChecked(QTR_PS["other3"]=="1");
  QTREditBox:SetText(QTR_PS["channel"]);
  QTREditP1:SetText(QTR_PC["name1"]);
  QTREditP2:SetText(QTR_PC["name2"]);
  QTREditP3:SetText(QTR_PC["name3"]);
  QTREditP4:SetText(QTR_PC["name4"]);
  QTREditP5:SetText(QTR_PC["name5"]);
  QTREditP6:SetText(QTR_PC["name6"]);
  QTREditP7:SetText(QTR_PC["name7"]);
  QTRCheckButtonGossip:SetChecked(QTR_PS["gossip"]=="1");
  QTRCheckButtonOnLine:SetChecked(QTR_PS["gossiponline"]=="1");
  QTRCheckButtonTutorial:SetChecked(QTR_PS["tutorial"]=="1");
  QTR_STframe:Hide();
end



function QTR_BlizzardOptions()
  -- Create main frame for information text
  local QTROptions = CreateFrame("FRAME", "WoWpoPolsku_Quests_Options");
  QTROptions.name = "WoWpoPolsku-Quests";
  QTROptions.refresh = function (self) QTR_SetCheckButtonState() end;
  InterfaceOptions_AddCategory(QTROptions);

  local QTROptionsHeader = QTROptions:CreateFontString(nil, "ARTWORK");
  QTROptionsHeader:SetFontObject(GameFontNormalLarge);
  QTROptionsHeader:SetJustifyH("LEFT"); 
  QTROptionsHeader:SetJustifyV("TOP");
  QTROptionsHeader:ClearAllPoints();
  QTROptionsHeader:SetPoint("TOPLEFT", 16, -16);
  QTROptionsHeader:SetText("WoWpoPolsku-Quests, ver. "..QTR_version.." ("..QTR_base..") by Platine © 2010-2020");

  local QTRDateOfBase = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRDateOfBase:SetFontObject(GameFontNormalLarge);
  QTRDateOfBase:SetJustifyH("LEFT"); 
  QTRDateOfBase:SetJustifyV("TOP");
  QTRDateOfBase:ClearAllPoints();
  QTRDateOfBase:SetPoint("TOPRIGHT", QTROptionsHeader, "TOPRIGHT", 0, -22);
  QTRDateOfBase:SetText("Data bazy tłumaczeń: "..QTR_date);
  QTRDateOfBase:SetFont(QTR_Font2, 16);

  local QTRCheckButton0 = CreateFrame("CheckButton", "QTRCheckButton0", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButton0:SetPoint("TOPLEFT", QTROptionsHeader, "BOTTOMLEFT", 0, -20);
  QTRCheckButton0:SetScript("OnClick", function(self) if (QTR_PS["active"]=="1") then QTR_PS["active"]="0" else QTR_PS["active"]="1" end; end);
  QTRCheckButton0Text:SetFont(QTR_Font2, 13);
  QTRCheckButton0Text:SetText(QTR_Interface.active);

  local QTROptionsMode1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTROptionsMode1:SetFontObject(GameFontWhite);
  QTROptionsMode1:SetJustifyH("LEFT");
  QTROptionsMode1:SetJustifyV("TOP");
  QTROptionsMode1:ClearAllPoints();
  QTROptionsMode1:SetPoint("TOPLEFT", QTRCheckButton0, "BOTTOMLEFT", 30, -10);
  QTROptionsMode1:SetFont(QTR_Font2, 13);
  QTROptionsMode1:SetText(QTR_Interface.options1);
  
  local QTRCheckButton3 = CreateFrame("CheckButton", "QTRCheckButton3", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButton3:SetPoint("TOPLEFT", QTROptionsMode1, "BOTTOMLEFT", 0, -5);
  QTRCheckButton3:SetScript("OnClick", function(self) if (QTR_PS["transtitle"]=="0") then QTR_PS["transtitle"]="1" else QTR_PS["transtitle"]="0" end; end);
  QTRCheckButton3Text:SetFont(QTR_Font2, 13);
  QTRCheckButton3Text:SetText(QTR_Interface.transtitle);

  local QTRCheckButton4 = CreateFrame("CheckButton", "QTRCheckButton4", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButton4:SetPoint("TOPLEFT", QTRCheckButton3, "BOTTOMLEFT", 0, 8);
  QTRCheckButton4:SetScript("OnClick", function(self) if (QTR_PS["voices"]=="0") then QTR_PS["voices"]="1" else QTR_PS["voices"]="0" end; end);
  QTRCheckButton4Text:SetFont(QTR_Font2, 13);
  QTRCheckButton4Text:SetText("Włącz komunikaty głosowe");

  local QTROptionsMode2 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTROptionsMode2:SetFontObject(GameFontWhite);
  QTROptionsMode2:SetJustifyH("LEFT");
  QTROptionsMode2:SetJustifyV("TOP");
  QTROptionsMode2:ClearAllPoints();
  QTROptionsMode2:SetPoint("TOPLEFT", QTROptionsMode1, "TOPRIGHT", 70, 0);
  QTROptionsMode2:SetFont(QTR_Font2, 13);
  QTROptionsMode2:SetText("Nazwa gracza w różnych przypadkach:");
  
  local QTREditP1 = CreateFrame("EditBox", "QTREditP1", QTROptions, "InputBoxTemplate");
  QTREditP1:SetPoint("TOPRIGHT", QTROptionsMode2, "BOTTOMRIGHT", 0, -10);
  QTREditP1:SetHeight(20);
  QTREditP1:SetWidth(100);
  QTREditP1:SetAutoFocus(false);
  QTREditP1:SetText(QTR_PC["name1"]);
  QTREditP1:SetCursorPosition(0);
  QTREditP1:SetScript("OnTextChanged", function(self) if (strlen(QTREditP1:GetText())>0) then QTR_PC["name1"]=QTREditP1:GetText() end; end);

  local QTRName1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName1:SetFontObject(GameFontNormalLarge);
  QTRName1:SetJustifyH("LEFT"); 
  QTRName1:SetJustifyV("TOP");
  QTRName1:ClearAllPoints();
  QTRName1:SetPoint("TOPRIGHT", QTREditP1, "TOPLEFT", -8, -4);
  QTRName1:SetText("Mianownik:");
  QTRName1:SetFont(QTR_Font2, 13);

  local QTREditP2 = CreateFrame("EditBox", "QTREditP2", QTROptions, "InputBoxTemplate");
  QTREditP2:SetPoint("TOPRIGHT", QTREditP1, "BOTTOMRIGHT", 0, 0);
  QTREditP2:SetHeight(20);
  QTREditP2:SetWidth(100);
  QTREditP2:SetAutoFocus(false);
  QTREditP2:SetText(QTR_PC["name2"]);
  QTREditP2:SetCursorPosition(0);
  QTREditP2:SetScript("OnTextChanged", function(self) if (strlen(QTREditP2:GetText())>0) then QTR_PC["name2"]=QTREditP2:GetText() end; end);

  local QTRName2 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName2:SetFontObject(GameFontNormalLarge);
  QTRName2:SetJustifyH("LEFT"); 
  QTRName2:SetJustifyV("TOP");
  QTRName2:ClearAllPoints();
  QTRName2:SetPoint("TOPRIGHT", QTREditP2, "TOPLEFT", -8, -4);
  QTRName2:SetText("Dopełniacz:");
  QTRName2:SetFont(QTR_Font2, 13);

  local QTREditP3 = CreateFrame("EditBox", "QTREditP3", QTROptions, "InputBoxTemplate");
  QTREditP3:SetPoint("TOPRIGHT", QTREditP2, "BOTTOMRIGHT", 0, 0);
  QTREditP3:SetHeight(20);
  QTREditP3:SetWidth(100);
  QTREditP3:SetAutoFocus(false);
  QTREditP3:SetText(QTR_PC["name3"]);
  QTREditP3:SetCursorPosition(0);
  QTREditP3:SetScript("OnTextChanged", function(self) if (strlen(QTREditP3:GetText())>0) then QTR_PC["name3"]=QTREditP3:GetText() end; end);

  local QTRName3 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName3:SetFontObject(GameFontNormalLarge);
  QTRName3:SetJustifyH("LEFT"); 
  QTRName3:SetJustifyV("TOP");
  QTRName3:ClearAllPoints();
  QTRName3:SetPoint("TOPRIGHT", QTREditP3, "TOPLEFT", -8, -4);
  QTRName3:SetText("Celownik:");
  QTRName3:SetFont(QTR_Font2, 13);

  local QTREditP4 = CreateFrame("EditBox", "QTREditP4", QTROptions, "InputBoxTemplate");
  QTREditP4:SetPoint("TOPRIGHT", QTREditP3, "BOTTOMRIGHT", 0, 0);
  QTREditP4:SetHeight(20);
  QTREditP4:SetWidth(100);
  QTREditP4:SetAutoFocus(false);
  QTREditP4:SetText(QTR_PC["name4"]);
  QTREditP4:SetCursorPosition(0);
  QTREditP4:SetScript("OnTextChanged", function(self) if (strlen(QTREditP4:GetText())>0) then QTR_PC["name4"]=QTREditP4:GetText() end; end);

  local QTRName4 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName4:SetFontObject(GameFontNormalLarge);
  QTRName4:SetJustifyH("LEFT"); 
  QTRName4:SetJustifyV("TOP");
  QTRName4:ClearAllPoints();
  QTRName4:SetPoint("TOPRIGHT", QTREditP4, "TOPLEFT", -8, -4);
  QTRName4:SetText("Biernik:");
  QTRName4:SetFont(QTR_Font2, 13);

  local QTREditP5 = CreateFrame("EditBox", "QTREditP5", QTROptions, "InputBoxTemplate");
  QTREditP5:SetPoint("TOPRIGHT", QTREditP4, "BOTTOMRIGHT", 0, 0);
  QTREditP5:SetHeight(20);
  QTREditP5:SetWidth(100);
  QTREditP5:SetAutoFocus(false);
  QTREditP5:SetText(QTR_PC["name5"]);
  QTREditP5:SetCursorPosition(0);
  QTREditP5:SetScript("OnTextChanged", function(self) if (strlen(QTREditP5:GetText())>0) then QTR_PC["name5"]=QTREditP5:GetText() end; end);

  local QTRName5 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName5:SetFontObject(GameFontNormalLarge);
  QTRName5:SetJustifyH("LEFT"); 
  QTRName5:SetJustifyV("TOP");
  QTRName5:ClearAllPoints();
  QTRName5:SetPoint("TOPRIGHT", QTREditP5, "TOPLEFT", -8, -4);
  QTRName5:SetText("Narzędnik:");
  QTRName5:SetFont(QTR_Font2, 13);

  local QTREditP6 = CreateFrame("EditBox", "QTREditP6", QTROptions, "InputBoxTemplate");
  QTREditP6:SetPoint("TOPRIGHT", QTREditP5, "BOTTOMRIGHT", 0, 0);
  QTREditP6:SetHeight(20);
  QTREditP6:SetWidth(100);
  QTREditP6:SetAutoFocus(false);
  QTREditP6:SetText(QTR_PC["name6"]);
  QTREditP6:SetCursorPosition(0);
  QTREditP6:SetScript("OnTextChanged", function(self) if (strlen(QTREditP6:GetText())>0) then QTR_PC["name6"]=QTREditP6:GetText() end; end);

  local QTRName6 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName6:SetFontObject(GameFontNormalLarge);
  QTRName6:SetJustifyH("LEFT"); 
  QTRName6:SetJustifyV("TOP");
  QTRName6:ClearAllPoints();
  QTRName6:SetPoint("TOPRIGHT", QTREditP6, "TOPLEFT", -8, -4);
  QTRName6:SetText("Miejscownik:");
  QTRName6:SetFont(QTR_Font2, 13);

  local QTREditP7 = CreateFrame("EditBox", "QTREditP7", QTROptions, "InputBoxTemplate");
  QTREditP7:SetPoint("TOPRIGHT", QTREditP6, "BOTTOMRIGHT", 0, 0);
  QTREditP7:SetHeight(20);
  QTREditP7:SetWidth(100);
  QTREditP7:SetAutoFocus(false);
  QTREditP7:SetText(QTR_PC["name7"]);
  QTREditP7:SetCursorPosition(0);
  QTREditP7:SetScript("OnTextChanged", function(self) if (strlen(QTREditP7:GetText())>0) then QTR_PC["name7"]=QTREditP7:GetText() end; end);

  local QTRName7 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRName7:SetFontObject(GameFontNormalLarge);
  QTRName7:SetJustifyH("LEFT"); 
  QTRName7:SetJustifyV("TOP");
  QTRName7:ClearAllPoints();
  QTRName7:SetPoint("TOPRIGHT", QTREditP7, "TOPLEFT", -8, -4);
  QTRName7:SetText("Wołacz:");
  QTRName7:SetFont(QTR_Font2, 13);

  local QTRCheckButton5 = CreateFrame("CheckButton", "QTRCheckButton5", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButton5:SetPoint("TOPLEFT", QTRCheckButton3, "BOTTOMLEFT", 0, -10);
  QTRCheckButton5:SetScript("OnClick", function(self) if (QTR_PS["reklama"]=="0") then QTR_PS["reklama"]="1" else QTR_PS["reklama"]="0" end; end);
  QTRCheckButton5Text:SetFont(QTR_Font2, 13);
  QTRCheckButton5Text:SetText(QTR_Reklama.ON);

  local QTREditBox = CreateFrame("EditBox", "QTREditBox", QTROptions, "InputBoxTemplate");
  QTREditBox:SetPoint("TOPLEFT", QTRCheckButton5Text, "TOPRIGHT", 10, 3);
  QTREditBox:SetHeight(20);
  QTREditBox:SetWidth(20);
  QTREditBox:SetAutoFocus(false);
  QTREditBox:SetText(QTR_PS["channel"]);
  QTREditBox:SetCursorPosition(0);
  QTREditBox:SetScript("OnTextChanged", function(self) if (strlen(QTREditBox:GetText())>0) then QTR_PS["channel"]=QTREditBox:GetText() end; end);

  local QTRPeriodText = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRPeriodText:SetFontObject(GameFontWhite);
  QTRPeriodText:SetJustifyH("LEFT");
  QTRPeriodText:SetJustifyV("TOP");
  QTRPeriodText:ClearAllPoints();
  QTRPeriodText:SetPoint("TOPLEFT", QTRCheckButton5, "BOTTOMLEFT", 30, -10);
  QTRPeriodText:SetFont(QTR_Font2, 13);
  QTRPeriodText:SetText(QTR_Reklama.PERIOD);
  
  local QTR_slider = CreateFrame("Slider","MyAddonSlider",QTROptions,'OptionsSliderTemplate');
  QTR_slider:ClearAllPoints();
  QTR_slider:SetPoint("TOPLEFT",QTRPeriodText, "BOTTOMLEFT", 80, -20);
  getglobal(QTR_slider:GetName() .. 'Low'):SetText('15 min.');
  getglobal(QTR_slider:GetName() .. 'High'):SetText('90 min.');
  getglobal(QTR_slider:GetName() .. 'Text'):SetText('20 min.');
  QTR_slider:SetMinMaxValues(15, 90);
  QTR_slider:SetValue(QTR_PS["period"]);
  getglobal(QTR_slider:GetName() .. 'Text'):SetText(QTR_PS["period"] .. " min.");
  QTR_slider:SetValueStep(5);
  QTR_slider:SetScript("OnValueChanged", function(self)
      QTR_PS["period"] = math.floor(QTR_slider:GetValue()+0.5);
      getglobal(QTR_slider:GetName() .. 'Text'):SetText(QTR_PS["period"] .. " min.");
      end);

  local QTRChoiceText = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRChoiceText:SetFontObject(GameFontWhite);
  QTRChoiceText:SetJustifyH("LEFT");
  QTRChoiceText:SetJustifyV("TOP");
  QTRChoiceText:ClearAllPoints();
  QTRChoiceText:SetPoint("TOPLEFT", QTRPeriodText, "BOTTOMLEFT", 0, -65);
  QTRChoiceText:SetFont(QTR_Font2, 13);
  QTRChoiceText:SetText(QTR_Reklama.CHOICE);
  
  local QTRCheckText1 = CreateFrame("CheckButton", "QTRCheckText1", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckText1:SetPoint("TOPLEFT", QTRChoiceText, "BOTTOMLEFT", -50, -5);
  QTRCheckText1:SetScript("OnClick", function(self) if (QTR_PS["text1"]=="0") then QTR_PS["text1"]="1" else QTR_PS["text1"]="0" end; end);
  QTRCheckText1Text:SetFont(QTR_Font2, 13);
  QTRCheckText1Text:SetText(QTR_Reklama.TEXT1);

  local QTRCheckText2 = CreateFrame("CheckButton", "QTRCheckText2", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckText2:SetPoint("TOPLEFT", QTRCheckText1, "BOTTOMLEFT", 0, 5);
  QTRCheckText2:SetScript("OnClick", function(self) if (QTR_PS["text2"]=="0") then QTR_PS["text2"]="1" else QTR_PS["text2"]="0" end; end);
  QTRCheckText2Text:SetFont(QTR_Font2, 13);
  QTRCheckText2Text:SetText(QTR_Reklama.TEXT2);
  
  local QTRCheckButtonGossip = CreateFrame("CheckButton", "QTRCheckButtonGossip", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButtonGossip:SetPoint("TOPLEFT", QTRCheckText2, "BOTTOMLEFT", -10, -15);
  QTRCheckButtonGossip:SetScript("OnClick", function(self) if (QTR_PS["gossip"]=="1") then QTR_PS["gossip"]="0" else QTR_PS["gossip"]="1" end; end);
  QTRCheckButtonGossipText:SetFont(QTR_Font2, 13);
  QTRCheckButtonGossipText:SetText("Wyświetlaj tłumaczenia tekstów GOSSIP");
  
  local QTRCheckButtonOnLine = CreateFrame("CheckButton", "QTRCheckButtonOnLine", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButtonOnLine:SetPoint("TOPLEFT", QTRCheckButtonGossip, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonOnLine:SetScript("OnClick", function(self) if (QTR_PS["gossiponline"]=="1") then QTR_PS["gossiponline"]="0" else QTR_PS["gossiponline"]="1" end; end);
  QTRCheckButtonOnLineText:SetFont(QTR_Font2, 13);
  QTRCheckButtonOnLineText:SetText("Włącz tłumaczenie tekstów GOSSIP w czasie gry");
  
  local QTRCheckButtonTutorial = CreateFrame("CheckButton", "QTRCheckButtonTutorial", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckButtonTutorial:SetPoint("TOPLEFT", QTRCheckButtonOnLine, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonTutorial:SetScript("OnClick", function(self) if (QTR_PS["tutorial"]=="1") then QTR_PS["tutorial"]="0" else QTR_PS["tutorial"]="1" end; end);
  QTRCheckButtonTutorialText:SetFont(QTR_Font2, 13);
  QTRCheckButtonTutorialText:SetText("Wyświetlaj tłumaczenia tekstów TUTORIAL");  
  
   -- przycisk "Inni gracze"
  local QTROptionsStatButton = CreateFrame("Button",nil, QTROptions, "UIPanelButtonTemplate");
  QTROptionsStatButton:SetWidth(145);
  QTROptionsStatButton:SetHeight(20);
  QTROptionsStatButton:SetText("Inni gracze");
  QTROptionsStatButton:Show();
  QTROptionsStatButton:ClearAllPoints();
  QTROptionsStatButton:SetPoint("TOPLEFT", QTRCheckButtonOnLineText, "TOPRIGHT", 90, 5);
  QTROptionsStatButton:SetScript("OnClick", QTR_ShowHideStatystyka);
  
  local QTRIntegration0 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRIntegration0:SetFontObject(GameFontWhite);
  QTRIntegration0:SetJustifyH("LEFT");
  QTRIntegration0:SetJustifyV("TOP");
  QTRIntegration0:ClearAllPoints();
  QTRIntegration0:SetPoint("TOPLEFT", QTRCheckButtonTutorial, "BOTTOMLEFT", 10, -20);
  QTRIntegration0:SetFont(QTR_Font2, 13);
  QTRIntegration0:SetText("Integracja z innymi addonami:");
  
  local QTRIntegration1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRIntegration1:SetFontObject(GameFontNormal);
  QTRIntegration1:SetJustifyH("LEFT");
  QTRIntegration1:SetJustifyV("TOP");
  QTRIntegration1:ClearAllPoints();
  QTRIntegration1:SetPoint("TOPLEFT", QTRIntegration0, "TOPRIGHT", 15, 0);
  QTRIntegration1:SetFont(QTR_Font2, 13);
  QTRIntegration1:SetText("QuestGuru,  Immersion,  Storyline");

  local QTRCheckOther1 = CreateFrame("CheckButton", "QTRCheckOther1", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckOther1:SetPoint("TOPLEFT", QTRIntegration1, "BOTTOMLEFT", -10, -10);
  QTRCheckOther1:SetScript("OnClick", function(self) if (QTR_PS["other1"]=="0") then QTR_PS["other1"]="1" else QTR_PS["other1"]="0" end; end);
  QTRCheckOther1Text:SetFont(QTR_Font2, 13);
  if (QuestGuru ~= nil ) then
     QTRCheckOther1Text:SetText(QTR_Reklama.OTHER1..QTR_Reklama.ACTIV1);
  else
     QTRCheckOther1Text:SetText(QTR_Reklama.OTHER1..QTR_Reklama.ACTIV2);
  end

  local QTRCheckOther2 = CreateFrame("CheckButton", "QTRCheckOther2", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckOther2:SetPoint("TOPLEFT", QTRCheckOther1, "BOTTOMLEFT", 0, 5);
  QTRCheckOther2:SetScript("OnClick", function(self) if (QTR_PS["other2"]=="0") then QTR_PS["other2"]="1" else QTR_PS["other2"]="0" end; end);
  QTRCheckOther2Text:SetFont(QTR_Font2, 13);
  if (ImmersionFrame ~= nil ) then
     QTRCheckOther2Text:SetText(QTR_Reklama.OTHER2..QTR_Reklama.ACTIV1);
  else
     QTRCheckOther2Text:SetText(QTR_Reklama.OTHER2..QTR_Reklama.ACTIV2);
  end
  
  local QTRCheckOther3 = CreateFrame("CheckButton", "QTRCheckOther3", QTROptions, "OptionsCheckButtonTemplate");
  QTRCheckOther3:SetPoint("TOPLEFT", QTRCheckOther2, "BOTTOMLEFT", 0, 5);
  QTRCheckOther3:SetScript("OnClick", function(self) if (QTR_PS["other3"]=="0") then QTR_PS["other3"]="1" else QTR_PS["other3"]="0" end; end);
  QTRCheckOther3Text:SetFont(QTR_Font2, 13);
  QTRCheckOther3Text:SetText(QTR_Reklama.OTHER3);
  
  local QTRWWW1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRWWW1:SetFontObject(GameFontWhite);
  QTRWWW1:SetJustifyH("LEFT");
  QTRWWW1:SetJustifyV("TOP");
  QTRWWW1:ClearAllPoints();
  QTRWWW1:SetPoint("BOTTOMLEFT", 16, 16);
  QTRWWW1:SetFont(QTR_Font2, 13);
  QTRWWW1:SetText(QTR_Reklama.WWW1);
  
  local QTRWWW2 = CreateFrame("EditBox", "QTRWWW2", QTROptions, "InputBoxTemplate");
  QTRWWW2:ClearAllPoints();
  QTRWWW2:SetPoint("TOPLEFT", QTRWWW1, "TOPRIGHT", 10, 4);
  QTRWWW2:SetHeight(20);
  QTRWWW2:SetWidth(170);
  QTRWWW2:SetAutoFocus(false);
  QTRWWW2:SetFontObject(GameFontGreen);
  QTRWWW2:SetText(QTR_Reklama.WWW2);
  QTRWWW2:SetCursorPosition(0);
  QTRWWW2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(QTR_Font2, 13);
  	  GameTooltip:SetText(QTR_Reklama.WWW3, nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  QTRWWW2:SetScript("OnLeave", function(self)
      getglobal("GameTooltipTextLeft1"):SetFont(Original_Font2, 13);
	  GameTooltip:Hide() --Hide the tooltip
     end);
  QTRWWW2:SetScript("OnTextChanged", function(self) QTRWWW2:SetText(QTR_Reklama.WWW2); end);

  local QTR_STframe = CreateFrame("Frame","QTR_STframe", QTROptions, "BasicFrameTemplateWithInset");
  QTR_STframe:SetMovable(false);
  QTR_STframe:SetWidth(600);
  QTR_STframe:SetHeight(400);
  QTR_STframe:ClearAllPoints();
  QTR_STframe:SetPoint("CENTER", QTROptions, "CENTER", 0, 0);
  QTR_STframe.title = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.title:SetPoint("CENTER", QTR_STframe.TitleBg);
  QTR_STframe.title:SetText("Inni gracze");
  
  QTR_STframe.text = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.text:SetPoint("TOPLEFT", QTR_STframe, "TOPLEFT", 20, -40);
  QTR_STframe.text:SetText("Liczba graczy z tym dodatkiem:");
  QTR_STframe.text:SetFont(QTR_Font2, 15);
  
  QTR_STframe.count = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontNormal");
  QTR_STframe.count:SetPoint("TOPLEFT", QTR_STframe.text, "TOPRIGHT", 10, 0);
  QTR_STframe.count:SetText("? ");
  QTR_STframe.count:SetFont(QTR_Font2, 15);

  QTR_STframe.alert = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontRed");
  QTR_STframe.alert:SetPoint("TOPLEFT", QTR_STframe.text, "TOPRIGHT", 40, -2);
  QTR_STframe.alert:SetText("");
  QTR_STframe.alert:SetFont(QTR_Font2, 13);

  QTR_STframe.ScrollFrame = CreateFrame("ScrollFrame", nil, QTR_STframe, "UIPanelScrollFrameTemplate");
  QTR_STframe.ScrollFrame:SetPoint("TOPLEFT", QTR_STframe.InsetBg, "TOPLEFT", 10, -40);
  QTR_STframe.ScrollFrame:SetPoint("BOTTOMRIGHT", QTR_STframe.InsetBg, "BOTTOMRIGHT", -5, 10);
  
  QTR_STframe.ScrollFrame.ScrollBar:ClearAllPoints();
  QTR_STframe.ScrollFrame.ScrollBar:SetPoint("TOPLEFT", QTR_STframe.ScrollFrame, "TOPRIGHT", -12, -18);
  QTR_STframe.ScrollFrame.ScrollBar:SetPoint("BOTTOMRIGHT", QTR_STframe.ScrollFrame, "BOTTOMRIGHT", -7, 15);
  local child = CreateFrame("Frame", nil, QTR_STframe.ScrollFrame);
  child:SetSize(552,500);
  child.bg = child:CreateTexture(nil, "BACKGROUND");
  child.bg:SetAllPoints(true);
  child.bg:SetColorTexture(0, 0.05, 0.1, 0.8);
  QTR_STframe.ScrollFrame:SetScrollChild(child);
  QTR_STframe.ScrollFrame:SetScript("OnMouseWheel", QTR_ScrollFrame_OnMouseWheel);
  
  QTR_STframe.tabela1 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.tabela1:SetPoint("TOPLEFT", child, "TOPLEFT", 10, -10);
  QTR_STframe.tabela1:SetText("");
  QTR_STframe.tabela1:SetJustifyH("LEFT");
  QTR_STframe.tabela1:SetFont(QTR_Font2, 15);
  
  QTR_STframe.tabela2 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.tabela2:SetPoint("TOPLEFT", child, "TOPLEFT", 150, -10);
  QTR_STframe.tabela2:SetText("");
  QTR_STframe.tabela2:SetJustifyH("LEFT");
  QTR_STframe.tabela2:SetFont(QTR_Font2, 15);

  QTR_STframe:SetFrameLevel(10);
  QTR_STframe:Hide();
 
end


function GS_ON_OFF()
   if (curr_goss=="1") then         -- wyłącz tłumaczenie - pokaż oryginalny tekst
      curr_goss="0";
      GossipGreetingText:SetText(QTR_GS[curr_hash]);
      GossipGreetingText:SetFont(Original_Font2, 13);      
      QTR_ToggleButtonGS:SetText("Gossip-Hash=["..tostring(curr_hash).."] EN");
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-angielska.mp3");
      end
   else                             -- pokaż tłumaczenie PL
      curr_goss="1";
      local Greeting_PL = GS_Gossip[curr_hash];
      GossipGreetingText:SetText(QTR_ExpandUnitInfo(Greeting_PL));
      GossipGreetingText:SetFont(QTR_Font2, 13);      
      QTR_ToggleButtonGS:SetText("Gossip-Hash=["..tostring(curr_hash).."] PL");
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-polska.mp3");
      end
   end
end


-- Otworzono okienko rozmowy z NPC
function QTR_Gossip_Show()
   local Nazwa_NPC = GossipFrameNpcNameText:GetText();
   curr_hash = 0;
   if (Nazwa_NPC) then
      local Greeting_Text = GossipGreetingText:GetText();
      if (string.find(Greeting_Text," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         Nazwa_NPC = string.gsub(Nazwa_NPC, '"', '\"');
         Greeting_Text = string.gsub(Greeting_Text, '"', '\"');
         local Czysty_Text = string.gsub(Greeting_Text, '\r', '');
         Czysty_Text = string.gsub(Czysty_Text, '\n', '$B');
         Czysty_Text = string.gsub(Czysty_Text, QTR_name, '$N');
         Czysty_Text = string.gsub(Czysty_Text, string.upper(QTR_name), '$N$');
         Czysty_Text = string.gsub(Czysty_Text, QTR_race, '$R');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_race), '$R');
         Czysty_Text = string.gsub(Czysty_Text, QTR_class, '$C');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_class), '$C');
         Czysty_Text = string.gsub(Czysty_Text, '$N$', '');
         Czysty_Text = string.gsub(Czysty_Text, '$N', '');
         Czysty_Text = string.gsub(Czysty_Text, '$B', '');
         Czysty_Text = string.gsub(Czysty_Text, '$R', '');
         Czysty_Text = string.gsub(Czysty_Text, '$C', '');
         local Hash = StringHash(Czysty_Text);
         curr_hash = Hash;
         QTR_GS[Hash] = Greeting_Text;                      -- zapis oryginalnego tekstu
         if ( GS_Gossip[Hash] ) then   -- istnieje tłumaczenie tekstu GOSSIP tego NPC
            curr_goss = "1";
            local Greeting_PL = GS_Gossip[Hash];
            GossipGreetingText:SetText(QTR_ExpandUnitInfo(Greeting_PL));
            GossipGreetingText:SetFont(QTR_Font2, 13);
            QTR_ToggleButtonGS:SetText("Gossip-Hash=["..tostring(Hash).."] PL");
            QTR_ToggleButtonGS:Enable();
         else                               -- nie ma tłumaczenia w bazie GOSSIP
            curr_goss = "0";
            -- zapis do pliku
            QTR_GOSSIP[Nazwa_NPC.."@"..tostring(Hash)] = Greeting_Text.."@"..QTR_name..":"..QTR_race..":"..QTR_class;
            QTR_ToggleButtonGS:SetText("Gossip-Hash=["..tostring(Hash).."] EN");
            QTR_ToggleButtonGS:Disable();
            if (QTR_PS["gossiponline"]=="1") then
               QTR_FrameOnLineHash = Hash;
               QTR_ShowOnLine();
            elseif (QTR_FrameOnLine) then
               QTR_FrameOnLine:Hide();
            end
         end
         if (GetNumGossipOptions()>0) then    -- są jeszcze przyciski funkcji dodatkowych
         --   local pozycja=GetNumGossipActiveQuests()+GetNumGossipAvailableQuests()+1;
            local pozycja=0;
            local titleButton;
            for i = 1, GetNumGossipOptions(), 1 do 
               titleButton=getglobal("GossipTitleButton"..tostring(pozycja+i));
               if (titleButton:GetText()) then
                  local gostxt = titleButton:GetText();
                  if (string.find(gostxt, "|cff000000") == nil) then   -- nie jest to quest w gossip
                     Hash = StringHash(gostxt);
                     if ( GS_Gossip[Hash] ) then   -- istnieje tłumaczenie tekstu dodatkowego
                        titleButton:SetText(QTR_ExpandUnitInfo(GS_Gossip[Hash]));
                        titleButton:GetFontString():SetFont(QTR_Font2, 13);
                     else
                        QTR_GOSSIP[Nazwa_NPC..'@'..tostring(Hash)] = gostxt.."@"..QTR_name..":"..QTR_race..":"..QTR_class;
                     end
                  end
               end
            end
         end
      end
   end
end


function QTR_ShowOnLine()
   if (QTR_FrameOnLine==nil) then            -- nie ma jeszcze utworzonego okienka tłumaczenia w grze
      QTR_FrameOnLine = CreateFrame("Frame", "FrameOnLine", GossipFrame, "BasicFrameTemplateWithInset");
      QTR_FrameOnLine:SetMovable(false);
      QTR_FrameOnLine:SetWidth(300);
      QTR_FrameOnLine:SetHeight(300);
      QTR_FrameOnLine:ClearAllPoints();
      QTR_FrameOnLine:SetPoint("TOPLEFT", GossipFrame, "TOPRIGHT", 0, 0);
      QTR_FrameOnLine.title = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
      QTR_FrameOnLine.title:SetPoint("CENTER", QTR_FrameOnLine.TitleBg);
      QTR_FrameOnLine.title:SetText("Tłumaczenie w czasie gry");
      QTR_FrameOnLine.text = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontNormal");
      QTR_FrameOnLine.text:SetPoint("TOPLEFT", QTR_FrameOnLine, "TOPLEFT", 20, -40);
      QTR_FrameOnLine.text:SetText("Podaj tłumaczenie tekstu GOSSIP:");
      QTR_FrameOnLine.text:SetFont(QTR_Font2, 15);
      
      QTR_FrameOnLine.tlum = CreateFrame("EditBox", nil, QTR_FrameOnLine);
      QTR_FrameOnLine.tlum:SetBackdrop({
	      bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
	      edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
	      tile = false, tileSize = 1, edgeSize = 1,
	      insets = {left = 3, right = 3, top = 3, bottom = 3},
         });
      QTR_FrameOnLine.tlum:SetBackdropColor(0, 0, 0);
      QTR_FrameOnLine.tlum:SetBackdropBorderColor(0.3, 0.3, 0.3);
      QTR_FrameOnLine.tlum:SetMultiLine(true);
      QTR_FrameOnLine.tlum:SetSize(255, 150);
      QTR_FrameOnLine.tlum:SetPoint("TOPLEFT", QTR_FrameOnLine, "TOPLEFT", 22, -65);
      QTR_FrameOnLine.tlum:SetAutoFocus(false);
      QTR_FrameOnLine.tlum:SetCursorPosition(0);
      QTR_FrameOnLine.tlum:SetMaxLetters(99999);
      QTR_FrameOnLine.tlum:SetFont(QTR_Font2, 15);
      QTR_FrameOnLine.tlum:SetJustifyH("LEFT");
      QTR_FrameOnLine.tlum:SetJustifyV("CENTER");
      
      -- przycisk "Zapisz tłumaczenie"
      QTR_FrameOnLineButton = CreateFrame("Button",nil, QTR_FrameOnLine, "UIPanelButtonTemplate");
      QTR_FrameOnLineButton:SetWidth(145);
      QTR_FrameOnLineButton:SetHeight(25);
      QTR_FrameOnLineButton:SetText("Zapisz tłumaczenie");
--      QTR_FrameOnLineButton:SetFont(QTR_Font2, 15);
      QTR_FrameOnLineButton:Show();
      QTR_FrameOnLineButton:ClearAllPoints();
      QTR_FrameOnLineButton:SetPoint("TOPLEFT", QTR_FrameOnLine, "BOTTOMLEFT", 78, 40);
      QTR_FrameOnLineButton:SetScript("OnClick", QTR_SaveGossipTranslation);

      QTR_FrameOnLine.alert = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontRed");
      QTR_FrameOnLine.alert:SetPoint("BOTTOMLEFT", QTR_FrameOnLineButton, "TOPLEFT", -32, 10);
      QTR_FrameOnLine.alert:SetText("Tekst tłumaczenia jest pusty!");
      QTR_FrameOnLine.alert:SetFont(QTR_Font2, 15);
      QTR_FrameOnLine.alert:Hide();
   end
   if (QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)]) then
      QTR_FrameOnLine.tlum:SetText(QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)]);
   else
      QTR_FrameOnLine.tlum:SetText("");
   end
   QTR_FrameOnLine:Show();
end


function QTR_SaveGossipTranslation()               -- zapisz tłumaczenie online
   if (QTR_FrameOnLine.tlum:GetText() == "") then
      QTR_FrameOnLine.alert:Show();
   else      
      QTR_FrameOnLine.alert:Hide();
      QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)] = QTR_FrameOnLine.tlum:GetText();
      QTR_FrameOnLine:Hide();
   end
end


function QTR_SaveQuest(event)
   if (event=="QUEST_DETAIL") then
      QTR_SAVED[QTR_quest_EN.id.." TITLE"]=GetTitleText();            -- save original title to future translation
      QTR_SAVED[QTR_quest_EN.id.." DESCRIPTION"]=GetQuestText();      -- save original text to future translation
      QTR_SAVED[QTR_quest_EN.id.." OBJECTIVE"]=GetObjectiveText();    -- save original text to future translation
      QTR_SAVED[QTR_quest_EN.id.." MAPID"]=C_Map.GetBestMapForUnit("player");     -- save mapID to locale place of this quest
   end
   if (event=="QUEST_PROGRESS") then
      QTR_SAVED[QTR_quest_EN.id.." PROGRESS"]=GetProgressText();      -- save original text to future translation
   end
   if (event=="QUEST_COMPLETE") then
      QTR_SAVED[QTR_quest_EN.id.." COMPLETE"]=GetRewardText();        -- save original text to future translation
   end
   if (QTR_SAVED[QTR_quest_EN.id.." TITLE"]==nil) then
      QTR_SAVED[QTR_quest_EN.id.." TITLE"]=GetTitleText();            -- zapisz tytuł w przypadku tylko Zakończenia
   end
   QTR_SAVED[QTR_quest_EN.id.." PLAYER"]=QTR_name..'@'..QTR_race..'@'..QTR_class;  -- zapisz dane gracza
end


function QTR_wait(delay, func, ...)
  if(type(delay)~="number" or type(func)~="function") then
    return false;
  end
  if (QTR_waitFrame == nil) then
    QTR_waitFrame = CreateFrame("Frame","QTR_WaitFrame", UIParent);
    QTR_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #QTR_waitTable;
      local i = 1;
      while(i<=count) do
        local waitRecord = tremove(QTR_waitTable,i);
        local d = tremove(waitRecord,1);
        local f = tremove(waitRecord,1);
        local p = tremove(waitRecord,1);
        if(d>elapse) then
          tinsert(QTR_waitTable,i,{d-elapse,f,p});
          i = i + 1;
        else
          count = count - 1;
          f(unpack(p));
        end
      end
    end);
  end
  tinsert(QTR_waitTable,{delay,func,{...}});
  return true;
end


function QTR_SendReklama()
  local now = GetTime();
  if (last_time + QTR_PS["period"]*60 < now) then                  -- OK, czas wypisać reklamę
     if ((QTR_PS["text1"]=="1") and (QTR_PS["text2"]=="1")) then   -- oba teksty naprzemiennie
        if (last_text==2) then
           if (tonumber(QTR_PS["channel"])>0) then
              SendChatMessage(QTR_Reklama.TEXT1,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
           else
              SendChatMessage(QTR_Reklama.TEXT1,"SAY");
           end
           last_text = 1;
        else
           if (tonumber(QTR_PS["channel"])>0) then
              SendChatMessage(QTR_Reklama.TEXT2,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
           else
              SendChatMessage(QTR_Reklama.TEXT2,"SAY");
           end
           last_text = 2;
        end
     elseif (QTR_PS["text1"]=="1") then
        if (tonumber(QTR_PS["channel"])>0) then
           SendChatMessage(QTR_Reklama.TEXT1,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
        else
           SendChatMessage(QTR_Reklama.TEXT1,"SAY");
        end        
        last_text = 1;
     elseif (QTR_PS["text2"]=="1") then
        if (tonumber(QTR_PS["channel"])>0) then
           SendChatMessage(QTR_Reklama.TEXT2,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
        else
           SendChatMessage(QTR_Reklama.TEXT2,"SAY");
        end
        last_text = 2;
     end
     last_time = now;
  end   
end


function QTR_ON_OFF()
   if (curr_trans=="1") then
      curr_trans="0";
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-angielska.mp3");
      end
      QTR_Translate_Off(1);
   else   
      curr_trans="1";
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-polska.mp3");
      end
      QTR_Translate_On(1);
   end
end


-- Pierwsza funkcja wywoływana po załadowaniu dodatku
function QTR_OnLoad()
   QTR = CreateFrame("Frame");
   QTR:SetScript("OnEvent", QTR_OnEvent);
   QTR:RegisterEvent("ADDON_LOADED");
   QTR:RegisterEvent("QUEST_ACCEPTED");
   QTR:RegisterEvent("QUEST_DETAIL");
   QTR:RegisterEvent("QUEST_PROGRESS");
   QTR:RegisterEvent("QUEST_COMPLETE");
--   QTR:RegisterEvent("QUEST_FINISHED");
--   QTR:RegisterEvent("QUEST_GREETING");

   -- przycisk z nr ID questu w QuestFrame (NPC)
   QTR_ToggleButton0 = CreateFrame("Button",nil, QuestFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton0:SetWidth(150);
   QTR_ToggleButton0:SetHeight(20);
   QTR_ToggleButton0:SetText("Quest ID=?");
   QTR_ToggleButton0:Show();
   QTR_ToggleButton0:ClearAllPoints();
   QTR_ToggleButton0:SetPoint("TOPLEFT", QuestFrame, "TOPLEFT", 92, -25);
   QTR_ToggleButton0:SetScript("OnClick", QTR_ON_OFF);
   
   -- przycisk z nr ID questu w QuestLogPopupDetailFrame
   QTR_ToggleButton1 = CreateFrame("Button",nil, QuestLogPopupDetailFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton1:SetWidth(150);
   QTR_ToggleButton1:SetHeight(20);
   QTR_ToggleButton1:SetText("Quest ID=?");
   QTR_ToggleButton1:Show();
   QTR_ToggleButton1:ClearAllPoints();
   QTR_ToggleButton1:SetPoint("TOPLEFT", QuestLogPopupDetailFrame, "TOPLEFT", 40, -31);
   QTR_ToggleButton1:SetScript("OnClick", QTR_ON_OFF);

   -- przycisk z nr ID questu w QuestMapDetailsScrollFrame
   QTR_ToggleButton2 = CreateFrame("Button",nil, QuestMapDetailsScrollFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton2:SetWidth(150);
   QTR_ToggleButton2:SetHeight(20);
   QTR_ToggleButton2:SetText("Quest ID=?");
   QTR_ToggleButton2:Show();
   QTR_ToggleButton2:ClearAllPoints();
   QTR_ToggleButton2:SetPoint("TOPLEFT", QuestMapDetailsScrollFrame, "TOPLEFT", 116, 29);
   QTR_ToggleButton2:SetScript("OnClick", QTR_ON_OFF);

   QTR:RegisterEvent("GOSSIP_SHOW");
   -- przycisk z nr HASH gossip w QuestMapDetailsScrollFrame
   QTR_ToggleButtonGS = CreateFrame("Button",nil, GossipFrame, "UIPanelButtonTemplate");
   QTR_ToggleButtonGS:SetWidth(220);
   QTR_ToggleButtonGS:SetHeight(20);
   QTR_ToggleButtonGS:SetText("Gossip-Hash=?");
   QTR_ToggleButtonGS:Show();
   QTR_ToggleButtonGS:ClearAllPoints();
   QTR_ToggleButtonGS:SetPoint("TOPLEFT", GossipFrame, "TOPLEFT", 70, -32);
   QTR_ToggleButtonGS:SetScript("OnClick", GS_ON_OFF);

   -- funkcja wywoływana po kliknięciu na nazwę questu w QuestTracker   
   hooksecurefunc(QUEST_TRACKER_MODULE, "OnBlockHeaderClick", QTR_PrepareReload);
   
   -- funkcja wywoływana po kliknięciu na nazwę questu w QuestMapFrame
   hooksecurefunc("QuestMapFrame_ShowQuestDetails", QTR_PrepareReload);
   
   QTR:RegisterEvent("TUTORIAL_TRIGGER");
   QTR:RegisterEvent("PLAYER_ENTERING_WORLD");
   CharacterFrame:HookScript("OnShow", Tut_onTutorialShow_Time);
   TutorialFrame:HookScript("OnShow", Tut_onTutorialShowOld);
   TutorialFrameNextButton:HookScript("OnClick", Tut_onTutorialShowOld);
   TutorialFramePrevButton:HookScript("OnClick", Tut_onTutorialShowOld);
   TalentMicroButtonAlert:HookScript("OnShow", Tut_TalentMicroButtonAlert);
   CharacterMicroButtonAlert:HookScript("OnShow", Tut_CharacterMicroButtonAlert);
   GuildMicroButtonAlert:HookScript("OnShow", Tut_GuildMicroButtonAlert);
   LFDMicroButtonAlert:HookScript("OnShow", Tut_LFDMicroButtonAlert);
   EJMicroButtonAlert:HookScript("OnShow", Tut_EJMicroButtonAlert);
   StoreMicroButtonAlert:HookScript("OnShow", Tut_StoreMicroButtonAlert);
   CollectionsMicroButtonAlert:HookScript("OnShow", Tut_CollectionsMicroButtonAlert);
   BagHelpBox:HookScript("OnShow", Tut_BagHelpBox);
   HelpPlateTooltip:HookScript("OnShow", Tut_HelpPlate);

   QTR:RegisterEvent("CHAT_MSG_ADDON");      -- ukryty kanał addonu
   C_ChatInfo.RegisterAddonMessagePrefix("WoWpoPolsku_QTR");
   
   isQuestGuru();
   isImmersion();
   isStoryline();       -- może być jeszcze nie załadowany, bo nazwa po QTR
end


function Tut_TalentMicroButtonAlert()
   -- You can now pick a new class specialization. Click here to view your specialization choices.
   -- You have unspent Talent points.
   local _font4, _size4, _34 = TalentMicroButtonAlert.Text:GetFont();
   if (string.sub(TalentMicroButtonAlert.Text:GetText(),1,23)=='You have unspent Talent') then
      TalentMicroButtonAlert.Text:SetText("Masz niewykorzystane punkty Talentu.");
   elseif (string.sub(TalentMicroButtonAlert.Text:GetText(),1,16)=='You can now pick') then
      TalentMicroButtonAlert.Text:SetText("Możesz teraz wybrać specjalizację dla twojej klasy.\nKliknij tutaj, aby wyświetlić opcje twojej specjalizacji.");
   end
   TalentMicroButtonAlert.Text:SetFont(QTR_Font2, _size4);
end


function Tut_CharacterMicroButtonAlert()
   -- An Azerite power is available. [875383902]
   -- You can change Essences in any rest area by Shift Right Clicking your Heart of Azeroth. [1834009890]
   local txt = CharacterMicroButtonAlert.Text:GetText();
   if (StringHash(txt) == 875383902) then             -- znamy to - jest tłumaczenie
      local _font4, _size4, _34 = CharacterMicroButtonAlert.Text:GetFont();
      CharacterMicroButtonAlert.Text:SetText("Dostępna jest moc Azerytu.");
      CharacterMicroButtonAlert.Text:SetFont(QTR_Font2, _size4);
   elseif (StringHash(txt) == 1834009890) then        -- znamy to - jest tłumaczenie
      local _font4, _size4, _34 = CharacterMicroButtonAlert.Text:GetFont();
      CharacterMicroButtonAlert.Text:SetText("Możesz zmienić Esencje w dowolnym obszarze odpoczynku, klikając Shift+PPM w swoje Serce Azeroth.");
      CharacterMicroButtonAlert.Text:SetFont(QTR_Font2, _size4);
   elseif (string.find(txt,"@") ~= nil) then
      QTR_TUTORIAL["MicroButton_Character_"..tostring(StringHash(txt))] = txt;
   end
end


function Tut_GuildMicroButtonAlert()
   -- New Guild and Community Finder. Click here to chek it out! [360186936]
   local txt = GuildMicroButtonAlert.Text:GetText();
   if (StringHash(txt) == 360186936) then             -- znamy to - jest tłumaczenie
      local _font4, _size4, _34 = GuildMicroButtonAlert.Text:GetFont();
      GuildMicroButtonAlert.Text:SetText("Nowa wyszukiwarka gildii i społeczności. Kliknij tutaj, aby@to sprawdzić!");
      GuildMicroButtonAlert.Text:SetFont(QTR_Font2, _size4);
   elseif (string.find(txt,"@") ~= nil) then
      QTR_TUTORIAL["MicroButton_Guild_"..tostring(StringHash(txt))] = txt;
   end
end


function Tut_LFDMicroButtonAlert()
   local txt = LFDMicroButtonAlert.Text:GetText();
   QTR_TUTORIAL["MicroButton_LFD_"..tostring(StringHash(txt))] = txt;
end


function Tut_EJMicroButtonAlert()
   -- Open the Adventure Guide to view recommended activities for you. [740200327]
   local txt = EJMicroButtonAlert.Text:GetText();
   if (StringHash(txt) == 740200327) then             -- znamy to - jest tłumaczenie
      local _font4, _size4, _34 = EJMicroButtonAlert.Text:GetFont();
      EJMicroButtonAlert.Text:SetText("Otwórz Przewodnik Przygody, aby wyświetlić zalecane dla@ciebie działania.");
      EJMicroButtonAlert.Text:SetFont(QTR_Font2, _size4);
   elseif (string.find(txt,"@") ~= nil) then
      QTR_TUTORIAL["MicroButton_EJ_"..tostring(StringHash(txt))] = txt;
   end
end


function Tut_StoreMicroButtonAlert()
   local txt = StoreMicroButtonAlert.Text:GetText();
   QTR_TUTORIAL["MicroButton_Store_"..tostring(StringHash(txt))] = txt;
end


function Tut_CollectionsMicroButtonAlert()
   -- Visit the Toy Box to view your toy collection.
   local _font5, _size5, _53 = CollectionsMicroButtonAlert.Text:GetFont();
   if (string.sub(CollectionsMicroButtonAlert.Text:GetText(),1,17)=="Visit the Toy Box") then
      CollectionsMicroButtonAlert.Text:SetText("Odwiedź Toy Box, aby zobaczyć swoją kolekcję zabawek.");
   end
   CollectionsMicroButtonAlert.Text:SetFont(QTR_Font2, _size5);
end


function Tut_BagHelpBox()
   -- Click this button to clean up your bags.\n\nIt auto-sorts and moves items out of the way to make room for new items.
   -- Click the bag icon to assign a type of item to this bag.\n\nThis feature works with the "Clean Up Bags" button.
   local _font3, _size3, _33 = BagHelpBox.Text:GetFont();
   if (string.sub(BagHelpBox.Text:GetText(),1,17)=='Click this button') then
      BagHelpBox.Text:SetText("Kliknij ten przycisk, aby posprzątać torby.\nAutomatycznie posortuje i poprzesuwa przedmioty, aby zrobić miejsce na nowe elementy.");
   elseif (string.sub(BagHelpBox.Text:GetText(),1,18)=='Click the bag icon') then
      BagHelpBox.Text:SetText("Kliknij ikonkę torby, aby przypisać rodzaj przedmiotu do tej torby.\nTa funkcja działa z przyciskiem 'Uporządkuj torby'.");
   end   
   BagHelpBox.Text:SetFont(QTR_Font2, _size3);
 end

 
function Tut_HelpPlate()
   local txt,id;
   txt = HelpPlateTooltip.Text:GetText();
   if (string.find(txt," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
      id = StringHash(txt);
      if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
         local _font2, _size2, _32 = HelpPlateTooltip.Text:GetFont();
         HelpPlateTooltip.Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
         HelpPlateTooltip.Text:SetFont(QTR_Font2, _size2);
      else
         QTR_TUTORIAL[tostring(id)] = txt;
      end
   end   
end


function Tut_onTutorialShow_Time()
   if ((QTR_PS["tutorial"] == "1") and (InterfaceOptionsDisplayPanelShowTutorials.value=="1"))then
      if (not QTR_wait(0.2,Tut_onTutorialShow)) then
         -- opóźnienie 0.2 sek
      end
   end
end


function Tut_onTutorialShow()
   local obj,txt,id;
   obj = "NPE_TutorialMainFrame_Frame";
   if ((_G[obj]) and (_G[obj]:IsVisible())) then
      if (tutShow==0) then
         _G[obj]:SetScript("OnUpdate", Tut_onTutorialShow_Time);
         tutShow = 1;
      end
      txt = _G[obj].Text:GetText();               -- odczytaj tekst oryginalny
      if (string.find(txt," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         id = StringHash(txt);
         if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
            local _font5, _size5, _35 = _G[obj].Text:GetFont();
            _G[obj].Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
            _G[obj].Text:SetFont(QTR_Font2, _size5);
         else
            QTR_TUTORIAL[tostring(id)] = txt;
         end
      end
   end
   for i=1,3,1 do
      obj = "NPE_PointerFrame_"..tostring(i).."Content";
      if ((_G[obj]) and (_G[obj]:IsVisible())) then
         if (aktShow<i) then
            _G[obj]:SetScript("OnShow", Tut_onTutorialShow);
            aktShow = i;
         end
         txt = _G[obj].Text:GetText();
         if (string.find(txt," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
            id = StringHash(txt);
            if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
               local _font6, _size6, _36 = _G[obj].Text:GetFont();
               _G[obj].Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
               _G[obj].Text:SetFont(QTR_Font2, _size6);
            else
               QTR_TUTORIAL[tostring(id)] = txt;
            end
         end
      end
   end
end


function Tut_onTutorialShowOld()
   if ((QTR_PS["tutorial"] == "1") and (InterfaceOptionsDisplayPanelShowTutorials.value=="1"))then
      if (not QTR_wait(0.1,Tut_TutorialShowDelayed)) then
         -- opóźnienie 0.1 sek
      end
   end
end


function Tut_TutorialShowDelayed()
   Tut_ID = TutorialFrame.id;
   local Tut_tytul, Tut_tekst = "","";
   if (Tut_Data[tostring(Tut_ID).."_"..Tut_race.."_"..Tut_class]) then    -- jest tłumaczenie PL
      Tut_tytul = Tut_Data[tostring(Tut_ID).."_"..Tut_race.."_"..Tut_class]["Title"];
      Tut_tekst = Tut_Data[tostring(Tut_ID).."_"..Tut_race.."_"..Tut_class]["Text"];
   elseif (Tut_Data[tostring(Tut_ID).."_"..Tut_class]) then
      Tut_tytul = Tut_Data[tostring(Tut_ID).."_"..Tut_class]["Title"];
      Tut_tekst = Tut_Data[tostring(Tut_ID).."_"..Tut_class]["Text"];
   elseif (Tut_Data[tostring(Tut_ID).."_"..Tut_race]) then
      Tut_tytul = Tut_Data[tostring(Tut_ID).."_"..Tut_race]["Title"];
      Tut_tekst = Tut_Data[tostring(Tut_ID).."_"..Tut_race]["Text"];
   elseif (Tut_Data[tostring(Tut_ID).."_A"]) then
      Tut_tytul = Tut_Data[tostring(Tut_ID).."_A"]["Title"];
      Tut_tekst = Tut_Data[tostring(Tut_ID).."_A"]["Text"];
   elseif (Tut_Data[tostring(Tut_ID)]) then
      Tut_tytul = Tut_Data[tostring(Tut_ID)]["Title"];
      Tut_tekst = Tut_Data[tostring(Tut_ID)]["Text"];
   end    
   if (string.len(Tut_tekst)>0) then
      TutorialFrameTitle:SetText(Tut_tytul);
      local _font1, _size1, _1 = TutorialFrameTitle:GetFont();
      TutorialFrameTitle:SetFont(QTR_Font2, _size1);
      TutorialFrameText:SetText(Tut_tekst);
      local _font2, _size2, _2 = TutorialFrameText:GetFont();
      TutorialFrameText:SetFont(QTR_Font2, _size2);  
   else
      QTR_TUTORIAL[tostring(Tut_ID).."_"..Tut_race.."_"..Tut_class] = Tut_tytul.."@"..Tut_tekst;
   end
   TutorialFrameOkayButton:SetText("Zamknij");
end


function Spr_Gender(msg)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do   -- szykaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end
   return msg;
end


function isQuestGuru()
   if (QuestGuru ~= nil ) then
      if (QTR_ToggleButton3==nil) then
         -- przycisk z nr ID questu w QuestGuru
         QTR_ToggleButton3 = CreateFrame("Button",nil, QuestGuru, "UIPanelButtonTemplate");
         QTR_ToggleButton3:SetWidth(150);
         QTR_ToggleButton3:SetHeight(20);
         QTR_ToggleButton3:SetText("Quest ID=?");
         QTR_ToggleButton3:Show();
         QTR_ToggleButton3:ClearAllPoints();
         QTR_ToggleButton3:SetPoint("TOPLEFT", QuestGuru, "TOPLEFT", 330, -33);
         QTR_ToggleButton3:SetScript("OnClick", QTR_ON_OFF);
         -- uaktualniono dane w QuestLogu
         QuestGuru:HookScript("OnUpdate", function() QTR_PrepareReload() end);
      end
      return true;
   else
      return false;   
   end
end


function isImmersion()
   if (ImmersionFrame ~= nil ) then
      if (QTR_ToggleButton4==nil) then
         -- przycisk z nr ID questu
         QTR_ToggleButton4 = CreateFrame("Button",nil, ImmersionFrame.TalkBox, "UIPanelButtonTemplate");
         QTR_ToggleButton4:SetWidth(150);
         QTR_ToggleButton4:SetHeight(20);
         QTR_ToggleButton4:SetText("Quest ID=?");
         QTR_ToggleButton4:Show();
         QTR_ToggleButton4:ClearAllPoints();
         QTR_ToggleButton4:SetPoint("TOPLEFT", ImmersionFrame.TalkBox, "TOPRIGHT", -200, -116);
         QTR_ToggleButton4:SetScript("OnClick", QTR_ON_OFF);
         -- otworzono okno dodatku Immersion : wywołanie przez OnEvent
         ImmersionFrame.TalkBox:HookScript("OnHide",function() QTR_ToggleButton4:Hide(); end);
         QTR_ToggleButton4:Disable();     -- nie można na razie przyciskać
         QTR_ToggleButton4:Hide();        -- wstępnie przycisk niewidoczny (bo może jest wybór questów)
      end
      return true;
   else   
      return false;
   end
end
   

function isStoryline()
   if (Storyline_NPCFrame ~= nil ) then
      if (QTR_ToggleButton5==nil) then
         -- przycisk z nr ID questu
         QTR_ToggleButton5 = CreateFrame("Button",nil, Storyline_NPCFrameChat, "UIPanelButtonTemplate");
         QTR_ToggleButton5:SetWidth(150);
         QTR_ToggleButton5:SetHeight(20);
         QTR_ToggleButton5:SetText("Quest ID=?");
         QTR_ToggleButton5:Hide();
         QTR_ToggleButton5:ClearAllPoints();
         QTR_ToggleButton5:SetPoint("BOTTOMLEFT", Storyline_NPCFrameChat, "BOTTOMLEFT", 244, -16);
         QTR_ToggleButton5:SetScript("OnClick", QTR_ON_OFF);
         Storyline_NPCFrameObjectivesContent:HookScript("OnShow", function() QTR_Storyline_Objectives() end);
         Storyline_NPCFrameRewards:HookScript("OnShow", function() QTR_Storyline_Rewards() end);
         Storyline_NPCFrameChat:HookScript("OnHide", function() QTR_Storyline_Hide() end);
--         QTR_ToggleButton5:Disable();     -- nie można przyciskać
      end
      return true;
   else
      return false;
   end
end


-- Określa aktualny numer ID questu z różnych metod
function QTR_GetQuestID()
   
   quest_ID = QuestMapFrame.DetailsFrame.questID;
   
   if (quest_ID==nil) then
      quest_ID = QuestLogPopupDetailFrame.questID;
   end
   
   if (quest_ID==nil) then
      if (isQuestGuru() and QuestGuru:IsVisible()) then
         local questTitle, level, questTag, isHeader, isCollapsed, isComplete, isDaily, questID = GetQuestLogTitle(GetQuestLogSelection());
         quest_ID = questID;
      end
   end
   
   if(quest_ID==nil) then
      if (isImmersion() and ImmersionFrame:IsVisible()) then
         local nameOrig=ImmersionFrame.TalkBox.NameFrame.Name:GetText();
         local i = 1;
         while GetQuestLogTitle(i) do    -- przeglądaj wszystkie questy w QuestLogu
            local questTitle, level, questTag, isHeader, isCollapsed, isComplete, isDaily, questID = GetQuestLogTitle(i);
            if (questTitle==nameOrig) then
               quest_ID = questID;
               break;
            end
            i = i + 1;
         end         
      end
      if (isStoryline() and Storyline_NPCFrameTitle:IsVisible()) then
         local nameOrig=Storyline_NPCFrameTitle:GetText();
         local i = 1;
         while GetQuestLogTitle(i) do    -- przeglądaj wszystkie questy w QuestLogu
            local questTitle, level, questTag, isHeader, isCollapsed, isComplete, isDaily, questID = GetQuestLogTitle(i);
            if (questTitle==nameOrig) then
               quest_ID = questID;
               break;
            end
            i = i + 1;
         end        
      end
   end   
   
   if (quest_ID==nil) then
      if ( isGetQuestID=="1" ) then
         quest_ID = GetQuestID();
      end
   end         

   if (quest_ID==nil) then
      quest_ID=0;
   end   
   
   return (quest_ID);
end



-- Wywoływane przy przechwytywanych zdarzeniach
function QTR_OnEvent(self, event, name, ...)
   isStoryline();       -- utwórz przycisk, gdy Storyline aktywny
   if (event=="ADDON_LOADED" and name=="WoWpoPolsku_Quests") then
      SlashCmdList["WOWPOPOLSKU_QUESTS"] = function(msg) QTR_SlashCommand(msg); end
      SLASH_WOWPOPOLSKU_QUESTS1 = "/wowpopolsku-quests";
      SLASH_WOWPOPOLSKU_QUESTS2 = "/qtr";
      QTR_CheckVars();
      -- twórz interface Options w Blizzard-Interface-Addons
      QTR_BlizzardOptions();
      print ("|cffffff00WoWpoPolsku-Quests ver. "..QTR_version.." - "..QTR_Messages.loaded);
      QTR:UnregisterEvent("ADDON_LOADED");
      QTR.ADDON_LOADED = nil;
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dodatek-wow-po-polsku-zostal-uruchomiony.mp3");
      end
      QTR_Messages.itemchoose1 = Spr_Gender(QTR_Messages.itemchoose1);
      if (not isGetQuestID) then
         DetectEmuServer();
      end
   elseif (event=="QUEST_DETAIL" or event=="QUEST_PROGRESS" or event=="QUEST_COMPLETE") then
      if (event=="QUEST_DETAIL") then      -- zapisz przypisanie questu do krainy
         QTR_SAVED[QTR_quest_EN.id.." MAPID"]=C_Map.GetBestMapForUnit("player");     -- save mapID to locale place of this quest
      end
      if ( QuestFrame:IsVisible() or isImmersion()) then
         QTR_QuestPrepare(event);
      elseif (isStoryline()) then
         if (not QTR_wait(1,QTR_Storyline_Quest)) then
         -- opóźnienie 1 sek
         end
      end	-- QuestFrame is Visible
   elseif (event=="GOSSIP_SHOW") then
      if (QTR_PS["gossip"] == "1") then
         QTR_Gossip_Show();
      end
      Tut_onTutorialShow_Time();
      QTR_SendVersion();
   elseif ( (event=="TUTORIAL_TRIGGER") or (event=="PLAYER_ENTERING_WORLD") ) then
      Tut_onTutorialShow_Time();
   elseif (event=="CHAT_MSG_ADDON") then        -- ukryty kanał addonu
      local msg, method, who = select (1, ...);
      if (name=="WoWpoPolsku_QTR") then 
         QTR_onChatMsgAddon(who,msg);
      end
   elseif (isImmersion() and event=="QUEST_ACCEPTED") then
      QTR_delayed3();
   end
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


function QTR_SendVersion()
   local now = GetTime();
   if (time_ver + 15*60 < now) then                  -- co 15 minut
      local message = QTR_lang..":"..string.sub(QTR_version,1,1)..string.sub(QTR_version,-2)..":"..QTR_base..":"..QTR_date..":"..GS_base..":"..GS_date;
      if ( IsInGuild() ) then                -- gracz jest w gildii
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_QTR", message, "GUILD");
      end
      if ( IsInRaid() ) then                -- gracz jest w raidzie
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_QTR", message, "RAID");
      end
      time_ver = now;
   end
end


function QTR_onChatMsgAddon(who,msg)       -- odebrano komunikat z ukrytego kanału addonu
--print('QTR - MSG od '..who..': '..msg);
   if (not Players_ver[who]) then
      local pla_lang, pla_ver, pla_base, pla_date, pla_gossip, pla_date2 = strsplit(":",msg);
      if (tonumber(pla_ver)>tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_VER = pla_ver;
         Version_max.ADDON_COUNT = 0;
      end
      if (tonumber(pla_ver)==tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_COUNT = Version_max.ADDON_COUNT + 1;
      end
      if (tonumber(pla_base)>tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_VER = pla_base;
         Version_max.BASE_DATE = pla_date;
         Version_max.BASE_COUNT = 0;
      end   
      if (tonumber(pla_base)==tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_COUNT = Version_max.BASE_COUNT + 1;
      end
      if (tonumber(pla_gossip)>tonumber(Version_max.GOSSIP_VER)) then
         Version_max.GOSSIP_VER = pla_gossip;
         Version_max.GOSSIP_DATE = pla_date2;
         Version_max.GOSSIP_COUNT = 0;
      end   
      if (tonumber(pla_gossip)==tonumber(Version_max.GOSSIP_VER)) then
         Version_max.GOSSIP_COUNT = Version_max.GOSSIP_COUNT + 1;
      end
      Players_ver[who] = { };
      Players_ver[who].LANG = pla_lang;
      Players_ver[who].VERSION = pla_ver;
      Players_ver[who].BASE = pla_base;
      Players_ver[who].DATE = pla_date;
      Players_ver[who].GOSSIP = pla_gossip;
      Players_ver[who].DATE2 = pla_date2;
      Players_ver_Count = Players_ver_Count + 1;
      Version_max.ALERT_ID = 0;
      if ((tonumber(Version_max.ADDON_VER)>tonumber(string.sub(QTR_version,1,1)..string.sub(QTR_version,-2))) and (Version_max.ADDON_COUNT>1) and (Version_max.ADDON_ALERT==0)) then
         Version_max.ALERT_ID = 4;
      end
      if ((tonumber(Version_max.BASE_VER)>tonumber(QTR_base)) and (Version_max.BASE_COUNT>1) and (Version_max.BASE_ALERT==0)) then
         Version_max.ALERT_ID = Version_max.ALERT_ID + 2;
      end
      if ((tonumber(Version_max.GOSSIP_VER)>tonumber(GS_base)) and (Version_max.GOSSIP_COUNT>1) and (Version_max.GOSSIP_ALERT==0)) then
         Version_max.ALERT_ID = Version_max.ALERT_ID + 1;
      end
   end
   if (Version_max.ALERT_ID>0) then
      PlaySound(10843);        -- dźwięk: HornOfCentarius
      if (Version_max.ALERT_ID>3) then              -- sam dodatek
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.ADDON_VER.."|r dodatku.");
         print("Możesz ją pobrać z serwisu CurseForge.com, WowInterface.com lub WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.ADDON_VER.." dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.ADDON_ALERT = 1;
      elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń zadań
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.BASE_VER.."|r bazy tłumaczeń zadań do dodatku WoWpoPolsku-Quests z dnia |cffffff00"..Version_max.BASE_DATE.."|r");
         print("Możesz ją pobrać tylko z serwisu WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.BASE_VER.." bazy tlumaczen zadan do dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.BASE_ALERT = 1;
      elseif (Version_max.ALERT_ID>0) then         -- baza tłumaczeń gossip
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.GOSSIP_VER.."|r bazy tłumaczeń GOSSIP do dodatku WoWpoPolsku-Quests z dnia |cffffff00"..Version_max.GOSSIP_DATE.."|r");
         print("Możesz ją pobrać tylko z serwisu WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.GOSSIP_VER.." bazy tlumaczen GOSSIP do dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.GOSSIP_ALERT = 1;
      end
      if (not QTR_wait(5,QTR_print_msg)) then
      --- czekaj 5 sek, aż skończy się dźwięk HornOfCentarius
      end
   end
end


-- Wyświetla komunikaty o dostępnej aktualizacji
function QTR_print_msg()
   if (Version_max.ALERT_ID>3) then              -- sam dodatek
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-dodatku.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 4;
   elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń zadań
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-bazy-quests.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 2;
   elseif (Version_max.ALERT_ID>0) then         -- baza tłumaczeń gossip
      if (QTR_PS["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-bazy-gossip.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 1;
   else
      Version_max.ALERT_ID = 0;
   end
end


-- Otworzono okienko QuestLogPopupDetailFrame lub QuestMapDetailsScrollFrame lub QuestGuru lub Immersion
function QTR_QuestPrepare(zdarzenie)
   if (isQuestGuru()) then
      if (QTR_PS["other1"]=="0") then       -- jest aktywny QuestGuru, ale nie zezwolono na tłumaczenie
         QTR_ToggleButton3:Hide();
         return;
      else   
         QTR_ToggleButton3:Show();
         if (QuestGuru:IsVisible() and (curr_trans=="0")) then
            QTR_Translate_Off(1);
            local questTitle, level, questTag, isHeader, isCollapsed, isComplete, isDaily, questID = GetQuestLogTitle(GetQuestLogSelection());
            if (QTR_quest_EN.id==questID) then
               return;
            end
         end
      end   
   end
   if (isImmersion()) then
      if (QTR_PS["other2"]=="0") then       -- jest aktywny Immersion, ale nie zezwolono na tłumaczenie
         QTR_ToggleButton4:Hide();
         return
      else
         QTR_ToggleButton4:Show();
         if (ImmersionContentFrame:IsVisible() and (curr_trans=="0")) then
            QTR_Translate_Off(1);
            return;
         end
      end      
   end
   q_ID = QTR_GetQuestID();
   str_ID = tostring(q_ID);
   QTR_quest_EN.id = q_ID;
   QTR_quest_LG.id = q_ID;
   if (isStoryline()) then
      QTR_ToggleButton5:Hide();
      if (QTR_PS["other3"]=="1") then
         if (q_ID>0) then
            QTR_ToggleButton5:Show();
         end
      else        -- nie zezwolono na tłumaczenie
         return
     end      
   end
   if ( QTR_PS["active"]=="1" ) then	-- tłumaczenia włączone
      CurrentQuestsText:SetText(QTR_Messages.currquests);
      CurrentQuestsText:SetFont(QTR_Font1, 18);
      AvailableQuestsText:SetText(QTR_Messages.avaiquests);
      AvailableQuestsText:SetFont(QTR_Font1, 18);
      QTR_ToggleButton0:Enable();
      QTR_ToggleButton1:Enable();
      QTR_ToggleButton2:Enable();
      if (isImmersion()) then
         if (q_ID==0) then
            return;
         end   
         QTR_ToggleButton4:Enable();
      end
      curr_trans = "1";
      if ( QTR_QuestData[str_ID] ) then   -- wyświetlaj tylko, gdy istnieje tłumaczenie
         QTR_quest_LG.title = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Title"]);
         QTR_quest_EN.title = GetTitleText();
         if (QTR_quest_EN.title=="") then
            QTR_quest_EN.title=GetQuestLogTitle(GetQuestLogSelection());
         end
         QTR_quest_LG.details = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Description"]);
         QTR_quest_LG.objectives = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Objectives"]);
         if (zdarzenie=="QUEST_DETAIL") then
            QTR_quest_EN.details = GetQuestText();
            QTR_quest_EN.objectives = GetObjectiveText();
            QTR_quest_EN.itemchoose = QTR_MessOrig.itemchoose1;
            QTR_quest_LG.itemchoose = QTR_Messages.itemchoose1;
            QTR_quest_EN.itemreceive = QTR_MessOrig.itemreceiv1;
            QTR_quest_LG.itemreceive = QTR_Messages.itemreceiv1;
            if (strlen(QTR_quest_EN.details)>0 and strlen(QTR_quest_LG.details)==0) then
               QTR_MISSING[QTR_quest_EN.id.." DESCRIPTION"]=QTR_quest_EN.details;     -- save missing translation part
            end
            if (strlen(QTR_quest_EN.objectives)>0 and strlen(QTR_quest_LG.objectives)==0) then
               QTR_MISSING[QTR_quest_EN.id.." OBJECTIVE"]=QTR_quest_EN.objectives;    -- save missing translation part
            end
         else   
            if (QTR_quest_LG.details ~= QuestInfoDescriptionText:GetText()) then
               QTR_quest_EN.details = QuestInfoDescriptionText:GetText();
            end
            if (QTR_quest_LG.objectives ~= QuestInfoObjectivesText:GetText()) then
               QTR_quest_EN.objectives = QuestInfoObjectivesText:GetText();
            end
         end   
         if (zdarzenie=="QUEST_PROGRESS") then
            QTR_quest_EN.progress = GetProgressText();
            QTR_quest_LG.progress = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Progress"]);
            if (strlen(QTR_quest_EN.progress)>0 and strlen(QTR_quest_LG.progress)==0) then
               QTR_MISSING[QTR_quest_EN.id.." PROGRESS"]=QTR_quest_EN.progress;     -- save missing translation part
            end
            if (strlen(QTR_quest_LG.progress)==0) then      -- treść jest pusta, a otworzono okienko Progress
               QTR_quest_LG.progress = QTR_ExpandUnitInfo('Dobrze ci idzie, YOUR_NAME');
            end
         end
         if (zdarzenie=="QUEST_COMPLETE") then
            QTR_quest_EN.completion = GetRewardText();
            QTR_quest_LG.completion = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Completion"]);
            QTR_quest_EN.itemchoose = QTR_MessOrig.itemchoose2;
            QTR_quest_LG.itemchoose = QTR_Messages.itemchoose2;
            QTR_quest_EN.itemreceive = QTR_MessOrig.itemreceiv2;
            QTR_quest_LG.itemreceive = QTR_Messages.itemreceiv2;
            if (strlen(QTR_quest_EN.completion)>0 and strlen(QTR_quest_LG.completion)==0) then
               QTR_MISSING[QTR_quest_EN.id.." COMPLETE"]=QTR_quest_EN.completion;     -- save missing translation part
            end
         end         
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         if (isQuestGuru()) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
            QTR_ToggleButton3:Enable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
            QTR_quest_EN.details = GetQuestText();
            QTR_quest_EN.progress = GetProgressText();
            QTR_quest_EN.completion = GetRewardText();
         end
         if (isStoryline() and Storyline_NPCFrame:IsVisible()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         end
         QTR_Translate_On(1);
--         if (QTR_first_show==0) then      -- pierwsze wyświetlenie, po co to? może bez opóźnienia? 
--            if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj wpierw na OFF
--            ---
--            end
--            if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj ponownie na ON
--            ---
--            end
--            QTR_first_show=1;
--         end
      else	      -- nie ma przetłumaczonego takiego questu
         QTR_ToggleButton0:Disable();
         QTR_ToggleButton1:Disable();
         QTR_ToggleButton2:Disable();
         if (isQuestGuru()) then
            QTR_ToggleButton3:Disable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Disable();
         end
         if (isStoryline()) then
            QTR_ToggleButton5:Disable();
         end
         QTR_ToggleButton0:SetText("Quest ID="..str_ID);
         QTR_ToggleButton1:SetText("Quest ID="..str_ID);
         QTR_ToggleButton2:SetText("Quest ID="..str_ID);
         if (isQuestGuru()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID);
         end
         if (isImmersion()) then
            if (q_ID==0) then
               if (ImmersionFrame.TitleButtons:IsVisible()) then
                  QTR_ToggleButton4:SetText("wybierz wpierw quest");
               end
            else
               QTR_ToggleButton4:SetText("Quest ID="..str_ID);
            end
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID);
         end
         if (QTR_PS["voices"]=="1") then
            PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\brak-tlumaczenia.mp3");
         end
         QTR_Translate_On(0);
         QTR_SaveQuest(zdarzenie);
      end -- jest przetłumaczony quest w bazie
   else	-- tłumaczenia wyłączone
      QTR_ToggleButton0:Disable();
      QTR_ToggleButton1:Disable();
      QTR_ToggleButton2:Disable();
--         if (isQuestGuru()) then
--            QTR_ToggleButton3:Disable();
--         end
--         if (isImmersion()) then
--            QTR_ToggleButton4:Disable();
--         end
      if ( QTR_QuestData[str_ID] ) then	-- ale jest tłumaczenie w bazie
         QTR_ToggleButton1:SetText("Quest ID="..str_ID.." (EN)");
         QTR_ToggleButton2:SetText("Quest ID="..str_ID.." (EN)");
         if (isQuestGuru()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID.." (EN)");
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..str_ID.." (EN)");
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID.." (EN)");
         end
      else
         QTR_ToggleButton1:SetText("Quest ID="..str_ID);
         QTR_ToggleButton2:SetText("Quest ID="..str_ID);
         if (isQuestGuru()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID);
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..str_ID);
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID);
         end
      end
   end	-- tłumaczenia są włączone
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


-- wyświetla tłumaczenie
function QTR_Translate_On(typ)
   if (QTR_PS["transtitle"]=="1") then    -- wyświetl przetłumaczony tytuł
      QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
      QuestProgressTitleText:SetFont(QTR_Font1, 18);
   end
   QuestInfoObjectivesHeader:SetFont(QTR_Font1, 18);
   QuestInfoObjectivesHeader:SetText(QTR_Messages.objectives);
   QuestInfoRewardsFrame.Header:SetFont(QTR_Font1, 18);
   QuestInfoRewardsFrame.Header:SetText(QTR_Messages.rewards);
   QuestInfoDescriptionHeader:SetFont(QTR_Font1, 18);
   QuestInfoDescriptionHeader:SetText(QTR_Messages.details);
   QuestProgressRequiredItemsText:SetFont(QTR_Font1, 18);
   QuestProgressRequiredItemsText:SetText(QTR_Messages.reqitems);
   QuestInfoDescriptionText:SetFont(QTR_Font2, 13);
   QuestInfoObjectivesText:SetFont(QTR_Font2, 13);
   QuestProgressText:SetFont(QTR_Font2, 13);
   QuestInfoRewardText:SetFont(QTR_Font2, 13);
   QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose);
   QuestInfoRewardsFrame.ItemChooseText:SetFont(QTR_Font2, 13);
   QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive);
   QuestInfoRewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 13);
   QuestInfoSpellObjectiveLearnLabel:SetFont(QTR_Font2, 13);
   QuestInfoSpellObjectiveLearnLabel:SetText(QTR_Messages.learnspell);
   QuestInfoXPFrame.ReceiveText:SetFont(QTR_Font2, 13);
   QuestInfoXPFrame.ReceiveText:SetText(QTR_Messages.experience);
--   MapQuestInfoRewardsFrame.ItemChooseText:SetFont(QTR_Font2, 11);
--   MapQuestInfoRewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 11);
--   MapQuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose);
--   MapQuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive);
   if (typ==1) then			-- pełne przełączenie (jest tłumaczenie)
      QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose);
      QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive);
      numer_ID = QTR_quest_LG.id;
      str_ID = tostring(numer_ID);
      if (numer_ID>0 and QTR_QuestData[str_ID]) then	-- przywróć przetłumaczoną wersję napisów
         if (QTR_PS["transtitle"]=="1") then
            QuestInfoTitleHeader:SetText(QTR_quest_LG.title);
            QuestProgressTitleText:SetText(QTR_quest_LG.title);
         end
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         if (isQuestGuru()) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
            if (not QTR_wait(0.2,QTR_Immersion)) then    -- wywołaj podmienianie danych po 0.2 sek
               -- opóźnienie 0.2 sek
            end
         end
         if (isStoryline() and Storyline_NPCFrame:IsVisible()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_LG.id.." ("..QTR_lang..")");
            QTR_Storyline(1);
         end
         QuestInfoDescriptionText:SetText(QTR_quest_LG.details);
         QuestInfoObjectivesText:SetText(QTR_quest_LG.objectives);
         QuestProgressText:SetText(QTR_quest_LG.progress);
         QuestInfoRewardText:SetText(QTR_quest_LG.completion);
--         QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose);
--         QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive);
      end
   else
      if (curr_trans == "1") then
         QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose);
         QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive);
         if ((ImmersionFrame ~= nil ) and (ImmersionFrame.TalkBox:IsVisible() )) then
            if (not QTR_wait(0.2,QTR_Immersion_Static)) then
               -- podmiana tekstu z opóźnieniem 0.2 sek
            end
         end
      end
   end
end


-- wyświetla oryginalny tekst
function QTR_Translate_Off(typ)
   QuestInfoTitleHeader:SetFont(Original_Font1, 18);
   QuestProgressTitleText:SetFont(Original_Font1, 18);
   QuestInfoObjectivesHeader:SetFont(Original_Font1, 18);
   QuestInfoObjectivesHeader:SetText(QTR_MessOrig.objectives);
   QuestInfoRewardsFrame.Header:SetFont(Original_Font1, 18);
   QuestInfoRewardsFrame.Header:SetText(QTR_MessOrig.rewards);
   QuestInfoDescriptionHeader:SetFont(Original_Font1, 18);
   QuestInfoDescriptionHeader:SetText(QTR_MessOrig.details);
   QuestProgressRequiredItemsText:SetFont(Original_Font1, 18);
   QuestProgressRequiredItemsText:SetText(QTR_MessOrig.reqitems);
   QuestInfoDescriptionText:SetFont(Original_Font2, 13);
   QuestInfoObjectivesText:SetFont(Original_Font2, 13);
   QuestProgressText:SetFont(Original_Font2, 13);
   QuestInfoRewardText:SetFont(Original_Font2, 13);
   QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN.itemchoose);
   QuestInfoRewardsFrame.ItemChooseText:SetFont(Original_Font2, 13);
   QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN.itemreceive);
   QuestInfoRewardsFrame.ItemReceiveText:SetFont(Original_Font2, 13);
--   MapQuestInfoRewardsFrame.ItemReceiveText:SetFont(Original_Font2, 11);
--   MapQuestInfoRewardsFrame.ItemChooseText:SetFont(Original_Font2, 11);
   QuestInfoSpellObjectiveLearnLabel:SetFont(Original_Font2, 13);
   QuestInfoSpellObjectiveLearnLabel:SetText(QTR_MessOrig.learnspell);
   QuestInfoXPFrame.ReceiveText:SetFont(Original_Font2, 13);
   QuestInfoXPFrame.ReceiveText:SetText(QTR_MessOrig.experience);
   if (typ==1) then			-- pełne przełączenie (jest tłumaczenie)
      QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN.itemchoose);
      QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN.itemreceive);
--      MapQuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN.itemchoose);
--      MapQuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN.itemreceive);
      numer_ID = QTR_quest_EN.id;
      if (numer_ID>0 and QTR_QuestData[str_ID]) then	-- przywróć oryginalną wersję napisów
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
         if (QuestGuru ~= nil ) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
         end
         if (ImmersionFrame ~= nil ) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
            QTR_Immersion_OFF();
            ImmersionFrame.TalkBox.TextFrame.Text:RepeatTexts();   --reload text
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_EN.id.." (EN)");
            QTR_Storyline_OFF(1);
         end
         QuestInfoTitleHeader:SetText(QTR_quest_EN.title);
         QuestProgressTitleText:SetText(QTR_quest_EN.title);
         QuestInfoDescriptionText:SetText(QTR_quest_EN.details);
         QuestInfoObjectivesText:SetText(QTR_quest_EN.objectives);
         QuestProgressText:SetText(QTR_quest_EN.progress);
         QuestInfoRewardText:SetText(QTR_quest_EN.completion);
--         QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN.itemchoose);
--         QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN.itemreceive);
      end
   else   
      if (curr_trans == "0") then
         if ((ImmersionFrame ~= nil ) and (ImmersionFrame.TalkBox:IsVisible() )) then
            if (not QTR_wait(0.2,QTR_Immersion_OFF_Static)) then
               -- podmiana tekstu z opóźnieniem 0.2 sek
            end
         end
      end
   end
end


function QTR_delayed3()
   QTR_ToggleButton4:SetText("wybierz wpierw quest");
   QTR_ToggleButton4:Hide();
   if (not QTR_wait(1,QTR_delayed4)) then
   ---
   end
end


function QTR_delayed4()
   if (ImmersionFrame.TitleButtons:IsVisible()) then
      if (ImmersionFrame.TitleButtons.Buttons[1] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[1]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[2] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[2]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[3] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[3]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end   
      if (ImmersionFrame.TitleButtons.Buttons[4] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[4]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[5] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[5]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
   end
   QTR_QuestPrepare('');
end;      


function QTR_PrepareDelay(czas)     -- wywoływane po kliknięciu na nazwę questu z listy NPC
   if (czas==1) then
      if (not QTR_wait(1,QTR_PrepareReload)) then
      ---
      end
   end
   if (czas==3) then
      if (not QTR_wait(3,QTR_PrepareReload)) then
      ---
      end
   end
end;      


function QTR_PrepareReload()
   QTR_QuestPrepare('');
end;      


function QTR_Immersion()   -- wywoływanie tłumaczenia z opóźnieniem 0.2 sek
  ImmersionContentFrame.ObjectivesText:SetFont(QTR_Font2, 14);
  ImmersionContentFrame.ObjectivesText:SetText(QTR_quest_LG.objectives);
  ImmersionFrame.TalkBox.NameFrame.Name:SetFont(QTR_Font1, 20);
  ImmersionFrame.TalkBox.NameFrame.Name:SetText(QTR_quest_LG.title);
  ImmersionFrame.TalkBox.TextFrame.Text:SetFont(QTR_Font2, 14);
  if (strlen(QTR_quest_EN.details)>0) then                                    -- mamy zdarzenie DETAILS
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG.details);
  elseif (strlen(QTR_quest_EN.completion)>0) then
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG.completion);
  else
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG.progress);
  end
  QTR_Immersion_Static();        -- inne statyczne dane
end


function QTR_Immersion_Static() 
  ImmersionContentFrame.ObjectivesHeader:SetFont(QTR_Font1, 18);
  ImmersionContentFrame.ObjectivesHeader:SetText(QTR_Messages.objectives);  -- "Zadanie"
  ImmersionContentFrame.RewardsFrame.Header:SetFont(QTR_Font1, 18);
  ImmersionContentFrame.RewardsFrame.Header:SetText(QTR_Messages.rewards);  -- "Nagroda"
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetFont(QTR_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetText(QTR_quest_LG.itemchoose); -- "Możesz wybrać nagrodę:"
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetText(QTR_quest_LG.itemreceive); -- "Otrzymasz w nagrodę:"
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetFont(QTR_Font2, 13);
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetText(QTR_Messages.experience);  -- "Doświadczenie"
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetFont(QTR_Font1, 18);
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetText(QTR_Messages.reqitems);  -- "Wymagane itemy:"
end


function QTR_Immersion_OFF()   -- wywoływanie oryginału
  ImmersionContentFrame.ObjectivesText:SetFont(Original_Font2, 14);
  ImmersionContentFrame.ObjectivesText:SetText(QTR_quest_EN.objectives);
  ImmersionFrame.TalkBox.NameFrame.Name:SetFont(Original_Font1, 20);
  ImmersionFrame.TalkBox.NameFrame.Name:SetText(QTR_quest_EN.title);
  ImmersionFrame.TalkBox.TextFrame.Text:SetFont(Original_Font2, 14);
  if (strlen(QTR_quest_EN.details)>0) then                                    -- przywróć oryginalny tekst
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN.details);
  elseif (strlen(QTR_quest_EN.progress)>0) then
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN.progress);
  else
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN.completion);
  end
  QTR_Immersion_OFF_Static();       -- inne statyczne dane
end


function QTR_Immersion_OFF_Static()
  ImmersionContentFrame.ObjectivesHeader:SetFont(Original_Font1, 18);
  ImmersionContentFrame.ObjectivesHeader:SetText(QTR_MessOrig.objectives);  -- "Zadanie"
  ImmersionContentFrame.RewardsFrame.Header:SetFont(Original_Font1, 18);
  ImmersionContentFrame.RewardsFrame.Header:SetText(QTR_MessOrig.rewards);  -- "Nagroda"
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetText(QTR_quest_EN.itemchoose); -- "Możesz wybrać nagrodę:"
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetText(QTR_quest_EN.itemreceive); -- "Otrzymasz w nagrodę:"
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetText(QTR_MessOrig.experience);  -- "Doświadczenie"
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetFont(Original_Font1, 18);
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetText(QTR_MessOrig.reqitems);  -- "Wymagane itemy:"
end


function QTR_Storyline_Delay()
   QTR_Storyline(1);
end


function QTR_Storyline_Quest()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1" and Storyline_NPCFrameTitle:IsVisible()) then
      QTR_QuestPrepare('');
   end
end


function QTR_Storyline_Hide()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1") then
      QTR_ToggleButton5:Hide();
   end
end


function QTR_Storyline_Objectives()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1" and QTR_quest_LG.id>0) then
      local string_ID= tostring(QTR_quest_LG.id);
      Storyline_NPCFrameObjectivesContent.Title:SetText('Zadanie');
      if (QTR_QuestData[string_ID] ) then
         Storyline_NPCFrameObjectivesContent.Objectives:SetText(QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Objectives"]));
         Storyline_NPCFrameObjectivesContent.Objectives:SetFont(QTR_Font2, 13);
      end   
   end
end


function QTR_Storyline_Rewards()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1") then
      Storyline_NPCFrameRewards.Content.Title:SetText('Nagroda');
   end
end


function QTR_Storyline(nr)
   if (QTR_PS["transtitle"]=="1") then
      Storyline_NPCFrameTitle:SetText(QTR_quest_LG.title);
      Storyline_NPCFrameTitle:SetFont(QTR_Font2, 18);
   end
   local string_ID= tostring(QTR_quest_LG.id);
   local texts = { "" };
   if ((Storyline_NPCFrameChat.event ~= nil) and (QTR_QuestData[string_ID] ~= nil))then
      local event = Storyline_NPCFrameChat.event;
      if (event=="QUEST_DETAIL") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Description"])) };
      end   
      if (event=="QUEST_PROGRESS") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Progress"])) };
      end   
      if (event=="QUEST_COMPLETE") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Completion"])) };
      end   
   end
   local ileOry = #Storyline_NPCFrameChat.texts;
   local indeks = 0;
   for i=1,#texts do
      if texts[i]:len() > 0 then
         if (indeks<ileOry) then
            indeks=indeks+1;
            Storyline_NPCFrameChat.texts[indeks]=texts[i];
         end
      end
   end
   Storyline_NPCFrameChatText:SetFont(QTR_Font2, 16);
   if (nr==1) then      -- Reload text
      Storyline_NPCFrameObjectivesContent:Hide();
      Storyline_NPCFrame.chat.currentIndex = 0;
      Storyline_API.playNext(Storyline_NPCFrameModelsYou);  -- reload
   end
end


function QTR_Storyline_OFF(nr)
   if (QTR_PS["transtitle"]=="1") then
      Storyline_NPCFrameTitle:SetText(QTR_quest_EN.title);
      Storyline_NPCFrameTitle:SetFont(Original_Font2, 18);
   end
   local string_ID= tostring(QTR_quest_EN.id);
   local texts = { "" };
   if ((Storyline_NPCFrameChat.event ~= nil) and (QTR_QuestData[string_ID] ~= nil))then
      local event = Storyline_NPCFrameChat.event;
      if (event=="QUEST_DETAIL") then
     	   texts = { strsplit("\n", GetQuestText()) };
      end   
      if (event=="QUEST_PROGRESS") then
     	   texts = { strsplit("\n", GetProgressText()) };
      end   
      if (event=="QUEST_COMPLETE") then
     	   texts = { strsplit("\n", GetRewardText()) };
      end   
   end
   local ileOry = #Storyline_NPCFrameChat.texts;
   local indeks = 0;
   for i=1,#texts do
      if texts[i]:len() > 0 then
         if (indeks<ileOry) then
            indeks=indeks+1;
            Storyline_NPCFrameChat.texts[indeks]=texts[i];
         end
      end
   end
   Storyline_NPCFrameChatText:SetFont(Original_Font2, 16);
   if (nr==1) then      -- Reload text
      Storyline_NPCFrameObjectivesContent:Hide();
      Storyline_NPCFrame.chat.currentIndex = 0;
      Storyline_API.playNext(Storyline_NPCFrameModelsYou);  -- reload
   end
end


-- podmieniaj specjane znaki w tekście
function QTR_ExpandUnitInfo(msg)
   msg = string.gsub(msg, "NEW_LINE", "\n");
   msg = string.gsub(msg, "YOUR_NAME0", string.upper(QTR_PC["name1"]));
   msg = string.gsub(msg, "YOUR_NAME1", QTR_PC["name1"]);
   msg = string.gsub(msg, "YOUR_NAME2", QTR_PC["name2"]);
   msg = string.gsub(msg, "YOUR_NAME3", QTR_PC["name3"]);
   msg = string.gsub(msg, "YOUR_NAME4", QTR_PC["name4"]);
   msg = string.gsub(msg, "YOUR_NAME5", QTR_PC["name5"]);
   msg = string.gsub(msg, "YOUR_NAME6", QTR_PC["name6"]);
   msg = string.gsub(msg, "YOUR_NAME7", QTR_PC["name7"]);
   msg = string.gsub(msg, "YOUR_NAME", QTR_name);
   
-- jeszcze obsłużyć YOUR_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end

-- jeszcze obsłużyć NPC_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local NPC_sex = UnitSex("npc");     -- 1:neutral,  2:męski,  3:żeński
   local nr_poz = string.find(msg, "NPC_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (NPC_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "NPC_GENDER");
   end

-- jeszcze obsłużyć OWN_NAME(EN;PL)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "OWN_NAME");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
--               if (QTR_PS["ownname"] == "1") then        -- forma polska
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               else                                      -- forma angielska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
--               end
--               if ((QTR_PS["ownname_obj"] == "1") and OnObjectives) then        -- zawsze forma angielska w Objectives
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "OWN_NAME");
   end

   if (QTR_sex==3) then        -- płeć żeńska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D2);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C2);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B2);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N2);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K2);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W2);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M2);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D2);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C2);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B2);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K2);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W2);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M2);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ą YOUR_RACE", "ą "..player_race.N2);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N2);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W2);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ą YOUR_CLASS", "ą "..player_class.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N2);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M2);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M2.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M2);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B2);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B2);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B2.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B2);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W2);                      -- Wołacz - pozostałe wystąpienia
   else                    -- płeć męska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D1);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C1);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B1);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N1);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K1);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W1);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M1);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D1);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C1);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B1);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K1);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W1);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M1);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ym YOUR_RACE", "ym "..player_race.N1);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N1);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W1);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ym YOUR_CLASS", "ym "..player_class.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N1);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M1);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M1.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M1);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B1);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B1);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "ego YOUR_CLASS", "ego "..player_class.B1);                -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B1.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B1);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W1);                      -- Wołacz - pozostałe wystąpienia
   end
   
   return msg;
end


function QTR_ScrollFrame_OnMouseWheel(self, step)
   local newValue = self:GetVerticalScroll() - (step * 15);
   if (newValue < 0) then
      newValue = 0;
   elseif (newValue > self:GetVerticalScrollRange()) then
      newValue = self:GetVerticalScrollRange();
   end
   self:SetVerticalScroll(newValue);
end


function QTR_ShowHideStatystyka()
   if (Players_ver_Count < 1) then          -- liczba graczy w tablicy Players_ver
      QTR_STframe.count:SetText("1 ");
   else
      QTR_STframe.count:SetText(tostring(Players_ver_Count));
   end
   local tabelka1 = "|cFF00FF00Nazwa gracza|r";
   local tabelka2 = string.format("|cFF00FF00%6s %8s %12s %13s %13s|r", "Wersja", " Baza ", "Data bazy", "Gossip", "Data gossip");

   local alert = 0;
   table.sort(Players_ver);
   for Name,Value in pairs(Players_ver) do
      tabelka1 = tabelka1 .. "\n" .. Name;
      if (tonumber(Value.VERSION)>tonumber(string.sub(QTR_version,1,1)..string.sub(QTR_version,-2)) and (Value.VERSION==Version_max.ADDON_VER)) then
         Value.VERSION = "|cFFFFFF00"..Value.VERSION.."|r";    -- w kolorze żółtym
         alert = 4;
      end
      if (tonumber(Value.BASE)>tonumber(QTR_base) and (Value.BASE==Version_max.BASE_VER)) then
         Value.BASE = "|cFFFFFF00"..Value.BASE.."|r";          -- w kolorze żółtym
         alert = alert + 2;
      end
      if (tonumber(Value.GOSSIP)>tonumber(GS_base) and (Value.GOSSIP==Version_max.GOSSIP_VER)) then
         Value.GOSSIP = "|cFFFFFF00"..Value.GOSSIP.."|r";      -- w kolorze żółtym
         alert = alert + 1;
      end
      tabelka2 = tabelka2 .. "\n" .. string.format("%6s %9s   %-13s %-7s %12s", Value.VERSION, Value.BASE, Value.DATE, Value.GOSSIP, Value.DATE2);
   end
   if (alert > 3) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja dodatku: |cFFFFFF00" .. Version_max.ADDON_VER .. "|r");
   elseif (alert > 1 ) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja bazy tłumaczeń");
   elseif (alert > 0 ) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja bazy GOSSIP");
   end
   QTR_STframe.tabela1:SetText(tabelka1);
   QTR_STframe.tabela2:SetText(tabelka2);
   QTR_STframe:Show();
end
