﻿-- Addon: WoWpoPolsku-Quests (version: 2.06) 2022.10.14
-- Description: AddOn displays translated quest information in original or separete window.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- WWW: https://wowpopolsku.pl

-- Global Variables
local QTR_version = "20400.04";
local QTR_name = UnitName("player");
local QTR_class= UnitClass("player");
local QTR_race = UnitRace("player");
local QTR_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local QTR_event="";
local QTR_waitTable = {};
local QTR_waitFrame = nil;
local QTR_MessOrig = {
      details    = "Description", 
      objectives = "Objectives", 
      rewards    = "Rewards", 
      itemchoose1= "You will be able to choose one of these rewards:", 
      itemchoose2= "Choose one of these rewards:", 
      itemreceiv1= "You will also receive:", 
      itemreceiv2= "You receiving the reward:", 
      learnspell = "Learn Spell:", 
      reqmoney   = "Required Money:", 
      reqitems   = "Required items:", 
      experience = "Experience:", 
      currquests = "Current Quests", 
      avaiquests = "Available Quests", };
local Original_Font1 = "Fonts\\MORPHEUS.ttf";
local Original_Font2 = "Fonts\\FRIZQT__.ttf";
if not QTR then
   QTR = { };
end

local p_race = {
      ["Blood Elf"] = { M1="Krwawy Elf", D1="krwawego elfa", C1="krwawemu elfowi", B1="krwawego elfa", N1="krwawym elfem", K1="krwawym elfie", W1="Krwawy Elfie", M2="Krwawa Elfka", D2="krwawej elfki", C2="krwawej elfce", B2="krwawą elfkę", N2="krwawą elfką", K2="krwawej elfce", W2="Krwawa Elfko" }, 
      ["Dark Iron Dwarf"] = { M1="Krasnolud Ciemnego Żelaza", D1="krasnoluda Ciemnego Żelaza", C1="krasnoludowi Ciemnego Żelaza", B1="krasnoluda Ciemnego Żelaza", N1="krasnoludem Ciemnego Żelaza", K1="krasnoludzie Ciemnego Żelaza", W1="Krasnoludzie Ciemnego Żelaza", M2="Krasnoludka Ciemnego Żelaza", D2="krasnoludki Ciemnego Żelaza", C2="krasnoludce Ciemnego Żelaza", B2="krasnoludkę Ciemnego Żelaza", N2="krasnoludką Ciemnego Żelaza", K2="krasnoludce Ciemnego Żelaza", W2="Krasnoludko Ciemnego Żelaza" },
      ["Draenei"] = { M1="Draenei", D1="draeneia", C1="draeneiowi", B1="draeneia", N1="draeneiem", K1="draeneiu", W1="Draeneiu", M2="Draeneika", D2="draeneiki", C2="draeneice", B2="draeneikę", N2="draeneiką", K2="draeneice", W2="Draeneiko" },
      ["Dwarf"] = { M1="Krasnolud", D1="krasnoluda", C1="krasnoludowi", B1="krasnoluda", N1="krasnoludem", K1="krasnoludzie", W1="Krasnoludzie", M2="Krasnoludka", D2="krasnoludki", C2="krasnoludce", B2="krasnoludkę", N2="krasnoludką", K2="krasnoludce", W2="Krasnoludko" },
      ["Gnome"] = { M1="Gnom", D1="gnoma", C1="gnomowi", B1="gnoma", N1="gnomem", K1="gnomie", W1="Gnomie", M2="Gnomka", D2="gnomki", C2="gnomce", B2="gnomkę", N2="gnomką", K2="gnomce", W2="Gnomko" },
      ["Goblin"] = { M1="Goblin", D1="goblina", C1="goblinowi", B1="goblina", N1="goblinem", K1="goblinie", W1="Goblinie", M2="Goblinka", D2="goblinki", C2="goblince", B2="goblinkę", N2="goblinką", K2="goblince", W2="Goblinko" },
      ["Highmountain Tauren"] = { M1="Tauren z Wysokiej Góry", D1="taurena z Wysokiej Góry", C1="taurenowi z Wysokiej Góry", B1="taurena z Wysokiej Góry", N1="taurenen z Wysokiej Góry", K1="taurenie z Wysokiej Góry", W1="Taurenie z Wysokiej Góry", M2="Taurenka z Wysokiej Góry", D2="taurenki z Wysokiej Góry", C2="taurence z Wysokiej Góry", B2="taurenkę z Wysokiej Góry", N2="taurenką z Wysokiej Góry", K2="taurence z Wysokiej Góry", W2="Taurenko z Wysokiej Góry" },
      ["Human"] = { M1="Człowiek", D1="człowieka", C1="człowiekowi", B1="człowieka", N1="człowiekiem", K1="człowieku", W1="Człowieku", M2="Człowiek", D2="człowieka", C2="człowiekowi", B2="człowieka", N2="człowiekiem", K2="człowieku", W2="Człowieku" },
      ["Kul Tiran"] = { M1="Kul Tiran", D1="Kul Tirana", C1="Kul Tiranowi", B1="Kul Tirana", N1="Kul Tiranem", K1="Kul Tiranie", W1="Kul Tiranie", M2="Kul Tiranka", D2="Kul Tiranki", C2="Kul Tirance", B2="Kul Tirankę", N2="Kul Tiranką", K2="Kul Tirance", W2="Kul Tiranko" },
      ["Lightforged Draenei"] = { M1="Świetlisty Draenei", D1="świetlistego draeneia", C1="świetlistemu draeneiowi", B1="świetlistego draeneia", N1="świetlistym draeneiem", K1="świetlistym draeneiu", W1="Świetlisty Draeneiu", M2="Świetlista Draeneika", D2="świetlistej draeneiki", C2="świetlistej draeneice", B2="świetlistą draeneikę", N2="świetlistą draeneiką", K2="świetlistej draeneice", W2="Świetlista Draeneiko" },
      ["Mag'har Orc"] = { M1="Ork z Mag'har", D1="orka z Mag'har", C1="orkowi z Mag'har", B1="orka z Mag'har", N1="orkiem z Mag'har", K1="orku z Mag'har", W1="Orku z Mag'har", M2="Orczyca z Mag'har", D2="orczycy z Mag'har", C2="orczycy z Mag'har", B2="orczycę z Mag'har", N2="orczycą z Mag'har", K2="orczyce z Mag'har", W2="Orczyco z Mag'har" },
      ["Nightborne"] = { M1="Dziecię Nocy", D1="dziecięcia nocy", C1="dziecięciu nocy", B1="dziecię nocy", N1="dziecięcem nocy", K1="dziecięciu nocy", W1="Dziecię Nocy", M2="Dziecię Nocy", D2="dziecięcia nocy", C2="dziecięciu nocy", B2="dziecię nocy", N2="dziecięcem nocy", K2="dziecięciu nocy", W2="Dziecię Nocy" },
      ["Night Elf"] = { M1="Nocny Elf", D1="nocnego elfa", C1="nocnemu elfowi", B1="nocnego elfa", N1="nocnym elfem", K1="nocnym elfie", W1="Nocny Elfie", M2="Nocna Elfka", D2="nocnej elfki", C2="nocnej elfce", B2="nocną elfkę", N2="nocną elfką", K2="nocnej elfce", W2="Nocna Elfko" },
      ["Orc"] = { M1="Ork", D1="orka", C1="orkowi", B1="orka", N1="orkiem", K1="orku", W1="Orku", M2="Orczyca", D2="orczycy", C2="orczycy", B2="orczycę", N2="orczycą", K2="orczycy", W2="Orczyco" },
      ["Pandaren"] = { M1="Pandaren", D1="pandarena", C1="pandarenowi", B1="pandarena", N1="pandarenem", K1="pandarenie", W1="Pandarenie", M2="Pandarenka", D2="pandarenki", C2="pandarence", B2="pandarenkę", N2="pandarenką", K2="pandarence", W2="Pandarenko" },
      ["Tauren"] = { M1="Tauren", D1="taurena", C1="taurenowi", B1="taurena", N1="taurenem", K1="taurenie", W1="Taurenie", M2="Taurenka", D2="taurenki", C2="taurence", B2="taurenkę", N2="taurenką", K2="taurence", W2="Taurenko" },
      ["Troll"] = { M1="Troll", D1="trolla", C1="trollowi", B1="trolla", N1="trollem", K1="trollu", W1="Trollu", M2="Trollica", D2="trollicy", C2="trollicy", B2="trollicę", N2="trollicą", K2="trollicy", W2="Trollico" },
      ["Undead"] = { M1="Nieumarły", D1="nieumarłego", C1="nieumarłemu", B1="nieumarłego", N1="nieumarłym", K1="nieumarłym", W1="Nieumarły", M2="Nieumarła", D2="nieumarłej", C2="nieumarłej", B2="nieumarłą", N2="nieumarłą", K2="nieumarłej", W2="Nieumarła" },
      ["Void Elf"] = { M1="Elf Pustki", D1="elfa Pustki", C1="elfowi Pustki", B1="elfa Pustki", N1="elfem Pustki", K1="elfie Pustki", W1="Elfie Pustki", M2="Elfka Pustki", D2="elfki Pustki", C2="elfce Pustki", B2="elfkę Pustki", N2="elfką Pustki", K2="elfce Pustki", W2="Elfko Pustki" },
      ["Worgen"] = { M1="Worgen", D1="worgena", C1="worgenowi", B1="worgena", N1="worgenem", K1="worgenie", W1="Worgenie", M2="Worgenka", D2="worgenki", C2="worgence", B2="worgenkę", N2="worgenką", K2="worgence", W2="Worgenko" },
      ["Zandalari Troll"] = { M1="Troll Zandalari", D1="trolla Zandalari", C1="trollowi Zandalari", B1="trolla Zandalari", N1="trollem Zandalari", K1="trollu Zandalari", W1="Trollu Zandalari", M2="Trollica Zandalari", D2="trollicy Zandalari", C2="trollicy Zandalari", B2="trollicę Zandalari", N2="trollicą Zandalari", K2="trollicy Zandalari", W2="Trollico Zandalari" }, }
local p_class = {
      ["Death Knight"] = { M1="Rycerz Śmierci", D1="rycerz śmierci", C1="rycerzowi śmierci", B1="rycerza śmierci", N1="rycerzem śmierci", K1="rycerzu śmierci", W1="Rycerzu Śmierci", M2="Rycerz Śmierci", D2="rycerz śmierci", C2="rycerzowi śmierci", B2="rycerza śmierci", N2="rycerzem śmierci", K2="rycerzu śmierci", W2="Rycerzu Śmierci" },
      ["Demon Hunter"] = { M1="Łowca demonów", D1="łowcy demonów", C1="łowcy demonów", B1="łowcę demonów", N1="łowcą demonów", K1="łowcy demonów", W1="Łowco demonów", M2="Łowczyni demonów", D2="łowczyni demonów", C2="łowczyni demonów", B2="łowczynię demonów", N2="łowczynią demonów", K2="łowczyni demonów", W2="Łowczyni demonów" },
      ["Druid"] = { M1="Druid", D1="druida", C1="druidowi", B1="druida", N1="druidem", K1="druidzie", W1="Druidzie", M2="Druidka", D2="druidki", C2="druidce", B2="druikę", N2="druidką", K2="druidce", W2="Druidko" },
      ["Hunter"] = { M1="Łowca", D1="łowcy", C1="łowcy", B1="łowcę", N1="łowcą", K1="łowcy", W1="Łowco", M2="Łowczyni", D2="łowczyni", C2="łowczyni", B2="łowczynię", N2="łowczynią", K2="łowczyni", W2="Łowczyni" },
      ["Mage"] = { M1="Czarodziej", D1="czarodzieja", C1="czarodziejowi", B1="czarodzieja", N1="czarodziejem", K1="czarodzieju", W1="Czarodzieju", M2="Czarodziejka", D2="czarodziejki", C2="czarodziejce", B2="czarodziejkę", N2="czarodziejką", K2="czarodziejce", W2="Czarodziejko" },
      ["Monk"] = { M1="Mnich", D1="mnicha", C1="mnichowi", B1="mnicha", N1="mnichem", K1="mnichu", W1="Mnichu", M2="Mniszka", D2="mniszki", C2="mniszce", B2="mniszkę", N2="mniszką", K2="mniszce", W2="Mniszko" },
      ["Paladin"] = { M1="Paladyn", D1="paladyna", C1="paladynowi", B1="paladyna", N1="paladynem", K1="paladynie", W1="Paladynie", M2="Paladynka", D2="paladynki", C2="paladynce", B2="paladynkę", N2="paladynką", K2="paladynce", W2="Paladynko" },
      ["Priest"] = { M1="Kapłan", D1="kapłana", C1="kapłanowi", B1="kapłana", N1="kapłanem", K1="kapłanie", W1="Kapłanie", M2="Kapłanka", D2="kapłanki", C2="kapłance", B2="kapłankę", N2="kapłanką", K2="kapłance", W2="Kapłanko" },
      ["Rogue"] = { M1="Łotrzyk", D1="łotrzyka", C1="łotrzykowi", B1="łotrzyka", N1="łotrzykiem", K1="łotrzyku", W1="Łotrzyku", M2="Łotrzyca", D2="łotrzycy", C2="łotrzycy", B2="łotrzycę", N2="łotrzycą", K2="łotrzycy", W2="Łotrzyco" },
      ["Shaman"] = { M1="Szaman", D1="szamana", C1="szamanowi", B1="szamana", N1="szamanem", K1="szamanie", W1="Szamanie", M2="Szamanka", D2="szamanki", C2="szamance", B2="szamankę", N2="szamanką", K2="szamance", W2="Szamanko" },
      ["Warlock"] = { M1="Czarnoksiężnik", D1="czarnoksiężnika", C1="czarnoksiężnikowi", B1="czarnoksiężnika", N1="czarnoksiężnikiem", K1="czarnoksiężniku", W1="Czarnoksiężniku", M2="Czarownica", D2="czarownicy", C2="czarownicy", B2="czarownicę", N2="czarownicą", K2="czarownicy", W2="Czarownico" },
      ["Warrior"] = { M1="Wojownik", D1="wojownika", C1="wojownikowi", B1="wojownika", N1="wojownikiem", K1="wojowniku", W1="Wojowniku", M2="Wojowniczka", D2="wojowniczki", C2="wojowniczce", B2="wojowniczkę", N2="wojowniczką", K2="wojowniczce", W2="Wojowniczko" }, }
if (p_race[QTR_race]) then      
   player_race = { M1=p_race[QTR_race].M1, D1=p_race[QTR_race].D1, C1=p_race[QTR_race].C1, B1=p_race[QTR_race].B1, N1=p_race[QTR_race].N1, K1=p_race[QTR_race].K1, W1=p_race[QTR_race].W1, M2=p_race[QTR_race].M2, D2=p_race[QTR_race].D2, C2=p_race[QTR_race].C2, B2=p_race[QTR_race].B2, N2=p_race[QTR_race].N2, K2=p_race[QTR_race].K2, W2=p_race[QTR_race].W2 };
else   
   player_race = { M1=QTR_race, D1=QTR_race, C1=QTR_race, B1=QTR_race, N1=QTR_race, K1=QTR_race, W1=QTR_race, M2=QTR_race, D2=QTR_race, C2=QTR_race, B2=QTR_race, N2=QTR_race, K2=QTR_race, W2=QTR_race };
   print ("|cff55ff00QTR - nowa rasa: "..QTR_race);
end
if (p_class[QTR_class]) then
   player_class = { M1=p_class[QTR_class].M1, D1=p_class[QTR_class].D1, C1=p_class[QTR_class].C1, B1=p_class[QTR_class].B1, N1=p_class[QTR_class].N1, K1=p_class[QTR_class].K1, W1=p_class[QTR_class].W1, M2=p_class[QTR_class].M2, D2=p_class[QTR_class].D2, C2=p_class[QTR_class].C2, B2=p_class[QTR_class].B2, N2=p_class[QTR_class].N2, K2=p_class[QTR_class].K2, W2=p_class[QTR_class].W2 };
else
   player_class = { M1=QTR_class, D1=QTR_class, C1=QTR_class, B1=QTR_class, N1=QTR_class, K1=QTR_class, W1=QTR_class, M2=QTR_class, D2=QTR_class, C2=QTR_class, B2=QTR_class, N2=QTR_class, K2=QTR_class, W2=QTR_class };
   print ("|cff55ff00QTR - nowa klasa: "..QTR_class);
end



function Spr_Gender(msg)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do   -- szykaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end
   return msg;
end


function QTR_CheckVars()
  if (not QTR_PS) then
     QTR_PS = {};
  end
  if (not QTR_PC) then
     QTR_PC = {};
  end
  if (not QTR_SAVED) then
     QTR_SAVED = {};
  end
  -- initialize check options
  if (not QTR_PS["active"]) then
     QTR_PS["active"] = "1";   
  end
  if (not QTR_PS["mode"] ) then
     QTR_PS["mode"] = "2";   
  end
  if (not QTR_PS["transtitle"] ) then
     QTR_PS["transtitle"] = "1";   
  end
  if (not QTR_PS["size"] ) then
     QTR_PS["size"] = "1";   
  end
  if (not QTR_PS["width"] ) then
     QTR_PS["width"] = "1";   
  end

  -- set check buttons 
  if (QTR_PS["size"] == "1") then
     QTR_SizeH = 1;
  else 
     QTR_SizeH = 2;     
     QTRFrame1:SetHeight(525);
     QTR_QuestDetail:SetHeight(430);
     QTR_ToggleButton2:SetText("^");
  end
  if (QTR_PS["width"] == "1") then
     QTR_SizeW = 1;
  else 
     QTR_SizeW = 2;     
     QTRFrame1:SetWidth(525);
     QTR_QuestDetail:SetWidth(495);
     QTR_QuestTitle:SetWidth(495);
     QTR_ToggleButton3:SetText("<");
  end
  if ( QTR_PS["isGetQuestID"] ) then
     isGetQuestID=QTR_PS["isGetQuestID"];
  end;
end


-- tłumaczenie przy QuestLog'u
function QTR_OnLoad1()
  QTR.frame1 = CreateFrame("Frame");
  QTR.frame1:RegisterEvent("ADDON_LOADED");
  QTR.frame1:RegisterEvent("QUEST_LOG_UPDATE");
  QTR.frame1:SetScript("OnEvent", function(self, event, ...) return QTR[event] and QTR[event](QTR, event, ...) end);
  QuestLogDetailScrollFrame:SetScript("OnShow", QTR_ShowAndUpdateQuestInfo);
  QuestLogDetailScrollFrame:SetScript("OnHide", QTR_HideQuestInfo);

  QTR_QuestTitle:SetFont(QTR_Font2, 17);
  QTR_QuestDetail:SetFont(QTR_Font2, 14);
  QTRFrame1:ClearAllPoints();
  QTRFrame1:SetPoint("TOPLEFT", QuestLogFrame, "TOPRIGHT", -3, -12);

  -- small button in QuestLogFrame
  QTR_ToggleButton1 = CreateFrame("Button",nil, QuestLogFrame, "UIPanelButtonTemplate");
  QTR_ToggleButton1:SetWidth(35);
  QTR_ToggleButton1:SetHeight(18);
  QTR_ToggleButton1:SetText("QTR");
  QTR_ToggleButton1:Show();
  QTR_ToggleButton1:ClearAllPoints();
  QTR_ToggleButton1:SetPoint("TOPLEFT", QuestLogFrame, "TOPRIGHT", -100, -15);
  QTR_ToggleButton1:SetScript("OnClick", QTR_ToggleVisibility);

  -- button for ChangeFrameHeight
  QTR_ToggleButton2 = CreateFrame("Button",nil, QTRFrame1, "UIPanelButtonTemplate");
  QTR_ToggleButton2:SetWidth(15);
  QTR_ToggleButton2:SetHeight(22);
  QTR_ToggleButton2:SetText("v");
  QTR_ToggleButton2:Show();
  QTR_ToggleButton2:ClearAllPoints();
  QTR_ToggleButton2:SetPoint("BOTTOMLEFT", QTRFrame1, "BOTTOMRIGHT", -40, 9);
  QTR_ToggleButton2:SetScript("OnClick", QTR_ChangeFrameHeight);

  -- button for ChangeFrameWidth
  QTR_ToggleButton3 = CreateFrame("Button",nil, QTRFrame1, "UIPanelButtonTemplate");
  QTR_ToggleButton3:SetWidth(15);
  QTR_ToggleButton3:SetHeight(22);
  QTR_ToggleButton3:SetText(">");
  QTR_ToggleButton3:Show();
  QTR_ToggleButton3:ClearAllPoints();
  QTR_ToggleButton3:SetPoint("BOTTOMLEFT", QTRFrame1, "BOTTOMRIGHT", -25, 9);
  QTR_ToggleButton3:SetScript("OnClick", QTR_ChangeFrameWidth);

  hooksecurefunc("QuestLogTitleButton_OnClick", function() QTR_UpdateQuestInfo() end);
end


-- tłumaczenie podczas rozmowy z NPC
function QTR_OnLoad2()
  QTR.frame2 = CreateFrame("Frame");
  QTR.frame2:RegisterEvent("QUEST_GREETING");
  QTR.frame2:RegisterEvent("QUEST_DETAIL");
  QTR.frame2:RegisterEvent("QUEST_PROGRESS");
  QTR.frame2:RegisterEvent("QUEST_COMPLETE");
  QTR.frame2:SetScript("OnEvent", function(self, event, ...) return QTR[event] and QTR[event](QTR, event, ...) end);
  QTR_QuestTitle2:SetFont(QTR_Font2, 17);
  QTR_QuestDetail2:SetFont(QTR_Font2, 14);
  QTR_QuestWarning2:SetFont(QTR_Font2, 12);
  QTRFrame2:ClearAllPoints();
  QTRFrame2:SetPoint("TOPLEFT", QuestFrame, "TOPRIGHT", -31, -19);
  QuestFrame:SetScript("OnHide", QTR_Frame2Close);
end


function QTR_SlashCommand(msg)
   if (msg=="on" or msg=="ON") then
      if (QTR_PS["active"]=="1") then
         print ("QTR - tłumaczenia są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenia.");
         QTR_PS["active"] = "1";
      end
   elseif (msg=="off" or msg=="OFF") then
      if (QTR_PS["active"]=="0") then
         print ("QTR - tłumaczenia są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia.");
         QTR_PS["active"] = "0";
      end
   elseif (msg=="title on" or msg=="TITLE ON") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenia tytułów są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenia tytułów.");
         QTR_PS["transtitle"] = "1";
      end
   elseif (msg=="title off" or msg=="TITLE OFF") then
      if (QTR_PS["transtilte"]=="0") then
         print ("QTR - tłumaczenia tytułów są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia tytułów.");
         QTR_PS["transtitle"] = "0";
      end
   else
      print ("QTR - menu szybkich komend addonu QTR:");
      print ("      /qtr on  - włącza tłumaczenia");
      print ("      /qtr off - wyłącza tłumaczenia");
      print ("      /qtr title on  - włącza tłumaczenie tytułu");
      print ("      /qtr title off - wyłącza tłumaczenie tytułu");
   end
end


function QTR:ADDON_LOADED(_, addon)
  if (addon == "WoWpoPolsku_Quests") then
     SlashCmdList["WOWPOPOLSKU_QUESTS"] = function(msg) QTR_SlashCommand(msg); end
     SLASH_WOWPOPOLSKU_QUESTS1 = "/wowpopolsku-quests";
     SLASH_WOWPOPOLSKU_QUESTS2 = "/qtr";
     QTR_CheckVars();
     print("|cffffff00WoWpoPolsku-Quests ver. "..QTR_version.." - " .. QTR_Messages.loaded);
     self.frame1:UnregisterEvent("ADDON_LOADED");
     self.ADDON_LOADED = nil;
     QTR_Messages.itemchoose1 = Spr_Gender(QTR_Messages.itemchoose1);
     if (not isGetQuestID) then
        DetectEmuServer();
     end;
  end
end


function QTR:QUEST_LOG_UPDATE()
  if (QTRFrame1:IsVisible()) then
     QTR_UpdateQuestInfo();
  end
end


function DetectEmuServer()
  QTR_PS["isGetQuestID"]="0";
  isGetQuestID="0";
  -- function GetQuestID() don't work on wow-emulator servers - possible lua error when you first start - not significant
--  if ( GetQuestID() ) then
--     QTR_PS["isGetQuestID"]="1";
--     isGetQuestID="1";
--  end
end


function QTR_wait(delay, func, ...)
  if(type(delay)~="number" or type(func)~="function") then
    return false;
  end
  if(QTR_waitFrame == nil) then
    QTR_waitFrame = CreateFrame("Frame","QTR_WaitFrame", UIParent);
    QTR_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #QTR_waitTable;
      local i = 1;
      while(i<=count) do
        local waitRecord = tremove(QTR_waitTable,i);
        local d = tremove(waitRecord,1);
        local f = tremove(waitRecord,1);
        local p = tremove(waitRecord,1);
        if(d>elapse) then
          tinsert(QTR_waitTable,i,{d-elapse,f,p});
          i = i + 1;
        else
          count = count - 1;
          f(unpack(p));
        end
      end
    end);
  end
  tinsert(QTR_waitTable,{delay,func,{...}});
  return true;
end


function QTR:QUEST_GREETING()
  if (QTR_PS["active"]=="1" and QTR_PS["mode"]=="1") then
     CurrentQuestsText:SetText(QTR_Messages.currquests);
     CurrentQuestsText:SetFont(QTR_Font1, 18);
     AvailableQuestsText:SetText(QTR_Messages.avaiquests);
     AvailableQuestsText:SetFont(QTR_Font1, 18);
  else
     CurrentQuestsText:SetText(QTR_MessOrig.currquests);
     CurrentQuestsText:SetFont(Original_Font1, 18);
     AvailableQuestsText:SetText(QTR_MessOrig.avaiquests);
     AvailableQuestsText:SetFont(Original_Font1, 18);
  end
end


function QTR:QUEST_DETAIL()
  QTR_event = "QUEST_DETAIL";
  if (isGetQuestID=="0") then
     if ( not QTR_wait(0.5,QTR_OnEvent2) ) then
        QTR_OnEvent2();
     end
  else
     QTR_OnEvent2();
  end
end


function QTR:QUEST_PROGRESS()
  QTR_event = "QUEST_PROGRESS";
  QTR_OnEvent2();
end


function QTR:QUEST_COMPLETE()
  QTR_event = "QUEST_COMPLETE";
  QTR_OnEvent2();
end


function QTR_OnEvent2()
  local q_title = GetTitleText();
  local q_ID = QTR_GetIDforTitle(q_title);

  if ( QTR_PS["active"]=="1" )then
     QTR_QuestID2:SetText("");
     QTR_QuestTitle2:SetText(q_title);
     QTR_QuestDetail2:SetText(QTR_Messages.missing);
     QTR_QuestWarning2:SetText("");
     if ( q_ID > 0 ) then
        local str_id = tostring(q_ID);
        QTR_QuestID2:SetText("Quest ID: " .. str_id);
        if (QTR_QuestData[str_id]) then
           -- display only, if translation exists
           QTR_ShowFrame2(QTR_event, str_id);
        else
           -- DEFAULT_CHAT_FRAME:AddMessage("WoWpoPolsku-Quests - Qid: "..tostring(q_ID).." ("..QTR_Messages.missing..")");
           QTR_SAVED[str_id.." TITLE"]=GetTitleText();               -- save original title to future translation
           if (QTR_event=="QUEST_DETAIL") then
              QTR_SAVED[str_id.." DESCRIPTION"]=GetQuestText();      -- save original text to future translation
              QTR_SAVED[str_id.." OBJECTIVE"]=GetObjectiveText();    -- save original text to future translation
           end
           if (QTR_event=="QUEST_PROGRESS") then
              QTR_SAVED[str_id.." PROGRESS"]=GetProgressText();      -- save original text to future translation
           end
           if (QTR_event=="QUEST_COMPLETE") then
              QTR_SAVED[str_id.." COMPLETE"]=GetRewardText();        -- save original text to future translation
           end
           QTRFrame2:Hide();
        end
     end
  end
  if (QTR_event == "QUEST_COMPLETE") then
     if ( q_ID > 0) then
        local str_id = tostring(q_ID);
        QTR_PC[str_id]="OK";
     end
  end
end


-- wyświetla okno tłumaczenia podczas rozmowy z NPC
function QTR_ShowFrame2(eventStr, qid)
  QTR_QuestID2:SetText("Quest ID: " .. qid);
  QTR_QuestDetail2:SetText(QTR_Messages.missing);
  if (QTR_QuestData[qid]) then
     QTR_QuestTitle2:SetText(QTR_ExpandUnitInfo(QTR_QuestData[qid]["Title"]));
     local QTR_text = "";
     if (eventStr == "QUEST_DETAIL") then
        if (QTR_QuestData[qid]["Description"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Description"]);
        end
        local QTR_text2 = "";
        if (QTR_QuestData[qid]["Objectives"]) then
           QTR_text2 = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Objectives"]);
        end
        QTR_text = QTR_text .. "\n\n" .. QTR_Messages.objectives .. "\n" .. QTR_text2;
     end
     if (eventStr == "QUEST_PROGRESS") then
        if (QTR_QuestData[qid]["Progress"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Progress"]);
        end
     end
     if (eventStr == "QUEST_COMPLETE") then
        if (QTR_QuestData[qid]["Completion"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Completion"]);
        end
     end
     QTR_QuestDetail2:SetText(QTR_text);
     QTRFrame2:ClearAllPoints();
     QTRFrame2:SetPoint("TOPLEFT", QuestFrame, "TOPRIGHT", -31, -19);
     if ( QuestNPCModel ) then
        if ( QuestNPCModel:IsVisible() ) then
           QTRFrame2:SetPoint("TOPLEFT", QuestNPCModel, "TOPRIGHT", 0, 42);
        end
     end
     QTRFrame2:Show();
  end
end


function QTR_Frame2Close()
  QTRFrame2:Hide();
  QuestFrame_OnHide();
end


function QTR_split(str, c)
  local aCount = 0;
  local array = {};
  local a = string.find(str, c);
  while a do
     aCount = aCount + 1;
     array[aCount] = string.sub(str, 1, a-1);
     str=string.sub(str, a+1);
     a = string.find(str, c);
  end
  aCount = aCount + 1;
  array[aCount] = str;
  return array;
end


function QTR_findlast(source, char)
  if (not source) then
     return 0;
  end
  local lastpos = 0;
  local byte_char = string.byte(char);
  for i=1, #source do
     if (string.byte(source,i)==byte_char) then
        lastpos = i;
     end
  end
  return lastpos;
end


function QTR_ChangeFrameHeight()
  -- normal height of Frame = 425, quest detail = 350
  if (QTR_SizeH == 1) then
     QTRFrame1:SetHeight(525);
     QTR_QuestDetail:SetHeight(430);
     QTR_ToggleButton2:SetText("^");
     QTR_SizeH = 2;
     QTR_PS["size"] = "2";
  else
     QTRFrame1:SetHeight(425);
     QTR_QuestDetail:SetHeight(350);
     QTR_ToggleButton2:SetText("v");
     QTR_SizeH = 1;
     QTR_PS["size"] = "1";
  end
end


function QTR_ChangeFrameWidth()
  -- normal width of Frame = 350, quest detail = 320
  if (QTR_SizeW == 1) then
     QTRFrame1:SetWidth(525);
     QTR_QuestDetail:SetWidth(495);
     QTR_QuestTitle:SetWidth(495);
     QTR_ToggleButton3:SetText("<");
     QTR_SizeW = 2;
     QTR_PS["width"] = "2";
  else
     QTRFrame1:SetWidth(350);
     QTR_QuestDetail:SetWidth(320);
     QTR_QuestTitle:SetWidth(320);
     QTR_ToggleButton3:SetText(">");
     QTR_SizeW = 1;
     QTR_PS["width"] = "1";
  end
end


function QTR_OnMouseDown1()
  -- start moving the window
  QTRFrame1:StartMoving();
end
  

function QTR_OnMouseUp1()
  -- stop moving the window
  QTRFrame1:StopMovingOrSizing();
end


function QTR_OnMouseDown2()
  -- start moving the window
  QTRFrame2:StartMoving();
end
  

function QTR_OnMouseUp2()
  -- stop moving the window
  QTRFrame2:StopMovingOrSizing();
end


function QTR_ChangeText_InEvent(QTR_event, str_id)
  if (QTR_PS["transtitle"]=="1") then
     QuestInfoTitleHeader:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Title"]));
     QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
     QuestProgressTitleText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Title"]));
     QuestProgressTitleText:SetFont(QTR_Font1, 18);
  end
  QuestInfoDescriptionHeader:SetText(QTR_Messages.details);
  QuestInfoDescriptionHeader:SetFont(QTR_Font1, 18);
  QuestInfoDescriptionText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Description"]));
  QuestInfoDescriptionText:SetFont(QTR_Font2, 13);
  QuestInfoObjectivesHeader:SetText(QTR_Messages.objectives);
  QuestInfoObjectivesHeader:SetFont(QTR_Font1, 18);
  QuestInfoObjectivesText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Objectives"]));
  QuestInfoObjectivesText:SetFont(QTR_Font2, 13);
  QuestInfoRewardsHeader:SetText(QTR_Messages.rewards);
  QuestInfoRewardsHeader:SetFont(QTR_Font1, 18);
  QuestInfoRewardText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Completion"]));
  QuestInfoRewardText:SetFont(QTR_Font2, 13);
  if (QTR_event=="QUEST_COMPLETE") then
     QuestInfoItemChooseText:SetText(QTR_Messages.itemchoose2);
     QuestInfoItemReceiveText:SetText(QTR_Messages.itemreceiv2);
  else
     QuestInfoItemChooseText:SetText(QTR_Messages.itemchoose1);
     QuestInfoItemReceiveText:SetText(QTR_Messages.itemreceiv1);
  end
  QuestInfoItemChooseText:SetFont(QTR_Font2, 13);
  QuestInfoItemReceiveText:SetFont(QTR_Font2, 13);
  QuestInfoXPFrameReceiveText:SetText(QTR_Messages.experience);
  QuestInfoXPFrameReceiveText:SetFont(QTR_Font2, 13);
  QuestInfoRequiredMoneyText:SetText(QTR_Messages.reqmoney);
  QuestInfoRequiredMoneyText:SetFont(QTR_Font2, 13);
  QuestInfoSpellLearnText:SetText(QTR_Messages.learnspell);
  QuestInfoSpellLearnText:SetFont(QTR_Font2, 13);
  QuestProgressText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Progress"]));
  QuestProgressText:SetFont(QTR_Font2, 13);
  QuestProgressRequiredMoneyText:SetText(QTR_Messages.reqmoney);
  QuestProgressRequiredMoneyText:SetFont(QTR_Font2, 13);
  QuestProgressRequiredItemsText:SetText(QTR_Messages.reqitems);
  QuestProgressRequiredItemsText:SetFont(QTR_Font1, 18);
end


function QTR_ChangeText_OnQuestLog(qid)
  if (QTR_PS["transtitle"]=="1") then
     QuestInfoTitleHeader:SetText(QTR_ExpandUnitInfo(QTR_QuestData[qid]["Title"]));
     QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
  end
  QuestInfoDescriptionHeader:SetText(QTR_Messages.details);
  QuestInfoDescriptionHeader:SetFont(QTR_Font1, 18);
  QuestInfoDescriptionText:SetText(QTR_description);
  QuestInfoDescriptionText:SetFont(QTR_Font2, 13);
  QuestInfoObjectivesHeader:SetText(QTR_Messages.objectives);
  QuestInfoObjectivesHeader:SetFont(QTR_Font1, 18);
  QuestInfoObjectivesText:SetText(QTR_objectives);
  QuestInfoObjectivesText:SetFont(QTR_Font2, 13);
  QuestInfoRewardsHeader:SetText(QTR_Messages.rewards);
  QuestInfoRewardsHeader:SetFont(QTR_Font1, 18);
  --QuestInfoRewardText:SetText(QTR_ExpandUnitInfo(QTR_QuestData[qid]["Completion"]));
  --QuestInfoRewardText:SetFont(QTR_Font2, 13);
  QuestInfoItemChooseText:SetText(QTR_Messages.itemchoose1);
  QuestInfoItemChooseText:SetFont(QTR_Font2, 13);
  QuestInfoItemReceiveText:SetText(QTR_Messages.itemreceiv1);
  QuestInfoItemReceiveText:SetFont(QTR_Font2, 13);
  QuestInfoXPFrameReceiveText:SetText(QTR_Messages.experience);
  QuestInfoXPFrameReceiveText:SetFont(QTR_Font2, 13);
  QuestInfoRequiredMoneyText:SetText(QTR_Messages.reqmoney);
  QuestInfoRequiredMoneyText:SetFont(QTR_Font2, 13);
  QuestInfoSpellLearnText:SetText(QTR_Messages.learnspell);
  QuestInfoSpellLearnText:SetFont(QTR_Font2, 13);
end


function QTR_ToggleVisibility()
  -- click on QTR button in QuestLogFrame
  if (QTR_PS["active"]=="0") then
     QTR_PS["active"] = "1";
     QTR_ShowAndUpdateQuestInfo();
     print("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isactive);
  else
     QTR_PS["active"] = "0";
     QTR_HideQuestInfo();
     print("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isinactive);
  end
end


function QTR_ShowAndUpdateQuestInfo()
  if (QTR_PS["active"]=="0") then
     return;
  end
  QTRFrame1:Show();
  QTR_UpdateQuestInfo();
end


function QTR_HideQuestInfo()
  QTRFrame1:Hide();
end


-- przekazuje nr ID z listy questów
function QTR_GetIDforTitle(qqq_title)
   qqq_ID = 0;
   if (QTR_QuestList[qqq_title]) then
      local qqq_lists=QTR_QuestList[qqq_title];
      qqq_i=string.find(qqq_lists, ",");
      if ( string.find(qqq_lists, ",")==nil ) then
         -- only 1 questID to this title
         qqq_ID=tonumber(qqq_lists);
      else
         -- multiple questIDs - get first, available (not completed) questID from QuestLists
         local QTR_table=QTR_split(qqq_lists, ",");
         local QTR_multiple = "";
         local QTR_Center="";
         for ii,vv in ipairs(QTR_table) do
            if (not QTR_PC[vv]) then
               if (QTR_Center=="") then
                  QTR_Center=vv;
               else
                  QTR_multiple = QTR_multiple .. ", " .. vv;
               end
            end
         end
         if ( string.len(QTR_Center)>0 ) then
            qqq_ID=tonumber(QTR_Center);
            if ( string.len(QTR_multiple)>0 ) then
               QTR_multiple = " (" .. string.sub(QTR_multiple, 3) .. ")";
               QTR_QuestWarning2:SetText(QTR_Messages.multipleID .. QTR_multiple);
            end
         end
      end
      if (qqq_ID==nil) then
         qqq_ID = 0;
      end
   end
   return qqq_ID;
end


-- uaktualnia tłumaczenie questu w okienku
function QTR_UpdateQuestInfo()
  if (QTR_PS["active"]=="0") then
     return;
  end
  local questSelected = GetQuestLogSelection();
  if (GetQuestLogTitle(questSelected) == nil) then
     return;
  end

  local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, questID = GetQuestLogTitle(questSelected);
  if (isHeader) then
     return;
  end
  questID = QTR_GetIDforTitle(questTitle);
  local qid = tostring(questID);
  QTR_QuestID:SetText("Quest ID: " .. qid);
  if (QTR_QuestData[qid]) then
     QTR_objectives  = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Objectives"]);
     QTR_description = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Description"]);
     QTR_descripFull = QTR_Messages.details .. "\n" .. QTR_description;
     QTR_translator = "";
     if (QTR_QuestData[qid]["Translator"]) then
        if (QTR_QuestData[qid]["Translator"]>"") then
            QTR_translator = "\n\n" .. QTR_Messages.translator .. " " .. QTR_ExpandUnitInfo(QTR_QuestData[qid]["Translator"]);
        end
     end
     QTR_QuestTitle:SetText(QTR_ExpandUnitInfo(QTR_QuestData[qid]["Title"]));
     QTR_QuestDetail:SetText(QTR_objectives .. "\n\n" .. QTR_descripFull .. QTR_translator);
     if (QTR_PS["mode"]=="1") then		       -- translation direct into original QuestLog frame
        QTR_ChangeText_OnQuestLog(qid);
     end
  else
     QTR_QuestTitle:SetText(questTitle);
     QTR_QuestDetail:SetText(QTR_Messages.missing);
  end 
end


function print(msg)
   if (DEFAULT_CHAT_FRAME) then
      DEFAULT_CHAT_FRAME:AddMessage(msg);
   else
      UIErrorsFrame:AddMessage(msg, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
   end
end


function QTR_ExpandUnitInfo(msg)
   msg = string.gsub(msg, "NEW_LINE", "\n");
   msg = string.gsub(msg, "YOUR_NAME0", string.upper(QTR_name));
   msg = string.gsub(msg, "YOUR_NAME1", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME2", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME3", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME4", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME5", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME6", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME7", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME", QTR_name);
   
-- jeszcze obsłużyć YOUR_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end

-- jeszcze obsłużyć NPC_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local NPC_sex = UnitSex("npc");     -- 1:neutral,  2:męski,  3:żeński
   local nr_poz = string.find(msg, "NPC_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (NPC_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "NPC_GENDER");
   end

-- jeszcze obsłużyć OWN_NAME(EN;PL)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "OWN_NAME");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
--               if (QTR_PS["ownname"] == "1") then        -- forma polska
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               else                                      -- forma angielska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
--               end
--               if ((QTR_PS["ownname_obj"] == "1") and OnObjectives) then        -- zawsze forma angielska w Objectives
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "OWN_NAME");
   end

   if (QTR_sex==3) then        -- płeć żeńska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D2);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C2);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B2);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N2);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K2);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W2);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M2);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D2);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C2);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B2);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K2);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W2);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M2);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ą YOUR_RACE", "ą "..player_race.N2);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N2);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W2);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ą YOUR_CLASS", "ą "..player_class.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N2);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M2);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M2.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M2);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B2);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B2);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B2.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B2);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W2);                      -- Wołacz - pozostałe wystąpienia
   else                    -- płeć męska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D1);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C1);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B1);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N1);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K1);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W1);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M1);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D1);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C1);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B1);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K1);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W1);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M1);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ym YOUR_RACE", "ym "..player_race.N1);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N1);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W1);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ym YOUR_CLASS", "ym "..player_class.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N1);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M1);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M1.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M1);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B1);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B1);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "ego YOUR_CLASS", "ego "..player_class.B1);                -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B1.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B1);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W1);                      -- Wołacz - pozostałe wystąpienia
   end

  return msg;
end
