﻿-- Addon: WoWpoPolsku-Quests (version: 11200.06) for Vanilla Wow (classic 1.12.1) 2022.10.14
-- Opis: AddOn wyświetla przetłumaczone questy podczas rozmowy z NPC.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- Addon project: https://wowpopolsku.pl


-- Global Variables
local QTR_version = "11200.02";
local QTR_name = UnitName("player");
local QTR_class= UnitClass("player");
local QTR_race = UnitRace("player");
local QTR_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local QTR_event="";
local QTR_MessOrig = {
      details    = "Description", 
      objectives = "Objectives", 
      rewards    = "Rewards", 
      itemchoose1= "You will be able to choose one of these rewards:", 
      itemchoose2= "Choose one of these rewards:", 
      itemreceiv1= "You will also receive:", 
      itemreceiv2= "You receiving the reward:", 
      learnspell = "Learn Spell:", 
      reqmoney   = "Required Money:", 
      reqitems   = "Required items:", 
      experience = "Experience:", 
      currquests = "Current Quests", 
      avaiquests = "Available Quests", };
local Original_Font1 = "Fonts\\MORPHEUS.ttf";
local Original_Font2 = "Fonts\\FRIZQT__.ttf";
if not QTR then
   QTR = { };
end
local p_race = {
      ["Dwarf"] = { M = "Krasnolud", W = "krasnoludzie", B = "krasnoluda", N = "krasnoludem" },
      ["Gnome"] = { M = "Gnom", W = "gnomie", B = "gnoma", N = "gnomem" },
      ["Human"] = { M = "Człowiek", W = "człowieku", B = "człowieka", N = "człowiekiem" },
      ["Night Elf"] = { M = "Nocny Elf", W = "nocny elfie", B = "nocnego elfa", N = "nocnym elfem" },
      ["Orc"] = { M = "Ork", W = "orku", B = "orka", N = "orkiem" },
      ["Tauren"] = { M = "Tauren", W = "taurenie", B = "taurena", N = "taurenem" },
      ["Troll"] = { M = "Troll", W = "trollu", B = "trolla", N = "trollem" },
      ["Undead"] = { M = "Nieumarły", W = "nieumarły", B = "nieumarłego", N = "nieumarłym" }, }
local p_class = {
      ["Druid"] = { M = "Driud", W = "druidzie", B = "druida", N = "druidem" },
      ["Hunter"] = { M = "Łowca", W = "łowco", B = "łowcę", N = "łowcą" },
      ["Mage"] = { M = "Czarodziej", W = "czarodzieju", B = "czarodzieja", N = "czarodziejem" },
      ["Paladin"] = { M = "Paladyn", W = "paladynie", B = "paladyna", N = "paladynem" },
      ["Priest"] = { M = "Kapłan", W = "kapłanie", B = "kapłana", N = "kapłanem" },
      ["Rogue"] = { M = "Łotrzyk", W = "łotrzyku", B = "łotrzyka", N = "łotrzykiem" },
      ["Shaman"] = { M = "Szaman", W = "szamanie", B = "szamana", N = "szamanem" },
      ["Warlock"] = { M = "Czarnoksiężnik", W = "czarnoksiężniku", B = "czarnoksiężnika", N = "czarnoksiężnikiem" },
      ["Warrior"] = { M = "Wojownik", W = "wojowniku", B = "wojownika", N = "wojownikiem" }, }
if (p_race[QTR_race]) then      
   player_race = { M = p_race[QTR_race].M, W = p_race[QTR_race].W, B = p_race[QTR_race].B, N = p_race[QTR_race].N };
else   
   player_race = { M = QTR_race, W = QTR_race, B = QTR_race, N = QTR_race };
   DEFAULT_CHAT_FRAME:AddMessage("|cff55ff00QTR - nowa rasa: "..QTR_race);
end
if (p_class[QTR_class]) then
   player_class = { M = p_class[QTR_class].M, W = p_class[QTR_class].W, B = p_class[QTR_class].B, N = p_class[QTR_class].N };
else
   player_class = { M = QTR_class, W = QTR_class, B = QTR_class, N = QTR_class };
   DEFAULT_CHAT_FRAME:AddMessage("|cff55ff00QTR - nowa klasa: "..QTR_class);
end



function Spr_Gender(msg)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do   -- szykaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end
   return msg;
end


function print(text)
   if (DEFAULT_CHAT_FRAME) then
      DEFAULT_CHAT_FRAME:AddMessage(text);
   else
      UIErrorsFrame:AddMessage(text, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
   end
end


-- Obsługa komend slash
function QTR_SlashCommand(msg)
   if (msg=="on" or msg=="ON") then
      if (QTR_PS["active"]=="1") then
         print ("QTR - tłumaczenia są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenia.");
         QTR_PS["active"] = "1";
      end
   elseif (msg=="off" or msg=="OFF") then
      if (QTR_PS["active"]=="0") then
         print ("QTR - tłumaczenia są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia.");
         QTR_PS["active"] = "0";
      end
   elseif (msg=="title on" or msg=="TITLE ON") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenia tytułów są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenia tytułów.");
         QTR_PS["transtitle"] = "1";
      end
   elseif (msg=="title off" or msg=="TITLE OFF") then
      if (QTR_PS["transtilte"]=="0") then
         print ("QTR - tłumaczenia tytułów są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia tytułów.");
         QTR_PS["transtitle"] = "0";
      end
   else
      print ("QTR - menu szybkich komend addonu:");
      print ("      /qtr on  - włącza tłumaczenia");
      print ("      /qtr off - wyłącza tłumaczenia");
      print ("      /qtr title on  - włącza tłumaczenie tytułu");
      print ("      /qtr title off - wyłącza tłumaczenie tytułu");
   end
end



function QTR_CheckVars()
  if (not QTR_PS) then
     QTR_PS = {};
  end
  if (not QTR_PC) then
     QTR_PC = {};
  end
  if (not QTR_SAVED) then
     QTR_SAVED = {};
  end
  -- initialize check options
  if (not QTR_PS["active"]) then
     QTR_PS["active"] = "1";   
  end
  if (not QTR_PS["mode"] ) then
     QTR_PS["mode"] = "2";   
  end
  if (not QTR_PS["transtitle"] ) then
     QTR_PS["transtitle"] = "0";   
  end
  if (not QTR_PS["size"] ) then
     QTR_PS["size"] = "1";   
  end
  if (not QTR_PS["width"] ) then
     QTR_PS["width"] = "1";   
  end

  -- set check buttons 
  if (QTR_PS["size"] == "1") then
     QTR_SizeH = 1;
  else 
     QTR_SizeH = 2;     
     QTRFrame1:SetHeight(525);
     QTR_QuestDetail:SetHeight(430);
     QTR_ToggleButton2:SetText("^");
  end
  if (QTR_PS["width"] == "1") then
     QTR_SizeW = 1;
  else 
     QTR_SizeW = 2;     
     QTRFrame1:SetWidth(525);
     QTR_QuestDetail:SetWidth(495);
     QTR_QuestTitle:SetWidth(495);
     QTR_ToggleButton3:SetText("<");
  end
  if ( QTR_PS["isGetQuestID"] ) then
     isGetQuestID=QTR_PS["isGetQuestID"];
  end;
end


function QTR_SetCheckButtonState()
  QTRCheckButton0:SetChecked(QTR_PS["active"]=="1");
  QTRCheckButton1:SetChecked(QTR_PS["mode"]=="1");
  QTRCheckButton2:SetChecked(QTR_PS["mode"]=="2");
  QTRCheckButton3:SetChecked(QTR_PS["transtitle"]=="1");
  QTRCheckButton4:SetChecked(QTR_PS["size"]=="1");
  QTRCheckButton5:SetChecked(QTR_PS["size"]=="2");
  QTRCheckButton6:SetChecked(QTR_PS["width"]=="1");
  QTRCheckButton7:SetChecked(QTR_PS["width"]=="2");
end


function QTR_OnLoad1()
  QTR.frame1 = CreateFrame("Frame");
  QTR.frame1:RegisterEvent("ADDON_LOADED");
  QTR.frame1:RegisterEvent("QUEST_LOG_UPDATE");
  QTR.frame1:SetScript("OnEvent", QTR_OnEvent1);
  QuestLogDetailScrollFrame:SetScript("OnShow", QTR_ShowAndUpdateQuestInfo);
  QuestLogDetailScrollFrame:SetScript("OnHide", QTR_HideQuestInfo);

  QTR_QuestTitle:SetFont(QTR_Font2, 17);
  QTR_QuestDetail:SetFont(QTR_Font2, 14);
  QTRFrame1:ClearAllPoints();
  QTRFrame1:SetPoint("TOPLEFT", QuestLogFrame, "TOPRIGHT", -3, -12);

  -- small button in QuestLogFrame
  QTR_ToggleButton1 = CreateFrame("Button",nil, QuestLogFrame, "UIPanelButtonTemplate");
  QTR_ToggleButton1:SetWidth(35);
  QTR_ToggleButton1:SetHeight(18);
  QTR_ToggleButton1:SetText("QTR");
  QTR_ToggleButton1:Show();
  QTR_ToggleButton1:ClearAllPoints();
  QTR_ToggleButton1:SetPoint("TOPLEFT", QuestLogFrame, "TOPRIGHT", -100, -15);
  QTR_ToggleButton1:SetScript("OnClick", QTR_ToggleVisibility);

  -- button for ChangeFrameHeight
  QTR_ToggleButton2 = CreateFrame("Button",nil, QTRFrame1, "UIPanelButtonTemplate");
  QTR_ToggleButton2:SetWidth(15);
  QTR_ToggleButton2:SetHeight(22);
  QTR_ToggleButton2:SetText("v");
  QTR_ToggleButton2:Show();
  QTR_ToggleButton2:ClearAllPoints();
  QTR_ToggleButton2:SetPoint("BOTTOMLEFT", QTRFrame1, "BOTTOMRIGHT", -40, 9);
  QTR_ToggleButton2:SetScript("OnClick", QTR_ChangeFrameHeight);

  -- button for ChangeFrameWidth
  QTR_ToggleButton3 = CreateFrame("Button",nil, QTRFrame1, "UIPanelButtonTemplate");
  QTR_ToggleButton3:SetWidth(15);
  QTR_ToggleButton3:SetHeight(22);
  QTR_ToggleButton3:SetText(">");
  QTR_ToggleButton3:Show();
  QTR_ToggleButton3:ClearAllPoints();
  QTR_ToggleButton3:SetPoint("BOTTOMLEFT", QTRFrame1, "BOTTOMRIGHT", -25, 9);
  QTR_ToggleButton3:SetScript("OnClick", QTR_ChangeFrameWidth);

  if hooksecurefunc then
     hooksecurefunc("QuestLogTitleButton_OnClick", function() QTR_UpdateQuestInfo() end);
  else
     local QTR_QuestLogTitleButton_OnClik = QuestLogTitleButton_OnClick;
     function QuestLogTitleButton_OnClick(button)
        QTR_UpdateQuestInfo();
        QTR_QuestLogTitleButton_OnClik(button);
     end
  end
end


function QTR_OnEvent1()

  if (event == "ADDON_LOADED") then
     SlashCmdList["WOWPOPOLSKU_QUESTS"] = function(msg) QTR_SlashCommand(msg); end
     SLASH_WOWPOPOLSKU_QUESTS1 = "/wowpopolsku-quests";
     SLASH_WOWPOPOLSKU_QUESTS2 = "/qtr";
     QTR_CheckVars();
     --QTR_BlizzardOptions();
     if (DEFAULT_CHAT_FRAME) then
         DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Quests ver. "..QTR_version.." - " .. QTR_Messages.loaded);
     else
         UIErrorsFrame:AddMessage("|cffffff00WoWpoPolsku-Quests ver. "..QTR_version.." - " .. QTR_Messages.loaded, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
     end
     QTR.frame1:UnregisterEvent("ADDON_LOADED");
     QTR_Messages.itemchoose1 = Spr_Gender(QTR_Messages.itemchoose1);
     if (not isGetQuestID) then
        DetectEmuServer();
     end;
  end

  if (event == "QUEST_LOG_UPDATE") then
     if (QTRFrame1:IsVisible()) then
        QTR_UpdateQuestInfo();
     end
  end

end
  

function QTR_OnLoad2()
  QTR.frame2 = CreateFrame("Frame");
  QTR.frame2:RegisterEvent("QUEST_GREETING");
  QTR.frame2:RegisterEvent("QUEST_DETAIL");
  QTR.frame2:RegisterEvent("QUEST_PROGRESS");
  QTR.frame2:RegisterEvent("QUEST_COMPLETE");
  QTR.frame2:SetScript("OnEvent", QTR_OnEvent3);
  QTR_QuestTitle2:SetFont(QTR_Font2, 17);
  QTR_QuestDetail2:SetFont(QTR_Font2, 14);
  QTR_QuestWarning2:SetFont(QTR_Font2, 12);
  QTRFrame2:ClearAllPoints();
  QTRFrame2:SetPoint("TOPLEFT", QuestFrame, "TOPRIGHT", -31, -19);
  QuestFrame:SetScript("OnHide", QTR_Frame2Close);
end


function DetectEmuServer()
  QTR_PS["isGetQuestID"]="0";
  isGetQuestID="0";
end


function QTR_OnEvent3()

  if (event == "QUEST_GREETING") then
    if (QTR_PS["active"]=="1" and QTR_PS["mode"]=="1") then
      CurrentQuestsText:SetText(QTR_Messages.currquests);
      CurrentQuestsText:SetFont(QTR_Font1, 18);
      AvailableQuestsText:SetText(QTR_Messages.avaiquests);
      AvailableQuestsText:SetFont(QTR_Font1, 18);
    else
      CurrentQuestsText:SetText(QTR_MessOrig.currquests);
      CurrentQuestsText:SetFont(Original_Font1, 18);
      AvailableQuestsText:SetText(QTR_MessOrig.avaiquests);
      AvailableQuestsText:SetFont(Original_Font1, 18);
    end
  end

  if (event == "QUEST_DETAIL") then
     QTR_event = "QUEST_DETAIL";
     QTR_OnEvent2();
  end

  if (event == "QUEST_PROGRESS") then
     QTR_event = "QUEST_PROGRESS";
     QTR_OnEvent2();
  end

  if (event == "QUEST_COMPLETE") then
     QTR_event = "QUEST_COMPLETE";
     QTR_OnEvent2();
  end
  
end


function QTR_SearchIDforName(qqq_title)
    qqq_ID = 0;
    if (QTR_QuestList[qqq_title]) then
        local qqq_lists=QTR_QuestList[qqq_title];
        qqq_i=string.find(qqq_lists, ",");
        if ( string.find(qqq_lists, ",")==nil ) then
            -- only 1 questID to this title
            qqq_ID=tonumber(qqq_lists);
        else
            -- multiple questIDs - get first, available (not completed) questID from QuestLists
            local QTR_table=QTR_split(qqq_lists, ",");
            local QTR_multiple = "";
            local QTR_Center="";
            for ii,vv in ipairs(QTR_table) do
                if (not QTR_PC[vv]) then
                    if (QTR_Center=="") then
                        QTR_Center=vv;
                    else
                        QTR_multiple = QTR_multiple .. ", " .. vv;
                    end
                end
            end
            if ( string.len(QTR_Center)>0 ) then
                qqq_ID=tonumber(QTR_Center);
                if ( string.len(QTR_multiple)>0 ) then
                    QTR_multiple = " (" .. string.sub(QTR_multiple, 3) .. ")";
                    QTR_QuestWarning2:SetText(QTR_Messages.multipleID .. QTR_multiple);
                end
            end
        end
    end
return qqq_ID;
end


function QTR_OnEvent2()
  local q_ID = 0;
  local q_title = GetTitleText();
  
  if ( QTR_PS["active"]=="1" )then
     QTR_QuestID2:SetText("");
     QTR_QuestTitle2:SetText(q_title);
     QTR_QuestDetail2:SetText(QTR_Messages.missing);
     QTR_QuestWarning2:SetText("");
     
     if ( q_ID == 0 ) then
        if ( isGetQuestID=="1" ) then
           q_ID = GetQuestID();
        end
        if ( q_ID == 0 ) then
		   q_ID = QTR_SearchIDforName(q_title);
        end
     end
     if ( q_ID > 0 ) then
        local str_id = tostring(q_ID);
        QTR_QuestID2:SetText("QuestID: " .. str_id);
        QTR_QuestTitle2:SetText(q_title);
        if (QTR_QuestData[str_id]) then
           -- display only, if translation exists
	   if (QTR_PS["mode"]=="2") then
              QTR_ShowFrame2(QTR_event, str_id);
           end
        else
           -- DEFAULT_CHAT_FRAME:AddMessage("WoWpoPolsku-Quests - Qid: "..tostring(q_ID).." ("..QTR_Messages.missing..")");
           QTR_SAVED[str_id.." TITLE"]=GetTitleText();               -- save original title to future translation
           if (QTR_event=="QUEST_DETAIL") then
              QTR_SAVED[str_id.." DESCRIPTION"]=GetQuestText();      -- save original text to future translation
              QTR_SAVED[str_id.." OBJECTIVE"]=GetObjectiveText();    -- save original text to future translation
           end
           if (QTR_event=="QUEST_PROGRESS") then
              QTR_SAVED[str_id.." PROGRESS"]=GetProgressText();      -- save original text to future translation
           end
           if (QTR_event=="QUEST_COMPLETE") then
              QTR_SAVED[str_id.." COMPLETE"]=GetRewardText();        -- save original text to future translation
           end
           QTRFrame2:Hide();
        end
     end
  end
  if (QTR_event == "QUEST_COMPLETE") then
     if ( q_ID > 0) then
        local str_id = tostring(q_ID);
        QTR_PC[str_id]="OK";
     end
  end
end


function QTR_ShowFrame2(eventStr, qid)
  QTR_QuestID2:SetText("QuestID: " .. qid);
  QTR_QuestDetail2:SetText(QTR_Messages.missing);
  if (QTR_QuestData[qid]) then
     QTR_QuestTitle2:SetText(QTR_ExpandUnitInfo(QTR_QuestData[qid]["Title"]));
     local QTR_text = "";
     if (eventStr == "QUEST_DETAIL") then
        if (QTR_QuestData[qid]["Description"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Description"]);
        end
        local QTR_text2 = "";
        if (QTR_QuestData[qid]["Objectives"]) then
           QTR_text2 = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Objectives"]);
        end
        QTR_text = QTR_text .. "\n\n" .. QTR_Messages.objectives .. "\n" .. QTR_text2;
     end
     if (eventStr == "QUEST_PROGRESS") then
        if (QTR_QuestData[qid]["Progress"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Progress"]);
        end
     end
     if (eventStr == "QUEST_COMPLETE") then
        if (QTR_QuestData[qid]["Completion"]) then
           QTR_text = QTR_ExpandUnitInfo(QTR_QuestData[qid]["Completion"]);
        end
     end
     QTR_QuestDetail2:SetText(QTR_text);
     QTRFrame2:ClearAllPoints();
     QTRFrame2:SetPoint("TOPLEFT", QuestFrame, "TOPRIGHT", -31, -19);
     if ( QuestNPCModel ) then
        if ( QuestNPCModel:IsVisible() ) then
           QTRFrame2:SetPoint("TOPLEFT", QuestNPCModel, "TOPRIGHT", 0, 42);
        end
     end
     QTRFrame2:Show();
  end
end


function QTR_Frame2Close()
  QTRFrame2:Hide();
  QuestFrame_OnHide();
end


function QTR_split(str, c)
  local aCount = 0;
  local array = {};
  local a = string.find(str, c);
  while a do
     aCount = aCount + 1;
     array[aCount] = string.sub(str, 1, a-1);
     str=string.sub(str, a+1);
     a = string.find(str, c);
  end
  aCount = aCount + 1;
  array[aCount] = str;
  return array;
end


function QTR_findlast(source, char)
  if (not source) then
     return 0;
  end
  local lastpos = 0;
  local byte_char = string.byte(char);
  for i=1, table.getn(source) do
     if (string.byte(source,i)==byte_char) then
        lastpos = i;
     end
  end
  return lastpos;
end


function QTR_ChangeFrameHeight()
  -- normal height of Frame = 450, quest detail = 350
  if (QTR_SizeH == 1) then
     QTRFrame1:SetHeight(525);
     QTR_QuestDetail:SetHeight(430);
     QTR_ToggleButton2:SetText("^");
     QTR_SizeH = 2;
     QTR_PS["size"] = "2";
  else
     QTRFrame1:SetHeight(450);
     QTR_QuestDetail:SetHeight(350);
     QTR_ToggleButton2:SetText("v");
     QTR_SizeH = 1;
     QTR_PS["size"] = "1";
  end
end


function QTR_ChangeFrameWidth()
  -- normal width of Frame = 350, quest detail = 320
  if (QTR_SizeW == 1) then
     QTRFrame1:SetWidth(525);
     QTR_QuestDetail:SetWidth(495);
     QTR_QuestTitle:SetWidth(495);
     QTR_ToggleButton3:SetText("<");
     QTR_SizeW = 2;
     QTR_PS["width"] = "2";
  else
     QTRFrame1:SetWidth(350);
     QTR_QuestDetail:SetWidth(320);
     QTR_QuestTitle:SetWidth(320);
     QTR_ToggleButton3:SetText(">");
     QTR_SizeW = 1;
     QTR_PS["width"] = "1";
  end
end


function QTR_OnMouseDown1()
  -- start moving the window
  QTRFrame1:StartMoving();
end
  

function QTR_OnMouseUp1()
  -- stop moving the window
  QTRFrame1:StopMovingOrSizing();
end


function QTR_OnMouseDown2()
  -- start moving the window
  QTRFrame2:StartMoving();
end
  

function QTR_OnMouseUp2()
  -- stop moving the window
  QTRFrame2:StopMovingOrSizing();
end


function QTR_ToggleVisibility()
  -- click on QTR button in QuestLogFrame
  if (QTR_PS["active"]=="0") then
     QTR_PS["active"] = "1";
     QTR_ShowAndUpdateQuestInfo();
     if (DEFAULT_CHAT_FRAME) then
         DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isactive);
     else
         UIErrorsFrame:AddMessage("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isactive, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
     end
  else
     QTR_PS["active"] = "0";
     QTR_HideQuestInfo();
     if (DEFAULT_CHAT_FRAME) then
         DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isinactive);
     else
         UIErrorsFrame:AddMessage("|cffffff00WoWpoPolsku-Quests "..QTR_Messages.isinactive, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
     end
     
  end
end


function QTR_ShowAndUpdateQuestInfo()
  if (QTR_PS["active"]=="0") then
     return;
  end
  if (QTR_PS["mode"]=="2") then
     QTRFrame1:Show();
  end;
  QTR_UpdateQuestInfo();
end


function QTR_HideQuestInfo()
  QTRFrame1:Hide();
end


function QTR_UpdateQuestInfo()
  if (QTR_PS["active"]=="0") then
     return;
  end
  local questSelected = GetQuestLogSelection();
  if (GetQuestLogTitle(questSelected) == nil) then
     return;
  end
  local questTitle = GetQuestLogTitle(questSelected);
  if (isHeader) then
     return;
  end

  local qid = QTR_SearchIDforName(questTitle);
  local str_id = tostring(qid);
  QTR_QuestID:SetText("QuestID: " .. str_id);

  if (QTR_QuestData[str_id]) then
     QTR_objectives  = QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Objectives"]);
     QTR_description = QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Description"]);
     QTR_descripFull = QTR_Messages.details .. "\n" .. QTR_description;
     QTR_translator = "";
     if (QTR_QuestData[str_id]["Translator"]) then
        if (QTR_QuestData[str_id]["Translator"]>"") then
            QTR_translator = "\n\n" .. QTR_Messages.translator .. " " .. QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Translator"]);
        end
     end
     QTR_QuestTitle:SetText(QTR_ExpandUnitInfo(QTR_QuestData[str_id]["Title"]));
     QTR_QuestDetail:SetText(QTR_objectives .. "\n\n" .. QTR_descripFull .. QTR_translator);
  else
     QTR_QuestTitle:SetText(questTitle);
     QTR_QuestDetail:SetText(QTR_Messages.missing);
  end 
end


function QTR_ExpandUnitInfo(msg)
  -- replace special characters into message
  msg = string.gsub(msg, "NEW_LINE", "\n");
  msg = string.gsub(msg, "YOUR_NAME0", string.upper(QTR_name));
  msg = string.gsub(msg, "YOUR_NAME1", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME2", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME3", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME4", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME5", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME6", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME7", QTR_name);
  msg = string.gsub(msg, "YOUR_NAME", QTR_name);
  
  msg = string.gsub(msg, "YOUR_CLASS1", player_class.M);          -- Mianownik (kto, co?)
  msg = string.gsub(msg, "YOUR_CLASS2", player_class.B);          -- Biernik (kogo, co?)
  msg = string.gsub(msg, "YOUR_CLASS3", player_class.N);          -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, "YOUR_CLASS4", player_class.W);          -- Wołacz (o!)
  msg = string.gsub(msg, "YOUR_RACE1", player_race.M);            -- Mianownik (kto, co?)
  msg = string.gsub(msg, "YOUR_RACE2", player_race.B);            -- Biernik (kogo, co?)
  msg = string.gsub(msg, "YOUR_RACE3", player_race.N);            -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, "YOUR_RACE4", player_race.W);            -- Wołacz (o!)
   
-- jeszcze obsłużyć YOUR_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end

-- jeszcze obsłużyć NPC_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local NPC_sex = UnitSex("npc");     -- 1:neutral,  2:męski,  3:żeński
   local nr_poz = string.find(msg, "NPC_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (NPC_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "NPC_GENDER");
   end

-- jeszcze obsłużyć OWN_NAME(EN;PL)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "OWN_NAME");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
--               if (QTR_PS["ownname"] == "1") then        -- forma polska
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               else                                      -- forma angielska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
--               end
--               if ((QTR_PS["ownname_obj"] == "1") and OnObjectives) then        -- zawsze forma angielska w Objectives
--                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
--               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "OWN_NAME");
   end

  msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M);     -- Mianownik (kto, co?)
  msg = string.gsub(msg, "ym YOUR_RACE", "ym "..player_race.N);              -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N);    -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, "YOUR_RACE", player_race.W);                        -- Wołacz - pozostałe wystąpienia
   
  msg = string.gsub(msg, "ym YOUR_CLASS", "ym "..player_class.N);            -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N);      -- Narzędnik (kim, czym?)
  msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M);    -- Mianownik (kto, co?)
  msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M.." do ");   -- Mianownik (kto, co?)
  msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M);      -- Mianownik (kto, co?)
  msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M);          -- Mianownik (kto, co?)
  msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B);     -- Biernik (kogo, co?)
  msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B);  -- Biernik (kogo, co?)
  msg = string.gsub(msg, "ego YOUR_CLASS", "ego "..player_class.B);                -- Biernik (kogo, co?)
  msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B.." taki jak ");    -- Biernik (kogo, co?)
  msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B);        -- Biernik (kogo, co?)
  msg = string.gsub(msg, "YOUR_CLASS", player_class.W);                      -- Wołacz - pozostałe wystąpienia
  
  return msg;
end

