﻿-- Addon: WoWpoPolsku-BB (version: 10.04) 2022.07.22
-- Description: AddOn displays translated Bubbles of NPC.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- WWW: https://wowpopolsku.pl

-------------------------------------------------------------------------------------------------------

local BB_version = GetAddOnMetadata("WoWpoPolsku_Bubbles", "Version");
local BB_ctrFrame = CreateFrame("FRAME", "WoWpoPolsku-BubblesFrame");
local BB_Font = "Interface\\AddOns\\WoWpoPolsku_Bubbles\\Fonts\\frizquadratatt_pl.ttf";
local BB_class= UnitClass("player");
local BB_race = UnitRace("player");
local BB_BubblesArray = {};
local p_race = {};
local p_class = {};
local player_race = {};
local player_class = {};
local player_name = UnitName("player");
local player_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local BB_TRvisible= 0;
local BB_Zatrzask = 0;
local BB_name_NPC = "";
local BB_hash_Code= "";
local BB_bufor = {};
local BB_gotowe= {};
local BB_ile_got = 0;
local BB_first = 1;
local Y_Race1=UnitRace("player");
local Y_Race2=string.lower(UnitRace("player"));
local Y_Race3=string.upper(UnitRace("player"));
local Y_Class1=UnitClass("player");
local Y_Class2=string.lower(UnitClass("player"));
local Y_Class3=string.upper(UnitClass("player"));
local time_ver = GetTime() - 15*60;
local Players_ver = {};           -- wersje dodatku innych graczy
local Players_ver_Count = 0;
local Version_max = {ADDON_VER=string.sub(BB_version,1,2)..string.sub(BB_version,-2), 
                     ALERT_ID=0,                                ADDON_COUNT=0,  ADDON_ALERT=0,
                     BASE_VER=BB_base,    BASE_DATE=BB_date,    BASE_COUNT=0,   BASE_ALERT=0 };
local BB_waitTable = {};
local BB_waitFrame = nil;


local function StringHash(text)           -- funkcja tworząca Hash (32-bitowa liczba) podanego tekstu
  local counter = 1;
  local pomoc = 0;
  local dlug = string.len(text);
  for i = 1, dlug, 3 do 
    counter = math.fmod(counter*8161, 4294967279);  -- 2^32 - 17: Prime!
    pomoc = (string.byte(text,i)*16776193);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+1) or (dlug-i+256))*8372226);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+2) or (dlug-i+256))*3932164);
    counter = counter + pomoc;
  end
  return math.fmod(counter, 4294967291) -- 2^32 - 5: Prime (and different from the prime in the loop)
end


local function BB_bubblizeText()
   if (TalkingHeadFrame and TalkingHeadFrame:IsVisible()) then
      for idx, iArray in ipairs(BB_BubblesArray) do      -- sprawdź, czy dane są właściwe (tekst oryg. się zgadza z zapisaną w tablicy)
         if (TalkingHeadFrame.TextFrame.Text:GetText() ==  iArray[1]) then
            local _font1, _size1, _3 = TalkingHeadFrame.TextFrame.Text:GetFont(); -- odczytaj aktualną czcionkę i rozmiar
            TalkingHeadFrame.TextFrame.Text:SetFont(BB_Font, _size1);             -- wpisz polską czcionkę
            TalkingHeadFrame.TextFrame.Text:SetText(iArray[2]);                   -- wpisz polskie tłumaczenie
            tremove(BB_BubblesArray, idx);               -- usuń zapamiętane dane z tablicy
         end
      end
   else
      for _, bubble in pairs(C_ChatBubbles.GetAllChatBubbles()) do
      -- Iterate the children, as the actual bubble content 
      -- has been placed in a nameless subframe in 9.0.1.
         for i = 1, bubble:GetNumChildren() do
            local child = select(i, select(i, bubble:GetChildren()))
            if not child:IsForbidden() then                       -- czy ramka nie jest zabroniona?
               if (child:GetObjectType() == "Frame") and (child.String) and (child.Center) then
               -- This is hopefully the frame with the content
                  for i = 1, child:GetNumRegions() do
                     local region = select(i, child:GetRegions());
                     for idx, iArray in ipairs(BB_BubblesArray) do      -- sprawdź, czy dane są właściwe (tekst oryg. się zgadza z zapisaną w tablicy)
                        if region and not region:GetName() and region:IsVisible() and region.GetText and (region:GetText() == iArray[1]) then
                           local oldTextWidth = region:GetStringWidth() -- dotychczasowa szerokość okna dymku
                           region:SetText(iArray[2]);                   -- wpisz tu nasze tłumaczenie
                           if (BB_PM["setsize"]=="1") then              -- jest włączona wielkość czcionki dymku
                              region:SetFont(BB_Font, tonumber(BB_PM["fontsize"]));   -- ustaw polską czcionkę oraz zmienioną wielkość
                           else
                              local _font1, _size1, _3 = region:GetFont(); -- odczytaj aktualną czcionkę i rozmiar
                              region:SetFont(BB_Font, _size1);             -- ustaw polską czcionkę oraz niezmienioną wielkość (13)
                           end
                           region:SetWidth(region:GetWidth()+(region:GetStringWidth() - oldTextWidth));  -- określ nową szer. okna
                           tremove(BB_BubblesArray, idx);               -- usuń zapamiętane dane z tablicy
                        end
                     end
                  end
               end
            end
         end
      end
   end

   for idx, iArray in ipairs(BB_BubblesArray) do            -- przeszukaj jeszcze raz tablicę
      if (iArray[3] >= 100) then                            -- licznik osiągnął 100
         tremove(BB_BubblesArray, idx);                     -- usuń zapamiętane dane z tablicy
      else
         iArray[3] = iArray[3]+1;                           -- zwiększ licznik (nie pokazał się dymek?)
      end;
   end;
   if (#(BB_BubblesArray) == 0) then
      BB_ctrFrame:SetScript("OnUpdate", nil);               -- wyłącz metodę Update, bo tablica pusta
   end;
end;


local function ChatFilter(self, event, arg1, arg2, arg3, _, arg5, ...)     -- wywoływana, gdy na chat ma pojawić się tekst od NPC
   local changeBubble = false;
   local colorText = "";
   local original_txt = strtrim(arg1);
   local name_NPC = string.gsub(arg2, " says:", "");
   local target = arg5;
	
   if (event == "CHAT_MSG_MONSTER_SAY") then          -- określ kolor tekstu do okna chat
      colorText = "|cFFFFFF9F";
      if (GetCVar("ChatBubbles")) then
         changeBubble = true;
      end
   elseif (event == "CHAT_MSG_MONSTER_PARTY") then
      colorText = "|cFFAAAAFF";
   elseif (event == "CHAT_MSG_MONSTER_YELL") then
      colorText = "|cFFFF4040";
      if (GetCVar("ChatBubbles")) then
         changeBubble = true;
      end
   elseif (event == "CHAT_MSG_MONSTER_WHISPER") then
      colorText = "|cFFFFB5EB";
   elseif (event == "CHAT_MSG_MONSTER_EMOTE") then
      colorText = "|cFFFF8040";
   end

   BB_is_translation = "0";      
   if (BB_PM["active"] == "1") then                       -- dodatek aktywny - szukaj tłumaczenia
      if (arg5 ~= "") then
         original_txt = string.gsub(original_txt, arg5, "");        -- usuń osobę ($target) z tekstu oryginalnego
      end
      original_txt = string.gsub(original_txt, Y_Race1, "");        -- usuń rasę z tekstu
      original_txt = string.gsub(original_txt, Y_Race2, "");
      original_txt = string.gsub(original_txt, Y_Race3, "");
      original_txt = string.gsub(original_txt, Y_Class1, "");       -- usuń klasę z tekstu
      original_txt = string.gsub(original_txt, Y_Class2, "");
      original_txt = string.gsub(original_txt, Y_Class3, "");
      if (string.sub(name_NPC,1,17) == "Bronze Timekeeper") then    -- wyścigi na smokach - wyjątej z sekundami
         original_txt = string.gsub(original_txt, "0", "");
         original_txt = string.gsub(original_txt, "1", "");
         original_txt = string.gsub(original_txt, "2", "");
         original_txt = string.gsub(original_txt, "3", "");
         original_txt = string.gsub(original_txt, "4", "");
         original_txt = string.gsub(original_txt, "5", "");
         original_txt = string.gsub(original_txt, "6", "");
         original_txt = string.gsub(original_txt, "7", "");
         original_txt = string.gsub(original_txt, "8", "");
         original_txt = string.gsub(original_txt, "9", "");
      end
      local HashCode = StringHash(original_txt);
      if (BB_Bubbles[HashCode]) then         -- jest tłumaczenie polskie
         newMessage = BB_Bubbles[HashCode];
         newMessage = BB_ZmienKody(newMessage,arg5);
         if (string.sub(name_NPC,1,17) == "Bronze Timekeeper") then       -- wyścigi na smokach - wyjątej z sekundami: $1.$2 oraz $3.$4
            local wartab = {0,0,0,0};                                     -- max. 4 liczby całkowite w tekście
            local arg0 = 0;
            for w in string.gmatch(strtrim(arg1), "%d+") do
               arg0 = arg0 + 1;
               wartab[arg0] = w;      -- tu mamy kolejne liczby całkowite z oryginału
            end;
            if (arg0>3) then
               newMessage=string.gsub(newMessage, "$4", wartab[4]);
            end
            if (arg0>2) then
               newMessage=string.gsub(newMessage, "$3", wartab[3]);
            end
            if (arg0>1) then
               newMessage=string.gsub(newMessage, "$2", wartab[2]);
            end
            if (arg0>0) then
               newMessage=string.gsub(newMessage, "$1", wartab[1]);
            end
         end
         BB_is_translation="1";      
         nr_poz=BB_FindProS(newMessage,1);
         if (BB_PM["chat-pl"] == "1") then                -- wyświetlaj tłumaczenie w linii czatu
            if (nr_poz>0) then           -- mamy formę opisową dymku %s np. NPC_name wpada w szał!
               if (nr_poz==1) then
                  newMessage = name_NPC..strsub(newMessage, 3);
               else
                  newMessage = strsub(newMessage,1,nr_poz-1)..name_NPC..strsub(newMessage, nr_poz+2);
               end
               DEFAULT_CHAT_FRAME:AddMessage(colorText..newMessage);
            elseif (strsub(newMessage,1,2)=="%o") then         -- jest forma '%o'
               newMessage = strsub(newMessage, 3);
               DEFAULT_CHAT_FRAME:AddMessage(colorText..newMessage:gsub("^%s*", "")); -- usuń białe spacje na początku
            else
               DEFAULT_CHAT_FRAME:AddMessage(colorText.."|cCCDDEEFF"..name_NPC.." mówi:|r "..newMessage);
            end
         else   
            if (nr_poz>0) then        -- mamy formę opisową dymku np. NPC_name coś robi.
               if (nr_poz==1) then
                  newMessage = name_NPC..strsub(newMessage, 3);
               else
                  newMessage = strsub(newMessage,1,nr_poz-1)..name_NPC..strsub(newMessage, nr_poz+2);
               end
            elseif (strsub(newMessage,1,2)=="%o") then         -- jest forma '%o'
               newMessage = strsub(newMessage, 3);
            end
         end
         if (changeBubble) then                          -- wyświetlaj dymek po polsku (jeśli istnieje)
            tinsert(BB_BubblesArray, { [1] = arg1, [2] = newMessage, [3] = 1 });
--            if (BB_first == 1) then          -- pierwszy uruchomienie, pomiń pierwszy dymek
--               BB_first = 0;
--            else
            BB_ctrFrame:SetScript("OnUpdate", BB_bubblizeText);
--            end
         end
      else                                               -- nie mamy tłumaczenia
         original_txt = strtrim(arg1);                   -- jeszcze raz wczytaj pełny tekst angielski
         if (BB_PM["saveNB"] == "1") then                -- zapisz oryginalny tekst
            BB_PS[name_NPC..":"..tostring(HashCode)] = original_txt.."@"..target..":"..player_name..":"..Y_Race1..":"..Y_Class1;
         end
         if (BB_PM["TRonline"] == "1") then              -- tłumaczenie online
            local pomoc = name_NPC.."@"..tostring(HashCode).."@"..original_txt;
            local jest = 0;
            for ind=1,BB_ile_got,1 do             -- sprawdź czy taki dymek jest już w gotowych
               if (BB_gotowe[ind] == pomoc) then
                  jest = 1;
               end
            end
            if (jest == 0) then
               if (BB_Zatrzask == 0) then                   -- bufor pusty
                  BB_Input1:SetText(original_txt);
                  BB_Input2:SetText("");
                  BB_Zatrzask = 1;
                  BB_ButtonZatrz:SetText("X");
                  BB_name_NPC = name_NPC;
                  BB_hash_Code= tostring(HashCode);
                  BB_bufor[BB_Zatrzask] = name_NPC.."@"..tostring(HashCode).."@"..original_txt;
               else
                  for ind=1,BB_Zatrzask,1 do             -- sprawdź czy jest już taki dymek w buforze
                     if (BB_bufor[ind] == pomoc) then
                        jest = 1;
                     end
                  end
                  if (jest == 0) then        -- nie ma jeszcze w buforze
                     BB_Zatrzask = BB_Zatrzask + 1;
                     BB_bufor[BB_Zatrzask] = pomoc;
                     BB_ButtonZatrz:SetText(tostring(BB_Zatrzask));
                  end
               end
            end
         end
      end
   end

   BB_SendVersion();

   if ((BB_PM["chat-en"] == "1") or (BB_is_translation ~= "1")) then     -- gdy nie ma także tłumaczenia                 
      return false;     -- wyświetlaj tekst oryginalny w oknie czatu
   else
      return true;      -- nie wyświetlaj oryginalnego tekstu
   end   
   
end


function BB_ZmienKody(message,target)
   if (target == "") then                             -- może być zmienna $target w tłumaczeniu
      target = player_name;
   end
   message = string.gsub(message, "$n$", string.upper(target));    -- i trzeba ją zamienić na nazwę gracza
   message = string.gsub(message, "$N$", string.upper(target));    -- tu jeszcze pisane DUŻYMI LITERAMI
   message = string.gsub(message, "$n", target);
   message = string.gsub(message, "$N", target);
   message = string.gsub(message, "$target", target);
   message = string.gsub(message, "$TARGET", target);
   
   message = string.gsub(message, "$g", "$G");     -- obsługa kodu $g(m;ż)
   local BB_forma = "";
   local nr_1, nr_2, nr_3 = 0;
   local nr_poz = string.find(message, "$G");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(message, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(message, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(message, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(message, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(message, nr_3, nr_3) ~= ")") do   -- szukaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(message, nr_3, nr_3) == ")") then
               if (target==player_name) then          -- wypowiedź kierowana do gracza
                  if (BB_PM["sex"]=="4") then         -- wypowiedzi wyświetlaj w formie zależnej od płci postaci
                     if (player_sex==3) then          -- postać płci żeńskiej
                        BB_forma = string.sub(message,nr_2+1,nr_3-1);
                     else                             -- postać płci męskiej
                        BB_forma = string.sub(message,nr_1+1,nr_2-1);
                     end
                  elseif (BB_PM["sex"]=="3") then         -- wypowiedzi wyświetlaj w formie żeńskiej
                     BB_forma = string.sub(message,nr_2+1,nr_3-1);
                  else                                -- wypowiedzi wyświetlaj w formie męskiej
                     BB_forma = string.sub(message,nr_1+1,nr_2-1);
                  end
               else
                  BB_forma = string.sub(message,nr_1+1,nr_2-1);    -- wypowiedź do kogoś innego - forma męska
               end
               message = string.sub(message,1,nr_poz-1) .. BB_forma .. string.sub(message,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(message, "$G");
   end
   
-- jeszcze obsłużyć nazwy własne $O(EN;PL)
   message = string.gsub(message, "$o", "$O");   -- obsługa kodu $o(EN;PL)
   local nr_1, nr_2, nr_3 = 0;
   local BB_forma = "";
   local nr_poz = string.find(message, "$O");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(message, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(message, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(message, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(message, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(message, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(message, nr_3, nr_3) == ")") then
               if (BB_PM["ownname"] == "1") then        -- forma polska
                  BB_forma = string.sub(message,nr_2+1,nr_3-1);
               else                                     -- forma angielska
                  BB_forma = string.sub(message,nr_1+1,nr_2-1);
               end
               message = string.sub(message,1,nr_poz-1) .. BB_forma .. string.sub(message,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(message, "$O");
   end

   message = string.gsub(message, "$r", "$R");  
   message = string.gsub(message, "$c", "$C");    
   if ((BB_PM["sex"]=="3") or ((BB_PM["sex"]=="4") and (player_sex=="3"))) then       -- gracz gra kobietą lub postać jest żeńska
      message = string.gsub(message, "$R1", player_race.M2);
      message = string.gsub(message, "$R2", player_race.D2);
      message = string.gsub(message, "$R3", player_race.C2);
      message = string.gsub(message, "$R4", player_race.B2);
      message = string.gsub(message, "$R5", player_race.N2);
      message = string.gsub(message, "$R6", player_race.K2);
      message = string.gsub(message, "$R7", player_race.W2);
      message = string.gsub(message, "$R", player_race.M2);
      message = string.gsub(message, "$C1", player_class.M2);
      message = string.gsub(message, "$C2", player_class.D2);
      message = string.gsub(message, "$C3", player_class.C2);
      message = string.gsub(message, "$C4", player_class.B2);
      message = string.gsub(message, "$C5", player_class.N2);
      message = string.gsub(message, "$C6", player_class.K2);
      message = string.gsub(message, "$C7", player_class.W2);
      message = string.gsub(message, "$C", player_class.M2);
   else                          -- gracz gra facetem
      message = string.gsub(message, "$R1", player_race.M1);
      message = string.gsub(message, "$R2", player_race.D1);
      message = string.gsub(message, "$R3", player_race.C1);
      message = string.gsub(message, "$R4", player_race.B1);
      message = string.gsub(message, "$R5", player_race.N1);
      message = string.gsub(message, "$R6", player_race.K1);
      message = string.gsub(message, "$R7", player_race.W1);
      message = string.gsub(message, "$R", player_race.M1);
      message = string.gsub(message, "$C1", player_class.M1);
      message = string.gsub(message, "$C2", player_class.D1);
      message = string.gsub(message, "$C3", player_class.C1);
      message = string.gsub(message, "$C4", player_class.B1);
      message = string.gsub(message, "$C5", player_class.N1);
      message = string.gsub(message, "$C6", player_class.K1);
      message = string.gsub(message, "$C7", player_class.W1);
      message = string.gsub(message, "$C", player_class.M1);
   end

   return message;   
end


function BB_FindProS(text)                 -- znajdź, czy jest tekst '%s' w podanym tłumaczeniu
   local dl_txt = string.len(text)-1;
   for i_j=1,dl_txt,1 do
      if (strsub(text,i_j,i_j+1)=="%s") then       
         return i_j;
      end
   end
   return 0;
end


function BB_CheckVars()
  if (not BB_PM) then
     BB_PM = {};
  end
  if (not BB_PS) then
     BB_PS = {};
  end
  if (not BB_TR) then
     BB_TR = {};
  end
  -- initialize check options
  if (not BB_PM["active"] ) then    -- dodatek aktywny
     BB_PM["active"] = "1";   
  end
  -- komunikaty głosowe
  if (not BB_PM["voices"] ) then
     BB_PM["voices"] = "1";   
  end
  if (not BB_PM["chat-en"] ) then   -- pokaż tekst angielski w oknie czatu
     BB_PM["chat-en"] = "0";   
  end
  if (not BB_PM["chat-pl"] ) then   -- pokaż tekst polski w oknie czatu
     BB_PM["chat-pl"] = "1";   
  end
  if (not BB_PM["saveNB"] ) then    -- zapisz nieprzetłumaczone dymki
     BB_PM["saveNB"] = "1";   
  end
  if (not BB_PM["setsize"] ) then   -- uaktywnij zmiany wielkości czcionki
     BB_PM["setsize"] = "0";   
  end
  if (not BB_PM["fontsize"] ) then  -- wielkość czcionki
     BB_PM["fontsize"] = "13";   
  end
  if (not BB_PM["TRonline"] ) then  -- przycisk okna tłumaczenia on-line
     BB_PM["TRonline"] = "0";   
  end
  if (not BB_PM["sex"] ) then       -- wybór płci wypowiedzi do gracza
     if (player_sex==3) then
        BB_PM["sex"] = "3";
     else
        BB_PM["sex"] = "2";
     end
  end
  if (not BB_PM["ownname"] ) then
     BB_PM["ownname"] = "1";   
  end
end
  

function BB_SetCheckButtonState()
  BBCheckButton1:SetValue(BB_PM["active"]=="1");
  BBCheckButtonG:SetValue(BB_PM["voices"]=="1");
  BBCheckButton2:SetValue(BB_PM["chat-en"]=="1");
  BBCheckButton3:SetValue(BB_PM["chat-pl"]=="1");
  BBCheckButton4:SetValue(BB_PM["ownname"]=="1");
  BBCheckButton5:SetValue(BB_PM["saveNB"]=="1");
  BBCheckButton8:SetValue(BB_PM["TRonline"]=="1");
  BBCheckSize:SetValue(BB_PM["setsize"]=="1");
  local fontsize = tonumber(BB_PM["fontsize"]);
  BBslider:SetValue(fontsize);
  if (BB_PM["setsize"]=="1") then
     BBOpis1:SetFont(BB_Font, fontsize);
  else   
     BBOpis1:SetFont(BB_Font, 13);
  end
  BBsex1:SetValue(BB_PM["sex"]=="2");
  BBsex2:SetValue(BB_PM["sex"]=="3");
  BBsex3:SetValue(BB_PM["sex"]=="4");
  BB_STframe:Hide();
end


function BB_BlizzardOptions()

-- Create main frame for information text
local BBOptions = CreateFrame("FRAME", "WoWpoPolskuBubblesOptions");
BBOptions.refresh = function (self) BB_SetCheckButtonState() end;
BBOptions.name = "WoWpoPolsku-Bubbles";
InterfaceOptions_AddCategory(BBOptions);

local BBOptionsHeader = BBOptions:CreateFontString(nil, "ARTWORK");
BBOptionsHeader:SetFontObject(GameFontNormalLarge);
BBOptionsHeader:SetJustifyH("LEFT"); 
BBOptionsHeader:SetJustifyV("TOP");
BBOptionsHeader:ClearAllPoints();
BBOptionsHeader:SetPoint("TOPLEFT", 16, -16);
BBOptionsHeader:SetText("WoWpoPolsku-Bubbles, ver. "..BB_version.." ("..BB_base..") by Platine © 2019-2023");

local BBOptionsDate = BBOptions:CreateFontString(nil, "ARTWORK");
BBOptionsDate:SetFontObject(GameFontNormalLarge);
BBOptionsDate:SetJustifyH("LEFT"); 
BBOptionsDate:SetJustifyV("TOP");
BBOptionsDate:ClearAllPoints();
BBOptionsDate:SetPoint("TOPRIGHT", BBOptionsHeader, "TOPRIGHT", 0, -22);
BBOptionsDate:SetText("Data bazy tłumaczeń: "..BB_date);
BBOptionsDate:SetFont(BB_Font, 16);

local BBCheckButton1 = CreateFrame("CheckButton", "BBCheckButton1", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton1.CheckBox:SetScript("OnClick", function(self) if (BB_PM["active"]=="1") then BB_PM["active"]="0" else BB_PM["active"]="1" end; end);
BBCheckButton1.CheckBox:SetPoint("TOPLEFT", BBOptionsHeader, "BOTTOMLEFT", 0, -30);
BBCheckButton1:SetPoint("TOPLEFT", BBOptionsHeader, "BOTTOMLEFT", 40, -30);
BBCheckButton1.Text:SetText("dodatek aktywny");     -- dodatek aktywny
BBCheckButton1.Text:SetFont(BB_Font, 13);

local BBCheckButtonG = CreateFrame("CheckButton", "BBCheckButtonG", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButtonG.CheckBox:SetScript("OnClick", function(self) if (BB_PM["voices"]=="1") then BB_PM["voices"]="0" else BB_PM["voices"]="1" end; end);
BBCheckButtonG.CheckBox:SetPoint("TOPLEFT", BBCheckButton1.CheckBox, "BOTTOMLEFT", 0, -20);
BBCheckButtonG:SetPoint("TOPLEFT", BBCheckButton1.CheckBox, "BOTTOMLEFT", 40, -20);
BBCheckButtonG.Text:SetText("włącz komunikaty głosowe dostępnej aktualizacji");
BBCheckButtonG.Text:SetFont(BB_Font, 13);

-- przycisk "Inni gracze"
local BBOptionsStatButton = CreateFrame("Button",nil, BBOptions, "UIPanelButtonTemplate");
BBOptionsStatButton:SetWidth(145);
BBOptionsStatButton:SetHeight(20);
BBOptionsStatButton:SetText("Inni gracze");
BBOptionsStatButton:Show();
BBOptionsStatButton:ClearAllPoints();
BBOptionsStatButton:SetPoint("TOPRIGHT", BBOptionsHeader, "TOPRIGHT", 0, -97);
BBOptionsStatButton:SetScript("OnClick", BB_ShowHideStatystyka);
  
local BBCheckButton2 = CreateFrame("CheckButton", "BBCheckButton2", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton2.CheckBox:SetScript("OnClick", function(self) if (BB_PM["chat-en"]=="1") then BB_PM["chat-en"]="0" else BB_PM["chat-en"]="1" end; end);
BBCheckButton2.CheckBox:SetPoint("TOPLEFT", BBCheckButtonG.CheckBox, "BOTTOMLEFT", 0, 5);
BBCheckButton2:SetPoint("TOPLEFT", BBCheckButtonG.CheckBox, "BOTTOMLEFT", 40, 5);
BBCheckButton2.Text:SetText("wyświetlaj tekst oryginalny w oknie czatu");
BBCheckButton2.Text:SetFont(BB_Font, 13);

local BBCheckButton3 = CreateFrame("CheckButton", "BBCheckButton3", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton3.CheckBox:SetScript("OnClick", function(self) if (BB_PM["chat-pl"]=="1") then BB_PM["chat-pl"]="0" else BB_PM["chat-pl"]="1" end; end);
BBCheckButton3.CheckBox:SetPoint("TOPLEFT", BBCheckButton2.CheckBox, "BOTTOMLEFT", 0, 5);
BBCheckButton3:SetPoint("TOPLEFT", BBCheckButton2.CheckBox, "BOTTOMLEFT", 40, 5);
BBCheckButton3.Text:SetText("wyświetlaj tekst tłumaczenia w oknie czatu"); 
BBCheckButton3.Text:SetFont(BB_Font, 13);

local BBCheckButton4 = CreateFrame("CheckButton", "BBCheckButton4", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton4.CheckBox:SetScript("OnClick", function(self) if (BB_PM["ownname"]=="1") then BB_PM["ownname"]="0" else BB_PM["ownname"]="1" end; end);
BBCheckButton4.CheckBox:SetPoint("TOPLEFT", BBCheckButton3.CheckBox, "BOTTOMLEFT", 0, 5);
BBCheckButton4:SetPoint("TOPLEFT", BBCheckButton3.CheckBox, "BOTTOMLEFT", 40, 5);
BBCheckButton4.Text:SetText("wyświetlaj przetłumaczone nazwy własne"); 
BBCheckButton4.Text:SetFont(BB_Font, 13);

local BBCheckButton5 = CreateFrame("CheckButton", "BBCheckButton5", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton5.CheckBox:SetScript("OnClick", function(self) if (BB_PM["saveNB"]=="1") then BB_PM["saveNB"]="0" else BB_PM["saveNB"]="1" end; end);
BBCheckButton5.CheckBox:SetPoint("TOPLEFT", BBCheckButton4.CheckBox, "BOTTOMLEFT", 0, 5);
BBCheckButton5:SetPoint("TOPLEFT", BBCheckButton4.CheckBox, "BOTTOMLEFT", 40, 5);
BBCheckButton5.Text:SetText("zapisz nieprzetłumaczone dymki");
BBCheckButton5.Text:SetFont(BB_Font, 13);

local BBCheckButton8 = CreateFrame("CheckButton", "BBCheckButton8", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckButton8.CheckBox:SetScript("OnClick", function(self) if (BB_PM["TRonline"]=="1") then BB_PM["TRonline"]="0";BB_TRframe:Hide(); else BB_PM["TRonline"]="1";BB_TRframe:Show(); end; end);
BBCheckButton8.CheckBox:SetPoint("TOPLEFT", BBCheckButton5.CheckBox, "BOTTOMLEFT", 0, 5);
BBCheckButton8:SetPoint("TOPLEFT", BBCheckButton5.CheckBox, "BOTTOMLEFT", 40, 5);
BBCheckButton8.Text:SetText("pokaż okno tłumaczenia online");
BBCheckButton8.Text:SetFont(BB_Font, 13);

local BBCheckSize = CreateFrame("CheckButton", "BBCheckSize", BBOptions, "SettingsCheckBoxControlTemplate");
BBCheckSize.CheckBox:SetScript("OnClick", function(self) if (BB_PM["setsize"]=="1") then BB_PM["setsize"]="0" else BB_PM["setsize"]="1" end; end);
BBCheckSize.CheckBox:SetPoint("TOPLEFT", BBCheckButton8.CheckBox, "BOTTOMLEFT", 0, -15);
BBCheckSize:SetPoint("TOPLEFT", BBCheckButton8.CheckBox, "BOTTOMLEFT", 40, -15);
BBCheckSize.Text:SetText("uaktywnij funkcję zmiany wielkości czcionki w dymkach (nie zawsze działa)");   
BBCheckSize.Text:SetFont(BB_Font, 13);

local BBslider = CreateFrame("Slider", "BBslider", BBOptions, "OptionsSliderTemplate");
BBslider:SetPoint("TOPLEFT", BBCheckSize, "BOTTOMLEFT", 10, -20);
BBslider:SetMinMaxValues(10, 20);
BBslider.minValue, BBslider.maxValue = BBslider:GetMinMaxValues();
BBslider.Low:SetText(BBslider.minValue);
BBslider.High:SetText(BBslider.maxValue);
getglobal(BBslider:GetName() .. 'Text'):SetText('Wielkość czcionki');
getglobal(BBslider:GetName() .. 'Text'):SetFont(BB_Font, 13);
BBslider:SetValue(tonumber(BB_PM["fontsize"]));
BBslider:SetValueStep(1);
BBslider:SetScript("OnValueChanged", function(self,event,arg1) 
                                      BB_PM["fontsize"]=string.format("%d",event); 
                                      BBsliderVal:SetText(BB_PM["fontsize"]);
									           BBOpis1:SetFont(BB_Font, event);
                                      end);
BBsliderVal = BBOptions:CreateFontString(nil, "ARTWORK");
BBsliderVal:SetFontObject(GameFontNormal);
BBsliderVal:SetJustifyH("CENTER");
BBsliderVal:SetJustifyV("TOP");
BBsliderVal:ClearAllPoints();
BBsliderVal:SetPoint("CENTER", BBslider, "CENTER", 0, -12);
BBsliderVal:SetText(BB_PM["fontsize"]);   
BBsliderVal:SetFont(BB_Font, 13);

BBOpis1 = BBOptions:CreateFontString(nil, "ARTWORK");
BBOpis1:SetFontObject(GameFontNormalLarge);
BBOpis1:SetJustifyH("LEFT");
BBOpis1:SetJustifyV("TOP");
BBOpis1:ClearAllPoints();
BBOpis1:SetPoint("TOPLEFT", BBslider, "BOTTOMLEFT", 200, 30);
local fontsize = tonumber(BB_PM["fontsize"]);
if (BB_PM["setsize"]=="1") then
   BBOpis1:SetFont(BB_Font, fontsize);
else
   BBOpis1:SetFont(BB_Font, 13);
end
BBOpis1:SetText("Przykładowy tekst wielkości czcionki");

local BBsex0 = BBOptions:CreateFontString(nil, "ARTWORK");
BBsex0:SetFontObject(GameFontNormal);
BBsex0:SetJustifyH("LEFT");
BBsex0:SetJustifyV("TOP");
BBsex0:ClearAllPoints();
BBsex0:SetPoint("TOPLEFT", BBslider, "BOTTOMLEFT", -30, -40);
BBsex0:SetFont(BB_Font, 13);
BBsex0:SetText("Wypowiedzi kierowane do gracza wyświetlaj w formie:");     -- 2:męski,  3:żeński,  4:zależny od płci postaci
   
local BBsex1 = CreateFrame("CheckButton", "BBsex1", BBOptions, "SettingsCheckBoxControlTemplate");
BBsex1.CheckBox:SetScript("OnClick", function(self) if (BB_PM["sex"]=="2") then BB_PM["sex"]="4";BBsex2.CheckBox:SetChecked(false);BBsex3.CheckBox:SetChecked(true) else BB_PM["sex"]="2";BBsex2.CheckBox:SetChecked(false);BBsex3.CheckBox:SetChecked(false) end; end);
BBsex1.CheckBox:SetPoint("TOPLEFT", BBsex0, "TOPRIGHT", 10, 5);
BBsex1:SetPoint("TOPLEFT", BBsex0, "TOPRIGHT", 50, 5);
BBsex1.Text:SetText("męskiej (jestem facetem)"); 
BBsex1.Text:SetFont(BB_Font, 13);

local BBsex2 = CreateFrame("CheckButton", "BBsex2", BBOptions, "SettingsCheckBoxControlTemplate");
BBsex2.CheckBox:SetScript("OnClick", function(self) if (BB_PM["sex"]=="3") then BB_PM["sex"]="4";BBsex1.CheckBox:SetChecked(false);BBsex3.CheckBox:SetChecked(true) else BB_PM["sex"]="3";BBsex1.CheckBox:SetChecked(false);BBsex3.CheckBox:SetChecked(false) end; end);
BBsex2.CheckBox:SetPoint("TOPLEFT", BBsex1.CheckBox, "BOTTOMLEFT", 0, 0);
BBsex2:SetPoint("TOPLEFT", BBsex1.CheckBox, "BOTTOMLEFT", 40, 0);
BBsex2.Text:SetText("żeńskiej (jestem kobietą)"); 
BBsex2.Text:SetFont(BB_Font, 13);

local BBsex3 = CreateFrame("CheckButton", "BBsex3", BBOptions, "SettingsCheckBoxControlTemplate");
BBsex3.CheckBox:SetScript("OnClick", function(self) if (BB_PM["sex"]=="4") then BB_PM["sex"]="2";BBsex1.CheckBox:SetChecked(true);BBsex2.CheckBox:SetChecked(false) else BB_PM["sex"]="4";BBsex1.CheckBox:SetChecked(false);BBsex2.CheckBox:SetChecked(false) end; end);
BBsex3.CheckBox:SetPoint("TOPLEFT", BBsex0, "TOPLEFT", 60, -20);
BBsex3:SetPoint("TOPLEFT", BBsex0, "TOPLEFT", 100, -20);
BBsex3.Text:SetText("forma zależna od aktualnej płci postaci"); 
BBsex3.Text:SetFont(BB_Font, 13);

--local IOF_Height = Settings:GetHeight();
--   if (IOF_Height>658) then

   local BBText0 = BBOptions:CreateFontString(nil, "ARTWORK");
   BBText0:SetFontObject(GameFontWhite);
   BBText0:SetJustifyH("LEFT");
   BBText0:SetJustifyV("TOP");
   BBText0:ClearAllPoints();
   BBText0:SetPoint("TOPLEFT", BBsex0, "BOTTOMLEFT", -5, -60);
   BBText0:SetFont(BB_Font, 13);
   BBText0:SetText("Szybkie komendy z linii czatu:");

   local BBText7 = BBOptions:CreateFontString(nil, "ARTWORK");
   BBText7:SetFontObject(GameFontWhite);
   BBText7:SetJustifyH("LEFT");
   BBText7:SetJustifyV("TOP");
   BBText7:ClearAllPoints();
   BBText7:SetPoint("TOPLEFT", BBText0, "BOTTOMLEFT", 0, -10);
   BBText7:SetFont(BB_Font, 13);
   BBText7:SetText("/bbtr   aby wywołać to okno ustawień dodatku");

   local BBText1 = BBOptions:CreateFontString(nil, "ARTWORK");
   BBText1:SetFontObject(GameFontWhite);
   BBText1:SetJustifyH("LEFT");
   BBText1:SetJustifyV("TOP");
   BBText1:ClearAllPoints();
   BBText1:SetPoint("TOPLEFT", BBText7, "BOTTOMLEFT", 0, -10);
   BBText1:SetFont(BB_Font, 13);
   BBText1:SetText("/bbtr 1  lub  /bbtr on   aby aktywować addon");

   local BBText2 = BBOptions:CreateFontString(nil, "ARTWORK");
   BBText2:SetFontObject(GameFontWhite);
   BBText2:SetJustifyH("LEFT");
   BBText2:SetJustifyV("TOP");
   BBText2:ClearAllPoints();
   BBText2:SetPoint("TOPLEFT", BBText1, "BOTTOMLEFT", 0, -4);
   BBText2:SetFont(BB_Font, 13);
   BBText2:SetText("/bbtr 0  lub  /bbtr off   aby deaktywawć addon");

--   end

local BBWWW1 = BBOptions:CreateFontString(nil, "ARTWORK");
BBWWW1:SetFontObject(GameFontWhite);
BBWWW1:SetJustifyH("LEFT");
BBWWW1:SetJustifyV("TOP");
BBWWW1:ClearAllPoints();
BBWWW1:SetPoint("BOTTOMLEFT", 16, 16);
BBWWW1:SetFont(BB_Font, 13);
BBWWW1:SetText("Odwiedź stronę WWW dodatku:");
  
local BBWWW2 = CreateFrame("EditBox", "BBWWW2", BBOptions, "InputBoxTemplate");
BBWWW2:ClearAllPoints();
BBWWW2:SetPoint("TOPLEFT", BBWWW1, "TOPRIGHT", 10, 4);
BBWWW2:SetHeight(20);
BBWWW2:SetWidth(160);
BBWWW2:SetAutoFocus(false);
BBWWW2:SetFontObject(GameFontGreen);
BBWWW2:SetText("https://wowpopolsku.pl");
BBWWW2:SetCursorPosition(0);
BBWWW2:SetScript("OnEnter", function(self)
   GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
   getglobal("GameTooltipTextLeft1"):SetFont(BB_Font, 13);
   GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
   GameTooltip:Show() --Show the tooltip
   end);
BBWWW2:SetScript("OnLeave", function(self)
   GameTooltip:Hide() --Hide the tooltip
   end);
BBWWW2:SetScript("OnTextChanged", function(self) BBWWW2:SetText("https://wowpopolsku.pl"); end);

  local BBdiscord2 = CreateFrame("EditBox", "BBWWW2", BBOptions, "InputBoxTemplate");
  BBdiscord2:ClearAllPoints();
  BBdiscord2:SetPoint("BOTTOMLEFT", BBWWW2, "TOPLEFT", 0, 3);
  BBdiscord2:SetHeight(20);
  BBdiscord2:SetWidth(200);
  BBdiscord2:SetAutoFocus(false);
  BBdiscord2:SetFontObject(GameFontGreen);
  BBdiscord2:SetText("https://discord.gg/s5rKEJMukA");
  BBdiscord2:SetCursorPosition(0);
  BBdiscord2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(BB_Font, 13);
     GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  BBdiscord2:SetScript("OnLeave", function(self)
	  GameTooltip:Hide() --Hide the tooltip
     end);
  BBdiscord2:SetScript("OnTextChanged", function(self) BBdiscord2:SetText("https://discord.gg/s5rKEJMukA"); end);

  local BBdiscord1 = BBOptions:CreateFontString(nil, "ARTWORK");
  BBdiscord1:SetFontObject(GameFontWhite);
  BBdiscord1:SetJustifyH("LEFT");
  BBdiscord1:SetJustifyV("TOP");
  BBdiscord1:ClearAllPoints();
  BBdiscord1:SetPoint("TOPRIGHT", BBdiscord2, "TOPLEFT", -10, -4);
  BBdiscord1:SetFont(BB_Font, 13);
  BBdiscord1:SetText("Discord:");
  
  local BB_STframe = CreateFrame("Frame","BB_STframe", BBOptions, "BasicFrameTemplateWithInset");
  BB_STframe:SetMovable(false);
  BB_STframe:SetWidth(600);
  BB_STframe:SetHeight(400);
  BB_STframe:ClearAllPoints();
  BB_STframe:SetPoint("CENTER", BBOptions, "CENTER", 0, 3);
  BB_STframe.title = BB_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  BB_STframe.title:SetPoint("CENTER", BB_STframe.TitleBg);
  BB_STframe.title:SetText("Inni gracze");
  
  BB_STframe.text = BB_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  BB_STframe.text:SetPoint("TOPLEFT", BB_STframe, "TOPLEFT", 20, -40);
  BB_STframe.text:SetText("Liczba graczy z tym dodatkiem:");
  BB_STframe.text:SetFont(BB_Font, 15);
  
  BB_STframe.count = BB_STframe:CreateFontString(nil, "OVERLAY", "GameFontNormal");
  BB_STframe.count:SetPoint("TOPLEFT", BB_STframe.text, "TOPRIGHT", 10, 0);
  BB_STframe.count:SetText("? ");
  BB_STframe.count:SetFont(BB_Font, 15);

  BB_STframe.alert = BB_STframe:CreateFontString(nil, "OVERLAY", "GameFontRed");
  BB_STframe.alert:SetPoint("TOPLEFT", BB_STframe.text, "TOPRIGHT", 40, -2);
  BB_STframe.alert:SetText("");
  BB_STframe.alert:SetFont(BB_Font, 13);

  BB_STframe.ScrollFrame = CreateFrame("ScrollFrame", nil, BB_STframe, "UIPanelScrollFrameTemplate");
  BB_STframe.ScrollFrame:SetPoint("TOPLEFT", BB_STframe.InsetBg, "TOPLEFT", 10, -40);
  BB_STframe.ScrollFrame:SetPoint("BOTTOMRIGHT", BB_STframe.InsetBg, "BOTTOMRIGHT", -5, 10);
  
  BB_STframe.ScrollFrame.ScrollBar:ClearAllPoints();
  BB_STframe.ScrollFrame.ScrollBar:SetPoint("TOPLEFT", BB_STframe.ScrollFrame, "TOPRIGHT", -12, -18);
  BB_STframe.ScrollFrame.ScrollBar:SetPoint("BOTTOMRIGHT", BB_STframe.ScrollFrame, "BOTTOMRIGHT", -7, 15);
  local child = CreateFrame("Frame", nil, BB_STframe.ScrollFrame);
  child:SetSize(552,500);
  child.bg = child:CreateTexture(nil, "BACKGROUND");
  child.bg:SetAllPoints(true);
  child.bg:SetColorTexture(0, 0.05, 0.1, 0.8);
  BB_STframe.ScrollFrame:SetScrollChild(child);
  BB_STframe.ScrollFrame:SetScript("OnMouseWheel", BB_ScrollFrame_OnMouseWheel);
  
  BB_STframe.tabela1 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  BB_STframe.tabela1:SetPoint("TOPLEFT", child, "TOPLEFT", 10, -10);
  BB_STframe.tabela1:SetText("");
  BB_STframe.tabela1:SetJustifyH("LEFT");
  BB_STframe.tabela1:SetFont(BB_Font, 15);
  
  BB_STframe.tabela2 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  BB_STframe.tabela2:SetPoint("TOPLEFT", child, "TOPLEFT", 150, -10);
  BB_STframe.tabela2:SetText("");
  BB_STframe.tabela2:SetJustifyH("LEFT");
  BB_STframe.tabela2:SetFont(BB_Font, 15);

  BB_STframe:SetFrameLevel(10);
  BB_STframe:Hide();
 
end


function BB_SlashCommand(msg)
  -- check the command
  if (msg) then
     local BB_command = string.lower(msg);                -- normalizacja, tylko małe litery
     if ((BB_command=="on") or (BB_command=="1")) then    -- włącz przełącznik aktywności
        BB_PM["active"]="1";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Bubbles jest teraz aktywny");
     elseif ((BB_command=="off") or (BB_command=="0")) then
        BB_PM["active"]="0";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Spells jest teraz nieaktywny");
     else
        Settings.OpenToCategory("WoWpoPolsku-Bubbles");
     end   
  end
end


function BB_ShowTRonline()
   if (BB_TRvisible == 0) then
      BB_TRvisible = 1;
      BB_Button8Save:Show();
      BB_Input1:Show();
      BB_Input2:Show();
      BB_ButtonZatrz:Show();
   else
      BB_TRvisible = 0;
      BB_Button8Save:Hide();
      BB_Input1:Hide();
      BB_Input2:Hide();
      BB_ButtonZatrz:Hide();
   end   
end


function BB_TRzatrzask()                  -- wciśnięto przycisk zwolnienia zatrzasku
   if (BB_Zatrzask > 0) then
      BB_Zatrzask = BB_Zatrzask - 1;
      if (BB_Zatrzask == 0) then
         BB_ButtonZatrz:SetText("O");
      else
         for ind=1,BB_Zatrzask,1 do
            BB_bufor[ind] = BB_bufor[ind+1];
         end
         BB_bufor[BB_Zatrzask+1] = "";
         local p1,p2,p3 = strsplit("@",BB_bufor[1]);
         BB_Input1:SetText(p3);
         if (BB_Zatrzask == 1) then
            BB_ButtonZatrz:SetText("X");
         else
            BB_ButtonZatrz:SetText(tostring(BB_Zatrzask));
         end
      end
   else   
      BB_Input1:SetText("czekam na tekst oryginalny z nieprzetlumaczonego dymku");
   end
   BB_Input2:SetText("");
end
  

function BB_ShowTRsave()
   if (BB_Input2:GetText() == "") then
      BB_Input2:SetText("?? - a gdzie tłumaczenie - ??");
   else
      local p1,p2,p3 = strsplit("@",BB_bufor[1]);
      BB_TR[p1.."@"..p2] = BB_Input1:GetText().."@"..BB_Input2:GetText();
      BB_Input2:SetText("OK - zapisano tłumaczenie - OK");
      BB_Input1:SetText("czekam na tekst oryginalny z nieprzetlumaczonego dymku");
      BB_ile_got = BB_ile_got + 1;
      BB_gotowe[BB_ile_got] = BB_bufor[1];
      BB_TRzatrzask();
   end
end

  
function BB_OknoTRonline()
  BB_TRframe = CreateFrame("Frame","DragFrame1", UIParent);
  BB_TRframe:SetMovable(true);
  BB_TRframe:EnableMouse(true);
  BB_TRframe:RegisterForDrag("LeftButton");
  BB_TRframe:SetScript("OnDragStart", BB_TRframe.StartMoving);
  BB_TRframe:SetScript("OnDragStop", BB_TRframe.StopMovingOrSizing);

  BB_TRframe:SetWidth(500);
  BB_TRframe:SetHeight(46);
  BB_TRframe:ClearAllPoints();
  BB_TRframe:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 250, 0);
  if (BB_PM["TRonline"] == "1") then
     BB_TRframe:Show();
  else
     BB_TRframe:Hide();
  end;
--local tex = BB_TRframe:CreateTexture("ARTWORK");
--tex:SetAllPoints();
--tex:SetTexture(1.0,0.5,0); tex:SetAlpha(0.5);

  BB_Button8 = CreateFrame("Button",nil, BB_TRframe, "UIPanelButtonTemplate");
  BB_Button8:SetWidth(60);
  BB_Button8:SetHeight(20);
  BB_Button8:SetText("BBTR");
  BB_Button8:ClearAllPoints();
  BB_Button8:SetPoint("TOPLEFT", BB_TRframe, "TOPLEFT", 3, -3);
  BB_Button8:SetScript("OnClick", BB_ShowTRonline);
  if (BB_PM["TRonline"] == "1") then
     BB_Button8:Show();
  end;

  BB_Button8Save = CreateFrame("Button",nil, BB_TRframe, "UIPanelButtonTemplate");
  BB_Button8Save:SetWidth(60);
  BB_Button8Save:SetHeight(20);
  BB_Button8Save:SetText("Zapisz");
  BB_Button8Save:ClearAllPoints();
  BB_Button8Save:SetPoint("TOPLEFT", BB_Button8, "BOTTOMLEFT", 0, 1);
  BB_Button8Save:SetScript("OnClick", BB_ShowTRsave);
  BB_Button8Save:Hide();

  BB_Input1 = CreateFrame("EditBox", "BB_Input1", BB_TRframe, "InputBoxTemplate");
  BB_Input1:ClearAllPoints();
  BB_Input1:SetPoint("TOPLEFT", BB_Button8, "TOPRIGHT", 4, 0);
  BB_Input1:SetHeight(20);
  BB_Input1:SetWidth(400);
  BB_Input1:SetAutoFocus(false);
  BB_Input1:SetFontObject(GameFontGreen);
  BB_Input1:SetText("tutaj bedzie tekst oryginalny");
  BB_Input1:SetCursorPosition(0);
  BB_Input1:Hide();
  
  BB_Input2 = CreateFrame("EditBox", "BB_Input2", BB_TRframe, "InputBoxTemplate");
  BB_Input2:ClearAllPoints();
  BB_Input2:SetPoint("TOPLEFT", BB_Button8Save, "TOPRIGHT", 4, 0);
  BB_Input2:SetHeight(20);
  BB_Input2:SetWidth(400);
  BB_Input2:SetAutoFocus(false);
  BB_Input2:SetFontObject(GameFontWhite);
  BB_Input2:SetText("a tutaj bedzie polskie tlumaczenie");
  BB_Input2:SetCursorPosition(0);
  BB_Input2:Hide();
  
  BB_ButtonZatrz = CreateFrame("Button",nil, BB_TRframe, "UIPanelButtonTemplate");
  BB_ButtonZatrz:SetWidth(30);
  BB_ButtonZatrz:SetHeight(20);
  BB_ButtonZatrz:SetText("O");
  BB_ButtonZatrz:ClearAllPoints();
  BB_ButtonZatrz:SetPoint("TOPLEFT", BB_Input1, "TOPRIGHT", -1, 0);
  BB_ButtonZatrz:SetScript("OnClick", BB_TRzatrzask);
  BB_ButtonZatrz:Hide();

end

  
function BBTR_onEvent(self, event, name, ...)
   if (event=="ADDON_LOADED" and name=="WoWpoPolsku_Bubbles") then
      self:UnregisterEvent("ADDON_LOADED");
      ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_SAY", ChatFilter)
      ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_PARTY", ChatFilter)
      ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_YELL", ChatFilter)
      ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_WHISPER", ChatFilter)
      ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_EMOTE", ChatFilter)
      SlashCmdList["WOWPOPOLSKU_BUBBLES"] = function(msg) BB_SlashCommand(msg); end
      SLASH_WOWPOPOLSKU_BUBBLES1 = "/wowpopolsku-bubbles";
      SLASH_WOWPOPOLSKU_BUBBLES2 = "/bbtr";
      BB_CheckVars();
      BB_BlizzardOptions();
      BB_OknoTRonline();
      DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Bubbles ver. "..BB_version.." - uruchomiomo");
      p_race = {
      ["Blood Elf"] = { M1="Krwawy Elf", D1="krwawego elfa", C1="krwawemu elfowi", B1="krwawego elfa", N1="krwawym elfem", K1="krwawym elfie", W1="Krwawy Elfie", M2="Krwawa Elfka", D2="krwawej elfki", C2="krwawej elfce", B2="krwawą elfkę", N2="krwawą elfką", K2="krwawej elfce", W2="Krwawa Elfko" }, 
      ["Dark Iron Dwarf"] = { M1="Krasnolud Ciemnego Żelaza", D1="krasnoluda Ciemnego Żelaza", C1="krasnoludowi Ciemnego Żelaza", B1="krasnoluda Ciemnego Żelaza", N1="krasnoludem Ciemnego Żelaza", K1="krasnoludzie Ciemnego Żelaza", W1="Krasnoludzie Ciemnego Żelaza", M2="Krasnoludzica Ciemnego Żelaza", D2="krasnoludzicy Ciemnego Żelaza", C2="krasnoludzicy Ciemnego Żelaza", B2="krasnoludzicę Ciemnego Żelaza", N2="krasnoludzicą Ciemnego Żelaza", K2="krasnoludzicy Ciemnego Żelaza", W2="Krasnoludzico Ciemnego Żelaza" },
      ["Dracthyr"] = { M1="Draktyr", D1="draktyra", C1="draktyrowi", B1="draktyra", N1="draktyrem", K1="draktyrze", W1="Draktyrze", M2="Draktyrka", D2="draktyrki", C2="draktyrce", B2="draktyrkę", N2="draktyrką", K2="draktyrce", W2="Draktyrko" },
      ["Draenei"] = { M1="Draenei", D1="draeneia", C1="draeneiowi", B1="draeneia", N1="draeneiem", K1="draeneiu", W1="Draeneiu", M2="Draeneika", D2="draeneiki", C2="draeneice", B2="draeneikę", N2="draeneiką", K2="draeneice", W2="Draeneiko" },
      ["Dwarf"] = { M1="Krasnolud", D1="krasnoluda", C1="krasnoludowi", B1="krasnoluda", N1="krasnoludem", K1="krasnoludzie", W1="Krasnoludzie", M2="Krasnoludzica", D2="krasnoludzicy", C2="krasnoludzicy", B2="krasnoludzicę", N2="krasnoludzicą", K2="krasnoludzicy", W2="Krasnoludzico" },
      ["Gnome"] = { M1="Gnom", D1="gnoma", C1="gnomowi", B1="gnoma", N1="gnomem", K1="gnomie", W1="Gnomie", M2="Gnomka", D2="gnomki", C2="gnomce", B2="gnomkę", N2="gnomką", K2="gnomce", W2="Gnomko" },
      ["Goblin"] = { M1="Goblin", D1="goblina", C1="goblinowi", B1="goblina", N1="goblinem", K1="goblinie", W1="Goblinie", M2="Goblinka", D2="goblinki", C2="goblince", B2="goblinkę", N2="goblinką", K2="goblince", W2="Goblinko" },
      ["Highmountain Tauren"] = { M1="Tauren z Wysokiej Góry", D1="taurena z Wysokiej Góry", C1="taurenowi z Wysokiej Góry", B1="taurena z Wysokiej Góry", N1="taurenen z Wysokiej Góry", K1="taurenie z Wysokiej Góry", W1="Taurenie z Wysokiej Góry", M2="Taurenka z Wysokiej Góry", D2="taurenki z Wysokiej Góry", C2="taurence z Wysokiej Góry", B2="taurenkę z Wysokiej Góry", N2="taurenką z Wysokiej Góry", K2="taurence z Wysokiej Góry", W2="Taurenko z Wysokiej Góry" },
      ["Human"] = { M1="Człowiek", D1="człowieka", C1="człowiekowi", B1="człowieka", N1="człowiekiem", K1="człowieku", W1="Człowieku", M2="Człowiek", D2="człowieka", C2="człowiekowi", B2="człowieka", N2="człowiekiem", K2="człowieku", W2="Człowieku" },
      ["Kul Tiran"] = { M1="Kul Tiran", D1="Kul Tirana", C1="Kul Tiranowi", B1="Kul Tirana", N1="Kul Tiranem", K1="Kul Tiranie", W1="Kul Tiranie", M2="Kul Tiranka", D2="Kul Tiranki", C2="Kul Tirance", B2="Kul Tirankę", N2="Kul Tiranką", K2="Kul Tirance", W2="Kul Tiranko" },
      ["Lightforged Draenei"] = { M1="Świetlisty Draenei", D1="świetlistego draeneia", C1="świetlistemu draeneiowi", B1="świetlistego draeneia", N1="świetlistym draeneiem", K1="świetlistym draeneiu", W1="Świetlisty Draeneiu", M2="Świetlista Draeneika", D2="świetlistej draeneiki", C2="świetlistej draeneice", B2="świetlistą draeneikę", N2="świetlistą draeneiką", K2="świetlistej draeneice", W2="Świetlista Draeneiko" },
      ["Mag'har Orc"] = { M1="Ork z Mag'har", D1="orka z Mag'har", C1="orkowi z Mag'har", B1="orka z Mag'har", N1="orkiem z Mag'har", K1="orku z Mag'har", W1="Orku z Mag'har", M2="Orczyca z Mag'har", D2="orczycy z Mag'har", C2="orczycy z Mag'har", B2="orczycę z Mag'har", N2="orczycą z Mag'har", K2="orczyce z Mag'har", W2="Orczyco z Mag'har" },
      ["Mechagnome"] = { M1="Mechagnom", D1="mechagnoma", C1="mechagnomowi", B1="mechagnoma", N1="mechagnomem", K1="mechagnomie", W1="Mechagnomie", M2="Mechagnomka", D2="mechagnomki", C2="mechagnomce", B2="mechagnomkę", N2="mechagnomką", K2="mechagnomce", W2="Mechagnomko" },
      ["Nightborne"] = { M1="Dziecię Nocy", D1="dziecięcia nocy", C1="dziecięciu nocy", B1="dziecię nocy", N1="dziecięcem nocy", K1="dziecięciu nocy", W1="Dziecię Nocy", M2="Dziecię Nocy", D2="dziecięcia nocy", C2="dziecięciu nocy", B2="dziecię nocy", N2="dziecięcem nocy", K2="dziecięciu nocy", W2="Dziecię Nocy" },
      ["Night Elf"] = { M1="Nocny Elf", D1="nocnego elfa", C1="nocnemu elfowi", B1="nocnego elfa", N1="nocnym elfem", K1="nocnym elfie", W1="Nocny Elfie", M2="Nocna Elfka", D2="nocnej elfki", C2="nocnej elfce", B2="nocną elfkę", N2="nocną elfką", K2="nocnej elfce", W2="Nocna Elfko" },
      ["Orc"] = { M1="Ork", D1="orka", C1="orkowi", B1="orka", N1="orkiem", K1="orku", W1="Orku", M2="Orczyca", D2="orczycy", C2="orczycy", B2="orczycę", N2="orczycą", K2="orczycy", W2="Orczyco" },
      ["Pandaren"] = { M1="Pandaren", D1="pandarena", C1="pandarenowi", B1="pandarena", N1="pandarenem", K1="pandarenie", W1="Pandarenie", M2="Pandarenka", D2="pandarenki", C2="pandarence", B2="pandarenkę", N2="pandarenką", K2="pandarence", W2="Pandarenko" },
      ["Tauren"] = { M1="Tauren", D1="taurena", C1="taurenowi", B1="taurena", N1="taurenem", K1="taurenie", W1="Taurenie", M2="Taurenka", D2="taurenki", C2="taurence", B2="taurenkę", N2="taurenką", K2="taurence", W2="Taurenko" },
      ["Troll"] = { M1="Troll", D1="trolla", C1="trollowi", B1="trolla", N1="trollem", K1="trollu", W1="Trollu", M2="Trollica", D2="trollicy", C2="trollicy", B2="trollicę", N2="trollicą", K2="trollicy", W2="Trollico" },
      ["Undead"] = { M1="Nieumarły", D1="nieumarłego", C1="nieumarłemu", B1="nieumarłego", N1="nieumarłym", K1="nieumarłym", W1="Nieumarły", M2="Nieumarła", D2="nieumarłej", C2="nieumarłej", B2="nieumarłą", N2="nieumarłą", K2="nieumarłej", W2="Nieumarła" },
      ["Void Elf"] = { M1="Elf Pustki", D1="elfa Pustki", C1="elfowi Pustki", B1="elfa Pustki", N1="elfem Pustki", K1="elfie Pustki", W1="Elfie Pustki", M2="Elfka Pustki", D2="elfki Pustki", C2="elfce Pustki", B2="elfkę Pustki", N2="elfką Pustki", K2="elfce Pustki", W2="Elfko Pustki" },
      ["Vulpera"] = { M1="Lisołak", D1="lisołaka", C1="lisołakowi", B1="lisołaka", N1="lisołakiem", K1="lisołaku", W1="Lisołaku", M2="Lisołaczka", D2="lisołaczki", C2="lisołaczce", B2="lisołaczkę", N2="lisołaczką", K2="lisołaczce", W2="Lisołaczko" },
      ["Worgen"] = { M1="Worgen", D1="worgena", C1="worgenowi", B1="worgena", N1="worgenem", K1="worgenie", W1="Worgenie", M2="Worgenka", D2="worgenki", C2="worgence", B2="worgenkę", N2="worgenką", K2="worgence", W2="Worgenko" },
      ["Zandalari Troll"] = { M1="Troll Zandalari", D1="trolla Zandalari", C1="trollowi Zandalari", B1="trolla Zandalari", N1="trollem Zandalari", K1="trollu Zandalari", W1="Trollu Zandalari", M2="Trollica Zandalari", D2="trollicy Zandalari", C2="trollicy Zandalari", B2="trollicę Zandalari", N2="trollicą Zandalari", K2="trollicy Zandalari", W2="Trollico Zandalari" }, }
      p_class = {
      ["Death Knight"] = { M1="Rycerz Śmierci", D1="rycerz śmierci", C1="rycerzowi śmierci", B1="rycerza śmierci", N1="rycerzem śmierci", K1="rycerzu śmierci", W1="Rycerzu Śmierci", M2="Rycerz Śmierci", D2="rycerz śmierci", C2="rycerzowi śmierci", B2="rycerza śmierci", N2="rycerzem śmierci", K2="rycerzu śmierci", W2="Rycerzu Śmierci" },
      ["Demon Hunter"] = { M1="Łowca demonów", D1="łowcy demonów", C1="łowcy demonów", B1="łowcę demonów", N1="łowcą demonów", K1="łowcy demonów", W1="Łowco demonów", M2="Łowczyni demonów", D2="łowczyni demonów", C2="łowczyni demonów", B2="łowczynię demonów", N2="łowczynią demonów", K2="łowczyni demonów", W2="Łowczyni demonów" },
      ["Druid"] = { M1="Druid", D1="druida", C1="druidowi", B1="druida", N1="druidem", K1="druidzie", W1="Druidzie", M2="Druidka", D2="druidki", C2="druidce", B2="druidkę", N2="druidką", K2="druidce", W2="Druidko" },
      ["Evoker"] = { M1="Przywoływacz", D1="przywoływacza", C1="przywoływaczowi", B1="przywoływacza", N1="przywoływaczem", K1="przywoływaczu", W1="Przywoływaczu", M2="Przywoływaczka", D2="przywoływaczki", C2="przywoływaczce", B2="przywoływaczkę", N2="przywoływaczką", K2="przywoływaczce", W2="przywoływaczko" },
      ["Hunter"] = { M1="Łowca", D1="łowcy", C1="łowcy", B1="łowcę", N1="łowcą", K1="łowcy", W1="Łowco", M2="Łowczyni", D2="łowczyni", C2="łowczyni", B2="łowczynię", N2="łowczynią", K2="łowczyni", W2="Łowczyni" },
      ["Mage"] = { M1="Mag", D1="maga", C1="magowi", B1="maga", N1="magiem", K1="magu", W1="Magu", M2="Maginia", D2="magini", C2="maginią", B2="maginię", N2="maginią", K2="magini", W2="Maginio" },
      ["Monk"] = { M1="Mnich", D1="mnicha", C1="mnichowi", B1="mnicha", N1="mnichem", K1="mnichu", W1="Mnichu", M2="Mniszka", D2="mniszki", C2="mniszce", B2="mniszkę", N2="mniszką", K2="mniszce", W2="Mniszko" },
      ["Paladin"] = { M1="Paladyn", D1="paladyna", C1="paladynowi", B1="paladyna", N1="paladynem", K1="paladynie", W1="Paladynie", M2="Paladynka", D2="paladynki", C2="paladynce", B2="paladynkę", N2="paladynką", K2="paladynce", W2="Paladynko" },
      ["Priest"] = { M1="Kapłan", D1="kapłana", C1="kapłanowi", B1="kapłana", N1="kapłanem", K1="kapłanie", W1="Kapłanie", M2="Kapłanka", D2="kapłanki", C2="kapłance", B2="kapłankę", N2="kapłanką", K2="kapłance", W2="Kapłanko" },
      ["Rogue"] = { M1="Łotrzyk", D1="łotrzyka", C1="łotrzykowi", B1="łotrzyka", N1="łotrzykiem", K1="łotrzyku", W1="Łotrzyku", M2="Łotrzyca", D2="łotrzycy", C2="łotrzycy", B2="łotrzycę", N2="łotrzycą", K2="łotrzycy", W2="Łotrzyco" },
      ["Shaman"] = { M1="Szaman", D1="szamana", C1="szamanowi", B1="szamana", N1="szamanem", K1="szamanie", W1="Szamanie", M2="Szamanka", D2="szamanki", C2="szamance", B2="szamankę", N2="szamanką", K2="szamance", W2="Szamanko" },
      ["Warlock"] = { M1="Czarnoksiężnik", D1="czarnoksiężnika", C1="czarnoksiężnikowi", B1="czarnoksiężnika", N1="czarnoksiężnikiem", K1="czarnoksiężniku", W1="Czarnoksiężniku", M2="Czarownica", D2="czarownicy", C2="czarownicy", B2="czarownicę", N2="czarownicą", K2="czarownicy", W2="Czarownico" },
      ["Warrior"] = { M1="Wojownik", D1="wojownika", C1="wojownikowi", B1="wojownika", N1="wojownikiem", K1="wojowniku", W1="Wojowniku", M2="Wojowniczka", D2="wojowniczki", C2="wojowniczce", B2="wojowniczkę", N2="wojowniczką", K2="wojowniczce", W2="Wojowniczko" }, }
      if (p_race[BB_race]) then      
         player_race = { M1=p_race[BB_race].M1, D1=p_race[BB_race].D1, C1=p_race[BB_race].C1, B1=p_race[BB_race].B1, N1=p_race[BB_race].N1, K1=p_race[BB_race].K1, W1=p_race[BB_race].W1, M2=p_race[BB_race].M2, D2=p_race[BB_race].D2, C2=p_race[BB_race].C2, B2=p_race[BB_race].B2, N2=p_race[BB_race].N2, K2=p_race[BB_race].K2, W2=p_race[BB_race].W2 };
      else   
         player_race = { M1=BB_race, D1=BB_race, C1=BB_race, B1=BB_race, N1=BB_race, K1=BB_race, W1=BB_race, M2=BB_race, D2=BB_race, C2=BB_race, B2=BB_race, N2=BB_race, K2=BB_race, W2=BB_race };
         print ("|cff55ff00BBTR - nowa rasa: "..BB_race);
      end
      if (p_class[BB_class]) then
         player_class = { M1=p_class[BB_class].M1, D1=p_class[BB_class].D1, C1=p_class[BB_class].C1, B1=p_class[BB_class].B1, N1=p_class[BB_class].N1, K1=p_class[BB_class].K1, W1=p_class[BB_class].W1, M2=p_class[BB_class].M2, D2=p_class[BB_class].D2, C2=p_class[BB_class].C2, B2=p_class[BB_class].B2, N2=p_class[BB_class].N2, K2=p_class[BB_class].K2, W2=p_class[BB_class].W2 };
      else
         player_class = { M1=BB_class, D1=BB_class, C1=BB_class, B1=BB_class, N1=BB_class, K1=BB_class, W1=BB_class, M2=BB_class, D2=BB_class, C2=BB_class, B2=BB_class, N2=BB_class, K2=BB_class, W2=BB_class };
         print ("|cff55ff00BBTR - nowa klasa: "..BB_class);
      end
      
      local BBTR = CreateFrame("Frame");
      BBTR.WelcomePanel = CreateFrame("Frame", nil, UIParent, "UIPanelDialogTemplate");
      BBTR.WelcomePanel:SetWidth(600);
      BBTR.WelcomePanel:SetHeight(300);
      BBTR.WelcomePanel:ClearAllPoints();
      BBTR.WelcomePanel:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
      BBTR.WelcomePanel:SetFrameStrata("TOOLTIP");
      BBTR.WelcomePanel.Title:SetText("WoWpoPolsku - Bubbles");
      BBTR.WelcomePanel.Text = BBTR.WelcomePanel:CreateFontString(nil, "ARTWORK");
      BBTR.WelcomePanel.Text:SetFontObject(GameFontWhite);
      BBTR.WelcomePanel.Text:SetJustifyH("LEFT"); 
      BBTR.WelcomePanel.Text:SetJustifyV("TOP");
      BBTR.WelcomePanel.Text:ClearAllPoints();
      BBTR.WelcomePanel.Text:SetPoint("TOPLEFT", BBTR.WelcomePanel, "TOPLEFT", 20, -40);
      BBTR.WelcomePanel.Text:SetWidth(570);
      BBTR.WelcomePanel.Text:SetText("UWAGA użytkownicy dodatku |cffff00ffWoWpoPolsku - Bubbles|r!\n\nDodatek |cffff00ffWoWpoPolsku - Bubbles|r nie będzie już więcej utrzymywany.\n\nAle w jego miejsce uruchamiamy zupełnie nowy, zintegrowany dodatek\n|cff00ffffAll-in-One|r zawierający w jednym dodatku wszystkie dostępne dodatki w ramach projektu |cff00ffffWoWpoPolsku|r.\n\nNazwa tego jednego dodatku, to po prostu: |cffff00ffWoWpoPolsku|r\n\nZapraszamy już dziś do pobrania nowego dodatku.\n\n\n|cffff00ffPlatine|r - autor");
      BBTR.WelcomePanel.Text:SetFont(BB_Font, 15);
      BBTR.WelcomePanel.Button = CreateFrame("Button",nil, BBTR.WelcomePanel, "UIPanelButtonTemplate");
      BBTR.WelcomePanel.Button:SetWidth(160);
      BBTR.WelcomePanel.Button:SetHeight(20);
      BBTR.WelcomePanel.Button:SetText("OK - przeczytano");
      BBTR.WelcomePanel.Button:ClearAllPoints();
      BBTR.WelcomePanel.Button:SetPoint("BOTTOMLEFT", BBTR.WelcomePanel, "BOTTOMLEFT", BBTR.WelcomePanel:GetWidth()/2-BBTR.WelcomePanel.Button:GetWidth()/2, 10);
      BBTR.WelcomePanel.Button:Show();
      BBTR.WelcomePanel.Button:SetScript("OnClick", function() BBTR.WelcomePanel:Hide(); end);
      BBTR.WelcomePanel:Show();

   elseif (event=="CHAT_MSG_ADDON") then        -- ukryty kanał addonu
      local msg, method, who = select (1, ...);
      if (name=="WoWpoPolsku_BBTR") then 
         BB_onChatMsgAddon(who,msg);
      end
   end
 
end


function BB_SendVersion()
   local now = GetTime();
   if (time_ver + 15*60 < now) then                  -- co 15 minut
      local message = BB_lang..":"..string.sub(BB_version,1,1)..string.sub(BB_version,-2)..":"..BB_base..":"..BB_date;
      if ( IsInGuild() ) then                -- gracz jest w gildii
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_BBTR", message, "GUILD");
      end
      if ( IsInRaid() ) then                -- gracz jest w raidzie
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_BBTR", message, "RAID");
      end
      time_ver = now;
   end
end


function BB_onChatMsgAddon(who,msg)       -- odebrano komunikat z ukrytego kanału addonu
   if (not Players_ver[who]) then
      local pla_lang, pla_ver, pla_base, pla_date = strsplit(":",msg);
      if (tonumber(pla_ver)>tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_VER = pla_ver;
         Version_max.ADDON_COUNT = 0;
      end
      if (tonumber(pla_ver)==tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_COUNT = Version_max.ADDON_COUNT + 1;
      end
      if (tonumber(pla_base)>tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_VER = pla_base;
         Version_max.BASE_DATE = pla_date;
         Version_max.BASE_COUNT = 0;
      end   
      if (tonumber(pla_base)==tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_COUNT = Version_max.BASE_COUNT + 1;
      end
      Players_ver[who] = { };
      Players_ver[who].LANG = pla_lang;
      Players_ver[who].VERSION = pla_ver;
      Players_ver[who].BASE = pla_base;
      Players_ver[who].DATE = pla_date;
      Players_ver_Count = Players_ver_Count + 1;
      Version_max.ALERT_ID = 0;
      if ((tonumber(Version_max.ADDON_VER)>tonumber(string.sub(BB_version,1,1)..string.sub(BB_version,-2))) and (Version_max.ADDON_COUNT>1) and (Version_max.ADDON_ALERT==0)) then
         Version_max.ALERT_ID = 4;
      end
      if ((tonumber(Version_max.BASE_VER)>tonumber(BB_base)) and (Version_max.BASE_COUNT>1) and (Version_max.BASE_ALERT==0)) then
         Version_max.ALERT_ID = Version_max.ALERT_ID + 2;
      end
   end
   if (Version_max.ALERT_ID>0) then
      PlaySound(10843);        -- dźwięk: HornOfCentarius
      if (Version_max.ALERT_ID>3) then              -- sam dodatek
         print("|cffffff00WoWpoPolsku-Bubbles:|r Dostępna jest nowa wersja |cffffff00"..Version_max.ADDON_VER.."|r dodatku.");
         print("Możesz ją pobrać z serwisu CurseForge.conm, WowInterface.com lub WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.ADDON_VER.." dodatku WoWpoPolsku-Bubbles", 1,0.5,1);
         Version_max.ADDON_ALERT = 1;
      elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń zadań
         print("|cffffff00WoWpoPolsku-Bubbles:|r Dostępna jest nowa wersja |cffffff00"..Version_max.BASE_VER.."|r bazy tłumaczeń zadań do dodatku WoWpoPolsku-Bubbles z dnia |cffffff00"..Version_max.BASE_DATE.."|r");
         print("Możesz ją pobrać tylko z serwisu WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.BASE_VER.." bazy tlumaczen dymkow do dodatku WoWpoPolsku-Bubbles", 1,0.5,1);
         Version_max.BASE_ALERT = 1;
      end
      if (not BB_wait(5,BB_print_msg)) then
      --- czekaj 5 sek, aż skończy się dźwięk HornOfCentarius
      end
   end
end


-- Wyświetla komunikaty głosowe o dostępnej aktualizacji
function BB_print_msg()
   if (Version_max.ALERT_ID>3) then              -- sam dodatek
      if (BB_PM["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-dodatku.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 4;
   elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń
      if (BB_PM["voices"]=="1") then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-bazy-bubbless.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 2;
   else
      Version_max.ALERT_ID = 0;
   end
end


function BB_wait(delay, func, ...)
   if(type(delay)~="number" or type(func)~="function") then
      return false;
   end
   if (BB_waitFrame == nil) then
     BB_waitFrame = CreateFrame("Frame","BB_WaitFrame", UIParent);
     BB_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #BB_waitTable;
      local i = 1;
      while (i<=count) do
         local waitRecord = tremove(BB_waitTable,i);
         local d = tremove(waitRecord,1);
         local f = tremove(waitRecord,1);
         local p = tremove(waitRecord,1);
         if(d>elapse) then
            tinsert(BB_waitTable,i,{d-elapse,f,p});
            i = i + 1;
         else
            count = count - 1;
            f(unpack(p));
         end
      end
     end);
   end
   tinsert(BB_waitTable,{delay,func,{...}});
   return true;
end


function BB_ScrollFrame_OnMouseWheel(self, step)
   local newValue = self:GetVerticalScroll() - (step * 15);
   if (newValue < 0) then
      newValue = 0;
   elseif (newValue > self:GetVerticalScrollRange()) then
      newValue = self:GetVerticalScrollRange();
   end
   self:SetVerticalScroll(newValue);
end


function BB_ShowHideStatystyka()
   if (Players_ver_Count < 1) then          -- liczba graczy w tablicy Players_ver
      BB_STframe.count:SetText("1 ");
   else
      BB_STframe.count:SetText(tostring(Players_ver_Count));
   end
   local tabelka1 = "|cFF00FF00Nazwa gracza|r";
   local tabelka2 = string.format("|cFF00FF00%-20s %-18s %-15s|r", "Wersja dodatku", "Wersja bazy", "Data bazy tłum.");

   local alert = 0;
   table.sort(Players_ver);
   for Name,Value in pairs(Players_ver) do
      tabelka1 = tabelka1 .. "\n" .. Name;
      if (tonumber(Value.VERSION)>tonumber(string.sub(BB_version,1,1)..string.sub(BB_version,-2)) and (Value.VERSION==Version_max.ADDON_VER)) then
         Value.VERSION = "|cFFFFFF00"..Value.VERSION.."|r";    -- w kolorze żółtym
         alert = 4;
      end
      if (tonumber(Value.BASE)>tonumber(BB_base) and (Value.BASE==Version_max.BASE_VER)) then
         Value.BASE = "|cFFFFFF00"..Value.BASE.."|r";          -- w kolorze żółtym
         alert = alert + 2;
      end
      tabelka2 = tabelka2 .. "\n" .. string.format("%-30s  %-21s  %-15s", Value.VERSION, Value.BASE, Value.DATE);
   end
   if (alert > 3) then
      BB_STframe.alert:SetText("Dostępna jest nowa wersja dodatku: |cFFFFFF00" .. Version_max.ADDON_VER .. "|r");
   elseif (alert > 1 ) then
      BB_STframe.alert:SetText("Dostępna jest nowa wersja bazy tłumaczeń");
   end
   BB_STframe.tabela1:SetText(tabelka1);
   BB_STframe.tabela2:SetText(tabelka2);
   BB_STframe:Show();
end


local BBTR_f = CreateFrame("Frame");
BBTR_f:RegisterEvent("ADDON_LOADED");
BBTR_f:SetScript("OnEvent", BBTR_onEvent);

BBTR_f:RegisterEvent("CHAT_MSG_ADDON");      -- ukryty kanał addonu
C_ChatInfo.RegisterAddonMessagePrefix("WoWpoPolsku_BBTR");
