﻿-- Addon: WoWpoPolsku-Books (version: 9.02) 2022.09.17
-- Description: AddOn displays translated books.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)

-- General Variables
local BT_version=GetAddOnMetadata("WoWpoPolsku_Books", "Version");
if (not BT_base) then
   BT_base = "błąd";
end
-- fonty z polskimi znakami diakrytycznymi (także innych narodów)
local BT_Font = "Interface\\AddOns\\WoWpoPolsku_Books\\Fonts\\frizquadratatt_pl.ttf";
local BT_act_tr = "0";
local BT_bookID = "0";
local BT_tytul_en, BT_tytul_pl, BT_tekst_en, BT_tekst_pl = "";


function BookTranslator_ShowTranslation()
   if (BT_PM["active"] == "1") then
      BT_ToggleButton0:Show();		
      BT_ToggleButton0:Disable();		
      BT_ToggleButton0:SetText("EN");
      BT_ToggleButton0:SetWidth(40);
      BT_act_tr = "0";
      BT_tytul_en=ItemTextGetItem();
      BT_tekst_en=ItemTextGetText();
      BT_nr_str=tostring(ItemTextGetPage());
      local par1, par2, par3 = GetItemInfo(ItemTextGetItem());
      if (par2) then
         local pa1, itemID, pa3 = strsplit(":",par2);
         BT_bookID = itemID;
      else
         local BT_beginTXT=string.gsub(BT_tekst_en,"\n","");
         local BT_znacznik=BT_tytul_en.."#"..BT_nr_str.."#"..string.sub(BT_beginTXT,1,15);
         if (BT_BooksID[BT_znacznik]) then		          -- jest znacznik w bazie ID - pobierz bookID
            BT_bookID = BT_BooksID[BT_znacznik];          -- jako string
         end
      end
      if (BT_bookID) then
         if (BT_Books[BT_bookID]) then	                -- jest tłumaczenie tej książki
            if (BT_Books[BT_bookID][BT_nr_str]) then   	 -- jest tłumaczenie tej strony
               if (BT_PM["title"] == "1") then			    -- wyświetlaj tłumaczenie tytułu
                  BT_tytul_pl=BT_Books[BT_bookID]["Title"];
                  ItemTextFrameTitleText:SetText(BT_tytul_pl);
                  ItemTextFrameTitleText:SetFont(BT_Font, 13);
               end
               BT_tekst_pl=string.gsub(BT_Books[BT_bookID][BT_nr_str],"$B","\n");
               ItemTextPageText:SetText(BT_tekst_pl);
               if (BT_PM["setsize"]=="1") then
                  ItemTextPageText:SetFont(BT_Font, BT_PM["fontsize"]);
               else
                  ItemTextPageText:SetFont(BT_Font, 13);
               end
               if (BT_PM["showID"]=="1") then				 -- pokaż ID książki
                  BT_ToggleButton0:SetText("Book ID: "..BT_bookID.." (PL)");
                  BT_ToggleButton0:SetWidth(150);
               else
                  BT_ToggleButton0:SetText("PL");
               end
               BT_ToggleButton0:Enable();
               BT_act_tr = "1";		                      -- aktualnie jest wyświetlane polskie tłumaczenie
            else	                                        -- brak tłumaczenia
               if (BT_PM["showID"] == "1") then				 -- pokaż ID książki
                  BT_ToggleButton0:SetText("Book ID: "..BT_bookID.." (EN)");
                  BT_ToggleButton0:SetWidth(150);
	            end  
               BT_save_original();
            end
         else
            BT_save_original();       -- jest ID pisma,listu, ale nie ma tłumaczenia - zapisz je
         end
      end
   else	 
      BT_ToggleButton0:Hide();
   end
end 


function BT_save_original()
   if (BT_PM["saveNW"] == "1") then              -- zapisz tekst angielski do pliku
      if (strlen(BT_nr_str)==1) then
	      BT_nr_str="0"..BT_nr_str;
	   end
	   BT_SAVED[BT_bookID.." STR"..BT_nr_str]=BT_tytul_en.."@"..BT_tekst_en;
      DEFAULT_CHAT_FRAME:AddMessage("|cffffff00BTR: zapisuję pismo ID: "..BT_bookID);
   end
end


function BT_ON_OFF()
  if (BT_act_tr == "0") then
    BT_act_tr = "1";
    if (BT_PM["title"] == "1") then			 -- wyświetlaj tłumaczenie tytułu
	    ItemTextFrameTitleText:SetText(BT_tytul_pl);
	end
	ItemTextPageText:SetText(BT_tekst_pl);
	if (BT_PM["showID"]=="1") then				 -- pokaż ID książki
       BT_ToggleButton0:SetText("Book ID: "..BT_bookID.." (PL)");
	else
       BT_ToggleButton0:SetText("PL");
	end
  else
    BT_act_tr = "0";
    if (BT_PM["title"] == "1") then			 -- wyświetlaj tłumaczenie tytułu
	    ItemTextFrameTitleText:SetText(BT_tytul_en);
	end
	ItemTextPageText:SetText(BT_tekst_en);
	if (BT_PM["showID"]=="1") then				 -- pokaż ID książki
       BT_ToggleButton0:SetText("Book ID: "..BT_bookID.." (EN)");
	else
       BT_ToggleButton0:SetText("EN");
	end   
  end  
end


function BookTranslator_SlashCommand(msg)
  -- check the command
  if (msg) then
     local BT_command = string.lower(msg);                -- normalizacja, tylko małe litery
     if ((BT_command=="on") or (BT_command=="1")) then    -- włącz przełącznik aktywności
        BT_PM["active"]="1";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Books "..BT_Messages.is_now_active);
     elseif ((BT_command=="off") or (BT_command=="0")) then
        BT_PM["active"]="0";
        DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Books "..BT_Messages.is_now_not_active);
     else
  	     InterfaceOptionsFrame_Show();
  	     InterfaceOptionsFrame_OpenToCategory("WoWpoPolsku-Books");
     end   
  end
end


function BookTranslator_CheckVars()
  if (not BT_PM) then
     BT_PM = {};
  end
  if (not BT_SAVED) then
     BT_SAVED = {};
  end
  -- initialize check options
  if (not BT_PM["active"] ) then    -- dodatek aktywny
     BT_PM["active"] = "1";   
  end
  if (not BT_PM["title"] ) then     -- pokaż tłumaczenie tytułu
     BT_PM["title"] = "1";   
  end
--  if (not BT_PM["showID"] ) then    -- pokaż ID książki
--     BT_PM["showID"] = "0";   
--  end
  if (not BT_PM["setsize"] ) then   -- uaktywnij zmiany wielkości czcionki
     BT_PM["setsize"] = "0";   
  end
  if (not BT_PM["fontsize"] ) then  -- wielkość czcionki
     BT_PM["fontsize"] = "13";   
  end
  if (not BT_PM["saveNW"] ) then    -- zapisz nieprzetłumaczone
     BT_PM["saveNW"] = "1";   
  end
end
  
function BookTranslator_SetCheckButtonState()
  BookTranslatorCheckButton0:SetChecked(BT_PM["active"]=="1");
  BookTranslatorCheckButton1:SetChecked(BT_PM["title"]=="1");
--  BookTranslatorCheckButton3:SetChecked(BT_PM["showID"]=="1");
  BookTranslatorCheckButton5:SetChecked(BT_PM["saveNW"]=="1");
  BookTranslatorCheckSize:SetChecked(BT_PM["setsize"]=="1");
  local fontsize = tonumber(BT_PM["fontsize"]);
  BookTranslatorslider:SetValue(fontsize);
  if (TB_PM["setsize"]=="1") then
     BookTranslatorOpis1:SetFont(BT_Font, fontsize);
  else   
     BookTranslatorOpis1:SetFont(BT_Font, 13);
  end
end


function BookTranslator_BlizzardOptions()

-- Create main frame for information text
local BookTranslatorOptions = CreateFrame("FRAME", "BookTranslatorOptions");
--BookTranslatorOptions:SetScript("OnShow", function(self) BookTranslator_SetCheckButtonState() end);
BookTranslatorOptions.refresh = function (self) BookTranslator_SetCheckButtonState() end;
BookTranslatorOptions.name = "WoWpoPolsku-Books";
InterfaceOptions_AddCategory(BookTranslatorOptions);

local BookTranslatorOptionsHeader = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
BookTranslatorOptionsHeader:SetFontObject(GameFontNormalLarge);
BookTranslatorOptionsHeader:SetJustifyH("LEFT"); 
BookTranslatorOptionsHeader:SetJustifyV("TOP");
BookTranslatorOptionsHeader:ClearAllPoints();
BookTranslatorOptionsHeader:SetPoint("TOPLEFT", 16, -16);
BookTranslatorOptionsHeader:SetText("WoWpoPolsku-Books, ver. "..BT_version.." ("..BT_base..") by Platine © 2017-2022");

local BookOptionsDate = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
BookOptionsDate:SetFontObject(GameFontNormalLarge);
BookOptionsDate:SetJustifyH("LEFT"); 
BookOptionsDate:SetJustifyV("TOP");
BookOptionsDate:ClearAllPoints();
BookOptionsDate:SetPoint("TOPRIGHT", BookTranslatorOptionsHeader, "TOPRIGHT", 0, -22);
BookOptionsDate:SetText("Data bazy tłumaczeń: "..BT_date);
BookOptionsDate:SetFont(BT_Font, 16);

local BookTranslatorCheckButton0 = CreateFrame("CheckButton", "BookTranslatorCheckButton0", BookTranslatorOptions, "OptionsCheckButtonTemplate");
BookTranslatorCheckButton0:SetPoint("TOPLEFT", BookTranslatorOptionsHeader, "BOTTOMLEFT", 0, -40);
BookTranslatorCheckButton0:SetScript("OnClick", function(self) if (BT_PM["active"]=="1") then BT_PM["active"]="0" else BT_PM["active"]="1" end; end);
BookTranslatorCheckButton0Text:SetFont(BT_Font, 13);
BookTranslatorCheckButton0Text:SetText(BT_Interface.active);     -- dodatek aktywny

local BookTranslatorCheckButton1 = CreateFrame("CheckButton", "BookTranslatorCheckButton1", BookTranslatorOptions, "OptionsCheckButtonTemplate");
BookTranslatorCheckButton1:SetPoint("TOPLEFT", BookTranslatorCheckButton0, "BOTTOMLEFT", 20, -10);
BookTranslatorCheckButton1:SetScript("OnClick", function(self) if (BT_PM["title"]=="1") then BT_PM["title"]="0" else BT_PM["title"]="1" end; end);
BookTranslatorCheckButton1Text:SetFont(BT_Font, 13);
BookTranslatorCheckButton1Text:SetText(BT_Interface.title);      -- tłumacz tytuł

--local BookTranslatorCheckButton3 = CreateFrame("CheckButton", "BookTranslatorCheckButton3", BookTranslatorOptions, "OptionsCheckButtonTemplate");
--BookTranslatorCheckButton3:SetPoint("TOPLEFT", BookTranslatorCheckButton1, "BOTTOMLEFT", 0, 0);
--BookTranslatorCheckButton3:SetScript("OnClick", function(self) if (BT_PM["showID"]=="1") then BT_PM["showID"]="0" else BT_PM["showID"]="1"; end; end);
--BookTranslatorCheckButton3Text:SetFont(BT_Font, 13);
--BookTranslatorCheckButton3Text:SetText(BT_Interface.showID);     -- pokaż nr ID książki

local BookTranslatorCheckButton5 = CreateFrame("CheckButton", "BookTranslatorCheckButton5", BookTranslatorOptions, "OptionsCheckButtonTemplate");
BookTranslatorCheckButton5:SetPoint("TOPLEFT", BookTranslatorCheckButton1, "BOTTOMLEFT", 0, 0);
BookTranslatorCheckButton5:SetScript("OnClick", function(self) if (BT_PM["saveNW"]=="1") then BT_PM["saveNW"]="0" else BT_PM["saveNW"]="1" end; end);
BookTranslatorCheckButton5Text:SetFont(BT_Font, 13);
BookTranslatorCheckButton5Text:SetText(BT_Interface.saveNW);     -- zapisz nieprzetłumaczone książki

local BookTranslatorCheckSize = CreateFrame("CheckButton", "BookTranslatorCheckSize", BookTranslatorOptions, "OptionsCheckButtonTemplate");
BookTranslatorCheckSize:SetPoint("TOPLEFT", BookTranslatorCheckButton5, "BOTTOMLEFT", 0, -20);
BookTranslatorCheckSize:SetScript("OnClick", function(self) if (BT_PM["setsize"]=="1") then BT_PM["setsize"]="0" else BT_PM["setsize"]="1" end; end);
BookTranslatorCheckSizeText:SetText("uaktywnij funkcję zmiany wielkości czcionki (nie zawsze działa)");   
BookTranslatorCheckSizeText:SetFont(BT_Font, 13);

local BookTranslatorslider = CreateFrame("Slider", "BookTranslatorslider", BookTranslatorOptions, "OptionsSliderTemplate");
BookTranslatorslider:SetPoint("TOPLEFT", BookTranslatorCheckSize, "BOTTOMLEFT", 10, -20);
BookTranslatorslider:SetMinMaxValues(10, 20);
BookTranslatorslider.minValue, BookTranslatorslider.maxValue = BookTranslatorslider:GetMinMaxValues();
BookTranslatorslider.Low:SetText(BookTranslatorslider.minValue);
BookTranslatorslider.High:SetText(BookTranslatorslider.maxValue);
getglobal(BookTranslatorslider:GetName() .. 'Text'):SetText('Wielkość czcionki');
getglobal(BookTranslatorslider:GetName() .. 'Text'):SetFont(BT_Font, 13);
BookTranslatorslider:SetValue(tonumber(BT_PM["fontsize"]));
BookTranslatorslider:SetValueStep(1);
BookTranslatorslider:SetScript("OnValueChanged", function(self,event,arg1) 
                                      BT_PM["fontsize"]=string.format("%d",event); 
                                      BookTranslatorsliderVal:SetText(BT_PM["fontsize"]);
									           BookTranslatorOpis1:SetFont(BT_Font, event);
                                      end);
BookTranslatorsliderVal = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
BookTranslatorsliderVal:SetFontObject(GameFontNormal);
BookTranslatorsliderVal:SetJustifyH("CENTER");
BookTranslatorsliderVal:SetJustifyV("TOP");
BookTranslatorsliderVal:ClearAllPoints();
BookTranslatorsliderVal:SetPoint("CENTER", BookTranslatorslider, "CENTER", 0, -12);
BookTranslatorsliderVal:SetText(BT_PM["fontsize"]);   
BookTranslatorsliderVal:SetFont(BT_Font, 13);

BookTranslatorOpis1 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
BookTranslatorOpis1:SetFontObject(GameFontNormalLarge);
BookTranslatorOpis1:SetJustifyH("LEFT");
BookTranslatorOpis1:SetJustifyV("TOP");
BookTranslatorOpis1:ClearAllPoints();
BookTranslatorOpis1:SetPoint("TOPLEFT", BookTranslatorslider, "BOTTOMLEFT", 200, 30);
local fontsize = tonumber(BT_PM["fontsize"]);
if (BT_PM["setsize"]=="1") then
   BookTranslatorOpis1:SetFont(BT_Font, fontsize);
else
   BookTranslatorOpis1:SetFont(BT_Font, 13);
end
BookTranslatorOpis1:SetText("Przykładowy tekst wielkości czcionki");

local IOF_Height = InterfaceOptionsFrame:GetHeight();
   if (IOF_Height>658) then

   local BookTranslatorText0 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
   BookTranslatorText0:SetFontObject(GameFontWhite);
   BookTranslatorText0:SetJustifyH("LEFT");
   BookTranslatorText0:SetJustifyV("TOP");
   BookTranslatorText0:ClearAllPoints();
   BookTranslatorText0:SetPoint("TOPLEFT", BookTranslatorslider, "BOTTOMLEFT", -5, -50);
   BookTranslatorText0:SetFont(BT_Font, 13);
   BookTranslatorText0:SetText("Szybkie komendy z linii czatu");

   local BookTranslatorText7 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
   BookTranslatorText7:SetFontObject(GameFontWhite);
   BookTranslatorText7:SetJustifyH("LEFT");
   BookTranslatorText7:SetJustifyV("TOP");
   BookTranslatorText7:ClearAllPoints();
   BookTranslatorText7:SetPoint("TOPLEFT", BookTranslatorText0, "BOTTOMLEFT", 0, -10);
   BookTranslatorText7:SetFont(BT_Font, 13);
   BookTranslatorText7:SetText("/btr   aby wywołać to okno ustawień dodatku");

   local BookTranslatorText1 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
   BookTranslatorText1:SetFontObject(GameFontWhite);
   BookTranslatorText1:SetJustifyH("LEFT");
   BookTranslatorText1:SetJustifyV("TOP");
   BookTranslatorText1:ClearAllPoints();
   BookTranslatorText1:SetPoint("TOPLEFT", BookTranslatorText7, "BOTTOMLEFT", 0, -10);
   BookTranslatorText1:SetFont(BT_Font, 13);
   BookTranslatorText1:SetText("/btr 1  lub  /btr on   aby aktywować addon");

   local BookTranslatorText2 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
   BookTranslatorText2:SetFontObject(GameFontWhite);
   BookTranslatorText2:SetJustifyH("LEFT");
   BookTranslatorText2:SetJustifyV("TOP");
   BookTranslatorText2:ClearAllPoints();
   BookTranslatorText2:SetPoint("TOPLEFT", BookTranslatorText1, "BOTTOMLEFT", 0, -4);
   BookTranslatorText2:SetFont(BT_Font, 13);
   BookTranslatorText2:SetText("/btr 0  lub  /btr off   aby deaktywawć addon");
end

local BBWWW1 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
BBWWW1:SetFontObject(GameFontWhite);
BBWWW1:SetJustifyH("LEFT");
BBWWW1:SetJustifyV("TOP");
BBWWW1:ClearAllPoints();
BBWWW1:SetPoint("BOTTOMLEFT", 16, 16);
BBWWW1:SetFont(BT_Font, 13);
BBWWW1:SetText("Odwiedź stronę WWW dodatku:");
  
local BBWWW2 = CreateFrame("EditBox", "BBWWW2", BookTranslatorOptions, "InputBoxTemplate");
BBWWW2:ClearAllPoints();
BBWWW2:SetPoint("TOPLEFT", BBWWW1, "TOPRIGHT", 10, 4);
BBWWW2:SetHeight(20);
BBWWW2:SetWidth(200);
BBWWW2:SetAutoFocus(false);
BBWWW2:SetFontObject(GameFontGreen);
BBWWW2:SetText("http://wowpopolsku.pl");
BBWWW2:SetCursorPosition(0);
BBWWW2:SetScript("OnEnter", function(self)
   GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
   getglobal("GameTooltipTextLeft1"):SetFont(BT_Font, 13);
   GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
   GameTooltip:Show() --Show the tooltip
   end);
BBWWW2:SetScript("OnLeave", function(self)
   GameTooltip:Hide() --Hide the tooltip
   end);
BBWWW2:SetScript("OnTextChanged", function(self) BBWWW2:SetText("http://wowpopolsku.pl"); end);

  local BBdiscord2 = CreateFrame("EditBox", "BBWWW2", BookTranslatorOptions, "InputBoxTemplate");
  BBdiscord2:ClearAllPoints();
  BBdiscord2:SetPoint("BOTTOMLEFT", BBWWW2, "TOPLEFT", 0, 5);
  BBdiscord2:SetHeight(20);
  BBdiscord2:SetWidth(200);
  BBdiscord2:SetAutoFocus(false);
  BBdiscord2:SetFontObject(GameFontGreen);
  BBdiscord2:SetText("https://discord.gg/s5rKEJMukA");
  BBdiscord2:SetCursorPosition(0);
  BBdiscord2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(BT_Font, 13);
     GameTooltip:SetText("kliknij i wciśnij Ctrl+C aby skopiować do schowka", nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  BBdiscord2:SetScript("OnLeave", function(self)
--      getglobal("GameTooltipTextLeft1"):SetFont(Original_Font, 13);
	  GameTooltip:Hide() --Hide the tooltip
     end);
  BBdiscord2:SetScript("OnTextChanged", function(self) BBdiscord2:SetText("https://discord.gg/s5rKEJMukA"); end);

  local BBdiscord1 = BookTranslatorOptions:CreateFontString(nil, "ARTWORK");
  BBdiscord1:SetFontObject(GameFontWhite);
  BBdiscord1:SetJustifyH("LEFT");
  BBdiscord1:SetJustifyV("TOP");
  BBdiscord1:ClearAllPoints();
  BBdiscord1:SetPoint("TOPRIGHT", BBdiscord2, "TOPLEFT", -10, -4);
  BBdiscord1:SetFont(BT_Font, 13);
  BBdiscord1:SetText("Discord:");
  
end


--function BT_OnEvent()
--   local unit = GameTooltip:GetUnit();
--   DEFAULT_CHAT_FRAME:AddMessage(unit);
--end

ItemTextFrame:HookScript("OnShow", function() BookTranslator_ShowTranslation() end);
ItemTextNextPageButton:HookScript("OnClick", function() BookTranslator_ShowTranslation() end);
ItemTextPrevPageButton:HookScript("OnClick", function() BookTranslator_ShowTranslation() end);
SlashCmdList["WOWPOPOLSKU_BOOKS"] = function(msg) BookTranslator_SlashCommand(msg); end
SLASH_WOWPOPOLSKU_BOOKS1 = "/wowpopolsku-books";
SLASH_WOWPOPOLSKU_BOOKS2 = "/btr";
BookTranslator_CheckVars();
BookTranslator_BlizzardOptions();
BT_ToggleButton0 = CreateFrame("Button",nil, ItemTextFrame, "UIPanelButtonTemplate");
BT_ToggleButton0:SetWidth(40);
BT_ToggleButton0:SetHeight(20);
BT_ToggleButton0:SetText("EN");
BT_ToggleButton0:Show();
BT_ToggleButton0:ClearAllPoints();
BT_ToggleButton0:SetPoint("BOTTOMRIGHT", ItemTextFrame, "BOTTOMRIGHT", -28, 5);
BT_ToggleButton0:SetScript("OnClick", BT_ON_OFF);
--BT_Frame = CreateFrame("Frame");
--BT_Frame:SetScript("OnEvent", BT_OnEvent);
--BT_Frame:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
--GameTooltip:HookScript("OnShow", function() BT_OnEvent() end);

DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Books ver. "..BT_version.." - "..BT_Messages.loaded);
