﻿-- Addon: WoWpoPolsku-Tutorials (Wersja: 10.03) 2023.07.22
-- Description: Dodatek wyświetla tłumaczenia instrukcji wyświetlanych podczas gry
-- Autor: Platine  (e-mail: platine.wow@gmail.com)

-- Zmienne Globalne
local _G = _G;
local TT_version = GetAddOnMetadata("WoWpoPolsku_Tutorials", "Version");
local tutMainFrameShow = 0;           -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local tutWalkShow = 0;                -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local tutKeyboardMouseFrameShow = 0;  -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local tutSingleKeyShow = 0;           -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local TT_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local aktShow = {};                   -- tablica aktualnie przypisanych zdarzeń OnShow do NPE_PointerFrame
local TT_waitTable = {};
local TT_waitFrame = nil;
local TT_firstUse = 0;
for i=1,20,1 do
   aktShow[i] = 0;
end

-- Fonty z polskimi znakami diakrytycznymi (ąćęńłóśżź ĄĆĘŃŁÓŚŻŹ)
local TT_Font = "Interface\\AddOns\\WoWpoPolsku_Tutorials\\Fonts\\frizquadratatt_pl.ttf";


local function StringHash(text)           -- funkcja tworząca Hash (32-bitowa liczba) podanego tekstu
  local counter = 1;
  local pomoc = 0;
  local dlug = string.len(text);
  for i = 1, dlug, 3 do 
    counter = math.fmod(counter*8161, 4294967279);  -- 2^32 - 17: Prime!
    pomoc = (string.byte(text,i)*16776193);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+1) or (dlug-i+256))*8372226);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+2) or (dlug-i+256))*3932164);
    counter = counter + pomoc;
  end
  return math.fmod(counter, 4294967291) -- 2^32 - 5: Prime (and different from the prime in the loop)
end


function TT_wait(delay, func, ...)
  if(type(delay)~="number" or type(func)~="function") then
    return false;
  end
  if (TT_waitFrame == nil) then
    TT_waitFrame = CreateFrame("Frame","TT_WaitFrame", UIParent);
    TT_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #TT_waitTable;
      local i = 1;
      while(i<=count) do
        local waitRecord = tremove(TT_waitTable,i);
        local d = tremove(waitRecord,1);
        local f = tremove(waitRecord,1);
        local p = tremove(waitRecord,1);
        if(d>elapse) then
          tinsert(TT_waitTable,i,{d-elapse,f,p});
          i = i + 1;
        else
          count = count - 1;
          f(unpack(p));
        end
      end
    end);
  end
  tinsert(TT_waitTable,{delay,func,{...}});
  return true;
end


function TT_OnEvent(self, event, ...)
--print(event)
   if (event=="TUTORIAL_TRIGGER") then
--print("TT-trigger=");
      TT_onTutorialShow();
   elseif (event=="ADDON_LOADED") then
      TT_onTutorialShow();
--   elseif (event=="CVAR_UPDATE") then
--print("CVAR_UPDATE")   
   end
end


function TT_onTutorialShow_Time()
--   if ((TT_PS["tutorial"] == "1") and (InterfaceOptionsDisplayPanelShowTutorials.value=="1"))then
      if (not TT_wait(0.2,TT_onTutorialShow)) then
         -- opóźnienie 0.2 sek
      end
--   end
end


function TT_onTutorialShow()
   local obj,txt,id;
   obj = "TutorialMainFrame_Frame";
   if (_G[obj]) then
      if (tutMainFrameShow==0) then
         _G[obj].ContainerFrame:SetScript("OnUpdate", TT_onTutorialShow_Time);
         tutMainFrameShow = 1;
      end
   end
   
   obj = "TutorialWalk_Frame";
   if (_G[obj]) then
      if (tutWalkShow==0) then
         _G[obj]:SetScript("OnUpdate", TT_onTutorialShow_Time);
         tutWalkShow = 1;
      end
   end
   
   obj = "TutorialKeyboardMouseFrame_Frame";
   if (_G[obj]) then
      if (tutKeyboardMouseFrameShow==0) then
         _G[obj]:SetScript("OnUpdate", TT_onTutorialShow_Time);
         tutKeyboardMouseFrameShow = 1;
      end
   end
   
   obj = "TutorialSingleKey_Frame";
   if (_G[obj]) then
      if (tutSingleKeyShow==0) then
         _G[obj]:SetScript("OnUpdate", TT_onTutorialShow_Time);
         tutSingleKeyShow = 1;
      end
   end
   TT_SprawdzFrames();
   
   for i=1,20,1 do
      obj = "TutorialPointerFrame_"..tostring(i).."Content";
      if (_G[obj]) then
         if (aktShow[i]==0) then
            _G[obj]:SetScript("OnUpdate", TT_onTutorialShow);
            aktShow[i] = 1;
         end
         if ((_G[obj]:IsVisible()) and (_G[obj].Text)) then
            txt = _G[obj].Text:GetText();
            if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
               id = StringHash(txt);
               if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
                  local _font5, _size5, _35 = _G[obj].Text:GetFont();
                  _G[obj].Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
                  _G[obj].Text:SetFont(TT_Font, _size5);
               else
               TT_TUTORIALS[tostring(id)] = txt;
               end
            end
         end
      end
   end
end


function TT_SprawdzFrames()
   local obj,txt,id;
   obj = "TutorialMainFrame_Frame";
   if ((_G[obj]) and (_G[obj].ContainerFrame) and (_G[obj].ContainerFrame:IsVisible()) and (_G[obj].ContainerFrame.Text)) then
      txt = _G[obj].ContainerFrame.Text:GetText();               -- odczytaj tekst oryginalny
      if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         id = StringHash(txt);
         if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
            local _font5, _size5, _35 = _G[obj].ContainerFrame.Text:GetFont();
            if (_size5 > 20) then
               _size5 = _size5 - 3;
            elseif (_size5 > 15) then
               _size5 = _size5 - 2;
            elseif (_size5 > 10) then
               _size5 = _size5 - 1;
            end
            _G[obj].ContainerFrame.Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
            _G[obj].ContainerFrame.Text:SetFont(TT_Font, _size5);
         else
            TT_TUTORIALS[tostring(id)] = txt;
         end
      end
   end
   obj = "TutorialWalk_Frame";
   if ((_G[obj]) and (_G[obj].ContainerFrame) and (_G[obj].ContainerFrame:IsVisible()) and (_G[obj].ContainerFrame.Text)) then
      txt = _G[obj].ContainerFrame.Text:GetText();               -- odczytaj tekst oryginalny
      if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         id = StringHash(txt);
         if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
            local _font5, _size5, _35 = _G[obj].ContainerFrame.Text:GetFont();
            if (_size5 > 20) then
               _size5 = _size5 - 3;
            elseif (_size5 > 15) then
               _size5 = _size5 - 2;
            elseif (_size5 > 10) then
               _size5 = _size5 - 1;
            end
            _G[obj].ContainerFrame.Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
            _G[obj].ContainerFrame.Text:SetFont(TT_Font, _size5);
         else
            TT_TUTORIALS[tostring(id)] = txt;
         end
      end
   end
   obj = "TutorialKeyboardMouseFrame_Frame";
   if ((_G[obj]) and (_G[obj]:IsVisible()) and (_G[obj].Text)) then
      txt = _G[obj].Text:GetText();               -- odczytaj tekst oryginalny
      if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         id = StringHash(txt);
         if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
            local _font5, _size5, _35 = _G[obj].Text:GetFont();
            if (_size5 > 20) then
               _size5 = _size5 - 3;
            elseif (_size5 > 15) then
               _size5 = _size5 - 2;
            elseif (_size5 > 10) then
               _size5 = _size5 - 1;
            end
            _G[obj].Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
            _G[obj].Text:SetFont(TT_Font, _size5);
         else
            TT_TUTORIALS[tostring(id)] = txt;
         end
      end
   end
   obj = "TutorialSingleKey_Frame";
   if ((_G[obj]) and (_G[obj].ContainerFrame) and (_G[obj].ContainerFrame:IsVisible()) and (_G[obj].ContainerFrame.Text)) then
      txt = _G[obj].ContainerFrame.Text:GetText();               -- odczytaj tekst oryginalny
      if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         id = StringHash(txt);
         if (Tut_Data7[tostring(id)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
            local _font5, _size5, _35 = _G[obj].ContainerFrame.Text:GetFont();
            if (_size5 > 20) then
               _size5 = _size5 - 3;
            elseif (_size5 > 15) then
               _size5 = _size5 - 2;
            elseif (_size5 > 10) then
               _size5 = _size5 - 1;
            end
            _G[obj].ContainerFrame.Text:SetText(Spr_Gender(Tut_Data7[tostring(id)]));  -- podmieniamy tekst na nasze tłumaczenie
            _G[obj].ContainerFrame.Text:SetFont(TT_Font, _size5);
         else
            TT_TUTORIALS[tostring(id)] = txt;
         end
      end
   end
end


function TT_onChoiceDelay()
   if (not TT_wait(0.5,TT_onChoiceShow)) then
      -- opóźnienie 0.5 sek
   end
end


function TT_onChoiceOpen()
   PlayerChoiceFrame:Show();
end


function TT_onChoiceShow()
   local txt = PlayerChoiceFrame.Title.Text:GetText();
   if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
      local hash = StringHash(txt);
      if (Tut_Data7[tostring(hash)]) then         -- jest polskie tłumaczenie w bazie tłumaczeń
         local _font6, _size6, _36 = PlayerChoiceFrame.Title.Text:GetFont();
         PlayerChoiceFrame.Title.Text:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
         PlayerChoiceFrame.Title.Text:SetFont(TT_Font, _size6);
      else
         TT_TUTORIALS[tostring(hash)] = txt;
      end
   end
   if (PlayerChoiceFrame.Option1) then
     if (PlayerChoiceFrame.Option1.OptionText) then
       local obj = PlayerChoiceFrame.Option1.OptionText.HTML:GetRegions();
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         txt = string.gsub(txt, '\r', '');         -- usuń \r, ale pozostaw \n
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end
     if (PlayerChoiceFrame.Option1.OptionButtonsContainer.button1) then      -- przycisk
       local obj = PlayerChoiceFrame.Option1.OptionButtonsContainer.button1;
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj.Text:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj.Text:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end
   end
   
   if (PlayerChoiceFrame.Option2) then
     if (PlayerChoiceFrame.Option2.OptionText) then
       local obj = PlayerChoiceFrame.Option2.OptionText.HTML:GetRegions();
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         txt = string.gsub(txt, '\r', '');         -- usuń \r, ale pozostaw \n
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end
     if (PlayerChoiceFrame.Option2.OptionButtonsContainer.button1) then      -- przycisk
       local obj = PlayerChoiceFrame.Option2.OptionButtonsContainer.button1;
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj.Text:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj.Text:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end
   end
   
   if (PlayerChoiceFrame.Option3) then
     if (PlayerChoiceFrame.Option3.OptionText) then
       local obj = PlayerChoiceFrame.Option3.OptionText.HTML:GetRegions();
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         txt = string.gsub(txt, '\r', '');         -- usuń \r, ale pozostaw \n
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end
     if (PlayerChoiceFrame.Option3.OptionButtonsContainer.button1) then      -- przycisk
       local obj = PlayerChoiceFrame.Option3.OptionButtonsContainer.button1;
       txt = obj:GetText();
       if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         hash= StringHash(txt);
         if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
            local _font7, _size7, _37 = obj.Text:GetFont();
            obj:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
            obj.Text:SetFont(TT_Font, _size7);
         else                                      -- nie ma tłumaczenia - zapisujemy
            TT_TUTORIALS[tostring(hash)] = txt;
         end
       end
     end  
   end
   if (TT_firstUse == 0) then      -- pierwsze uruchomienie - trzeba jeszcze raz przeładować ramkę
      TT_firstUse = 1;
      PlayerChoiceFrame:Hide();
      UIErrorsFrame:AddMessage("Otwórz Tablice Ogloszen jeszcze raz.", 1,0.5,1);     
   end
end


function Spr_Gender(msg)
   local nr_1, nr_2, nr_3 = 0;
   local TT_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do   -- szykaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (TT_sex==3) then        -- forma żeńska
                  TT_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  TT_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. TT_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end
   return msg;
end


hooksecurefunc(HelpTip,"Show", 
   function(self)
      local frame;
      for frame in self.framePool:EnumerateActive() do
         if frame.info.system == "MicroButtons" then
            local txt = frame.Text:GetText();
            if ((txt) and (string.find(txt," ")==nil)) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
               local hash= StringHash(txt);
               if (Tut_Data7[tostring(hash)]) then       -- jest tłumacznie tego tekstu
                  local _font8, _size8, _38 = frame.Text:GetFont();
                  frame.Text:SetText(Spr_Gender(Tut_Data7[tostring(hash)]));  -- podmieniamy tekst na nasze tłumaczenie
                  frame.Text:SetFont(TT_Font, _size8);
               else                                      -- nie ma tłumaczenia - zapisujemy
                  TT_TUTORIALS[tostring(hash)] = txt;
               end
            end
         end
      end
   end
)


TT_Frame = CreateFrame("Frame");
TT_Frame:SetScript("OnEvent", TT_OnEvent);
TT_Frame:RegisterEvent("TUTORIAL_TRIGGER");
TT_Frame:RegisterEvent("ADDON_LOADED");
--TT_Frame:RegisterEvent("CVAR_UPDATE");
TutorialFrame:HookScript("OnShow", TT_onTutorialShow);
if (not PlayerChoiceFrame) then
   PlayerChoice_LoadUI();
end
PlayerChoiceFrame:HookScript("OnShow", TT_onChoiceDelay);
--NPE_PointerFrame:HookScript("OnShow", TT_onTutorialShow);
--NewPlayerExperience:HookScript("OnShow", TT_onTutorialShow);
if (not TT_PS) then
   TT_PS = {};
end
if (not TT_TUTORIALS) then
   TT_TUTORIALS = {};
end

DEFAULT_CHAT_FRAME:AddMessage("|cffffff00WoWpoPolsku-Tutorials ver. "..TT_version.." - uruchomiono");

local TTR = CreateFrame("Frame");
TTR.WelcomePanel = CreateFrame("Frame", nil, UIParent, "UIPanelDialogTemplate");
TTR.WelcomePanel:SetWidth(600);
TTR.WelcomePanel:SetHeight(300);
TTR.WelcomePanel:ClearAllPoints();
TTR.WelcomePanel:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
TTR.WelcomePanel:SetFrameStrata("TOOLTIP");
TTR.WelcomePanel.Title:SetText("WoWpoPolsku - Tutorials");
TTR.WelcomePanel.Text = TTR.WelcomePanel:CreateFontString(nil, "ARTWORK");
TTR.WelcomePanel.Text:SetFontObject(GameFontWhite);
TTR.WelcomePanel.Text:SetJustifyH("LEFT"); 
TTR.WelcomePanel.Text:SetJustifyV("TOP");
TTR.WelcomePanel.Text:ClearAllPoints();
TTR.WelcomePanel.Text:SetPoint("TOPLEFT", TTR.WelcomePanel, "TOPLEFT", 20, -40);
TTR.WelcomePanel.Text:SetWidth(570);
TTR.WelcomePanel.Text:SetText("UWAGA użytkownicy dodatku |cffff00ffWoWpoPolsku - Tutorials|r!\n\nDodatek |cffff00ffWoWpoPolsku - Tutorials|r nie będzie już więcej utrzymywany.\n\nAle w jego miejsce uruchamiamy zupełnie nowy, zintegrowany dodatek\n|cff00ffffAll-in-One|r zawierający w jednym dodatku wszystkie dostępne dodatki w ramach projektu |cff00ffffWoWpoPolsku|r.\n\nNazwa tego jednego dodatku, to po prostu: |cffff00ffWoWpoPolsku|r\n\nZapraszamy już dziś do pobrania nowego dodatku.\n\n\n|cffff00ffPlatine|r - autor");
TTR.WelcomePanel.Text:SetFont(TT_Font, 15);
TTR.WelcomePanel.Button = CreateFrame("Button",nil, TTR.WelcomePanel, "UIPanelButtonTemplate");
TTR.WelcomePanel.Button:SetWidth(160);
TTR.WelcomePanel.Button:SetHeight(20);
TTR.WelcomePanel.Button:SetText("OK - przeczytano");
TTR.WelcomePanel.Button:ClearAllPoints();
TTR.WelcomePanel.Button:SetPoint("BOTTOMLEFT", TTR.WelcomePanel, "BOTTOMLEFT", TTR.WelcomePanel:GetWidth()/2-TTR.WelcomePanel.Button:GetWidth()/2, 10);
TTR.WelcomePanel.Button:Show();
TTR.WelcomePanel.Button:SetScript("OnClick", function() TTR.WelcomePanel:Hide(); end);
TTR.WelcomePanel:Show();
