﻿-- Addon: WoWpoPolsku_Quests (wersja: 10.05) 2023.07.22
-- Opis: AddOn wyświetla przetłumaczone questy w języku polskim.
-- Autor: Platine  (e-mail: platine.wow@gmail.com)
-- Addon project page: https://wowpopolsku.pl
-- Special thanks to developer Vrul for preparing extension Enum-functions

-- Zmienne lokalne
local QTR_version = GetAddOnMetadata("WoWpoPolsku_Quests", "Version");
local QTR_onDebug = false;      
local QTR_name = UnitName("player");
local QTR_class= UnitClass("player");
local QTR_race = UnitRace("player");
local QTR_sex = UnitSex("player");     -- 1:neutral,  2:męski,  3:żeński
local QTR_waitTable = {};
local QTR_waitFrame = nil;
local QTR_MessOrig = {
      details    = "Description", 
      objectives = "Quest Objectives", 
      rewards    = "Rewards", 
      itemchoose0= "You will receive:",
      itemchoose1= "You will be able to choose one of these rewards:", 
      itemchoose2= "Choose one of these rewards:", 
      itemchoose3= "You receiving the reward:",
      itemreceiv0= "You will receive:",
      itemreceiv1= "You will also receive:", 
      itemreceiv2= "You receiving the reward:", 
      itemreceiv3= "You also receiving the reward:",
      learnspell = "Learn Spell:", 
      reqmoney   = "Required Money:", 
      reqitems   = "Required items:", 
      experience = "Experience:", 
      currquests = "Current Quests", 
      avaiquests = "Available Quests", 
      reward_aura      = "The following will be cast on you:", 
      reward_spell     = "You will learn the following:", 
      reward_companion = "You will gain these Companions:", 
      reward_follower  = "You will gain these followers:", 
      reward_reputation= "Reputation awards:", 
      reward_title     = "You shall be granted the title:", 
      reward_tradeskill= "You will learn how to create::", 
      reward_unlock    = "You will unlock access to the following:", 
      reward_bonus     = "Completing this quest while in Party Sync may reward:", 
      };
local QTR_quest_ID = 0;      
local QTR_quest_EN = { };      
local QTR_quest_LG = { };      
      QTR_quest_EN[0] = { };
      QTR_quest_LG[0] = { };
local QTR_Reklama = {
      ON = "Reklamuj dodatek na czacie kanału nr:",
      PERIOD= "Określ czas pomiędzy kolejnymi reklamami:",
      CHOICE1= "Który tekst wyświetlać?",
      CHOICE2= "(gdy zaznaczysz oba, to naprzemian):",
      OTHER1= "tłumacz w dodatku ClassicQuestLog ",
      OTHER2= "tłumacz w dodatku Immersion ",
      OTHER3= "tłumacz w dodatku Storyline ",
      ACTIV1= "(aktywny)",
      ACTIV2= "(nieaktywny)",
      WWW1  = "Odwiedź stronę WWW dodatku:",
      WWW2  = "https://wowpopolsku.pl",
      WWW3  = "kliknij i wciśnij Ctrl+C aby skopiować do schowka",
      TEXT1 = "WoWpoPolsku-Quests - addon that displays the translated quests (wowpopolsku.pl)",
      TEXT2 = "WoWpoPolsku-Quests - dodatek wyświetlający questy po polsku (wowpopolsku.pl)", };
local last_time = GetTime();
local last_text = 0;
local curr_trans = "1";
local curr_goss = "X";
local curr_hash = 0;
local QTR_first_show = 0;
local QTR_first_show2 = 0;
local QTR_first_voice = 0;
local QTR_first_gs_show = 0;
local QTR_first_gs_voice = 0;
local QTR_ModelTextHash = 0;
local QTR_ModelText_EN = ""; 
local QTR_ModelText_PL = ""; 
local aktShow = 0;      -- liczba aktualnie przypisanych zdarzeń OnShow do NPE_PointerFrame
local tutShow = 0;      -- znacznik przypisania skryptu od wyświetlenia okienka tutoriału
local Original_Font1 = "Fonts\\MORPHEUS.ttf";
local Original_Font2 = "Fonts\\FRIZQT__.ttf";
local QTR_FrameOnLine, QTR_FrameOnLineButton, QTR_FrameOnLineHash;
local Tut_ID = 0;
local Tut_race = string.gsub(strupper(QTR_race)," ","");
local Tut_class= string.gsub(strupper(QTR_class)," ","");
if (Tut_class == "DEATHKNIGHT") then
   Tut_race = "DEATHKNIGHT";
end
local quest_numReward = {};       -- liczba dostępnych nagród do questu
local time_ver = GetTime() - 15*60;
local Players_ver = {};           -- wersje dodatku innych graczy
local Players_ver_Count = 0;
local Version_max = {ADDON_VER=string.sub(QTR_version,1,1)..string.sub(QTR_version,-2), 
                     ALERT_ID=0,                                ADDON_COUNT=0,  ADDON_ALERT=0,
                     BASE_VER=QTR_base,   BASE_DATE=QTR_date,   BASE_COUNT=0,   BASE_ALERT=0,
                     GOSSIP_VER=GS_base,  GOSSIP_DATE=GS_date,  GOSSIP_COUNT=0, GOSSIP_ALERT=0, };
local p_race = {
      ["Blood Elf"] = { M1="Krwawy Elf", D1="krwawego elfa", C1="krwawemu elfowi", B1="krwawego elfa", N1="krwawym elfem", K1="krwawym elfie", W1="Krwawy Elfie", M2="Krwawa Elfka", D2="krwawej elfki", C2="krwawej elfce", B2="krwawą elfkę", N2="krwawą elfką", K2="krwawej elfce", W2="Krwawa Elfko" }, 
      ["Dark Iron Dwarf"] = { M1="Krasnolud Ciemnego Żelaza", D1="krasnoluda Ciemnego Żelaza", C1="krasnoludowi Ciemnego Żelaza", B1="krasnoluda Ciemnego Żelaza", N1="krasnoludem Ciemnego Żelaza", K1="krasnoludzie Ciemnego Żelaza", W1="Krasnoludzie Ciemnego Żelaza", M2="Krasnoludzica Ciemnego Żelaza", D2="krasnoludzicy Ciemnego Żelaza", C2="krasnoludzicy Ciemnego Żelaza", B2="krasnoludzicę Ciemnego Żelaza", N2="krasnoludzicą Ciemnego Żelaza", K2="krasnoludzicy Ciemnego Żelaza", W2="Krasnoludzico Ciemnego Żelaza" },
      ["Dracthyr"] = { M1="Draktyr", D1="draktyra", C1="draktyrowi", B1="draktyra", N1="draktyrem", K1="draktyrze", W1="Draktyrze", M2="Draktyrka", D2="draktyrki", C2="draktyrce", B2="draktyrkę", N2="draktyrką", K2="draktyrce", W2="Draktyrko" },
      ["Draenei"] = { M1="Draenei", D1="draeneia", C1="draeneiowi", B1="draeneia", N1="draeneiem", K1="draeneiu", W1="Draeneiu", M2="Draeneika", D2="draeneiki", C2="draeneice", B2="draeneikę", N2="draeneiką", K2="draeneice", W2="Draeneiko" },
      ["Dwarf"] = { M1="Krasnolud", D1="krasnoluda", C1="krasnoludowi", B1="krasnoluda", N1="krasnoludem", K1="krasnoludzie", W1="Krasnoludzie", M2="Krasnoludzica", D2="krasnoludzicy", C2="krasnoludzicy", B2="krasnoludzicę", N2="krasnoludzicą", K2="krasnoludzicy", W2="Krasnoludzico" },
      ["Gnome"] = { M1="Gnom", D1="gnoma", C1="gnomowi", B1="gnoma", N1="gnomem", K1="gnomie", W1="Gnomie", M2="Gnomka", D2="gnomki", C2="gnomce", B2="gnomkę", N2="gnomką", K2="gnomce", W2="Gnomko" },
      ["Goblin"] = { M1="Goblin", D1="goblina", C1="goblinowi", B1="goblina", N1="goblinem", K1="goblinie", W1="Goblinie", M2="Goblinka", D2="goblinki", C2="goblince", B2="goblinkę", N2="goblinką", K2="goblince", W2="Goblinko" },
      ["Highmountain Tauren"] = { M1="Tauren z Wysokiej Góry", D1="taurena z Wysokiej Góry", C1="taurenowi z Wysokiej Góry", B1="taurena z Wysokiej Góry", N1="taurenen z Wysokiej Góry", K1="taurenie z Wysokiej Góry", W1="Taurenie z Wysokiej Góry", M2="Taurenka z Wysokiej Góry", D2="taurenki z Wysokiej Góry", C2="taurence z Wysokiej Góry", B2="taurenkę z Wysokiej Góry", N2="taurenką z Wysokiej Góry", K2="taurence z Wysokiej Góry", W2="Taurenko z Wysokiej Góry" },
      ["Human"] = { M1="Człowiek", D1="człowieka", C1="człowiekowi", B1="człowieka", N1="człowiekiem", K1="człowieku", W1="Człowieku", M2="Człowiek", D2="człowieka", C2="człowiekowi", B2="człowieka", N2="człowiekiem", K2="człowieku", W2="Człowieku" },
      ["Kul Tiran"] = { M1="Kul Tiran", D1="Kul Tirana", C1="Kul Tiranowi", B1="Kul Tirana", N1="Kul Tiranem", K1="Kul Tiranie", W1="Kul Tiranie", M2="Kul Tiranka", D2="Kul Tiranki", C2="Kul Tirance", B2="Kul Tirankę", N2="Kul Tiranką", K2="Kul Tirance", W2="Kul Tiranko" },
      ["Lightforged Draenei"] = { M1="Świetlisty Draenei", D1="świetlistego draeneia", C1="świetlistemu draeneiowi", B1="świetlistego draeneia", N1="świetlistym draeneiem", K1="świetlistym draeneiu", W1="Świetlisty Draeneiu", M2="Świetlista Draeneika", D2="świetlistej draeneiki", C2="świetlistej draeneice", B2="świetlistą draeneikę", N2="świetlistą draeneiką", K2="świetlistej draeneice", W2="Świetlista Draeneiko" },
      ["Mag'har Orc"] = { M1="Ork z Mag'har", D1="orka z Mag'har", C1="orkowi z Mag'har", B1="orka z Mag'har", N1="orkiem z Mag'har", K1="orku z Mag'har", W1="Orku z Mag'har", M2="Orczyca z Mag'har", D2="orczycy z Mag'har", C2="orczycy z Mag'har", B2="orczycę z Mag'har", N2="orczycą z Mag'har", K2="orczyce z Mag'har", W2="Orczyco z Mag'har" },
      ["Mechagnome"] = { M1="Mechagnom", D1="mechagnoma", C1="mechagnomowi", B1="mechagnoma", N1="mechagnomem", K1="mechagnomie", W1="Mechagnomie", M2="Mechagnomka", D2="mechagnomki", C2="mechagnomce", B2="mechagnomkę", N2="mechagnomką", K2="mechagnomce", W2="Mechagnomko" },
      ["Nightborne"] = { M1="Dziecię Nocy", D1="dziecięcia nocy", C1="dziecięciu nocy", B1="dziecię nocy", N1="dziecięcem nocy", K1="dziecięciu nocy", W1="Dziecię Nocy", M2="Dziecię Nocy", D2="dziecięcia nocy", C2="dziecięciu nocy", B2="dziecię nocy", N2="dziecięcem nocy", K2="dziecięciu nocy", W2="Dziecię Nocy" },
      ["Night Elf"] = { M1="Nocny Elf", D1="nocnego elfa", C1="nocnemu elfowi", B1="nocnego elfa", N1="nocnym elfem", K1="nocnym elfie", W1="Nocny Elfie", M2="Nocna Elfka", D2="nocnej elfki", C2="nocnej elfce", B2="nocną elfkę", N2="nocną elfką", K2="nocnej elfce", W2="Nocna Elfko" },
      ["Orc"] = { M1="Ork", D1="orka", C1="orkowi", B1="orka", N1="orkiem", K1="orku", W1="Orku", M2="Orczyca", D2="orczycy", C2="orczycy", B2="orczycę", N2="orczycą", K2="orczycy", W2="Orczyco" },
      ["Pandaren"] = { M1="Pandaren", D1="pandarena", C1="pandarenowi", B1="pandarena", N1="pandarenem", K1="pandarenie", W1="Pandarenie", M2="Pandarenka", D2="pandarenki", C2="pandarence", B2="pandarenkę", N2="pandarenką", K2="pandarence", W2="Pandarenko" },
      ["Tauren"] = { M1="Tauren", D1="taurena", C1="taurenowi", B1="taurena", N1="taurenem", K1="taurenie", W1="Taurenie", M2="Taurenka", D2="taurenki", C2="taurence", B2="taurenkę", N2="taurenką", K2="taurence", W2="Taurenko" },
      ["Troll"] = { M1="Troll", D1="trolla", C1="trollowi", B1="trolla", N1="trollem", K1="trollu", W1="Trollu", M2="Trollica", D2="trollicy", C2="trollicy", B2="trollicę", N2="trollicą", K2="trollicy", W2="Trollico" },
      ["Undead"] = { M1="Nieumarły", D1="nieumarłego", C1="nieumarłemu", B1="nieumarłego", N1="nieumarłym", K1="nieumarłym", W1="Nieumarły", M2="Nieumarła", D2="nieumarłej", C2="nieumarłej", B2="nieumarłą", N2="nieumarłą", K2="nieumarłej", W2="Nieumarła" },
      ["Void Elf"] = { M1="Elf Pustki", D1="elfa Pustki", C1="elfowi Pustki", B1="elfa Pustki", N1="elfem Pustki", K1="elfie Pustki", W1="Elfie Pustki", M2="Elfka Pustki", D2="elfki Pustki", C2="elfce Pustki", B2="elfkę Pustki", N2="elfką Pustki", K2="elfce Pustki", W2="Elfko Pustki" },
      ["Vulpera"] = { M1="Lisołak", D1="lisołaka", C1="lisołakowi", B1="lisołaka", N1="lisołakiem", K1="lisołaku", W1="Lisołaku", M2="Lisołaczka", D2="lisołaczki", C2="lisołaczce", B2="lisołaczkę", N2="lisołaczką", K2="lisołaczce", W2="Lisołaczko" },
      ["Worgen"] = { M1="Worgen", D1="worgena", C1="worgenowi", B1="worgena", N1="worgenem", K1="worgenie", W1="Worgenie", M2="Worgenka", D2="worgenki", C2="worgence", B2="worgenkę", N2="worgenką", K2="worgence", W2="Worgenko" },
      ["Zandalari Troll"] = { M1="Troll Zandalari", D1="trolla Zandalari", C1="trollowi Zandalari", B1="trolla Zandalari", N1="trollem Zandalari", K1="trollu Zandalari", W1="Trollu Zandalari", M2="Trollica Zandalari", D2="trollicy Zandalari", C2="trollicy Zandalari", B2="trollicę Zandalari", N2="trollicą Zandalari", K2="trollicy Zandalari", W2="Trollico Zandalari" }, }
local p_class = {
      ["Death Knight"] = { M1="Rycerz Śmierci", D1="rycerz śmierci", C1="rycerzowi śmierci", B1="rycerza śmierci", N1="rycerzem śmierci", K1="rycerzu śmierci", W1="Rycerzu Śmierci", M2="Rycerz Śmierci", D2="rycerz śmierci", C2="rycerzowi śmierci", B2="rycerza śmierci", N2="rycerzem śmierci", K2="rycerzu śmierci", W2="Rycerzu Śmierci" },
      ["Demon Hunter"] = { M1="Łowca demonów", D1="łowcy demonów", C1="łowcy demonów", B1="łowcę demonów", N1="łowcą demonów", K1="łowcy demonów", W1="Łowco demonów", M2="Łowczyni demonów", D2="łowczyni demonów", C2="łowczyni demonów", B2="łowczynię demonów", N2="łowczynią demonów", K2="łowczyni demonów", W2="Łowczyni demonów" },
      ["Druid"] = { M1="Druid", D1="druida", C1="druidowi", B1="druida", N1="druidem", K1="druidzie", W1="Druidzie", M2="Druidka", D2="druidki", C2="druidce", B2="druidkę", N2="druidką", K2="druidce", W2="Druidko" },
      ["Evoker"] = { M1="Przywoływacz", D1="przywoływacza", C1="przywoływaczowi", B1="przywoływacza", N1="przywoływaczem", K1="przywoływaczu", W1="Przywoływaczu", M2="Przywoływaczka", D2="przywoływaczki", C2="przywoływaczce", B2="przywoływaczkę", N2="przywoływaczką", K2="przywoływaczce", W2="przywoływaczko" },
      ["Hunter"] = { M1="Łowca", D1="łowcy", C1="łowcy", B1="łowcę", N1="łowcą", K1="łowcy", W1="Łowco", M2="Łowczyni", D2="łowczyni", C2="łowczyni", B2="łowczynię", N2="łowczynią", K2="łowczyni", W2="Łowczyni" },
      ["Mage"] = { M1="Mag", D1="maga", C1="magowi", B1="maga", N1="magiem", K1="magu", W1="Magu", M2="Maginia", D2="magini", C2="maginią", B2="maginię", N2="maginią", K2="magini", W2="Maginio" },
      ["Monk"] = { M1="Mnich", D1="mnicha", C1="mnichowi", B1="mnicha", N1="mnichem", K1="mnichu", W1="Mnichu", M2="Mniszka", D2="mniszki", C2="mniszce", B2="mniszkę", N2="mniszką", K2="mniszce", W2="Mniszko" },
      ["Paladin"] = { M1="Paladyn", D1="paladyna", C1="paladynowi", B1="paladyna", N1="paladynem", K1="paladynie", W1="Paladynie", M2="Paladynka", D2="paladynki", C2="paladynce", B2="paladynkę", N2="paladynką", K2="paladynce", W2="Paladynko" },
      ["Priest"] = { M1="Kapłan", D1="kapłana", C1="kapłanowi", B1="kapłana", N1="kapłanem", K1="kapłanie", W1="Kapłanie", M2="Kapłanka", D2="kapłanki", C2="kapłance", B2="kapłankę", N2="kapłanką", K2="kapłance", W2="Kapłanko" },
      ["Rogue"] = { M1="Łotrzyk", D1="łotrzyka", C1="łotrzykowi", B1="łotrzyka", N1="łotrzykiem", K1="łotrzyku", W1="Łotrzyku", M2="Łotrzyca", D2="łotrzycy", C2="łotrzycy", B2="łotrzycę", N2="łotrzycą", K2="łotrzycy", W2="Łotrzyco" },
      ["Shaman"] = { M1="Szaman", D1="szamana", C1="szamanowi", B1="szamana", N1="szamanem", K1="szamanie", W1="Szamanie", M2="Szamanka", D2="szamanki", C2="szamance", B2="szamankę", N2="szamanką", K2="szamance", W2="Szamanko" },
      ["Warlock"] = { M1="Czarnoksiężnik", D1="czarnoksiężnika", C1="czarnoksiężnikowi", B1="czarnoksiężnika", N1="czarnoksiężnikiem", K1="czarnoksiężniku", W1="Czarnoksiężniku", M2="Czarownica", D2="czarownicy", C2="czarownicy", B2="czarownicę", N2="czarownicą", K2="czarownicy", W2="Czarownico" },
      ["Warrior"] = { M1="Wojownik", D1="wojownika", C1="wojownikowi", B1="wojownika", N1="wojownikiem", K1="wojowniku", W1="Wojowniku", M2="Wojowniczka", D2="wojowniczki", C2="wojowniczce", B2="wojowniczkę", N2="wojowniczką", K2="wojowniczce", W2="Wojowniczko" }, }
if (p_race[QTR_race]) then      
   player_race = { M1=p_race[QTR_race].M1, D1=p_race[QTR_race].D1, C1=p_race[QTR_race].C1, B1=p_race[QTR_race].B1, N1=p_race[QTR_race].N1, K1=p_race[QTR_race].K1, W1=p_race[QTR_race].W1, M2=p_race[QTR_race].M2, D2=p_race[QTR_race].D2, C2=p_race[QTR_race].C2, B2=p_race[QTR_race].B2, N2=p_race[QTR_race].N2, K2=p_race[QTR_race].K2, W2=p_race[QTR_race].W2 };
else   
   player_race = { M1=QTR_race, D1=QTR_race, C1=QTR_race, B1=QTR_race, N1=QTR_race, K1=QTR_race, W1=QTR_race, M2=QTR_race, D2=QTR_race, C2=QTR_race, B2=QTR_race, N2=QTR_race, K2=QTR_race, W2=QTR_race };
   print ("|cff55ff00QTR - nowa rasa: "..QTR_race);
end
if (p_class[QTR_class]) then
   player_class = { M1=p_class[QTR_class].M1, D1=p_class[QTR_class].D1, C1=p_class[QTR_class].C1, B1=p_class[QTR_class].B1, N1=p_class[QTR_class].N1, K1=p_class[QTR_class].K1, W1=p_class[QTR_class].W1, M2=p_class[QTR_class].M2, D2=p_class[QTR_class].D2, C2=p_class[QTR_class].C2, B2=p_class[QTR_class].B2, N2=p_class[QTR_class].N2, K2=p_class[QTR_class].K2, W2=p_class[QTR_class].W2 };
else
   player_class = { M1=QTR_class, D1=QTR_class, C1=QTR_class, B1=QTR_class, N1=QTR_class, K1=QTR_class, W1=QTR_class, M2=QTR_class, D2=QTR_class, C2=QTR_class, B2=QTR_class, N2=QTR_class, K2=QTR_class, W2=QTR_class };
   print ("|cff55ff00QTR - nowa klasa: "..QTR_class);
end


local function StringHash(text)           -- funkcja tworząca Hash (32-bitowa liczba) podanego tekstu
  local counter = 1;
  local pomoc = 0;
  local dlug = string.len(text);
  for i = 1, dlug, 3 do 
    counter = math.fmod(counter*8161, 4294967279);  -- 2^32 - 17: Prime!
    pomoc = (string.byte(text,i)*16776193);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+1) or (dlug-i+256))*8372226);
    counter = counter + pomoc;
    pomoc = ((string.byte(text,i+2) or (dlug-i+256))*3932164);
    counter = counter + pomoc;
  end
  return math.fmod(counter, 4294967291) -- 2^32 - 5: Prime (and different from the prime in the loop)
end


-- Zmienne programowe zapisane na stałe na komputerze
function QTR_CheckVars()
  if (not QTR_PS) then
     QTR_PS = {};
  end
  if (not QTR_SAVED) then
     QTR_SAVED = {};
  end
  if (not QTR_MISSING) then
     QTR_MISSING = {};
  end
  if (not QTR_GOSSIP) then
     QTR_GOSSIP = {};
  end
  if (not QTR_GOSSIP_TR) then
     QTR_GOSSIP_TR = {};
  end
  if (not QTR_CONTROL) then
     QTR_CONTROL = {};
  end

  -- inicjalizacja: tłumaczenia włączone
  if (not QTR_PS["active"]) then
     QTR_PS["active"] = "1";
  end
  -- inicjalizacja: tłumaczenie tytułu questu włączone
  if (not QTR_PS["transtitle"] ) then
     QTR_PS["transtitle"] = "0";   
  end
  -- komunikaty głosowe
  if (not QTR_PS["voices"] ) then
     QTR_PS["voices"] = "1";   
  end
  if (not QTR_PS["voice1"]) then
     QTR_PS["voice1"] = "0";
  end
  if (not QTR_PS["voice2"]) then
     QTR_PS["voice2"] = "0";
  end
  if (not QTR_PS["voice3"]) then
     QTR_PS["voice3"] = "1";
  end
  if (not QTR_PS["voice4"]) then
     QTR_PS["voice4"] = "1";
  end
  if (not QTR_PS["voice5"]) then
     QTR_PS["voice5"] = "1";
  end
  if (not QTR_PS["voice6"]) then
     QTR_PS["voice6"] = "1";
  end
  if (not QTR_PS["voice7"]) then
     QTR_PS["voice7"] = "1";
  end
  -- zmienna specjalna dostępności funkcji GetQuestID 
  if ( QTR_PS["isGetQuestID"] ) then
     isGetQuestID=QTR_PS["isGetQuestID"];
  end;
  -- okresowe wyświetlanie reklam o dodatku 
  if (not QTR_PS["reklama"] ) then
     QTR_PS["reklama"] = "0";
     QTR_PS["period"] = 20;
     QTR_PS["text1"] = "0";
     QTR_PS["text2"] = "1";
     QTR_PS["channel"] = "0";
  end;
  if (not QTR_PS["other1"] ) then
     QTR_PS["other1"] = "1";
  end;
  if (not QTR_PS["other2"] ) then
     QTR_PS["other2"] = "1";
  end;
  if (not QTR_PS["other3"] ) then
     QTR_PS["other3"] = "1";
  end;
  if (not QTR_PS["channel"] ) then
     QTR_PS["channel"] = "0";
  end;
   -- zapis wersji patcha Wow'a
  QTR_PS["patch"] = GetBuildInfo();    -- zapisz za każdym razem, bo może masz nową wersję gry
  -- jeszcze nazwa gracza w przepadkach / per character
  if (not QTR_PC) then
     QTR_PC = {};
  end
--  if (not QTR_PC["name1"] ) then
--     QTR_PC["name1"] = QTR_name;
--  end;
--  if (not QTR_PC["name2"] ) then
--     QTR_PC["name2"] = QTR_name.."a";
--  end;
--  if (not QTR_PC["name3"] ) then
--     QTR_PC["name3"] = QTR_name.."owi";
--  end;
--  if (not QTR_PC["name4"] ) then
--     QTR_PC["name4"] = QTR_name.."a";
--  end;
--  if (not QTR_PC["name5"] ) then
--     QTR_PC["name5"] = QTR_name.."em";
--  end;
--  if (not QTR_PC["name6"] ) then
--     QTR_PC["name6"] = QTR_name.."ie";
--  end;
--  if (not QTR_PC["name7"] ) then
--     QTR_PC["name7"] = QTR_name;
--  end;
  if (not QTR_PS["gossip"] ) then
     QTR_PS["gossip"] = "1";   
  end
  if (not QTR_PS["gossiponline"] ) then
     QTR_PS["gossiponline"] = "0";   
  end
  if (not QTR_PS["tracker"] ) then
     QTR_PS["tracker"] = "0";   
  end
  if (not QTR_PS["ownname"] ) then
     QTR_PS["ownname"] = "1";   
  end
  if (not QTR_PS["ownname_obj"] ) then
     QTR_PS["ownname_obj"] = "1";   
  end
  QTR_GS = {};                -- tablica na teksty oryginalne
  QTR_PS["control"] = "1";    -- zapisuj kontrolnie oryginalne teksty zadań
end


-- Sprawdza dostępność funkcji specjalnej Wow'a: GetQuestID()
function DetectEmuServer()
  QTR_PS["isGetQuestID"]="0";
  isGetQuestID="0";
  -- funkcja GetQuestID() występuje tylko na serwerach Blizzarda
  if ( GetQuestID() ) then
     QTR_PS["isGetQuestID"]="1";
     isGetQuestID="1";
  end
end


-- Obsługa komend slash
function QTR_SlashCommand(msg)
   if (msg=="on" or msg=="ON" or msg=="1") then
      if (QTR_PS["active"]=="1") then
         print ("QTR - tłumaczenie są włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenie.");
         QTR_PS["active"] = "1";
         QTR_ToggleButton0:Enable();
         QTR_ToggleButton1:Enable();
         QTR_ToggleButton2:Enable();
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:Enable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Enable();
         end
         QTR_Translate_On(1);
      end
   elseif (msg=="off" or msg=="OFF" or msg=="0") then
      if (QTR_PS["active"]=="0") then
         print ("QTR - tłumaczenia są wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenia.");
         QTR_PS["active"] = "0";
         QTR_ToggleButton0:Disable();
         QTR_ToggleButton1:Disable();
         QTR_ToggleButton2:Disable();
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:Disable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Disable();
         end
         QTR_Translate_Off(1);
      end
   elseif (msg=="title on" or msg=="TITLE ON" or msg=="title 1") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenie tytułów jest włączone.");
      else
         print ("|cffffff00QTR - włączam tłumaczenie tytułów.");
         QTR_PS["transtitle"] = "1";
         QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
      end
   elseif (msg=="title off" or msg=="TITLE OFF" or msg=="title 0") then
      if (QTR_PS["transtilte"]=="0") then
         print ("QTR - tłumaczenie tytułów jest wyłączone.");
      else
         print ("|cffffff00QTR - wyłączam tłumaczenie tytułów.");
         QTR_PS["transtitle"] = "0";
         QuestInfoTitleHeader:SetFont(Original_Font1, 18);
      end
   elseif (msg=="title" or msg=="TITLE") then
      if (QTR_PS["transtilte"]=="1") then
         print ("QTR - tłumaczenie tytułów jest włączone.");
      else
         print ("QTR - tłumaczenie tytułów jest wyłączone.");
      end
   elseif (msg=="") then
      Settings.OpenToCategory("WoWpoPolsku-Quests");
   else
      print ("QTR - menu szybkich komend addonu:");
      print ("      /qtr on|1  - włącza tłumaczenia");
      print ("      /qtr off|0 - wyłącza tłumaczenia");
      print ("      /qtr title on|1  - włącza tłumaczenie tytułu");
      print ("      /qtr title off|0 - wyłącza tłumaczenie tytułu");
   end
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


function QTR_SetCheckButtonState()
  QTRCheckButton0:SetValue(QTR_PS["active"]=="1");
  QTRCheckButton3:SetValue(QTR_PS["transtitle"]=="1");
  QTRCheckButton4:SetValue(QTR_PS["voices"]=="1");
  QTRCheckButton5:SetValue(QTR_PS["reklama"]=="1");
--  QTRCheckOther1:SetChecked(QTR_PS["other1"]=="1");
  QTRCheckOther2:SetValue(QTR_PS["other2"]=="1");
  QTRCheckOther3:SetValue(QTR_PS["other3"]=="1");
--  QTREditP1:SetText(QTR_PC["name1"]);
--  QTREditP2:SetText(QTR_PC["name2"]);
--  QTREditP3:SetText(QTR_PC["name3"]);
--  QTREditP4:SetText(QTR_PC["name4"]);
--  QTREditP5:SetText(QTR_PC["name5"]);
--  QTREditP6:SetText(QTR_PC["name6"]);
--  QTREditP7:SetText(QTR_PC["name7"]);
  QTRCheckButtonGossip:SetValue(QTR_PS["gossip"]=="1");
  QTRCheckButtonOnLine:SetValue(QTR_PS["gossiponline"]=="1");
  QTRCheckButtonTracker:SetValue(QTR_PS["tracker"]=="1");
  QTRCheckButtonOwnName:SetValue(QTR_PS["ownname"]=="1");
  QTRCheckButtonOwnName2:SetValue(QTR_PS["ownname_obj"]=="1");
  QTR_STframe:Hide();
  QTR_SeTframe:Hide();
  QTR_SeRframe:Hide();
end


function QTR_BlizzardOptions()
  -- Create main frame for information text
  local QTROptions = CreateFrame("FRAME", "WoWpoPolsku_Quests_Options");
  QTROptions.name = "WoWpoPolsku-Quests";
  QTROptions.refresh = function (self) QTR_SetCheckButtonState() end;
  InterfaceOptions_AddCategory(QTROptions);

  local QTROptionsHeader = QTROptions:CreateFontString(nil, "ARTWORK");
  QTROptionsHeader:SetFontObject(GameFontNormalLarge);
  QTROptionsHeader:SetJustifyH("LEFT"); 
  QTROptionsHeader:SetJustifyV("TOP");
  QTROptionsHeader:ClearAllPoints();
  QTROptionsHeader:SetPoint("TOPLEFT", 16, -16);
  QTROptionsHeader:SetText("WoWpoPolsku-Quests, ver. "..QTR_version.." ("..QTR_base..") by Platine © 2010-2022");

  local QTRDateOfBase = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRDateOfBase:SetFontObject(GameFontNormalLarge);
  QTRDateOfBase:SetJustifyH("LEFT"); 
  QTRDateOfBase:SetJustifyV("TOP");
  QTRDateOfBase:ClearAllPoints();
  QTRDateOfBase:SetPoint("TOPRIGHT", QTROptionsHeader, "TOPRIGHT", 0, -22);
  QTRDateOfBase:SetText("Data bazy tłumaczeń: "..QTR_date);
  QTRDateOfBase:SetFont(QTR_Font2, 16);

  local QTRCheckButton0 = CreateFrame("CheckButton", "QTRCheckButton0", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButton0.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["active"]=="1") then QTR_PS["active"]="0" else QTR_PS["active"]="1" end; end);
  QTRCheckButton0.CheckBox:SetPoint("TOPLEFT", QTROptionsHeader, "BOTTOMLEFT", 0, -30);   -- pozycja przycisku CheckBox
  QTRCheckButton0:SetPoint("TOPLEFT", QTROptionsHeader, "BOTTOMLEFT", 40, -30);           -- pozycja opisu przycisku CheckBox
  QTRCheckButton0.Text:SetFont(QTR_Font2, 13);
  QTRCheckButton0.Text:SetText(QTR_Interface.active);

  local QTROptionsMode1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTROptionsMode1:SetFontObject(GameFontWhite);
  QTROptionsMode1:SetJustifyH("LEFT");
  QTROptionsMode1:SetJustifyV("TOP");
  QTROptionsMode1:ClearAllPoints();
  QTROptionsMode1:SetPoint("TOPLEFT", QTRCheckButton0, "BOTTOMLEFT", 0, -10);
  QTROptionsMode1:SetFont(QTR_Font2, 13);
  QTROptionsMode1:SetText("Ustawienia dodatku:");
  
  local QTRCheckButton3 = CreateFrame("CheckButton", "QTRCheckButton3", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButton3.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["transtitle"]=="0") then QTR_PS["transtitle"]="1" else QTR_PS["transtitle"]="0" end; end);
  QTRCheckButton3.CheckBox:SetPoint("TOPLEFT", QTROptionsMode1, "BOTTOMLEFT", 0, -5);
  QTRCheckButton3:SetPoint("TOPLEFT", QTROptionsMode1, "BOTTOMLEFT", 40, -5);
  QTRCheckButton3.Text:SetFont(QTR_Font2, 13);
  QTRCheckButton3.Text:SetText(QTR_Interface.transtitle);

   -- przycisk "Inni gracze"
  local QTROptionsStatButton = CreateFrame("Button",nil, QTROptions, "UIPanelButtonTemplate");
  QTROptionsStatButton:SetWidth(150);
  QTROptionsStatButton:SetHeight(20);
  QTROptionsStatButton:SetText("Inni gracze");
  QTROptionsStatButton:Show();
  QTROptionsStatButton:ClearAllPoints();
  QTROptionsStatButton:SetPoint("TOPLEFT", QTRCheckButton3.CheckBox, "TOPRIGHT", 300, -2);
  QTROptionsStatButton:SetScript("OnClick", QTR_ShowHideStatystyka);
  
  local QTRCheckButton4 = CreateFrame("CheckButton", "QTRCheckButton4", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButton4.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voices"]=="0") then QTR_PS["voices"]="1" else QTR_PS["voices"]="0" end; end);
  QTRCheckButton4.CheckBox:SetPoint("TOPLEFT", QTRCheckButton3.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButton4:SetPoint("TOPLEFT", QTRCheckButton3.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButton4.Text:SetFont(QTR_Font2, 13);
  QTRCheckButton4.Text:SetText("Włącz komunikaty głosowe");

   -- przycisk "Ustawienia dźwięków"
  local QTROptionsSoundButton = CreateFrame("Button",nil, QTROptions, "UIPanelButtonTemplate");
  QTROptionsSoundButton:SetWidth(150);
  QTROptionsSoundButton:SetHeight(20);
  QTROptionsSoundButton:SetText("Ustawienia głosowe");
  QTROptionsSoundButton:Show();
  QTROptionsSoundButton:ClearAllPoints();
  QTROptionsSoundButton:SetPoint("TOPLEFT", QTRCheckButton4.CheckBox, "TOPRIGHT", 300, -2);
  QTROptionsSoundButton:SetScript("OnClick", QTR_ShowHideUstawienia);

--  local QTROptionsMode2 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTROptionsMode2:SetFontObject(GameFontWhite);
--  QTROptionsMode2:SetJustifyH("LEFT");
--  QTROptionsMode2:SetJustifyV("TOP");
--  QTROptionsMode2:ClearAllPoints();
--  QTROptionsMode2:SetPoint("TOPLEFT", QTROptionsMode1, "TOPRIGHT", 200, 0);
--  QTROptionsMode2:SetFont(QTR_Font2, 13);
--  QTROptionsMode2:SetText("Nazwa gracza w różnych przypadkach:");
  
--  local QTREditP1 = CreateFrame("EditBox", "QTREditP1", QTROptions, "InputBoxTemplate");
--  QTREditP1:SetPoint("TOPRIGHT", QTROptionsMode2, "BOTTOMRIGHT", 0, -10);
--  QTREditP1:SetHeight(20);
--  QTREditP1:SetWidth(100);
--  QTREditP1:SetAutoFocus(false);
--  QTREditP1:SetText(QTR_PC["name1"]);
--  QTREditP1:SetCursorPosition(0);
--  QTREditP1:SetScript("OnTextChanged", function(self) if (strlen(QTREditP1:GetText())>0) then QTR_PC["name1"]=QTREditP1:GetText() end; end);

--  local QTRName1 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName1:SetFontObject(GameFontNormalLarge);
--  QTRName1:SetJustifyH("LEFT"); 
--  QTRName1:SetJustifyV("TOP");
--  QTRName1:ClearAllPoints();
--  QTRName1:SetPoint("TOPRIGHT", QTREditP1, "TOPLEFT", -8, -4);
--  QTRName1:SetText("Mianownik:");
--  QTRName1:SetFont(QTR_Font2, 13);

--  local QTREditP2 = CreateFrame("EditBox", "QTREditP2", QTROptions, "InputBoxTemplate");
--  QTREditP2:SetPoint("TOPRIGHT", QTREditP1, "BOTTOMRIGHT", 0, 0);
--  QTREditP2:SetHeight(20);
--  QTREditP2:SetWidth(100);
--  QTREditP2:SetAutoFocus(false);
--  QTREditP2:SetText(QTR_PC["name2"]);
--  QTREditP2:SetCursorPosition(0);
--  QTREditP2:SetScript("OnTextChanged", function(self) if (strlen(QTREditP2:GetText())>0) then QTR_PC["name2"]=QTREditP2:GetText() end; end);

--  local QTRName2 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName2:SetFontObject(GameFontNormalLarge);
--  QTRName2:SetJustifyH("LEFT"); 
--  QTRName2:SetJustifyV("TOP");
--  QTRName2:ClearAllPoints();
--  QTRName2:SetPoint("TOPRIGHT", QTREditP2, "TOPLEFT", -8, -4);
--  QTRName2:SetText("Dopełniacz:");
--  QTRName2:SetFont(QTR_Font2, 13);

--  local QTREditP3 = CreateFrame("EditBox", "QTREditP3", QTROptions, "InputBoxTemplate");
--  QTREditP3:SetPoint("TOPRIGHT", QTREditP2, "BOTTOMRIGHT", 0, 0);
--  QTREditP3:SetHeight(20);
--  QTREditP3:SetWidth(100);
--  QTREditP3:SetAutoFocus(false);
--  QTREditP3:SetText(QTR_PC["name3"]);
--  QTREditP3:SetCursorPosition(0);
--  QTREditP3:SetScript("OnTextChanged", function(self) if (strlen(QTREditP3:GetText())>0) then QTR_PC["name3"]=QTREditP3:GetText() end; end);

--  local QTRName3 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName3:SetFontObject(GameFontNormalLarge);
--  QTRName3:SetJustifyH("LEFT"); 
--  QTRName3:SetJustifyV("TOP");
--  QTRName3:ClearAllPoints();
--  QTRName3:SetPoint("TOPRIGHT", QTREditP3, "TOPLEFT", -8, -4);
--  QTRName3:SetText("Celownik:");
--  QTRName3:SetFont(QTR_Font2, 13);

--  local QTREditP4 = CreateFrame("EditBox", "QTREditP4", QTROptions, "InputBoxTemplate");
--  QTREditP4:SetPoint("TOPRIGHT", QTREditP3, "BOTTOMRIGHT", 0, 0);
--  QTREditP4:SetHeight(20);
--  QTREditP4:SetWidth(100);
--  QTREditP4:SetAutoFocus(false);
--  QTREditP4:SetText(QTR_PC["name4"]);
--  QTREditP4:SetCursorPosition(0);
--  QTREditP4:SetScript("OnTextChanged", function(self) if (strlen(QTREditP4:GetText())>0) then QTR_PC["name4"]=QTREditP4:GetText() end; end);

--  local QTRName4 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName4:SetFontObject(GameFontNormalLarge);
--  QTRName4:SetJustifyH("LEFT"); 
--  QTRName4:SetJustifyV("TOP");
--  QTRName4:ClearAllPoints();
--  QTRName4:SetPoint("TOPRIGHT", QTREditP4, "TOPLEFT", -8, -4);
--  QTRName4:SetText("Biernik:");
--  QTRName4:SetFont(QTR_Font2, 13);

--  local QTREditP5 = CreateFrame("EditBox", "QTREditP5", QTROptions, "InputBoxTemplate");
--  QTREditP5:SetPoint("TOPRIGHT", QTREditP4, "BOTTOMRIGHT", 0, 0);
--  QTREditP5:SetHeight(20);
--  QTREditP5:SetWidth(100);
--  QTREditP5:SetAutoFocus(false);
--  QTREditP5:SetText(QTR_PC["name5"]);
--  QTREditP5:SetCursorPosition(0);
--  QTREditP5:SetScript("OnTextChanged", function(self) if (strlen(QTREditP5:GetText())>0) then QTR_PC["name5"]=QTREditP5:GetText() end; end);

--  local QTRName5 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName5:SetFontObject(GameFontNormalLarge);
--  QTRName5:SetJustifyH("LEFT"); 
--  QTRName5:SetJustifyV("TOP");
--  QTRName5:ClearAllPoints();
--  QTRName5:SetPoint("TOPRIGHT", QTREditP5, "TOPLEFT", -8, -4);
--  QTRName5:SetText("Narzędnik:");
--  QTRName5:SetFont(QTR_Font2, 13);

--  local QTREditP6 = CreateFrame("EditBox", "QTREditP6", QTROptions, "InputBoxTemplate");
--  QTREditP6:SetPoint("TOPRIGHT", QTREditP5, "BOTTOMRIGHT", 0, 0);
--  QTREditP6:SetHeight(20);
--  QTREditP6:SetWidth(100);
--  QTREditP6:SetAutoFocus(false);
--  QTREditP6:SetText(QTR_PC["name6"]);
--  QTREditP6:SetCursorPosition(0);
--  QTREditP6:SetScript("OnTextChanged", function(self) if (strlen(QTREditP6:GetText())>0) then QTR_PC["name6"]=QTREditP6:GetText() end; end);

--  local QTRName6 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName6:SetFontObject(GameFontNormalLarge);
--  QTRName6:SetJustifyH("LEFT"); 
--  QTRName6:SetJustifyV("TOP");
--  QTRName6:ClearAllPoints();
--  QTRName6:SetPoint("TOPRIGHT", QTREditP6, "TOPLEFT", -8, -4);
--  QTRName6:SetText("Miejscownik:");
--  QTRName6:SetFont(QTR_Font2, 13);

--  local QTREditP7 = CreateFrame("EditBox", "QTREditP7", QTROptions, "InputBoxTemplate");
--  QTREditP7:SetPoint("TOPRIGHT", QTREditP6, "BOTTOMRIGHT", 0, 0);
--  QTREditP7:SetHeight(20);
--  QTREditP7:SetWidth(100);
--  QTREditP7:SetAutoFocus(false);
--  QTREditP7:SetText(QTR_PC["name7"]);
--  QTREditP7:SetCursorPosition(0);
--  QTREditP7:SetScript("OnTextChanged", function(self) if (strlen(QTREditP7:GetText())>0) then QTR_PC["name7"]=QTREditP7:GetText() end; end);

--  local QTRName7 = QTROptions:CreateFontString(nil, "ARTWORK");
--  QTRName7:SetFontObject(GameFontNormalLarge);
--  QTRName7:SetJustifyH("LEFT"); 
--  QTRName7:SetJustifyV("TOP");
--  QTRName7:ClearAllPoints();
--  QTRName7:SetPoint("TOPRIGHT", QTREditP7, "TOPLEFT", -8, -4);
--  QTRName7:SetText("Wołacz:");
--  QTRName7:SetFont(QTR_Font2, 13);

  local QTRCheckButton5 = CreateFrame("CheckButton", "QTRCheckButton5", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButton5.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["reklama"]=="0") then QTR_PS["reklama"]="1" else QTR_PS["reklama"]="0" end; end);
  QTRCheckButton5.CheckBox:SetPoint("TOPLEFT", QTRCheckButton4.CheckBox, "BOTTOMLEFT", 0, 2);
  QTRCheckButton5:SetPoint("TOPLEFT", QTRCheckButton4.CheckBox, "BOTTOMLEFT", 40, 2);
  QTRCheckButton5.Text:SetFont(QTR_Font2, 13);
  QTRCheckButton5.Text:SetText("Reklamuj dodatek w grze");

   -- przycisk "Ustawienia reklamy"
  local QTROptionsReklamaButton = CreateFrame("Button",nil, QTROptions, "UIPanelButtonTemplate");
  QTROptionsReklamaButton:SetWidth(150);
  QTROptionsReklamaButton:SetHeight(20);
  QTROptionsReklamaButton:SetText("Ustawienia reklamy");
  QTROptionsReklamaButton:Show();
  QTROptionsReklamaButton:ClearAllPoints();
  QTROptionsReklamaButton:SetPoint("TOPLEFT", QTRCheckButton5.CheckBox, "TOPRIGHT", 300, -2);
  QTROptionsReklamaButton:SetScript("OnClick", QTR_ShowHideUstawieniaReklama);
  
  local QTRCheckButtonGossip = CreateFrame("CheckButton", "QTRCheckButtonGossip", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButtonGossip.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["gossip"]=="1") then QTR_PS["gossip"]="0" else QTR_PS["gossip"]="1" end; end);
  QTRCheckButtonGossip.CheckBox:SetPoint("TOPLEFT", QTRCheckButton5.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonGossip:SetPoint("TOPLEFT", QTRCheckButton5.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButtonGossip.Text:SetFont(QTR_Font2, 13);
  QTRCheckButtonGossip.Text:SetText("Wyświetlaj tłumaczenia tekstów GOSSIP");
  
  local QTRCheckButtonOnLine = CreateFrame("CheckButton", "QTRCheckButtonOnLine", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButtonOnLine.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["gossiponline"]=="1") then QTR_PS["gossiponline"]="0" else QTR_PS["gossiponline"]="1" end; end);
  QTRCheckButtonOnLine.CheckBox:SetPoint("TOPLEFT", QTRCheckButtonGossip.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonOnLine:SetPoint("TOPLEFT", QTRCheckButtonGossip.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButtonOnLine.Text:SetFont(QTR_Font2, 13);
  QTRCheckButtonOnLine.Text:SetText("Włącz okno tłumaczenia ONLINE tekstów GOSSIP (tylko dla tłumaczy i moderatorów)");
  
  local QTRCheckButtonTracker = CreateFrame("CheckButton", "QTRCheckButtonTracker", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButtonTracker.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["tracker"]=="1") then QTR_PS["tracker"]="0" else QTR_PS["tracker"]="1" end; end);
  QTRCheckButtonTracker.CheckBox:SetPoint("TOPLEFT", QTRCheckButtonOnLine.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonTracker:SetPoint("TOPLEFT", QTRCheckButtonOnLine.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButtonTracker.Text:SetFont(QTR_Font2, 13);
  QTRCheckButtonTracker.Text:SetText("Wyświetlaj tłumaczenia online w Objective Tracker");  
  
  local QTRCheckButtonOwnName = CreateFrame("CheckButton", "QTRCheckButtonOwnName", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButtonOwnName.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["ownname"]=="1") then QTR_PS["ownname"]="0" else QTR_PS["ownname"]="1" end; end);
  QTRCheckButtonOwnName.CheckBox:SetPoint("TOPLEFT", QTRCheckButtonTracker.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonOwnName:SetPoint("TOPLEFT", QTRCheckButtonTracker.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButtonOwnName.Text:SetFont(QTR_Font2, 13);
  QTRCheckButtonOwnName.Text:SetText("Wyświetlaj przetłumaczone nazwy własne PL");  
  
  local QTRCheckButtonOwnName2 = CreateFrame("CheckButton", "QTRCheckButtonOwnName2", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckButtonOwnName2.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["ownname_obj"]=="1") then QTR_PS["ownname_obj"]="0" else QTR_PS["ownname_obj"]="1" end; end);
  QTRCheckButtonOwnName2.CheckBox:SetPoint("TOPLEFT", QTRCheckButtonOwnName.CheckBox, "BOTTOMLEFT", 0, 0);
  QTRCheckButtonOwnName2:SetPoint("TOPLEFT", QTRCheckButtonOwnName.CheckBox, "BOTTOMLEFT", 40, 0);
  QTRCheckButtonOwnName2.Text:SetFont(QTR_Font2, 13);
  QTRCheckButtonOwnName2.Text:SetText("Nazwy własne w sekcji Zadanie - wyświetlaj zawsze w oryginale EN");  
  
  local QTRIntegration0 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRIntegration0:SetFontObject(GameFontWhite);
  QTRIntegration0:SetJustifyH("LEFT");
  QTRIntegration0:SetJustifyV("TOP");
  QTRIntegration0:ClearAllPoints();
  QTRIntegration0:SetPoint("TOPLEFT", QTRCheckButtonOwnName2, "BOTTOMLEFT", 10, -15);
  QTRIntegration0:SetFont(QTR_Font2, 13);
  QTRIntegration0:SetText("Integracja z innymi addonami:");
  
  local QTRIntegration1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRIntegration1:SetFontObject(GameFontNormal);
  QTRIntegration1:SetJustifyH("LEFT");
  QTRIntegration1:SetJustifyV("TOP");
  QTRIntegration1:ClearAllPoints();
  QTRIntegration1:SetPoint("TOPLEFT", QTRIntegration0, "TOPRIGHT", 15, 0);
  QTRIntegration1:SetFont(QTR_Font2, 13);
  QTRIntegration1:SetText("Immersion,  Storyline");

--*  local QTRCheckOther1 = CreateFrame("CheckButton", "QTRCheckOther1", QTROptions, "SettingsCheckBoxControlTemplate");     -- Classic Quest Log
--*  QTRCheckOther1.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["other1"]=="0") then QTR_PS["other1"]="1" else QTR_PS["other1"]="0" end; end);
--*  QTRCheckOther1.CheckBox:SetPoint("TOPLEFT", QTRIntegration1, "BOTTOMLEFT", -10, -10);
--*  QTRCheckOther1:SetPoint("TOPLEFT", QTRIntegration1, "BOTTOMLEFT", 30, -10);
--*  QTRCheckOther1.Text:SetFont(QTR_Font2, 13);
--*  if (ClassicQuestLog ~= nil ) then
--*     QTRCheckOther1.Text:SetText(QTR_Reklama.OTHER1..QTR_Reklama.ACTIV1);
--*  else
--*     QTRCheckOther1.Text:SetText(QTR_Reklama.OTHER1..QTR_Reklama.ACTIV2);
--*  end

  local QTRCheckOther2 = CreateFrame("CheckButton", "QTRCheckOther2", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckOther2.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["other2"]=="0") then QTR_PS["other2"]="1" else QTR_PS["other2"]="0" end; end);
  QTRCheckOther2.CheckBox:SetPoint("TOPLEFT", QTRIntegration1, "BOTTOMLEFT", -10, -10);
  QTRCheckOther2:SetPoint("TOPLEFT", QTRIntegration1, "BOTTOMLEFT", 30, -10);
  QTRCheckOther2.Text:SetFont(QTR_Font2, 13);
  if (ImmersionFrame ~= nil ) then
     QTRCheckOther2.Text:SetText(QTR_Reklama.OTHER2..QTR_Reklama.ACTIV1);
  else
     QTRCheckOther2.Text:SetText(QTR_Reklama.OTHER2..QTR_Reklama.ACTIV2);
  end
  
  local QTRCheckOther3 = CreateFrame("CheckButton", "QTRCheckOther3", QTROptions, "SettingsCheckBoxControlTemplate");
  QTRCheckOther3.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["other3"]=="0") then QTR_PS["other3"]="1" else QTR_PS["other3"]="0" end; end);
  QTRCheckOther3.CheckBox:SetPoint("TOPLEFT", QTRCheckOther2.CheckBox, "BOTTOMLEFT", 0, 5);
  QTRCheckOther3:SetPoint("TOPLEFT", QTRCheckOther2.CheckBox, "BOTTOMLEFT", 40, 5);
  QTRCheckOther3.Text:SetFont(QTR_Font2, 13);
  QTRCheckOther3.Text:SetText(QTR_Reklama.OTHER3);
  
  local QTRWWW1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRWWW1:SetFontObject(GameFontWhite);
  QTRWWW1:SetJustifyH("LEFT");
  QTRWWW1:SetJustifyV("TOP");
  QTRWWW1:ClearAllPoints();
  QTRWWW1:SetPoint("BOTTOMLEFT", 16, 16);
  QTRWWW1:SetFont(QTR_Font2, 13);
  QTRWWW1:SetText(QTR_Reklama.WWW1);
  
  local QTRWWW2 = CreateFrame("EditBox", "QTRWWW2", QTROptions, "InputBoxTemplate");
  QTRWWW2:ClearAllPoints();
  QTRWWW2:SetPoint("TOPLEFT", QTRWWW1, "TOPRIGHT", 10, 4);
  QTRWWW2:SetHeight(20);
  QTRWWW2:SetWidth(170);
  QTRWWW2:SetAutoFocus(false);
  QTRWWW2:SetFontObject(GameFontGreen);
  QTRWWW2:SetText(QTR_Reklama.WWW2);
  QTRWWW2:SetCursorPosition(0);
  QTRWWW2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(QTR_Font2, 13);
  	  GameTooltip:SetText(QTR_Reklama.WWW3, nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  QTRWWW2:SetScript("OnLeave", function(self)
	  GameTooltip:Hide() --Hide the tooltip
     end);
  QTRWWW2:SetScript("OnTextChanged", function(self) QTRWWW2:SetText(QTR_Reklama.WWW2); end);

  local QTRdiscord2 = CreateFrame("EditBox", "QTRWWW2", QTROptions, "InputBoxTemplate");
  QTRdiscord2:ClearAllPoints();
  QTRdiscord2:SetPoint("BOTTOMLEFT", QTRWWW2, "TOPLEFT", 0, 3);
  QTRdiscord2:SetHeight(20);
  QTRdiscord2:SetWidth(200);
  QTRdiscord2:SetAutoFocus(false);
  QTRdiscord2:SetFontObject(GameFontGreen);
  QTRdiscord2:SetText("https://discord.gg/s5rKEJMukA");
  QTRdiscord2:SetCursorPosition(0);
  QTRdiscord2:SetScript("OnEnter", function(self)
	  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
      getglobal("GameTooltipTextLeft1"):SetFont(QTR_Font2, 13);
  	  GameTooltip:SetText(QTR_Reklama.WWW3, nil, nil, nil, nil, true)
	  GameTooltip:Show() --Show the tooltip
     end);
  QTRdiscord2:SetScript("OnLeave", function(self)
	  GameTooltip:Hide() --Hide the tooltip
     end);
  QTRdiscord2:SetScript("OnTextChanged", function(self) QTRdiscord2:SetText("https://discord.gg/s5rKEJMukA"); end);

  local QTRdiscord1 = QTROptions:CreateFontString(nil, "ARTWORK");
  QTRdiscord1:SetFontObject(GameFontWhite);
  QTRdiscord1:SetJustifyH("LEFT");
  QTRdiscord1:SetJustifyV("TOP");
  QTRdiscord1:ClearAllPoints();
  QTRdiscord1:SetPoint("TOPRIGHT", QTRdiscord2, "TOPLEFT", -10, -4);
  QTRdiscord1:SetFont(QTR_Font2, 13);
  QTRdiscord1:SetText("Discord:");
  
  local QTR_STframe = CreateFrame("Frame","QTR_STframe", QTROptions, "BasicFrameTemplateWithInset");
  QTR_STframe:SetMovable(false);
  QTR_STframe:SetWidth(600);
  QTR_STframe:SetHeight(400);
  QTR_STframe:ClearAllPoints();
  QTR_STframe:SetPoint("CENTER", QTROptions, "CENTER", 0, 0);
  QTR_STframe.title = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.title:SetPoint("CENTER", QTR_STframe.TitleBg);
  QTR_STframe.title:SetText("Inni gracze");
  
  QTR_STframe.text = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.text:SetPoint("TOPLEFT", QTR_STframe, "TOPLEFT", 20, -40);
  QTR_STframe.text:SetText("Liczba graczy z tym dodatkiem:");
  QTR_STframe.text:SetFont(QTR_Font2, 15);
  
  QTR_STframe.count = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontNormal");
  QTR_STframe.count:SetPoint("TOPLEFT", QTR_STframe.text, "TOPRIGHT", 10, 0);
  QTR_STframe.count:SetText("? ");
  QTR_STframe.count:SetFont(QTR_Font2, 15);

  QTR_STframe.alert = QTR_STframe:CreateFontString(nil, "OVERLAY", "GameFontRed");
  QTR_STframe.alert:SetPoint("TOPLEFT", QTR_STframe.text, "TOPRIGHT", 40, -2);
  QTR_STframe.alert:SetText("");
  QTR_STframe.alert:SetFont(QTR_Font2, 13);

  QTR_STframe.ScrollFrame = CreateFrame("ScrollFrame", nil, QTR_STframe, "UIPanelScrollFrameTemplate");
  QTR_STframe.ScrollFrame:SetPoint("TOPLEFT", QTR_STframe.InsetBg, "TOPLEFT", 10, -40);
  QTR_STframe.ScrollFrame:SetPoint("BOTTOMRIGHT", QTR_STframe.InsetBg, "BOTTOMRIGHT", -5, 10);
  
  QTR_STframe.ScrollFrame.ScrollBar:ClearAllPoints();
  QTR_STframe.ScrollFrame.ScrollBar:SetPoint("TOPLEFT", QTR_STframe.ScrollFrame, "TOPRIGHT", -12, -18);
  QTR_STframe.ScrollFrame.ScrollBar:SetPoint("BOTTOMRIGHT", QTR_STframe.ScrollFrame, "BOTTOMRIGHT", -7, 15);
  local child = CreateFrame("Frame", nil, QTR_STframe.ScrollFrame);
  child:SetSize(552,500);
  child.bg = child:CreateTexture(nil, "BACKGROUND");
  child.bg:SetAllPoints(true);
  child.bg:SetColorTexture(0, 0.05, 0.1, 0.8);
  QTR_STframe.ScrollFrame:SetScrollChild(child);
  QTR_STframe.ScrollFrame:SetScript("OnMouseWheel", QTR_ScrollFrame_OnMouseWheel);
  
  QTR_STframe.tabela1 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.tabela1:SetPoint("TOPLEFT", child, "TOPLEFT", 10, -10);
  QTR_STframe.tabela1:SetText("");
  QTR_STframe.tabela1:SetJustifyH("LEFT");
  QTR_STframe.tabela1:SetFont(QTR_Font2, 15);
  
  QTR_STframe.tabela2 = child:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_STframe.tabela2:SetPoint("TOPLEFT", child, "TOPLEFT", 150, -10);
  QTR_STframe.tabela2:SetText("");
  QTR_STframe.tabela2:SetJustifyH("LEFT");
  QTR_STframe.tabela2:SetFont(QTR_Font2, 15);

  QTR_STframe.CloseButton:SetPoint("TOPRIGHT", QTR_STframe, "TOPRIGHT", 0, 0);
  QTR_STframe:SetFrameLevel(10);
  QTR_STframe:Hide();
 
  local QTR_SeTframe = CreateFrame("Frame","QTR_SeTframe", QTROptions, "BasicFrameTemplateWithInset");
  QTR_SeTframe:SetMovable(false);
  QTR_SeTframe:SetWidth(400);
  QTR_SeTframe:SetHeight(270);
  QTR_SeTframe:ClearAllPoints();
  QTR_SeTframe:SetPoint("CENTER", QTROptions, "CENTER", 0, 0);
  QTR_SeTframe.title = QTR_SeTframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeTframe.title:SetPoint("CENTER", QTR_SeTframe.TitleBg);
  QTR_SeTframe.title:SetText("Ustawienia dźwięków");
  QTR_SeTframe.title:SetFont(QTR_Font2, 13);

  QTR_SeTframe.text = QTR_SeTframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeTframe.text:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 25, -40);
  QTR_SeTframe.text:SetText("Odtwarzaj zaznaczone dźwięki:");
  QTR_SeTframe.text:SetFont(QTR_Font2, 15);
  
  local QTR_SeTframeCheck1 = CreateFrame("CheckButton", "QTR_SeTframeCheck1", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck1.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice1"]=="1") then QTR_PS["voice1"]="0" else QTR_PS["voice1"]="1" end; end);
  QTR_SeTframeCheck1.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -70);
  QTR_SeTframeCheck1:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -70);
  QTR_SeTframeCheck1.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck1.Text:SetText("GŁOS: Dodatek WoWpoPolsku został uruchomiony");  

  local QTR_SeTframeCheck2 = CreateFrame("CheckButton", "QTR_SeTframeCheck2", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck2.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice2"]=="1") then QTR_PS["voice2"]="0" else QTR_PS["voice2"]="1" end; end);
  QTR_SeTframeCheck2.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -95);
  QTR_SeTframeCheck2:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -95);
  QTR_SeTframeCheck2.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck2.Text:SetText("GŁOS: Brak tłumaczenia");  

  local QTR_SeTframeCheck3 = CreateFrame("CheckButton", "QTR_SeTframeCheck3", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck3.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice3"]=="1") then QTR_PS["voice3"]="0" else QTR_PS["voice3"]="1" end; end);
  QTR_SeTframeCheck3.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -120);
  QTR_SeTframeCheck3:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -120);
  QTR_SeTframeCheck3.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck3.Text:SetText("GŁOS: Wersja polska");  

  local QTR_SeTframeCheck4 = CreateFrame("CheckButton", "QTR_SeTframeCheck4", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck4.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice4"]=="1") then QTR_PS["voice4"]="0" else QTR_PS["voice4"]="1" end; end);
  QTR_SeTframeCheck4.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -145);
  QTR_SeTframeCheck4:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -145);
  QTR_SeTframeCheck4.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck4.Text:SetText("GŁOS: Wersja angielska");  

  local QTR_SeTframeCheck5 = CreateFrame("CheckButton", "QTR_SeTframeCheck5", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck5.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice5"]=="1") then QTR_PS["voice5"]="0" else QTR_PS["voice5"]="1" end; end);
  QTR_SeTframeCheck5.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -170);
  QTR_SeTframeCheck5:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -170);
  QTR_SeTframeCheck5.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck5.Text:SetText("GŁOS: Dostępna jest nowa wersja dodatku");  

  local QTR_SeTframeCheck6 = CreateFrame("CheckButton", "QTR_SeTframeCheck6", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck6.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice6"]=="1") then QTR_PS["voice6"]="0" else QTR_PS["voice6"]="1" end; end);
  QTR_SeTframeCheck6.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -195);
  QTR_SeTframeCheck6:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -195);
  QTR_SeTframeCheck6.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck6.Text:SetText("GŁOS: Dostępna jest nowa wersja bazy tłumaczeń");  

  local QTR_SeTframeCheck7 = CreateFrame("CheckButton", "QTR_SeTframeCheck7", QTR_SeTframe, "SettingsCheckBoxControlTemplate");
  QTR_SeTframeCheck7.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["voice7"]=="1") then QTR_PS["voice7"]="0" else QTR_PS["voice7"]="1" end; end);
  QTR_SeTframeCheck7.CheckBox:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 20, -220);
  QTR_SeTframeCheck7:SetPoint("TOPLEFT", QTR_SeTframe, "TOPLEFT", 60, -220);
  QTR_SeTframeCheck7.Text:SetFont(QTR_Font2, 13);
  QTR_SeTframeCheck7.Text:SetText("GŁOS: Dostępna jest nowa wersja bazy gossip");  

  QTR_SeTframe.CloseButton:SetPoint("TOPRIGHT", QTR_SeTframe, "TOPRIGHT", 0, 0);
  QTR_SeTframe:SetFrameLevel(9);
  QTR_SeTframe:Hide();
  
  local QTR_SeRframe = CreateFrame("Frame","QTR_SeRframe", QTROptions, "BasicFrameTemplateWithInset");
  QTR_SeRframe:SetMovable(false);
  QTR_SeRframe:SetWidth(400);
  QTR_SeRframe:SetHeight(270);
  QTR_SeRframe:ClearAllPoints();
  QTR_SeRframe:SetPoint("CENTER", QTROptions, "CENTER", 0, 0);
  QTR_SeRframe.title = QTR_SeRframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeRframe.title:SetPoint("CENTER", QTR_SeRframe.TitleBg);
  QTR_SeRframe.title:SetText("Ustawienia wyświetlania reklamy");
  QTR_SeRframe.title:SetFont(QTR_Font2, 13);

  QTR_SeRframe.text1 = QTR_SeRframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeRframe.text1:SetPoint("TOPLEFT", QTR_SeRframe, "TOPLEFT", 25, -40);
  QTR_SeRframe.text1:SetText(QTR_Reklama.ON);
  QTR_SeRframe.text1:SetFont(QTR_Font2, 15);
  
  QTRReklEditBox = CreateFrame("EditBox", "QTREditBox", QTR_SeRframe, "InputBoxTemplate");
  QTRReklEditBox:SetPoint("TOPLEFT", QTR_SeRframe.text1, "TOPRIGHT", 15, 3);
  QTRReklEditBox:SetHeight(20);
  QTRReklEditBox:SetWidth(20);
  QTRReklEditBox:SetAutoFocus(false);
  QTRReklEditBox:SetText(QTR_PS["channel"]);
  QTRReklEditBox:SetCursorPosition(0);
  QTRReklEditBox:SetScript("OnTextChanged", function(self) if (strlen(QTREditBox:GetText())>0) then QTR_PS["channel"]=QTREditBox:GetText() end; end);

  QTR_SeRframe.text2 = QTR_SeRframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeRframe.text2:SetPoint("TOPLEFT", QTR_SeRframe, "TOPLEFT", 25, -70);
  QTR_SeRframe.text2:SetText(QTR_Reklama.PERIOD);
  QTR_SeRframe.text2:SetFont(QTR_Font2, 15);
  
  local QTR_slider = CreateFrame("Slider","MyAddonSlider",QTR_SeRframe,'OptionsSliderTemplate');
  QTR_slider:ClearAllPoints();
  QTR_slider:SetPoint("TOPLEFT",QTR_SeRframe.text2, "BOTTOMLEFT", 80, -20);
  getglobal(QTR_slider:GetName() .. 'Low'):SetText('15 min.');
  getglobal(QTR_slider:GetName() .. 'High'):SetText('90 min.');
  getglobal(QTR_slider:GetName() .. 'Text'):SetText('20 min.');
  QTR_slider:SetMinMaxValues(15, 90);
  QTR_slider:SetValue(QTR_PS["period"]);
  getglobal(QTR_slider:GetName() .. 'Text'):SetText(QTR_PS["period"] .. " min.");
  QTR_slider:SetValueStep(5);
  QTR_slider:SetScript("OnValueChanged", function(self)
      QTR_PS["period"] = math.floor(QTR_slider:GetValue()+0.5);
      getglobal(QTR_slider:GetName() .. 'Text'):SetText(QTR_PS["period"] .. " min.");
      end);
  
  QTR_SeRframe.text3 = QTR_SeRframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeRframe.text3:SetPoint("TOPLEFT", QTR_SeRframe, "TOPLEFT", 25, -150);
  QTR_SeRframe.text3:SetText(QTR_Reklama.CHOICE1);
  QTR_SeRframe.text3:SetFont(QTR_Font2, 15);
  
  QTR_SeRframe.text4 = QTR_SeRframe:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
  QTR_SeRframe.text4:SetPoint("TOPLEFT", QTR_SeRframe, "TOPLEFT", 25, -170);
  QTR_SeRframe.text4:SetText(QTR_Reklama.CHOICE2);
  QTR_SeRframe.text4:SetFont(QTR_Font2, 15);
  
  QTRCheckText1 = CreateFrame("CheckButton", "QTRCheckText1", QTR_SeRframe, "SettingsCheckBoxControlTemplate");
  QTRCheckText1.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["text1"]=="0") then QTR_PS["text1"]="1" else QTR_PS["text1"]="0" end; end);
  QTRCheckText1.CheckBox:SetPoint("TOPLEFT", QTR_SeRframe.text4, "TOPLEFT", -10, -20);
  QTRCheckText1:SetPoint("TOPLEFT", QTR_SeRframe.text4, "BOTTOMLEFT", 30, -8);
  QTRCheckText1.Text:SetFont(QTR_Font2, 13);
  QTRCheckText1.Text:SetText(string.sub(QTR_Reklama.TEXT1,1,45).." ...");

  QTRCheckText2 = CreateFrame("CheckButton", "QTRCheckText2", QTR_SeRframe, "SettingsCheckBoxControlTemplate");
  QTRCheckText2.CheckBox:SetScript("OnClick", function(self) if (QTR_PS["text2"]=="0") then QTR_PS["text2"]="1" else QTR_PS["text2"]="0" end; end);
  QTRCheckText2.CheckBox:SetPoint("TOPLEFT", QTR_SeRframe.text4, "TOPLEFT", -10, -50);
  QTRCheckText2:SetPoint("TOPLEFT", QTR_SeRframe.text4, "BOTTOMLEFT", 30, -38);
  QTRCheckText2.Text:SetFont(QTR_Font2, 13);
  QTRCheckText2.Text:SetText(string.sub(QTR_Reklama.TEXT2,1,45).." ...");

  QTR_SeRframe.CloseButton:SetPoint("TOPRIGHT", QTR_SeRframe, "TOPRIGHT", 0, 0);
  QTR_SeRframe:SetFrameLevel(8);
  QTR_SeRframe:Hide();
end


function GS_ON_OFF()
   if (curr_goss=="1") then         -- wyłącz tłumaczenie - pokaż oryginalny tekst
      curr_goss="0";
      GossipGreetingText:SetText(QTR_GS[curr_hash]);
      GossipGreetingText:SetFont(Original_Font2, 13);      
      QTR_ToggleButtonGS1:SetText("Gossip-Hash="..tostring(curr_hash).." EN");
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice4"]=="1") and (QTR_first_gs_voice==1)) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-angielska.mp3");
      end
   else                             -- pokaż tłumaczenie PL
      curr_goss="1";
      local Greeting_PL = GS_Gossip[curr_hash];
      GossipGreetingText:SetText(QTR_ExpandUnitInfo(Greeting_PL,false));
      GossipGreetingText:SetFont(QTR_Font2, 13);      
      QTR_ToggleButtonGS1:SetText("Gossip-Hash="..tostring(curr_hash).." PL");
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice3"]=="1") and (QTR_first_gs_voice==1)) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-polska.mp3");
         QTR_first_gs_voice=1;
      end
   end
end


-- Otworzono okienko rozmowy z NPC
function QTR_Gossip_Show()
--   QTR_ToggleButtonGS1:Hide();
--   QTR_GossipFrame:Hide();
   local Nazwa_NPC = GossipFrameTitleText:GetText();
   if ((Nazwa_NPC==nil) and isImmersion()) then       -- jest aktywny Immersion
      Nazwa_NPC = ImmersionFrame.TalkBox.NameFrame.Name:GetText();
   end
   curr_hash = 0;
   if (Nazwa_NPC) then
      local GossipTextFrame;
--print("GS: GossipFrame");      
      Greeting_Text = C_GossipInfo:GetText();         
      for _,GTxtframe in GossipFrame.GreetingPanel.ScrollBox:EnumerateFrames() do      -- pobierz obiekty enumeryczne
         local GTtype =  GTxtframe.GetElementData().buttonType;
         if (GTxtframe.GreetingText) then    -- Greeting Text
            GossipTextFrame = GTxtframe;
         else
            if ((GTtype==3) or (((GTtype==4) or (GTtype==5)) and (QTR_PS["transtitle"]=="1"))) then    -- gossip options
               local GOptionText = GTxtframe:GetText();
               local prefix = "";
               local sufix = "";
               if (string.sub(GOptionText,1,2) == "|c") then
                  prefix = string.sub(GOptionText, 1, 10);
                  sufix = "|r";
                  GOptionText = string.gsub(GOptionText, prefix, "");
                  GOptionText = string.gsub(GOptionText, sufix, "");
               end
               local OptHash = StringHash(GOptionText);
               if (GS_Gossip[OptHash]) then               -- jest tłumaczenie
                  GTxtframe:SetText(prefix .. QTR_ExpandUnitInfo(GS_Gossip[OptHash],false) .. sufix);
                  local regions = { GTxtframe:GetRegions() };     -- poszukiwanie obiektu FontString do ustawienia własnej czcionki
                  for k, v in pairs(regions) do
                     if (v:GetObjectType() == "FontString") then
                        v:SetFont(QTR_Font2, 13);
                     end
                  end
               end
            end
         end
      end
      if (string.find(Greeting_Text," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         Nazwa_NPC = string.gsub(Nazwa_NPC, '"', '\"');
         Greeting_Text = string.gsub(Greeting_Text, '"', '\"');
         local Czysty_Text = string.gsub(Greeting_Text, '\r', '');
         Czysty_Text = string.gsub(Czysty_Text, '\n', '$B');
         Czysty_Text = string.gsub(Czysty_Text, QTR_name, '$N');
         Czysty_Text = string.gsub(Czysty_Text, string.upper(QTR_name), '$N$');
         Czysty_Text = string.gsub(Czysty_Text, QTR_race, '$R');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_race), '$R');
         Czysty_Text = string.gsub(Czysty_Text, QTR_class, '$C');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_class), '$C');
         Czysty_Text = string.gsub(Czysty_Text, '$N$', '');
         Czysty_Text = string.gsub(Czysty_Text, '$N', '');
         Czysty_Text = string.gsub(Czysty_Text, '$B', '');
         Czysty_Text = string.gsub(Czysty_Text, '$R', '');
         Czysty_Text = string.gsub(Czysty_Text, '$C', '');
         local Hash = StringHash(Czysty_Text);
         curr_hash = Hash;
         QTR_GS[Hash] = Greeting_Text;                      -- zapis oryginalnego tekstu
         if ( GS_Gossip[Hash] ) then   -- istnieje tłumaczenie tekstu GOSSIP tego NPC
            local Greeting_PL = GS_Gossip[Hash];
            if (GossipTextFrame) then
               QTR_ToggleButtonGS1:SetText("Gossip-Hash="..tostring(Hash).." PL");
               QTR_ToggleButtonGS1:Enable();
--               QTR_ToggleButtonGS1:Show();
               GossipGreetingText = GossipTextFrame.GreetingText;
               GossipGreetingText:SetText(QTR_ExpandUnitInfo(Greeting_PL,false));
               GossipGreetingText:SetFont(QTR_Font2, 13);
--               QTR_GossipFrame:Hide();
               curr_goss="1";
--            else
--               QTR_ToggleButtonGS2:SetText("Gossip-Hash="..tostring(Hash).." PL");
--               QTR_GossipFrame.text:SetText(QTR_ExpandUnitInfo(Greeting_PL,false));
--               QTR_GossipFrame.text:SetFont(QTR_Font2, 13);
--               QTR_GossipFrame:Show();
            end
            if (isImmersion() and (QTR_PS["other2"]=="1")) then       -- jest aktywny Immersion i zezwolono na tłumaczenia
               ImmersionFrame.TalkBox.TextFrame.Text:SetFont(QTR_Font2, 14);
               ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_ExpandUnitInfo(Greeting_PL,false));     
            end
         else              -- nie mamy tłumaczenia
            QTR_ToggleButtonGS1:SetText("Gossip-Hash="..tostring(Hash).." EN");
            QTR_ToggleButtonGS1:Disable();
--            QTR_ToggleButtonGS1:Show();
            if (QTR_PS["gossiponline"]=="1") then
               QTR_FrameOnLineHash = Hash;
               QTR_ShowOnLine();
            elseif (QTR_FrameOnLine) then
               QTR_FrameOnLine:Hide();
            end
            -- zapis do pliku
            if (C_Map.GetBestMapForUnit("player")) then
               QTR_GOSSIP[Nazwa_NPC.."@"..tostring(Hash).."@"..C_Map.GetBestMapForUnit("player")] = Greeting_Text.."@"..QTR_name..":"..QTR_race..":"..QTR_class;
            else
               QTR_GOSSIP[Nazwa_NPC.."@"..tostring(Hash).."@0"] = Greeting_Text.."@"..QTR_name..":"..QTR_race..":"..QTR_class;
            end
         end
      end
--      if (not QTR_wait(3,QTR_FlightMap_IsShow)) then     -- po 3 sek. sprawdź, czy jest otwarte okno FlightMapFrame, MerchantFrame itp.
      ---
--      end      
   end
end


--function QTR_FlightMap_IsShow()        -- zamyka okno QTR_GossipFrame, gdy otwarte jest okno FlightMapFrame
--   if (FlightMapFrame and FlightMapFrame:IsVisible()) then
--      QTR_GossipFrame:Hide();
--   end
--   if (MerchantFrame and MerchantFrame:IsVisible()) then
--      QTR_GossipFrame:Hide();
--   end
--   if (ClassTrainerFrame and ClassTrainerFrame:IsVisible()) then
--      QTR_GossipFrame:Hide();
--   end
--end


function GossipOnQuestFrame()
   if ((GreetingText:IsVisible()) and (QTR_PS["gossip"]=="1")) then     -- mamy gossip w QuestFrame i włączone wyświetlanie tłumaczeń gossip
      QTR_ToggleButton0:Disable();        -- nie można na ten przycisk klikać
      local Greeting_Text = GreetingText:GetText();
--print("GS: QuestFrame");      
      if (string.find(Greeting_Text," ")==nil) then         -- nie jest to tekst po polsku (nie ma twardej spacji)
         Greeting_Text = string.gsub(Greeting_Text, '"', '\"');
         local Czysty_Text = string.gsub(Greeting_Text, '\r', '');
         Czysty_Text = string.gsub(Czysty_Text, '\n', '$B');
         Czysty_Text = string.gsub(Czysty_Text, QTR_name, '$N');
         Czysty_Text = string.gsub(Czysty_Text, string.upper(QTR_name), '$N$');
         Czysty_Text = string.gsub(Czysty_Text, QTR_race, '$R');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_race), '$R');
         Czysty_Text = string.gsub(Czysty_Text, QTR_class, '$C');
         Czysty_Text = string.gsub(Czysty_Text, string.lower(QTR_class), '$C');
         Czysty_Text = string.gsub(Czysty_Text, '$N$', '');
         Czysty_Text = string.gsub(Czysty_Text, '$N', '');
         Czysty_Text = string.gsub(Czysty_Text, '$B', '');
         Czysty_Text = string.gsub(Czysty_Text, '$R', '');
         Czysty_Text = string.gsub(Czysty_Text, '$C', '');
         local Hash = StringHash(Czysty_Text);
         QTR_ToggleButton0:SetText("Gossip="..tostring(Hash));
         if ( GS_Gossip[Hash] ) then   -- istnieje tłumaczenie tekstu GOSSIP dla tego hasha
            local Greeting_PL = GS_Gossip[Hash];
            GreetingText:SetText(QTR_ExpandUnitInfo(Greeting_PL,false));
            GreetingText:SetFont(QTR_Font2, 13);
         else
            local Nazwa_NPC = QuestFrameTitleText:GetText();
            QTR_GOSSIP[Nazwa_NPC..'@'..tostring(Hash).."@"..C_Map.GetBestMapForUnit("player")] = Greeting_Text.."@"..QTR_name..":"..QTR_race..":"..QTR_class;
            if (QTR_PS["gossiponline"]=="1") then
               QTR_FrameOnLineHash = Hash;
               QTR_ShowOnLine();
            elseif (QTR_FrameOnLine) then
               QTR_FrameOnLine:Hide();
            end
         end
         if (CurrentQuestsText and CurrentQuestsText:IsVisible()) then
            CurrentQuestsText:SetText(QTR_Messages.currquests);
            CurrentQuestsText:SetFont(QTR_Font1, 18);
         end
         if (AvailableQuestsText and AvailableQuestsText:IsVisible()) then
            AvailableQuestsText:SetText(QTR_Messages.avaiquests);
            AvailableQuestsText:SetFont(QTR_Font1, 18);
         end
         if (QTR_PS["transtitle"]=="1") then
            for GText in QuestFrameGreetingPanel.titleButtonPool:EnumerateActive() do
               local GossText = GText:GetText();
               local prefix = "";
               local sufix = "";
               if (string.sub(GossText,1,2) == "|c") then
                  prefix = string.sub(GossText, 1, 10);
                  sufix = "|r";
                  GossText = string.gsub(GossText, prefix, "");
                  GossText = string.gsub(GossText, sufix, "");
               end
               local TitleHash = StringHash(GossText);
               if (GS_Gossip[TitleHash]) then
                  GText:SetText(prefix .. QTR_ExpandUnitInfo(GS_Gossip[TitleHash],false) .. sufix);
                  local regions = { GText:GetRegions() };     -- poszukiwanie obiektu FontString do ustawienia własnej czcionki
                  for k, v in pairs(regions) do
                     if (v:GetObjectType() == "FontString") then
                        v:SetFont(QTR_Font2, 13);
                     end
                  end
               else
                  local Nazwa_NPC = QuestFrameTitleText:GetText();
                  QTR_GOSSIP[Nazwa_NPC..'@'..tostring(TitleHash).."@"..C_Map.GetBestMapForUnit("player")] = GossText;
               end
            end
         end
      end
   end
end


function QTR_ShowOnLine()
   if (QTR_FrameOnLine==nil) then            -- nie ma jeszcze utworzonego okienka tłumaczenia w grze
      QTR_FrameOnLine = CreateFrame("Frame", "FrameOnLine", GossipFrame, "BasicFrameTemplateWithInset");
      QTR_FrameOnLine:SetMovable(false);
      QTR_FrameOnLine:SetWidth(300);
      QTR_FrameOnLine:SetHeight(300);
      QTR_FrameOnLine:ClearAllPoints();
      QTR_FrameOnLine:SetPoint("TOPLEFT", GossipFrame, "TOPRIGHT", 0, 0);
      QTR_FrameOnLine.title = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
      QTR_FrameOnLine.title:SetPoint("CENTER", QTR_FrameOnLine.TitleBg);
      QTR_FrameOnLine.title:SetText("Tłumaczenie w czasie gry");
      QTR_FrameOnLine.text = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontNormal");
      QTR_FrameOnLine.text:SetPoint("TOPLEFT", QTR_FrameOnLine, "TOPLEFT", 20, -60);
      QTR_FrameOnLine.text:SetText("Podaj tłumaczenie tekstu GOSSIP:");
      QTR_FrameOnLine.text:SetFont(QTR_Font2, 15);
      
      QTR_FrameOnLine.tlum = CreateFrame("EditBox", nil, QTR_FrameOnLine, BackdropTemplateMixin and "BackdropTemplate" or nil);
      QTR_FrameOnLine.tlum:SetBackdrop({
	      bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
	      edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
	      tile = false, tileSize = 1, edgeSize = 1,
	      insets = {left = 3, right = 3, top = 3, bottom = 3},
         });
      QTR_FrameOnLine.tlum:SetBackdropColor(0, 0, 0);
      QTR_FrameOnLine.tlum:SetBackdropBorderColor(0.3, 0.3, 0.3);
      QTR_FrameOnLine.tlum:SetMultiLine(true);
      QTR_FrameOnLine.tlum:SetSize(255, 150);
      QTR_FrameOnLine.tlum:SetPoint("TOPLEFT", QTR_FrameOnLine, "TOPLEFT", 22, -85);
      QTR_FrameOnLine.tlum:SetAutoFocus(false);
      QTR_FrameOnLine.tlum:SetCursorPosition(0);
      QTR_FrameOnLine.tlum:SetMaxLetters(99999);
      local a1, a2, a3 = QTR_FrameOnLine.tlum:GetFont();
      QTR_FrameOnLine.tlum:SetFont(QTR_Font2, 15, a3);
      QTR_FrameOnLine.tlum:SetJustifyH("LEFT");
      QTR_FrameOnLine.tlum:SetJustifyV("CENTER");
      
      -- przycisk "Zapisz tłumaczenie"
      QTR_FrameOnLineButton = CreateFrame("Button",nil, QTR_FrameOnLine, "UIPanelButtonTemplate");
      QTR_FrameOnLineButton:SetWidth(245);
      QTR_FrameOnLineButton:SetHeight(25);
      QTR_FrameOnLineButton:SetText("Zapisz ponizsze tłumaczenie");
--      QTR_FrameOnLineButton:SetFont(QTR_Font2, 15);
      QTR_FrameOnLineButton:Show();
      QTR_FrameOnLineButton:ClearAllPoints();
      QTR_FrameOnLineButton:SetPoint("TOPLEFT", QTR_FrameOnLine, "TOPLEFT", 25, -30);
      QTR_FrameOnLineButton:SetScript("OnClick", QTR_SaveGossipTranslation);

      QTR_FrameOnLine.alert = QTR_FrameOnLine:CreateFontString(nil, "OVERLAY", "GameFontRed");
      QTR_FrameOnLine.alert:SetPoint("BOTTOMLEFT", QTR_FrameOnLineButton, "TOPLEFT", -32, 10);
      QTR_FrameOnLine.alert:SetText("Tekst tłumaczenia jest pusty!");
      QTR_FrameOnLine.alert:SetFont(QTR_Font2, 15);
      QTR_FrameOnLine.alert:Hide();
   end
   if (QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)]) then
      QTR_FrameOnLine.tlum:SetText(QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)]);
   else
      QTR_FrameOnLine.tlum:SetText("");
   end
   QTR_FrameOnLine:Show();
end


function QTR_SaveGossipTranslation()               -- zapisz tłumaczenie online
   if (QTR_FrameOnLine.tlum:GetText() == "") then
      QTR_FrameOnLine.alert:Show();
   else      
      QTR_FrameOnLine.alert:Hide();
      QTR_GOSSIP_TR[tostring(QTR_FrameOnLineHash)] = QTR_FrameOnLine.tlum:GetText();
      QTR_FrameOnLine:Hide();
   end
end


function QTR_SaveQuest(event)
   if (event=="QUEST_DETAIL") then
      QTR_SAVED[QTR_quest_ID.." TITLE"]=GetTitleText();            -- save original title to future translation
      QTR_SAVED[QTR_quest_ID.." DESCRIPTION"]=GetQuestText();      -- save original text to future translation
      QTR_SAVED[QTR_quest_ID.." OBJECTIVE"]=GetObjectiveText();    -- save original text to future translation
      local QTR_mapID = C_Map.GetBestMapForUnit("player");
      if (QTR_mapID) then
         local QTR_mapINFO = C_Map.GetMapInfo(QTR_mapID);
         QTR_SAVED[QTR_quest_ID.." MAPID"]=QTR_mapID.."@"..QTR_mapINFO.name.."@"..QTR_mapINFO.mapType.."@"..QTR_mapINFO.parentMapID;     -- save mapID to locale place of this quest
      end
   end
   if (event=="QUEST_PROGRESS") then
      QTR_SAVED[QTR_quest_ID.." PROGRESS"]=GetProgressText();      -- save original text to future translation
   end
   if (event=="QUEST_COMPLETE") then
      QTR_SAVED[QTR_quest_ID.." COMPLETE"]=GetRewardText();        -- save original text to future translation
   end
   if (QTR_SAVED[QTR_quest_ID.." TITLE"]==nil) then
      QTR_SAVED[QTR_quest_ID.." TITLE"]=GetTitleText();            -- zapisz tytuł w przypadku tylko Zakończenia
   end
   QTR_SAVED[QTR_quest_ID.." PLAYER"]=QTR_name..'@'..QTR_race..'@'..QTR_class;  -- zapisz dane gracza
end


function QTR_wait(delay, func, ...)
  if(type(delay)~="number" or type(func)~="function") then
    return false;
  end
  if (QTR_waitFrame == nil) then
    QTR_waitFrame = CreateFrame("Frame","QTR_WaitFrame", UIParent);
    QTR_waitFrame:SetScript("onUpdate",function (self,elapse)
      local count = #QTR_waitTable;
      local i = 1;
      while(i<=count) do
        local waitRecord = tremove(QTR_waitTable,i);
        local d = tremove(waitRecord,1);
        local f = tremove(waitRecord,1);
        local p = tremove(waitRecord,1);
        if(d>elapse) then
          tinsert(QTR_waitTable,i,{d-elapse,f,p});
          i = i + 1;
        else
          count = count - 1;
          f(unpack(p));
        end
      end
    end);
  end
  tinsert(QTR_waitTable,{delay,func,{...}});
  return true;
end


function QTR_SendReklama()
  local now = GetTime();
  if (last_time + QTR_PS["period"]*60 < now) then                  -- OK, czas wypisać reklamę
     if ((QTR_PS["text1"]=="1") and (QTR_PS["text2"]=="1")) then   -- oba teksty naprzemiennie
        if (last_text==2) then
           if (tonumber(QTR_PS["channel"])>0) then
              SendChatMessage(QTR_Reklama.TEXT1,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
           else
              SendChatMessage(QTR_Reklama.TEXT1,"SAY");
           end
           last_text = 1;
        else
           if (tonumber(QTR_PS["channel"])>0) then
              SendChatMessage(QTR_Reklama.TEXT2,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
           else
              SendChatMessage(QTR_Reklama.TEXT2,"SAY");
           end
           last_text = 2;
        end
     elseif (QTR_PS["text1"]=="1") then
        if (tonumber(QTR_PS["channel"])>0) then
           SendChatMessage(QTR_Reklama.TEXT1,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
        else
           SendChatMessage(QTR_Reklama.TEXT1,"SAY");
        end        
        last_text = 1;
     elseif (QTR_PS["text2"]=="1") then
        if (tonumber(QTR_PS["channel"])>0) then
           SendChatMessage(QTR_Reklama.TEXT2,"CHANNEL",nil,tonumber(QTR_PS["channel"]));
        else
           SendChatMessage(QTR_Reklama.TEXT2,"SAY");
        end
        last_text = 2;
     end
     last_time = now;
  end   
end


function QTR_ON_OFF()
   if (curr_trans=="1") then
      curr_trans="0";
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice4"]=="1") and (QTR_first_voice==1)) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-angielska.mp3");
      end
      QTR_Translate_Off(1);
   else   
      curr_trans="1";
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice3"]=="1") and (QTR_first_voice==1)) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\wersja-polska.mp3");
         QTR_first_voice=1;
      end
      QTR_Translate_On(1);
   end
end


-- Pierwsza funkcja wywoływana po załadowaniu dodatku
function QTR_START()
   -- przycisk z nr ID questu w QuestFrame (NPC)
   QTR_ToggleButton0 = CreateFrame("Button",nil, QuestFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton0:SetWidth(150);
   QTR_ToggleButton0:SetHeight(20);
   QTR_ToggleButton0:SetText("Quest ID=?");
   QTR_ToggleButton0:Show();
   QTR_ToggleButton0:ClearAllPoints();
   QTR_ToggleButton0:SetPoint("TOPLEFT", QuestFrame, "TOPLEFT", 105, -32);
   QTR_ToggleButton0:SetScript("OnClick", QTR_ON_OFF);
   
   -- przycisk z nr ID questu w QuestLogPopupDetailFrame
   QTR_ToggleButton1 = CreateFrame("Button",nil, QuestLogPopupDetailFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton1:SetWidth(150);
   QTR_ToggleButton1:SetHeight(20);
   QTR_ToggleButton1:SetText("Quest ID=?");
   QTR_ToggleButton1:Show();
   QTR_ToggleButton1:ClearAllPoints();
   QTR_ToggleButton1:SetPoint("TOPLEFT", QuestLogPopupDetailFrame, "TOPLEFT", 45, -31);
   QTR_ToggleButton1:SetScript("OnClick", QTR_ON_OFF);

   -- przycisk z nr ID questu w QuestMapDetailsScrollFrame
   QTR_ToggleButton2 = CreateFrame("Button",nil, QuestMapDetailsScrollFrame, "UIPanelButtonTemplate");
   QTR_ToggleButton2:SetWidth(150);
   QTR_ToggleButton2:SetHeight(20);
   QTR_ToggleButton2:SetText("Quest ID=?");
   QTR_ToggleButton2:Show();
   QTR_ToggleButton2:ClearAllPoints();
   QTR_ToggleButton2:SetPoint("TOPLEFT", QuestMapDetailsScrollFrame, "TOPLEFT", 116, 29);
   QTR_ToggleButton2:SetScript("OnClick", QTR_ON_OFF);

   -- ramka do wyświetlania tłumaczenia tekstów gossip
--   QTR_GossipFrame = CreateFrame("Frame", "QTRGossipFrame", UIParent, "BasicFrameTemplateWithInset");
--   QTR_GossipFrame:SetMovable(false);
--   QTR_GossipFrame:SetWidth(300);
--   QTR_GossipFrame:SetHeight(300);
--   QTR_GossipFrame:ClearAllPoints();
--   QTR_GossipFrame:SetPoint("TOPLEFT", GossipFrame, "TOPRIGHT", 0, -2);
--   QTR_GossipFrame.title = QTR_GossipFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
--   QTR_GossipFrame.title:SetPoint("CENTER", QTR_GossipFrame.TitleBg);
--   QTR_GossipFrame.title:SetText("Tłumaczenie tekstu gossip:");
--   QTR_GossipFrame.ScrollFrame = CreateFrame("ScrollFrame", nil, QTR_GossipFrame, "UIPanelScrollFrameTemplate");
--   QTR_GossipFrame.ScrollFrame:SetPoint("TOPLEFT", QTR_GossipFrame.InsetBg, "TOPLEFT", 10, -40);
--   QTR_GossipFrame.ScrollFrame:SetPoint("BOTTOMRIGHT", QTR_GossipFrame.InsetBg, "BOTTOMRIGHT", -5, 10);
  
--   QTR_GossipFrame.ScrollFrame.ScrollBar:ClearAllPoints();
--   QTR_GossipFrame.ScrollFrame.ScrollBar:SetPoint("TOPLEFT", QTR_GossipFrame.ScrollFrame, "TOPRIGHT", -12, -18);
--   QTR_GossipFrame.ScrollFrame.ScrollBar:SetPoint("BOTTOMRIGHT", QTR_GossipFrame.ScrollFrame, "BOTTOMRIGHT", -7, 15);
--   local GSchild = CreateFrame("Frame", nil, QTR_GossipFrame.ScrollFrame);
--   GSchild:SetSize(552,500);
--   GSchild.bg = GSchild:CreateTexture(nil, "BACKGROUND");
--   GSchild.bg:SetAllPoints(true);
--   GSchild.bg:SetColorTexture(0, 0.05, 0.1, 0.8);
--   QTR_GossipFrame.ScrollFrame:SetScrollChild(GSchild);
--   QTR_GossipFrame.ScrollFrame:SetScript("OnMouseWheel", QTR_ScrollFrame_OnMouseWheel);
  
--   QTR_GossipFrame.text = GSchild:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
--   QTR_GossipFrame.text:SetPoint("TOPLEFT", GSchild, "TOPLEFT", 2, 0);
--   QTR_GossipFrame.text:SetText("");
--   QTR_GossipFrame.text:SetSize(250,0);
--   QTR_GossipFrame.text:SetJustifyH("LEFT");
--   QTR_GossipFrame.text:SetFont(QTR_Font2, 13);
   
--   QTR_GossipFrame.CloseButton:SetPoint("TOPRIGHT", QTR_GossipFrame, "TOPRIGHT", 0, 0);

   QTR:RegisterEvent("GOSSIP_SHOW");
   QTR:RegisterEvent("GOSSIP_CLOSED");
   
   -- przycisk z nr HASH gossip w GossipFrame
   QTR_ToggleButtonGS1 = CreateFrame("Button",nil, GossipFrame, "UIPanelButtonTemplate");
   QTR_ToggleButtonGS1:SetWidth(220);
   QTR_ToggleButtonGS1:SetHeight(20);
   QTR_ToggleButtonGS1:SetText("Gossip-Hash=?");
   QTR_ToggleButtonGS1:ClearAllPoints();
   QTR_ToggleButtonGS1:SetPoint("TOPLEFT", GossipFrame, "TOPLEFT", 75, -32);
   QTR_ToggleButtonGS1:Disable();
   QTR_ToggleButtonGS1:Show();
   QTR_ToggleButtonGS1:SetScript("OnClick", GS_ON_OFF);


   -- przycisk z nr HASH gossip w QTR_GossipFrame
--   QTR_ToggleButtonGS2 = CreateFrame("Button",nil, QTR_GossipFrame, "UIPanelButtonTemplate");
--   QTR_ToggleButtonGS2:SetWidth(220);
--   QTR_ToggleButtonGS2:SetHeight(20);
--   QTR_ToggleButtonGS2:SetText("Gossip-Hash=?");
--   QTR_ToggleButtonGS2:ClearAllPoints();
--   QTR_ToggleButtonGS2:SetPoint("TOPLEFT", QTR_GossipFrame, "TOPLEFT", 40, -32);
--   QTR_ToggleButtonGS2:Enable();
--   QTR_ToggleButtonGS2:Show();

   -- funkcja wywoływana po kliknięciu na nazwę questu w QuestTracker   
   hooksecurefunc(QUEST_TRACKER_MODULE, "OnBlockHeaderClick", QTR_PrepareReload);
   -- a ta funkcja wywoływana przy aktualizacji QuestTrackera
   hooksecurefunc(QUEST_TRACKER_MODULE, "EnumQuestWatchData", QTR_ObjectiveTracker_Check);
   WorldMapFrame:HookScript("OnHide", function() 
      if (not QTR_wait(0.1, QTR_ObjectiveTracker_QuestHeader)) then
      -- opóźnienie 0.1 sek
      end
   end );
   WorldMapFrame:HookScript("OnShow", function() 
      if (not QTR_wait(0.2, QTR_QuestScrollFrame_OnShow)) then
      -- opóźnienie 0.2 sek
      end
   end );
   hooksecurefunc("QuestLogQuests_Update", QTR_QuestLogQuests_Update);
   
   -- funkcja wywoływana po kliknięciu na nazwę questu w QuestMapFrame
   hooksecurefunc("QuestMapFrame_ShowQuestDetails", QTR_PrepareReload);
   
   -- funkcja wywoływana po wyświetleniu się obiektu GreetingText w oknie QuestFrame
   QuestFrame:SetScript("OnShow", GossipOnQuestFrame);
   QuestFrameAcceptButton:HookScript("OnClick", QTR_QuestFrameButton_OnClick);
   QuestFrameCompleteQuestButton:HookScript("OnClick", QTR_QuestFrameButton_OnClick);
   QuestLogPopupDetailFrame:HookScript("OnShow", QTR_QuestLogPopupShow);
   
   QTR:RegisterEvent("CHAT_MSG_ADDON");      -- ukryty kanał addonu
   C_ChatInfo.RegisterAddonMessagePrefix("WoWpoPolsku_QTR");
   
   isClassicQuestLog();
   isImmersion();
   isStoryline();       -- może być jeszcze nie załadowany, bo nazwa po QTR
   
   QTR.WelcomePanel = CreateFrame("Frame", nil, UIParent, "UIPanelDialogTemplate");
   QTR.WelcomePanel:SetWidth(600);
   QTR.WelcomePanel:SetHeight(300);
   QTR.WelcomePanel:ClearAllPoints();
   QTR.WelcomePanel:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
   QTR.WelcomePanel:SetFrameStrata("TOOLTIP");
   QTR.WelcomePanel.Title:SetText("WoWpoPolsku - Quests");
   QTR.WelcomePanel.Text = QTR.WelcomePanel:CreateFontString(nil, "ARTWORK");
   QTR.WelcomePanel.Text:SetFontObject(GameFontWhite);
   QTR.WelcomePanel.Text:SetJustifyH("LEFT"); 
   QTR.WelcomePanel.Text:SetJustifyV("TOP");
   QTR.WelcomePanel.Text:ClearAllPoints();
   QTR.WelcomePanel.Text:SetPoint("TOPLEFT", QTR.WelcomePanel, "TOPLEFT", 20, -40);
   QTR.WelcomePanel.Text:SetWidth(570);
   QTR.WelcomePanel.Text:SetText("UWAGA użytkownicy dodatku |cffff00ffWoWpoPolsku - Quests|r!\n\nDodatek |cffff00ffWoWpoPolsku - Quests|r nie będzie już więcej utrzymywany.\n\nAle w jego miejsce uruchamiamy zupełnie nowy, zintegrowany dodatek\n|cff00ffffAll-in-One|r zawierający w jednym dodatku wszystkie dostępne dodatki w ramach projektu |cff00ffffWoWpoPolsku|r.\n\nNazwa tego jednego dodatku, to po prostu: |cffff00ffWoWpoPolsku|r\n\nZapraszamy już dziś do pobrania nowego dodatku.\n\n\n|cffff00ffPlatine|r - autor");
   QTR.WelcomePanel.Text:SetFont(QTR_Font2, 15);
   QTR.WelcomePanel.Button = CreateFrame("Button",nil, QTR.WelcomePanel, "UIPanelButtonTemplate");
   QTR.WelcomePanel.Button:SetWidth(160);
   QTR.WelcomePanel.Button:SetHeight(20);
   QTR.WelcomePanel.Button:SetText("OK - przeczytano");
   QTR.WelcomePanel.Button:ClearAllPoints();
   QTR.WelcomePanel.Button:SetPoint("BOTTOMLEFT", QTR.WelcomePanel, "BOTTOMLEFT", QTR.WelcomePanel:GetWidth()/2-QTR.WelcomePanel.Button:GetWidth()/2, 10);
   QTR.WelcomePanel.Button:Show();
   QTR.WelcomePanel.Button:SetScript("OnClick", function() QTR.WelcomePanel:Hide(); end);
   QTR.WelcomePanel:Show();
end


function QTR_QuestLogPopupShow()
   if (QuestLogPopupDetailFrame:IsVisible()) then
      QTR_QuestPrepare("QUEST_DETAIL");
   end
end

function QTR_ObjectiveTracker_QuestHeader()
   if ( QTR_PS["active"]=="1" and QTR_PS["tracker"]=="1" ) then   -- tłumaczenia włączone
      ObjectiveTrackerBlocksFrame.QuestHeader.Text:SetText("Zadania");
   end
end


function QTR_QuestScrollFrame_OnShow()
   if ( QTR_PS["active"]=="1" and QTR_PS["tracker"]=="1" ) then   -- tłumaczenia włączone
      if (QuestScrollFrame.Contents.StoryHeader.Progress and QuestScrollFrame.Contents.StoryHeader.Progress:GetText()) then
         local txt = QuestScrollFrame.Contents.StoryHeader.Progress:GetText();
         txt = string.gsub(txt, "Story Progress", "Postęp Fabuły");
         txt = string.gsub(txt, "Chapters", "Rozdziały");
         local _font1, _size1, _3 = QuestScrollFrame.Contents.StoryHeader.Progress:GetFont();   -- odczytaj aktualną czcionkę i rozmiar
         QuestScrollFrame.Contents.StoryHeader.Progress:SetText(txt); 
         QuestScrollFrame.Contents.StoryHeader.Progress:SetFont(QTR_Font2, _size1); 
      end
   end
end


-- Kolejny quest w otwartym już oknie QuestFrame?
function QTR_QuestFrameButton_OnClick()
   if (not QTR_wait(0.5, QTR_QuestFrameWithoutOpenQuestFrame)) then
      -- opóźnienie 0.5 sek
   end
end


function QTR_QuestFrameWithoutOpenQuestFrame()
   if (QuestFrame:IsVisible()) then
      GossipOnQuestFrame();
   end
end


function Spr_Gender(msg)         -- miało być używane w QTR_Messages.itemchoose1 - na razie wyłączone
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil; liczy od 1
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do   -- szukaj nawiasu otwierającego
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do   -- szukaj średnika oddzielającego
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do   -- szykaj nawiasu zamykającego
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end
   return msg;
end


function isClassicQuestLog()
   if (ClassicQuestLog ~= nil ) then
      if (QTR_ToggleButton3==nil) then
         -- przycisk z nr ID questu w ClassicQuestLog
         QTR_ToggleButton3 = CreateFrame("Button",nil, ClassicQuestLog, "UIPanelButtonTemplate");
         QTR_ToggleButton3:SetWidth(150);
         QTR_ToggleButton3:SetHeight(20);
         QTR_ToggleButton3:SetText("Quest ID=?");
         QTR_ToggleButton3:Show();
         QTR_ToggleButton3:ClearAllPoints();
         QTR_ToggleButton3:SetPoint("TOPLEFT", ClassicQuestLog, "TOPLEFT", 330, -33);
         QTR_ToggleButton3:SetScript("OnClick", QTR_ON_OFF);
         -- uaktualniono dane w QuestLogu
         ClassicQuestLog:HookScript("OnUpdate", function() QTR_PrepareDelay(1) end);
      end
      return true;
   else
      return false;   
   end
end


function isImmersion()
   if (ImmersionFrame ~= nil ) then
      if (QTR_ToggleButton4==nil) then
         -- przycisk z nr ID questu
         QTR_ToggleButton4 = CreateFrame("Button",nil, ImmersionFrame.TalkBox, "UIPanelButtonTemplate");
         QTR_ToggleButton4:SetWidth(150);
         QTR_ToggleButton4:SetHeight(20);
         QTR_ToggleButton4:SetText("Quest ID=?");
         QTR_ToggleButton4:Show();
         QTR_ToggleButton4:ClearAllPoints();
         QTR_ToggleButton4:SetPoint("TOPLEFT", ImmersionFrame.TalkBox, "TOPRIGHT", -200, -116);
         QTR_ToggleButton4:SetScript("OnClick", QTR_ON_OFF);
         -- otworzono okno dodatku Immersion : wywołanie przez OnEvent
         ImmersionFrame.TalkBox:HookScript("OnHide",function() QTR_ToggleButton4:Hide(); end);
         QTR_ToggleButton4:Disable();     -- nie można na razie przyciskać
         QTR_ToggleButton4:Hide();        -- wstępnie przycisk niewidoczny (bo może jest wybór questów)
      end
      return true;
   else   
      return false;
   end
end
   

function isStoryline()
   if (Storyline_NPCFrame ~= nil ) then
      if (QTR_ToggleButton5==nil) then
         -- przycisk z nr ID questu
         QTR_ToggleButton5 = CreateFrame("Button",nil, Storyline_NPCFrameChat, "UIPanelButtonTemplate");
         QTR_ToggleButton5:SetWidth(150);
         QTR_ToggleButton5:SetHeight(20);
         QTR_ToggleButton5:SetText("Quest ID=?");
         QTR_ToggleButton5:Hide();
         QTR_ToggleButton5:ClearAllPoints();
         QTR_ToggleButton5:SetPoint("BOTTOMLEFT", Storyline_NPCFrameChat, "BOTTOMLEFT", 244, -16);
         QTR_ToggleButton5:SetScript("OnClick", QTR_ON_OFF);
         Storyline_NPCFrameObjectivesContent:HookScript("OnShow", function() QTR_Storyline_Objectives() end);
         Storyline_NPCFrameRewards:HookScript("OnShow", function() QTR_Storyline_Rewards() end);
         Storyline_NPCFrameChat:HookScript("OnHide", function() QTR_Storyline_Hide() end);
--         QTR_ToggleButton5:Disable();     -- nie można przyciskać
      end
      return true;
   else
      return false;
   end
end


-- Określa aktualny numer ID questu z różnych metod
function QTR_GetQuestID()
   local quest_ID;
   
   if ((QuestFrame:IsVisible() or isStoryline() or isImmersion()) and (isGetQuestID=="1")) then
      quest_ID = GetQuestID();
   end
   
   if (QuestMapDetailsScrollFrame:IsVisible() and ((quest_ID==nil) or (quest_ID==0))) then
      quest_ID = QuestMapFrame.DetailsFrame.questID;
   end         

   if (QuestLogPopupDetailFrame:IsVisible() and ((quest_ID==nil) or (quest_ID==0))) then
      quest_ID = QuestLogPopupDetailFrame.questID;
   end
      
   if (quest_ID==nil) then
      quest_ID=0;
   end   
   
   return (quest_ID);
end


-- Wywoływane przy przechwytywanych zdarzeniach
function QTR_OnEvent(self, event, name, ...)
   isStoryline();       -- utwórz przycisk, gdy Storyline aktywny
   if (event=="ADDON_LOADED" and name=="WoWpoPolsku_Quests") then
      QTR_START();
      SlashCmdList["WOWPOPOLSKU_QUESTS"] = function(msg) QTR_SlashCommand(msg); end
      SLASH_WOWPOPOLSKU_QUESTS1 = "/wowpopolsku-quests";
      SLASH_WOWPOPOLSKU_QUESTS2 = "/qtr";
      QTR_CheckVars();
      -- twórz interface Options w Blizzard-Interface-Addons
      QTR_BlizzardOptions();
      print ("|cffffff00WoWpoPolsku-Quests  ver. "..QTR_version.." - "..QTR_Messages.loaded);
      QTR:UnregisterEvent("ADDON_LOADED");
      QTR.ADDON_LOADED = nil;
            
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice1"]=="1")) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dodatek-wow-po-polsku-zostal-uruchomiony.mp3");
      end
--      QTR_Messages.itemchoose1 = Spr_Gender(QTR_Messages.itemchoose1);
      if (not isGetQuestID) then
         DetectEmuServer();
      end
   elseif (event=="QUEST_DETAIL" or event=="QUEST_PROGRESS" or event=="QUEST_COMPLETE") then
      if (event=="QUEST_DETAIL" and QTR_quest_ID>0) then      -- zapisz przypisanie questu do krainy
         local QTR_mapID = C_Map.GetBestMapForUnit("player");
         local QTR_mapINFO = C_Map.GetMapInfo(QTR_mapID);
         QTR_SAVED[QTR_quest_ID.." MAPID"]=QTR_mapID.."@"..QTR_mapINFO.name.."@"..QTR_mapINFO.mapType.."@"..QTR_mapINFO.parentMapID;     -- save mapID to locale place of this quest
      end
      if ( QuestFrame:IsVisible() or isImmersion()) then
         QTR_QuestPrepare(event);
      elseif (isStoryline()) then
         if (not QTR_wait(1,QTR_Storyline_Quest)) then
         -- opóźnienie 1 sek
         end
      end	-- QuestFrame is Visible
      if (not QTR_wait(1,QTR_ObjectiveTracker_Check)) then
         -- opóźnienie 1 sek
      end
   elseif (event=="GOSSIP_SHOW") then
      if (QTR_PS["gossip"] == "1") then
         QTR_Gossip_Show();
      end
      QTR_SendVersion();
--   elseif (event=="GOSSIP_CLOSED") then
--      QTR_GossipFrame:Hide();
   elseif (event=="CHAT_MSG_ADDON") then        -- ukryty kanał addonu
      local msg, method, who = select (1, ...);
      if (name=="WoWpoPolsku_QTR") then 
         QTR_onChatMsgAddon(who,msg);
      end
   elseif (isImmersion() and event=="QUEST_ACCEPTED") then
      QTR_delayed3();
   end
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


local objectiveSpecials = {
   ClickComplete = function(fontString)
      fontString:SetText("(kliknij, aby zakończyć)");   -- (click to complete)
      fontString:SetFont(QTR_Font2, 13);   
   end,
 
   Failed = function(fontString)
      fontString:SetText("Niepowodzenie");              -- Failed
   end,
 
   QuestComplete = function(fontString, questID)
      if ((fontString:GetText() == QUEST_WATCH_QUEST_READY) or (fontString:GetText() == "Gotowe do oddania")) then
         fontString:SetText("Gotowe do oddania");       -- Ready for turn-in
      else
         if (QTR_quest_EN[questID] and QTR_quest_EN[questID].objectives) then
            local obj = QTR_quest_EN[questID].objectives;
            local obj1= strsplit("\n\n", obj);
            if (QTR_QuestData[tostring(questID)] and (fontString:GetText() == obj1)) then
               obj = QTR_ExpandUnitInfo(QTR_QuestData[tostring(questID)]["Objectives"],true);
               obj1= strsplit("\n\n", obj);
               fontString:SetText(obj1);      
               fontString:SetFont(QTR_Font2, 13);
               QTR_ResizeBlock(fontString);
            elseif (string.find(fontString:GetText(),"@") == nil) then   -- nie jest to polski tekst
               local qtr_obj = fontString:GetText();
               for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
                  qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
               end
               fontString:SetText(qtr_obj);
               fontString:SetFont(QTR_Font2, 13);
               QTR_ResizeBlock(fontString);
            end
         elseif (string.find(fontString:GetText(),"@") == nil) then   -- nie jest to polski tekst
            local qtr_obj = fontString:GetText();
            for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
               qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
            end
            fontString:SetText(qtr_obj);
            fontString:SetFont(QTR_Font2, 13);
            QTR_ResizeBlock(fontString);
         end
      end
   end,
 
   Waypoint = function(fontString, questID)
      local waypointText = C_QuestLog.GetNextWaypointText(questID);
      if (waypointText) then
         fontString:SetText(("0/1 %s (Opcjonalne)"):format(waypointText));    -- 0/1 %s (Optional)
         fontString:SetFont(QTR_Font2, 13);   
      end
   end
}


function QTR_ObjectiveTracker_Check()
   if ( QUEST_TRACKER_MODULE.usedBlocks.ObjectiveTrackerBlockTemplate and QTR_PS["active"]=="1" and QTR_PS["tracker"]=="1" ) then   -- tłumaczenia włączone
      ObjectiveTrackerFrame.HeaderMenu.Title:SetText("Cele");
      ObjectiveTrackerBlocksFrame.QuestHeader.Text:SetText("Zadania");
      for questID, block in pairs(QUEST_TRACKER_MODULE.usedBlocks.ObjectiveTrackerBlockTemplate) do
         local str_ID = tostring(questID);
         if (str_ID and QTR_PS["transtitle"]=="1" and QTR_QuestData[str_ID]) then  -- tłumaczenie tytułu
            block.HeaderText:SetText(QTR_QuestData[str_ID]["Title"]);
            block.HeaderText:SetFont(QTR_Font2, 13);
            QTR_ResizeBlock(block.HeaderText);
         end
         local objectives = block.lines;
         for special, func in pairs(objectiveSpecials) do
            if (questID and objectives[special]) then
               func(objectives[special].Text, questID);
            end
         end
         if (block.currentLine and block.currentLine.Text) then
            local qtr_obj = block.currentLine.Text:GetText();
            for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
               qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
            end
            block.currentLine.Text:SetText(qtr_obj);
            block.currentLine.Text:SetFont(QTR_Font2, 13);
            QTR_ResizeBlock(block.currentLine.Text);
         end
         for index = 1, #objectives do
            if ((index <= #objectives) and objectives[index]) then
               local qtr_obj = objectives[index].Text:GetText();
               for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
                  qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
               end
               objectives[index].Text:SetText(qtr_obj);
               objectives[index].Text:SetFont(QTR_Font2, 13);
               QTR_ResizeBlock(objectives[index].Text);
            end
         end
      end
   end
end


function QTR_ResizeBlock(element)
   local dlug = string.len(element:GetText());
   local linia = 12.7869625;
   local wys, szer;
   if (element:GetWidth()<220) then    -- jest ikonka akcji
      szer = 30
   else
      szer = 34;
   end
   if (dlug+2<szer) then
      wys = linia;
   elseif (dlug*1.1<=szer*2) then
      wys = linia*2;
   elseif (dlug*1.2<=szer*3) then
      wys = linia*3;
   elseif (dlug*1.25<=szer*4) then
      wys = linia*4;
   elseif (dlug*1.3<=szer*5) then
      wys = linia*5;
   else
      wys = element:GetHeight();
   end
--print(dlug.." < "..szer.." "..wys.." "..element:GetText())   
   element:SetHeight(wys);   -- resize text on the block
end


function QTR_QuestLogQuests_Update()
   if ( QTR_PS["active"]=="1" and QTR_PS["tracker"]=="1" ) then   -- tłumaczenia włączone
      for button in QuestScrollFrame.titleFramePool:EnumerateActive() do
         local str_ID = tostring(button.questID);
         if (QTR_PS["transtitle"]=="1" and QTR_QuestData[str_ID]) then  -- tłumaczenie tytułu
            button.Text:SetText(QTR_QuestData[str_ID]["Title"]);
            button.Text:SetFont(QTR_Font2, 13);
         end
      end
      for frame in QuestScrollFrame.objectiveFramePool:EnumerateActive() do
         local str_ID = tostring(frame.questID);
         local qtr_obj = frame.Text:GetText();
         if (strfind(qtr_obj,"/") and (strfind(qtr_obj,"/") > 0)) then
            for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
               qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
            end
            frame.Text:SetText(qtr_obj);
            frame.Text:SetFont(QTR_Font2, 13);
         else
            if ((qtr_obj == QUEST_WATCH_QUEST_READY) or (qtr_obj == "Gotowe do oddania")) then
               frame.Text:SetText("Gotowe do oddania");       -- Ready for turn-in
            else
               if (QTR_quest_EN[frame.questID] and QTR_quest_EN[frame.questID].objectives) then
                  local obj = QTR_quest_EN[frame.questID].objectives;
                  local obj1= strsplit("\n\n", obj);
                  if (qtr_obj == obj1) then
                     obj = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Objectives"],true);
                     obj1= strsplit("\n\n", obj);
                     frame.Text:SetText(obj1);      
                     frame.Text:SetFont(QTR_Font2, 13);
                  else
                     for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
                       qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
                    end
                     frame.Text:SetText(qtr_obj);
                     frame.Text:SetFont(QTR_Font2, 13);
                  end
               else
                  for qtr_en, qtr_pl in pairsByKeys(QTR_Tlumacz_Online) do
                     qtr_obj = string.gsub(qtr_obj, qtr_en, qtr_pl);
                  end
                  frame.Text:SetText(qtr_obj);
                  frame.Text:SetFont(QTR_Font2, 13);
               end
            end
         end
      end
      QTR_QuestScrollFrame_OnShow();     -- Story Progress
   end
end


function QTR_SendVersion()
   local now = GetTime();
   if (time_ver + 15*60 < now) then                  -- co 15 minut
      local message = QTR_lang..":"..string.sub(QTR_version,1,1)..string.sub(QTR_version,-2)..":"..QTR_base..":"..QTR_date..":"..GS_base..":"..GS_date;
      if ( IsInGuild() ) then                -- gracz jest w gildii
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_QTR", message, "GUILD");
      end
      if ( IsInRaid() ) then                -- gracz jest w raidzie
         C_ChatInfo.SendAddonMessage("WoWpoPolsku_QTR", message, "RAID");
      end
      time_ver = now;
   end
end


function QTR_onChatMsgAddon(who,msg)       -- odebrano komunikat z ukrytego kanału addonu
--print('QTR - MSG od '..who..': '..msg);
   if (not Players_ver[who]) then
      local pla_lang, pla_ver, pla_base, pla_date, pla_gossip, pla_date2 = strsplit(":",msg);
      if (tonumber(pla_ver)>tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_VER = pla_ver;
         Version_max.ADDON_COUNT = 0;
      end
      if (tonumber(pla_ver)==tonumber(Version_max.ADDON_VER)) then
         Version_max.ADDON_COUNT = Version_max.ADDON_COUNT + 1;
      end
      if (tonumber(pla_base)>tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_VER = pla_base;
         Version_max.BASE_DATE = pla_date;
         Version_max.BASE_COUNT = 0;
      end   
      if (tonumber(pla_base)==tonumber(Version_max.BASE_VER)) then
         Version_max.BASE_COUNT = Version_max.BASE_COUNT + 1;
      end
      if (tonumber(pla_gossip)>tonumber(Version_max.GOSSIP_VER)) then
         Version_max.GOSSIP_VER = pla_gossip;
         Version_max.GOSSIP_DATE = pla_date2;
         Version_max.GOSSIP_COUNT = 0;
      end   
      if (tonumber(pla_gossip)==tonumber(Version_max.GOSSIP_VER)) then
         Version_max.GOSSIP_COUNT = Version_max.GOSSIP_COUNT + 1;
      end
      Players_ver[who] = { };
      Players_ver[who].LANG = pla_lang;
      Players_ver[who].VERSION = pla_ver;
      Players_ver[who].BASE = pla_base;
      Players_ver[who].DATE = pla_date;
      Players_ver[who].GOSSIP = pla_gossip;
      Players_ver[who].DATE2 = pla_date2;
      Players_ver_Count = Players_ver_Count + 1;
      Version_max.ALERT_ID = 0;
      if ((tonumber(Version_max.ADDON_VER)>tonumber(string.sub(QTR_version,1,1)..string.sub(QTR_version,-2))) and (Version_max.ADDON_COUNT>1) and (Version_max.ADDON_ALERT==0)) then
         Version_max.ALERT_ID = 4;
      end
      if ((tonumber(Version_max.BASE_VER)>tonumber(QTR_base)) and (Version_max.BASE_COUNT>1) and (Version_max.BASE_ALERT==0)) then
         Version_max.ALERT_ID = Version_max.ALERT_ID + 2;
      end
      if ((tonumber(Version_max.GOSSIP_VER)>tonumber(GS_base)) and (Version_max.GOSSIP_COUNT>1) and (Version_max.GOSSIP_ALERT==0)) then
         Version_max.ALERT_ID = Version_max.ALERT_ID + 1;
      end
   end
   if (Version_max.ALERT_ID>0) then
      PlaySound(10843);        -- dźwięk: HornOfCentarius
      if (Version_max.ALERT_ID>3) then              -- sam dodatek
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.ADDON_VER.."|r dodatku.");
         print("Możesz ją pobrać z serwisu CurseForge.com, WowInterface.com lub WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.ADDON_VER.." dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.ADDON_ALERT = 1;
      elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń zadań
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.BASE_VER.."|r bazy tłumaczeń zadań do dodatku WoWpoPolsku-Quests z dnia |cffffff00"..Version_max.BASE_DATE.."|r");
         print("Możesz ją pobrać tylko z serwisu WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.BASE_VER.." bazy tlumaczen zadan do dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.BASE_ALERT = 1;
      elseif (Version_max.ALERT_ID>0) then         -- baza tłumaczeń gossip
         print("|cffffff00WoWpoPolsku-Quests:|r Dostępna jest nowa wersja |cffffff00"..Version_max.GOSSIP_VER.."|r bazy tłumaczeń GOSSIP do dodatku WoWpoPolsku-Quests z dnia |cffffff00"..Version_max.GOSSIP_DATE.."|r");
         print("Możesz ją pobrać tylko z serwisu WoWpoPolsku.pl");
         UIErrorsFrame:SetTimeVisible(10);
         UIErrorsFrame:AddMessage("Dostepna jest nowa wersja "..Version_max.GOSSIP_VER.." bazy tlumaczen GOSSIP do dodatku WoWpoPolsku-Quests", 1,0.5,1);
         Version_max.GOSSIP_ALERT = 1;
      end
      if (not QTR_wait(5,QTR_print_msg)) then
      --- czekaj 5 sek, aż skończy się dźwięk HornOfCentarius
      end
   end
end


-- Wyświetla komunikaty o dostępnej aktualizacji
function QTR_print_msg()
   if (Version_max.ALERT_ID>3) then              -- sam dodatek
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice5"]=="1")) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-dodatku.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 4;
   elseif (Version_max.ALERT_ID>1) then         -- baza tłumaczeń zadań
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice6"]=="1")) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-bazy-quests.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 2;
   elseif (Version_max.ALERT_ID>0) then         -- baza tłumaczeń gossip
      if ((QTR_PS["voices"]=="1") and (QTR_PS["voice7"]=="1")) then
         PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\dostepna-jest-nowa-wersja-bazy-gossip.mp3");
      end
      Version_max.ALERT_ID = Version_max.ALERT_ID - 1;
   else
      Version_max.ALERT_ID = 0;
   end
end


-- Otworzono okienko QuestLogPopupDetailFrame lub QuestMapDetailsScrollFrame lub ClassicQuestLog lub Immersion
function QTR_QuestPrepare(zdarzenie)
   if (isClassicQuestLog()) then
      if (QTR_PS["other1"]=="0") then       -- jest aktywny ClassicQuestLog, ale nie zezwolono na tłumaczenie
         QTR_ToggleButton3:Hide();
         return;
      else   
         QTR_ToggleButton3:Show();
         if (ClassicQuestLog:IsVisible() and (curr_trans=="0")) then
            QTR_Translate_Off(1);
         end
      end   
   end
   if (isImmersion()) then
      if (QTR_PS["other2"]=="0") then       -- jest aktywny Immersion, ale nie zezwolono na tłumaczenie
         QTR_ToggleButton4:Hide();
         return
      else
         QTR_ToggleButton4:Show();
         if (ImmersionContentFrame:IsVisible() and (curr_trans=="0")) then
            QTR_Translate_Off(1);
            return;
         end
      end      
   end
   q_ID = QTR_GetQuestID();         -- uzyskaj aktualne ID questu
   if (q_ID==0) then
      return
   end   
   if (isStoryline()) then
      QTR_ToggleButton5:Hide();
      if (QTR_PS["other3"]=="1") then  -- zezwolenie na tłumaczenie w Storyline
         if (q_ID>0) then
            QTR_ToggleButton5:Show();
         end
      else        -- nie zezwolono na tłumaczenie dla Storyline
         return
     end      
   end

   QTR_quest_ID = q_ID;
   str_ID = tostring(q_ID);
   if ( not (QTR_quest_EN[QTR_quest_ID])) then
      QTR_quest_EN[QTR_quest_ID] = { };
      QTR_quest_LG[QTR_quest_ID] = { };
   end
   if (QTR_PS["control"]=="1") then         -- zapisuj kontrolnie treść oryginalnych questów EN
      QTR_quest_EN.title = GetTitleText();
      if (QTR_quest_EN.title=="") then
         QTR_quest_EN.title = QuestInfoTitleHeader:GetText();
      end
      QTR_CONTROL[str_ID.." TITLE"]=QTR_quest_EN.title;
      if (zdarzenie=="QUEST_DETAIL") then
         QTR_quest_EN.details = GetQuestText();
         QTR_quest_EN.objectives = GetObjectiveText();
         QTR_CONTROL[str_ID.." DESCRIPTION"]=QTR_quest_EN.details;
         QTR_CONTROL[str_ID.." OBJECTIVE"]=QTR_quest_EN.objectives;
      end
      if (zdarzenie=="QUEST_PROGRESS") then
         QTR_quest_EN.progress = GetProgressText();
         QTR_CONTROL[str_ID.." PROGRESS"]=QTR_quest_EN.progress;
      end
      if (zdarzenie=="QUEST_COMPLETE") then
         QTR_quest_EN.completion = GetRewardText();
         QTR_CONTROL[str_ID.." COMPLETE"]=QTR_quest_EN.completion;
      end
      QTR_CONTROL[str_ID.." PLAYER"]=QTR_name..'@'..QTR_race..'@'..QTR_class..'@'..QTR_PS["patch"];  -- zapisz dane gracza oraz wersję gry
   end
   if ( QTR_PS["active"]=="1" ) then	-- tłumaczenia włączone
      QTR_ToggleButton0:Enable();      -- przycisk w ramce QuestFrame (NPC)
      QTR_ToggleButton1:Enable();      -- przycisk w ramce QuestLogPopupDetailFrame
      QTR_ToggleButton2:Enable();      -- przycisk w ramce QuestMapDetailsScrollFrame
      if (isClassicQuestLog()) then
         QTR_ToggleButton3:Enable();   -- przycisk w ramce ClassicQuestLog
      end
      if (isImmersion()) then
         QTR_ToggleButton4:Enable();   -- przycisk w ramce Immersion
      end
      if (isStoryline()) then
         QTR_ToggleButton5:Enable();   -- przycisk w ramce StoryLine
      end
      if (QuestNPCModelText:IsVisible()) then              -- jest wyświetlony tekst QuestNPCModelText
         local QTR_ModelText = QuestNPCModelText:GetText();
         if (string.find(QTR_ModelText," ") == nil) then   -- nie jest to polski tekst (twarda spacja)
            QTR_ModelTextHash = StringHash(QTR_ModelText);
            if (GS_Gossip[QTR_ModelTextHash]) then         -- jest tłumaczenie w bazie gossip
               QTR_ModelText_EN = QTR_ModelText;
               QTR_ModelText_PL = QTR_ExpandUnitInfo(GS_Gossip[QTR_ModelTextHash],false);
            else
               local mapka = 0;
               if (C_Map.GetBestMapForUnit("player")) then
                  mapka = C_Map.GetBestMapForUnit("player");
               end
               QTR_GOSSIP[QuestNPCModelNameText:GetText().."@"..tostring(QTR_ModelTextHash).."@"..mapka] = QTR_ModelText.."@"..QTR_name..":"..QTR_race..":"..QTR_class;  -- zapisz do tłumaczenia
               QTR_ModelTextHash = 0;
            end
         end
      end      
      curr_trans = "1";                -- aktualnie wyświetlane jest tłumaczenie PL
      if ( QTR_QuestData[str_ID] ) then   -- wyświetlaj tylko, gdy istnieje tłumaczenie
         if (QTR_quest_EN[QTR_quest_ID].title == nil) then
            QTR_quest_LG[QTR_quest_ID].title = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Title"],false);
            QTR_quest_EN[QTR_quest_ID].title = GetTitleText();
            if (QTR_quest_EN[QTR_quest_ID].title=="") then
               QTR_quest_EN[QTR_quest_ID].title=QuestInfoTitleHeader:GetText();
            end
         end
         if (QTR_quest_LG[QTR_quest_ID].details == nil) then
            QTR_quest_LG[QTR_quest_ID].details = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Description"],false);
            QTR_quest_LG[QTR_quest_ID].objectives = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Objectives"],false);
         end
         if (zdarzenie=="QUEST_DETAIL") then
            if (QTR_quest_EN[QTR_quest_ID].details == nil) then
               QTR_quest_EN[QTR_quest_ID].details = GetQuestText();
               QTR_quest_EN[QTR_quest_ID].objectives = GetObjectiveText();
            end
            -- sprawdź ile jest nagród za ten quest?
            quest_numReward[str_ID] = GetNumQuestChoices();
            if (quest_numReward[str_ID]>1) then
               QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose1;
               QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose1;
            else
               QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose0;
               QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose0;
            end
            -- czy jest jeszcze kasa w nagrodę? a może jest tylko sama kasa?
            if (quest_numReward[str_ID]>0) then
               QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv1;
               QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv1;
            else
               QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv0;
               QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv0;
            end
            if (strlen(QTR_quest_EN[QTR_quest_ID].details)>0 and strlen(QTR_quest_LG[QTR_quest_ID].details)==0) then
               QTR_MISSING[QTR_quest_ID.." DESCRIPTION"]=QTR_quest_EN[QTR_quest_ID].details;     -- save missing translation part
            end
            if (strlen(QTR_quest_EN[QTR_quest_ID].objectives)>0 and strlen(QTR_quest_LG[QTR_quest_ID].objectives)==0) then
               QTR_MISSING[QTR_quest_ID.." OBJECTIVE"]=QTR_quest_EN[QTR_quest_ID].objectives;    -- save missing translation part
            end
         else        -- nie jest to zdarzenie QUEST_DETAILS
            if (QTR_quest_EN[QTR_quest_ID].details == nil) then
               QTR_quest_EN[QTR_quest_ID].details = QuestInfoDescriptionText:GetText();
            end
            if (QTR_quest_EN[QTR_quest_ID].objectives == nil) then
               QTR_quest_EN[QTR_quest_ID].objectives = QuestInfoObjectivesText:GetText();
            end
            if (quest_numReward[str_ID]==nil) then         -- mamy zapamiętaną liczbę nagród do tego questu
               QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose0;
               QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose0;
               if (MapQuestInfoRewardsFrame.ItemChooseText:IsVisible()) then
                  QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv1;
                  QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv1;                  
               else
                  QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv0;
                  QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv0;
               end
            else
               if (quest_numReward[str_ID]>1) then
                  QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose1;
                  QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose1;
               else
                  QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose0;
                  QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose0;
               end
               -- czy jest jeszcze kasa w nagrodę? a może jest tylko sama kasa?
               if (quest_numReward[str_ID]>0) then
                  QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv1;
                  QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv1;
               else
                  QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv0;
                  QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv0;
               end
            end
         end   
         if (zdarzenie=="QUEST_PROGRESS") then
            if (QTR_quest_EN[QTR_quest_ID].progress == nil) then
               QTR_quest_EN[QTR_quest_ID].progress = GetProgressText();
               QTR_quest_LG[QTR_quest_ID].progress = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Progress"],false);
            end
            if (strlen(QTR_quest_EN[QTR_quest_ID].progress)>0 and strlen(QTR_quest_LG[QTR_quest_ID].progress)==0) then
               QTR_MISSING[QTR_quest_ID.." PROGRESS"]=QTR_quest_EN[QTR_quest_ID].progress;     -- save missing translation part
            end
            if (strlen(QTR_quest_LG[QTR_quest_ID].progress)==0) then      -- treść jest pusta, a otworzono okienko Progress
               QTR_quest_LG[QTR_quest_ID].progress = QTR_ExpandUnitInfo('Dobrze ci idzie, YOUR_NAME',false);
            end
         end
         if (zdarzenie=="QUEST_COMPLETE") then
            if (QTR_quest_EN[QTR_quest_ID].completion == nil) then
               QTR_quest_EN[QTR_quest_ID].completion = GetRewardText();
               QTR_quest_LG[QTR_quest_ID].completion = QTR_ExpandUnitInfo(QTR_QuestData[str_ID]["Completion"],false);
            end
            -- sprawdź ile jest nagród za ten quest?
            if (quest_numReward[str_ID]==nil) then
               quest_numReward[str_ID] = GetNumQuestChoices();
            end
            if (quest_numReward[str_ID]>1) then
               QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose2;
               QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose2;
            else
               QTR_quest_EN[QTR_quest_ID].itemchoose = QTR_MessOrig.itemchoose3;
               QTR_quest_LG[QTR_quest_ID].itemchoose = QTR_Messages.itemchoose3;
            end
            -- czy jest jeszcze kasa w nagrodę? a może jest tylko sama kasa?
            if (quest_numReward[str_ID]>0) then
               QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv3;
               QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv3;
            else
               QTR_quest_EN[QTR_quest_ID].itemreceive = QTR_MessOrig.itemreceiv2;
               QTR_quest_LG[QTR_quest_ID].itemreceive = QTR_Messages.itemreceiv2;
            end
            if (strlen(QTR_quest_EN[QTR_quest_ID].completion)>0 and strlen(QTR_quest_LG[QTR_quest_ID].completion)==0) then
               QTR_MISSING[QTR_quest_ID.." COMPLETE"]=QTR_quest_EN[QTR_quest_ID].completion;     -- save missing translation part
            end
         end         
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
            QTR_ToggleButton3:Enable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
--            QTR_quest_EN[QTR_quest_ID].details = GetQuestText();
--            QTR_quest_EN[QTR_quest_ID].progress = GetProgressText();
--            QTR_quest_EN[QTR_quest_ID].completion = GetRewardText();
         end
         if (isStoryline() and Storyline_NPCFrame:IsVisible()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         end
         QTR_Translate_On(1);
         if (QTR_first_show==0) then      -- pierwsze wyświetlenie, daj opóźnienie i przełączaj, bo nie wyświetla danych stałych 
            if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj wpierw na OFF
            ---
            end
            if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj ponownie na ON
            ---
            end
            QTR_first_show=1;
         end
      else	      -- nie ma przetłumaczonego takiego questu
         QTR_ToggleButton0:Disable();     -- przycisk w ramce QuestFrame (NPC)
         QTR_ToggleButton1:Disable();     -- przycisk w ramce QuestLogPopupDetailFrame
         QTR_ToggleButton2:Disable();     -- przycisk w ramce QuestMapDetailsScrollFrame
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:Disable();
         end
         if (isImmersion()) then
            QTR_ToggleButton4:Disable();
         end
         if (isStoryline()) then
            QTR_ToggleButton5:Disable();
         end
         QTR_ToggleButton0:SetText("Quest ID="..str_ID);
         QTR_ToggleButton1:SetText("Quest ID="..str_ID);
         QTR_ToggleButton2:SetText("Quest ID="..str_ID);
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID);
         end
         if (isImmersion()) then
            if (q_ID==0) then
               if (ImmersionFrame.TitleButtons:IsVisible()) then
                  QTR_ToggleButton4:SetText("wybierz wpierw quest");
               end
            else
               QTR_ToggleButton4:SetText("Quest ID="..str_ID);
            end
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID);
         end
         if ((QTR_PS["voices"]=="1") and (QTR_PS["voice2"]=="1")) then
            PlaySoundFile("Interface\\Addons\\WoWpoPolsku_Quests\\Sounds\\brak-tlumaczenia.mp3");
         end
         QTR_Translate_On(0);
         QTR_SaveQuest(zdarzenie);
      end -- jest przetłumaczony quest w bazie
   else	-- tłumaczenia wyłączone
      QTR_ToggleButton0:Disable();        -- przycisk w ramce QuestFrame (NPC)
      QTR_ToggleButton1:Disable();        -- przycisk w ramce QuestLogPopupDetailFrame
      QTR_ToggleButton2:Disable();        -- przycisk w ramce QuestMapDetailsScrollFrame
      if ( QTR_QuestData[str_ID] ) then	-- ale jest tłumaczenie w bazie
         QTR_ToggleButton1:SetText("Quest ID="..str_ID.." (EN)");
         QTR_ToggleButton2:SetText("Quest ID="..str_ID.." (EN)");
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID.." (EN)");
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..str_ID.." (EN)");
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID.." (EN)");
         end
      else
         QTR_ToggleButton1:SetText("Quest ID="..str_ID);
         QTR_ToggleButton2:SetText("Quest ID="..str_ID);
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:SetText("Quest ID="..str_ID);
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..str_ID);
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..str_ID);
         end
      end
   end	-- tłumaczenia są włączone
   if (QTR_PS["reklama"]=="1") then
      QTR_SendReklama();
   end
end


-- wyświetla tłumaczenie
function QTR_Translate_On(typ)
   QTR_display_constants(1);
   if (QuestNPCModelText:IsVisible() and (QTR_ModelTextHash>0)) then         -- jest wyświetlony tekst QuestNPCModelText
      QuestNPCModelText:SetText(QTR_ModelText_PL);
      QuestNPCModelText:SetFont(QTR_Font2, 13);
   end
   
   if (typ==1) then			-- pełne przełączenie (jest tłumaczenie)
      local numer_ID = QTR_quest_ID;
      str_ID = tostring(numer_ID);
      if (numer_ID>0 and QTR_QuestData[str_ID]) then	-- przywróć przetłumaczoną wersję napisów
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         if (isClassicQuestLog()) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
         end
         if (isImmersion()) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
            if (not QTR_wait(0.2,QTR_Immersion)) then    -- wywołaj podmienianie danych po 0.2 sek
               -- opóźnienie 0.2 sek
            end
         end
         if (isStoryline() and Storyline_NPCFrame:IsVisible()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_ID.." ("..QTR_lang..")");
            QTR_Storyline(1);
         end
         if (QTR_PS["transtitle"]=="1") then
            QuestInfoTitleHeader:SetFont(QTR_Font1, 18);
            QuestProgressTitleText:SetFont(QTR_Font1, 18);
            QuestInfoTitleHeader:SetText(QTR_quest_LG[QTR_quest_ID].title);
            QuestProgressTitleText:SetText(QTR_quest_LG[QTR_quest_ID].title);
         end
         QuestInfoDescriptionText:SetFont(QTR_Font2, 13);
         QuestInfoObjectivesText:SetFont(QTR_Font2, 13);
         QuestProgressText:SetFont(QTR_Font2, 13);
         QuestInfoRewardText:SetFont(QTR_Font2, 13);
         QuestInfoDescriptionText:SetText(QTR_quest_LG[QTR_quest_ID].details);
         QuestInfoObjectivesText:SetText(QTR_quest_LG[QTR_quest_ID].objectives);
         QuestProgressText:SetText(QTR_quest_LG[QTR_quest_ID].progress);
         QuestInfoRewardText:SetText(QTR_quest_LG[QTR_quest_ID].completion);
      end
      if ((not isImmersion()) and (QuestInfoDescriptionText~=QTR_quest_LG[QTR_quest_ID].details) and (QTR_first_show2 == 0)) then   -- nie wczytały się tłumaczenia
         QTR_first_show2 = 1;
         if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj wpierw na OFF
         ---
         end
         if (not QTR_wait(0.2,QTR_ON_OFF)) then    -- przeładuj ponownie na ON
         ---
         end
      end
   else
      if (curr_trans == "1") then
         if ((ImmersionFrame ~= nil ) and (ImmersionFrame.TalkBox:IsVisible() )) then
            if (not QTR_wait(0.2,QTR_Immersion_Static)) then
               -- podmiana tekstu z opóźnieniem 0.2 sek
            end
         end
      end
   end
end


-- wyświetla oryginalny tekst angielski
function QTR_Translate_Off(typ)
   QTR_display_constants(0);
   if (QuestNPCModelText:IsVisible() and (QTR_ModelTextHash>0)) then         -- jest wyświetlony tekst QuestNPCModelText
      QuestNPCModelText:SetText(QTR_ModelText_EN);
      QuestNPCModelText:SetFont(Original_Font2, 13);
   end
   
   if (typ==1) then			-- pełne przełączenie (jest tłumaczenie)
      local numer_ID = QTR_quest_ID;
      str_ID = tostring(numer_ID);
      if (numer_ID>0 and QTR_QuestData[str_ID]) then	-- przywróć oryginalną wersję napisów
         QTR_ToggleButton0:SetText("Quest ID="..QTR_quest_ID.." (EN)");
         QTR_ToggleButton1:SetText("Quest ID="..QTR_quest_ID.." (EN)");
         QTR_ToggleButton2:SetText("Quest ID="..QTR_quest_ID.." (EN)");
         if (ClassicQuestLog ~= nil ) then
            QTR_ToggleButton3:SetText("Quest ID="..QTR_quest_ID.." (EN)");
         end
         if (ImmersionFrame ~= nil ) then
            QTR_ToggleButton4:SetText("Quest ID="..QTR_quest_ID.." (EN)");
            QTR_Immersion_OFF();
            ImmersionFrame.TalkBox.TextFrame.Text:RepeatTexts();   --reload text
         end
         if (isStoryline()) then
            QTR_ToggleButton5:SetText("Quest ID="..QTR_quest_ID.." (EN)");
            QTR_Storyline_OFF(1);
         end
         QuestInfoTitleHeader:SetFont(Original_Font1, 18);
         QuestProgressTitleText:SetFont(Original_Font1, 18);
         QuestInfoTitleHeader:SetText(QTR_quest_EN[QTR_quest_ID].title);
         QuestProgressTitleText:SetText(QTR_quest_EN[QTR_quest_ID].title);
         QuestInfoDescriptionText:SetFont(Original_Font2, 13);
         QuestInfoObjectivesText:SetFont(Original_Font2, 13);
         QuestProgressText:SetFont(Original_Font2, 13);
         QuestInfoRewardText:SetFont(Original_Font2, 13);
         QuestInfoDescriptionText:SetText(QTR_quest_EN[QTR_quest_ID].details);
         QuestInfoObjectivesText:SetText(QTR_quest_EN[QTR_quest_ID].objectives);
         QuestProgressText:SetText(QTR_quest_EN[QTR_quest_ID].progress);
         QuestInfoRewardText:SetText(QTR_quest_EN[QTR_quest_ID].completion);
      end
   else   
      if (curr_trans == "0") then
         if ((ImmersionFrame ~= nil ) and (ImmersionFrame.TalkBox:IsVisible() )) then
            if (not QTR_wait(0.2,QTR_Immersion_OFF_Static)) then
               -- podmiana tekstu z opóźnieniem 0.2 sek
            end
         end
      end
   end
end


function QTR_display_constants(lg)
   if (lg==1) then        -- dane stałe po polsku
      QuestInfoObjectivesHeader:SetFont(QTR_Font1, 18);
      QuestInfoObjectivesHeader:SetText(QTR_Messages.objectives);
      QuestInfoRewardsFrame.Header:SetFont(QTR_Font1, 18);
      QuestInfoRewardsFrame.Header:SetText(QTR_Messages.rewards);
      QuestInfoDescriptionHeader:SetFont(QTR_Font1, 18);
      QuestInfoDescriptionHeader:SetText(QTR_Messages.details);
      QuestProgressRequiredItemsText:SetFont(QTR_Font1, 18);
      QuestProgressRequiredItemsText:SetText(QTR_Messages.reqitems);
      CurrentQuestsText:SetFont(QTR_Font1, 18);
      CurrentQuestsText:SetText(QTR_Messages.currquests);
      AvailableQuestsText:SetFont(QTR_Font1, 18);
      AvailableQuestsText:SetText(QTR_Messages.avaiquests);
      local regions = { QuestMapFrame.DetailsFrame.RewardsFrame:GetRegions() };
      for index = 1, #regions do
         local region = regions[index];
         if ((region:GetObjectType() == "FontString") and (region:GetText() == QUEST_REWARDS)) then
            region:SetText(QTR_Messages.rewards);
         end
      end
      
      -- stałe elementy okna zadania:
      QuestInfoRewardsFrame.ItemChooseText:SetFont(QTR_Font2, 13);
      QuestInfoRewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 13);
      QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG[QTR_quest_ID].itemchoose);
      QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG[QTR_quest_ID].itemreceive);
      QuestInfoSpellObjectiveLearnLabel:SetFont(QTR_Font2, 13);
      QuestInfoSpellObjectiveLearnLabel:SetText(QTR_Messages.learnspell);
      QuestInfoXPFrame.ReceiveText:SetFont(QTR_Font2, 13);
      QuestInfoXPFrame.ReceiveText:SetText(QTR_Messages.experience);
      QuestInfoRewardsFrame.XPFrame.ReceiveText:SetFont(QTR_Font2, 13);
      QuestInfoRewardsFrame.XPFrame.ReceiveText:SetText(QTR_Messages.experience);
      MapQuestInfoRewardsFrame.ItemChooseText:SetFont(QTR_Font2, 11);
      MapQuestInfoRewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 11);
      MapQuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_LG[QTR_quest_ID].itemchoose);
      MapQuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_LG[QTR_quest_ID].itemreceive);
      QuestInfoRewardsFrame.PlayerTitleText:SetFont(QTR_Font2, 13);
      QuestInfoRewardsFrame.PlayerTitleText:SetText(QTR_Messages.reward_title);
      QuestInfoRewardsFrame.QuestSessionBonusReward:SetFont(QTR_Font2, 13);
      QuestInfoRewardsFrame.QuestSessionBonusReward:SetText(QTR_Messages.reward_bonus);
      if ( QuestInfoRewardsFrame:IsVisible() ) then
         for fontString in QuestInfoRewardsFrame.spellHeaderPool:EnumerateActive() do
            if (fontString:GetText() == REWARD_AURA) then
               fontString:SetText(QTR_Messages.reward_aura);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_SPELL) then
               fontString:SetText(QTR_Messages.reward_spell);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_COMPANION) then
               fontString:SetText(QTR_Messages.reward_companion);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_FOLLOWER) then
               fontString:SetText(QTR_Messages.reward_follower);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_REPUTATION) then
               fontString:SetText(QTR_Messages.reward_reputation);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_TITLE) then
               fontString:SetText(QTR_Messages.reward_title);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_TRADESKILL) then
               fontString:SetText(QTR_Messages.reward_tradeskill);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_UNLOCK) then
               fontString:SetText(QTR_Messages.reward_unlock);
               fontString:SetFont(QTR_Font2, 13);
            end
            if (fontString:GetText() == REWARD_BONUS) then
               fontString:SetText(QTR_Messages.reward_bonus);
               fontString:SetFont(QTR_Font2, 13);
            end
         end
      end
      if ( MapQuestInfoRewardsFrame:IsVisible() ) then
         for fontString in MapQuestInfoRewardsFrame.spellHeaderPool:EnumerateActive() do
            if (fontString:GetText() == REWARD_AURA) then
               fontString:SetText(QTR_Messages.reward_aura);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_SPELL) then
               fontString:SetText(QTR_Messages.reward_spell);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_COMPANION) then
               fontString:SetText(QTR_Messages.reward_companion);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_FOLLOWER) then
               fontString:SetText(QTR_Messages.reward_follower);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_REPUTATION) then
               fontString:SetText(QTR_Messages.reward_reputation);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_TITLE) then
               fontString:SetText(QTR_Messages.reward_title);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_TRADESKILL) then
               fontString:SetText(QTR_Messages.reward_tradeskill);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_UNLOCK) then
               fontString:SetText(QTR_Messages.reward_unlock);
               fontString:SetFont(QTR_Font2, 11);
            end
            if (fontString:GetText() == REWARD_BONUS) then
               fontString:SetText(QTR_Messages.reward_bonus);
               fontString:SetFont(QTR_Font2, 11);
            end
         end
      end
   else
      QuestInfoObjectivesHeader:SetFont(Original_Font1, 18);
      QuestInfoObjectivesHeader:SetText(QTR_MessOrig.objectives);
      QuestInfoRewardsFrame.Header:SetFont(Original_Font1, 18);
      QuestInfoRewardsFrame.Header:SetText(QTR_MessOrig.rewards);
      QuestInfoDescriptionHeader:SetFont(Original_Font1, 18);
      QuestInfoDescriptionHeader:SetText(QTR_MessOrig.details);
      QuestProgressRequiredItemsText:SetFont(Original_Font1, 18);
      QuestProgressRequiredItemsText:SetText(QTR_MessOrig.reqitems);
      CurrentQuestsText:SetFont(Original_Font1, 18);
      CurrentQuestsText:SetText(QTR_MessOrig.currquests);
      AvailableQuestsText:SetFont(Original_Font1, 18);
      AvailableQuestsText:SetText(QTR_MessOrig.avaiquests);
      local regions = { QuestMapFrame.DetailsFrame.RewardsFrame:GetRegions() };
      for index = 1, #regions do
         local region = regions[index];
         if ((region:GetObjectType() == "FontString") and (region:GetText() == QTR_Messages.rewards)) then
            region:SetText(QUEST_REWARDS);
         end
      end
      
      -- stałe elementy okna zadania:
      QuestInfoRewardsFrame.ItemChooseText:SetFont(Original_Font2, 13);
      QuestInfoRewardsFrame.ItemReceiveText:SetFont(Original_Font2, 13);
      QuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN[QTR_quest_ID].itemchoose);
      QuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN[QTR_quest_ID].itemreceive);
      QuestInfoSpellObjectiveLearnLabel:SetFont(Original_Font2, 13);
      QuestInfoSpellObjectiveLearnLabel:SetText(QTR_MessOrig.learnspell);
      QuestInfoXPFrame.ReceiveText:SetFont(Original_Font2, 13);
      QuestInfoXPFrame.ReceiveText:SetText(QTR_MessOrig.experience);
      QuestInfoRewardsFrame.XPFrame.ReceiveText:SetFont(Original_Font2, 13);
      QuestInfoRewardsFrame.XPFrame.ReceiveText:SetText(QTR_MessOrig.experience);
      MapQuestInfoRewardsFrame.ItemChooseText:SetFont(Original_Font2, 11);
      MapQuestInfoRewardsFrame.ItemReceiveText:SetFont(Original_Font2, 11);
      MapQuestInfoRewardsFrame.ItemChooseText:SetText(QTR_quest_EN[QTR_quest_ID].itemchoose);
      MapQuestInfoRewardsFrame.ItemReceiveText:SetText(QTR_quest_EN[QTR_quest_ID].itemreceive);
      QuestInfoRewardsFrame.PlayerTitleText:SetFont(Original_Font2, 13);
      QuestInfoRewardsFrame.PlayerTitleText:SetText(QTR_MessOrig.reward_title);
      QuestInfoRewardsFrame.QuestSessionBonusReward:SetFont(Original_Font2, 13);
      QuestInfoRewardsFrame.QuestSessionBonusReward:SetText(QTR_MessOrig.reward_bonus);
      if ( QuestInfoRewardsFrame:IsVisible() ) then
         for fontString in QuestInfoRewardsFrame.spellHeaderPool:EnumerateActive() do
            if (fontString:GetText() == QTR_Messages.reward_aura) then
               fontString:SetText(REWARD_AURA);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_spell) then
               fontString:SetText(REWARD_SPELL);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_companion) then
               fontString:SetText(REWARD_COMPANION);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_follower) then
               fontString:SetText(REWARD_FOLLOWER);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_reputation) then
               fontString:SetText(REWARD_REPUTATION);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_title) then
               fontString:SetText(REWARD_TITLE);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_tradeskill) then
               fontString:SetText(REWARD_TRADESKILL);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_unlock) then
               fontString:SetText(REWARD_UNLOCK);
               fontString:SetFont(Original_Font2, 13);
            end
            if (fontString:GetText() == QTR_Messages.reward_bonus) then
               fontString:SetText(REWARD_BONUS);
               fontString:SetFont(Original_Font2, 13);
            end
         end
      end
      if ( MapQuestInfoRewardsFrame:IsVisible() ) then
         for fontString in MapQuestInfoRewardsFrame.spellHeaderPool:EnumerateActive() do
            if (fontString:GetText() == QTR_Messages.reward_aura) then
               fontString:SetText(REWARD_AURA);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_spell) then
               fontString:SetText(REWARD_SPELL);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_companion) then
               fontString:SetText(REWARD_COMPANION);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_follower) then
               fontString:SetText(REWARD_FOLLOWER);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_reputation) then
               fontString:SetText(REWARD_REPUTATION);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_title) then
               fontString:SetText(REWARD_TITLE);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_tradeskill) then
               fontString:SetText(REWARD_TRADESKILL);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_unlock) then
               fontString:SetText(REWARD_UNLOCK);
               fontString:SetFont(Original_Font2, 11);
            end
            if (fontString:GetText() == QTR_Messages.reward_bonus) then
               fontString:SetText(REWARD_BONUS);
               fontString:SetFont(Original_Font2, 11);
            end
         end
      end
   end
end


function QTR_delayed3()
   QTR_ToggleButton4:SetText("wybierz wpierw quest");
   QTR_ToggleButton4:Hide();
   if (not QTR_wait(1,QTR_delayed4)) then
   ---
   end
end


function QTR_delayed4()
   if (ImmersionFrame.TitleButtons:IsVisible()) then
      if (ImmersionFrame.TitleButtons.Buttons[1] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[1]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[2] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[2]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[3] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[3]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end   
      if (ImmersionFrame.TitleButtons.Buttons[4] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[4]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
      if (ImmersionFrame.TitleButtons.Buttons[5] ~= nil ) then
         ImmersionFrame.TitleButtons.Buttons[5]:HookScript("OnClick", function() QTR_PrepareDelay(1) end);
      end
   end
   QTR_QuestPrepare('');
end;      


function QTR_PrepareDelay(czas)     -- wywoływane po kliknięciu na nazwę questu z listy NPC
   if (czas==1) then
      if (not QTR_wait(1,QTR_PrepareReload)) then
      ---
      end
   end
   if (czas==3) then
      if (not QTR_wait(3,QTR_PrepareReload)) then
      ---
      end
   end
   if (czas==9) then
      if (not QTR_wait(0.5,QTR_PrepareReload)) then
      ---
      end
   end
end;      


function QTR_PrepareReload()
   QTR_QuestPrepare('');
end;      


function QTR_Immersion()   -- wywoływanie tłumaczenia z opóźnieniem 0.2 sek
  ImmersionContentFrame.ObjectivesText:SetFont(QTR_Font2, 14);
  ImmersionContentFrame.ObjectivesText:SetText(QTR_quest_LG[QTR_quest_ID].objectives);
  ImmersionFrame.TalkBox.NameFrame.Name:SetFont(QTR_Font1, 20);
  ImmersionFrame.TalkBox.NameFrame.Name:SetText(QTR_quest_LG[QTR_quest_ID].title);
  ImmersionFrame.TalkBox.TextFrame.Text:SetFont(QTR_Font2, 14);
  if (QTR_quest_EN[QTR_quest_ID].completion and (strlen(QTR_quest_EN[QTR_quest_ID].completion)>0)) then   -- zdarzenie COMPLETION
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG[QTR_quest_ID].completion);
  elseif (QTR_quest_EN[QTR_quest_ID].progress and (strlen(QTR_quest_EN[QTR_quest_ID].progress)>0)) then   -- mamy zdarzenie PROGRESS
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG[QTR_quest_ID].progress);
  else                                                                                                    -- mamy zdarzenie DETAILS
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_LG[QTR_quest_ID].details);
  end
  QTR_Immersion_Static();        -- inne statyczne dane
end


function QTR_Immersion_Static() 
   ImmersionContentFrame.ObjectivesHeader:SetFont(QTR_Font1, 18);
   ImmersionContentFrame.ObjectivesHeader:SetText(QTR_Messages.objectives);  -- "Zadanie"
   ImmersionContentFrame.RewardsFrame.Header:SetFont(QTR_Font1, 18);
   ImmersionContentFrame.RewardsFrame.Header:SetText(QTR_Messages.rewards);  -- "Nagrody"
   ImmersionContentFrame.RewardsFrame.ItemChooseText:SetFont(QTR_Font2, 13);
   ImmersionContentFrame.RewardsFrame.ItemChooseText:SetText(QTR_quest_LG[QTR_quest_ID].itemchoose); -- "Możesz wybrać nagrodę:"
   ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetFont(QTR_Font2, 13);
   ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetText(QTR_quest_LG[QTR_quest_ID].itemreceive); -- "Otrzymasz w nagrodę:"
   ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetFont(QTR_Font2, 13);
   ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetText(QTR_Messages.experience);  -- "Doświadczenie"
   ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetFont(QTR_Font1, 18);
   ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetText(QTR_Messages.reqitems);  -- "Wymagane itemy:"
   for fontString in ImmersionContentFrame.RewardsFrame.spellHeaderPool:EnumerateActive() do
      if (fontString:GetText() == REWARD_AURA) then
         fontString:SetText(QTR_Messages.reward_aura);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_SPELL) then
         fontString:SetText(QTR_Messages.reward_spell);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_COMPANION) then
         fontString:SetText(QTR_Messages.reward_companion);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_FOLLOWER) then
         fontString:SetText(QTR_Messages.reward_follower);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_REPUTATION) then
         fontString:SetText(QTR_Messages.reward_reputation);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_TITLE) then
         fontString:SetText(QTR_Messages.reward_title);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_TRADESKILL) then
         fontString:SetText(QTR_Messages.reward_tradeskill);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_UNLOCK) then
         fontString:SetText(QTR_Messages.reward_unlock);
         fontString:SetFont(QTR_Font2, 13);
      end
      if (fontString:GetText() == REWARD_BONUS) then
         fontString:SetText(QTR_Messages.reward_bonus);
         fontString:SetFont(QTR_Font2, 13);
      end
   end
end


function QTR_Immersion_OFF()   -- wywoływanie oryginału
  ImmersionContentFrame.ObjectivesText:SetFont(Original_Font2, 14);
  ImmersionContentFrame.ObjectivesText:SetText(QTR_quest_EN[QTR_quest_ID].objectives);
  ImmersionFrame.TalkBox.NameFrame.Name:SetFont(Original_Font1, 20);
  ImmersionFrame.TalkBox.NameFrame.Name:SetText(QTR_quest_EN[QTR_quest_ID].title);
  ImmersionFrame.TalkBox.TextFrame.Text:SetFont(Original_Font2, 14);
  if (QTR_quest_EN[QTR_quest_ID].completion and (strlen(QTR_quest_EN[QTR_quest_ID].completion)>0)) then   -- przywróć oryginalny tekst
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN[QTR_quest_ID].completion);
  elseif (QTR_quest_EN[QTR_quest_ID].progress and (strlen(QTR_quest_EN[QTR_quest_ID].progress)>0)) then
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN[QTR_quest_ID].progress);
  else
     ImmersionFrame.TalkBox.TextFrame.Text:SetText(QTR_quest_EN[QTR_quest_ID].details);
  end
  QTR_Immersion_OFF_Static();       -- inne statyczne dane
end


function QTR_Immersion_OFF_Static()
  ImmersionContentFrame.ObjectivesHeader:SetFont(Original_Font1, 18);
  ImmersionContentFrame.ObjectivesHeader:SetText(QTR_MessOrig.objectives);  -- "Zadanie"
  ImmersionContentFrame.RewardsFrame.Header:SetFont(Original_Font1, 18);
  ImmersionContentFrame.RewardsFrame.Header:SetText(QTR_MessOrig.rewards);  -- "Nagroda"
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemChooseText:SetText(QTR_quest_EN[QTR_quest_ID].itemchoose); -- "Możesz wybrać nagrodę:"
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.ItemReceiveText:SetText(QTR_quest_EN[QTR_quest_ID].itemreceive); -- "Otrzymasz w nagrodę:"
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetFont(Original_Font2, 13);
  ImmersionContentFrame.RewardsFrame.XPFrame.ReceiveText:SetText(QTR_MessOrig.experience);  -- "Doświadczenie"
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetFont(Original_Font1, 18);
  ImmersionFrame.TalkBox.Elements.Progress.ReqText:SetText(QTR_MessOrig.reqitems);  -- "Wymagane itemy:"
end


function QTR_Storyline_Delay()
   QTR_Storyline(1);
end


function QTR_Storyline_Quest()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1" and Storyline_NPCFrame:IsVisible()) then
      QTR_QuestPrepare('');
   end
end


function QTR_Storyline_Hide()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1") then
      QTR_ToggleButton5:Hide();
   end
end


function QTR_Storyline_Objectives()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1" and QTR_quest_ID>0) then
      local string_ID= tostring(QTR_quest_ID);
      Storyline_NPCFrameObjectivesContent.Title:SetText('Zadanie');
      if (QTR_QuestData[string_ID] ) then
         Storyline_NPCFrameObjectivesContent.Objectives:SetText(QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Objectives"],true));
         Storyline_NPCFrameObjectivesContent.Objectives:SetFont(QTR_Font2, 13);
      end   
      if (Storyline_RewardsHeader0) then
         Storyline_RewardsHeader0:SetText(QTR_quest_LG[QTR_quest_ID].itemreceive);
         Storyline_RewardsHeader0:SetFont(QTR_Font2, 13);
      end
      if (Storyline_RewardsHeader1) then
         if (Storyline_RewardsHeader1:GetText() == REWARD_AURA) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_aura);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_SPELL) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_spell);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_COMPANION) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_companion);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_FOLLOWER) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_follower);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_REPUTATION) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_reputation);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_TITLE) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_title);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_TRADESKILL) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_tradeskill);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_UNLOCK) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_unlock);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         elseif (Storyline_RewardsHeader1:GetText() == REWARD_BONUS) then
            Storyline_RewardsHeader1:SetText(QTR_Messages.reward_bonus);
            Storyline_RewardsHeader1:SetFont(QTR_Font2, 13);
         end
      end
   end
end


function QTR_Storyline_Rewards()
   if (QTR_PS["active"]=="1" and QTR_PS["other3"]=="1") then
      Storyline_NPCFrameRewards.Content.Title:SetText('Nagrody');
   end
end


function QTR_Storyline(nr)
   if (QTR_PS["transtitle"]=="1") then
      Storyline_NPCFrame.Banner.Title:SetText(QTR_quest_LG[QTR_quest_ID].title);
      Storyline_NPCFrame.Banner.Title:SetFont(QTR_Font2, 18);
   end
   local string_ID= tostring(QTR_quest_ID);
   local texts = { "" };
   if ((Storyline_NPCFrameChat.event ~= nil) and (QTR_QuestData[string_ID] ~= nil))then
      local event = Storyline_NPCFrameChat.event;
      if (event=="QUEST_DETAIL") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Description"],false)) };
      end   
      if (event=="QUEST_PROGRESS") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Progress"],false)) };
      end   
      if (event=="QUEST_COMPLETE") then
     	   texts = { strsplit("\n", QTR_ExpandUnitInfo(QTR_QuestData[string_ID]["Completion"],false)) };
      end   
   end
   local ileOry = #Storyline_NPCFrameChat.texts;
   local indeks = 0;
   for i=1,#texts do
      if texts[i]:len() > 0 then
         if (indeks<ileOry) then
            indeks=indeks+1;
            Storyline_NPCFrameChat.texts[indeks]=texts[i];
         end
      end
   end
   Storyline_NPCFrameChatText:SetFont(QTR_Font2, 16);
   if (nr==1) then      -- Reload text
      Storyline_NPCFrameObjectivesContent:Hide();
      Storyline_NPCFrame.chat.currentIndex = 0;
      Storyline_API.playNext(Storyline_NPCFrameModelsYou);  -- reload
   end
end


function QTR_Storyline_OFF(nr)
   if (QTR_PS["transtitle"]=="1") then
      Storyline_NPCFrame.Banner.Title:SetText(QTR_quest_EN[QTR_quest_ID].title);
      Storyline_NPCFrame.Banner.Title:SetFont(Original_Font2, 18);
   end
   local string_ID= tostring(QTR_quest_ID);
   local texts = { "" };
   if ((Storyline_NPCFrameChat.event ~= nil) and (QTR_QuestData[string_ID] ~= nil))then
      local event = Storyline_NPCFrameChat.event;
      if (event=="QUEST_DETAIL") then
     	   texts = { strsplit("\n", GetQuestText()) };
      end   
      if (event=="QUEST_PROGRESS") then
     	   texts = { strsplit("\n", GetProgressText()) };
      end   
      if (event=="QUEST_COMPLETE") then
     	   texts = { strsplit("\n", GetRewardText()) };
      end   
   end
   local ileOry = #Storyline_NPCFrameChat.texts;
   local indeks = 0;
   for i=1,#texts do
      if texts[i]:len() > 0 then
         if (indeks<ileOry) then
            indeks=indeks+1;
            Storyline_NPCFrameChat.texts[indeks]=texts[i];
         end
      end
   end
   Storyline_NPCFrameChatText:SetFont(Original_Font2, 16);
   if (nr==1) then      -- Reload text
      Storyline_NPCFrameObjectivesContent:Hide();
      Storyline_NPCFrame.chat.currentIndex = 0;
      Storyline_API.playNext(Storyline_NPCFrameModelsYou);  -- reload
   end
end


-- podmieniaj specjane znaki w tekście
function QTR_ExpandUnitInfo(msg,OnObjectives)
   if (msg == nil) then
      msg = "";
   end
   msg = string.gsub(msg, "NEW_LINE", "\n");
   msg = string.gsub(msg, "YOUR_NAME0", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME1", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME2", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME3", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME4", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME5", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME6", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME7", QTR_name);
   msg = string.gsub(msg, "YOUR_NAME", QTR_name);
   
-- jeszcze obsłużyć YOUR_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "YOUR_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "YOUR_GENDER");
   end

-- jeszcze obsłużyć NPC_GENDER(x;y)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local NPC_sex = UnitSex("npc");     -- 1:neutral,  2:męski,  3:żeński
   local nr_poz = string.find(msg, "NPC_GENDER");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (NPC_sex==3) then        -- forma żeńska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                        -- forma męska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "NPC_GENDER");
   end

-- jeszcze obsłużyć OWN_NAME(EN;PL)
   local nr_1, nr_2, nr_3 = 0;
   local QTR_forma = "";
   local nr_poz = string.find(msg, "OWN_NAME");    -- gdy nie znalazł, jest: nil
   while (nr_poz and nr_poz>0) do
      nr_1 = nr_poz + 1;   
      while (string.sub(msg, nr_1, nr_1) ~= "(") do
         nr_1 = nr_1 + 1;
      end
      if (string.sub(msg, nr_1, nr_1) == "(") then
         nr_2 =  nr_1 + 1;
         while (string.sub(msg, nr_2, nr_2) ~= ";") do
            nr_2 = nr_2 + 1;
         end
         if (string.sub(msg, nr_2, nr_2) == ";") then
            nr_3 = nr_2 + 1;
            while (string.sub(msg, nr_3, nr_3) ~= ")") do
               nr_3 = nr_3 + 1;
            end
            if (string.sub(msg, nr_3, nr_3) == ")") then
               if (QTR_PS["ownname"] == "1") then        -- forma polska
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               else                                      -- forma angielska
                  QTR_forma = string.sub(msg,nr_1+1,nr_2-1);
               end
               if ((QTR_PS["ownname_obj"] == "1") and OnObjectives) then        -- zawsze forma angielska w Objectives
                  QTR_forma = string.sub(msg,nr_2+1,nr_3-1);
               end
               msg = string.sub(msg,1,nr_poz-1) .. QTR_forma .. string.sub(msg,nr_3+1);
            end   
         end
      end
      nr_poz = string.find(msg, "OWN_NAME");
   end

   if (QTR_sex==3) then        -- płeć żeńska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D2);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C2);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B2);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N2);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K2);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W2);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M2);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D2);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C2);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B2);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K2);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W2);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M2);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ą YOUR_RACE", "ą "..player_race.N2);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N2);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W2);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ą YOUR_CLASS", "ą "..player_class.N2);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N2);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M2);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M2.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M2);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M2);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B2);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B2);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B2.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B2);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W2);                      -- Wołacz - pozostałe wystąpienia
   else                    -- płeć męska
      msg = string.gsub(msg, "YOUR_CLASS1", player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_CLASS2", player_class.D1);          -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_CLASS3", player_class.C1);          -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_CLASS4", player_class.B1);          -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS5", player_class.N1);          -- Narzędnik (z kim, z czym?)
      msg = string.gsub(msg, "YOUR_CLASS6", player_class.K1);          -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_CLASS7", player_class.W1);          -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE1", player_race.M1);            -- Mianownik (kto, co?)
      msg = string.gsub(msg, "YOUR_RACE2", player_race.D1);            -- Dopełniacz (kogo, czego?)
      msg = string.gsub(msg, "YOUR_RACE3", player_race.C1);            -- Celownik (komu, czemu?)
      msg = string.gsub(msg, "YOUR_RACE4", player_race.B1);            -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_RACE5", player_race.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE6", player_race.K1);            -- Miejscownik (o kim, o czym?)
      msg = string.gsub(msg, "YOUR_RACE7", player_race.W1);            -- Wołacz (o!)
      msg = string.gsub(msg, "YOUR_RACE YOUR_CLASS", "YOUR_RACE "..player_class.M1);     -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ym YOUR_RACE", "ym "..player_race.N1);              -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " jesteś YOUR_RACE", " jesteś "..player_race.N1);    -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "YOUR_RACE", player_race.W1);                        -- Wołacz - pozostałe wystąpienia
      msg = string.gsub(msg, "ym YOUR_CLASS", "ym "..player_class.N1);            -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, "esteś YOUR_CLASS", "esteś "..player_class.N1);      -- Narzędnik (kim, czym?)
      msg = string.gsub(msg, " z Ciebie YOUR_CLASS", " z Ciebie "..player_class.M1);    -- Mianownik (kto, co?)
      msg = string.gsub(msg, " kolejny YOUR_CLASS do ", " kolejny "..player_class.M1.." do ");   -- Mianownik (kto, co?)
      msg = string.gsub(msg, " taki YOUR_CLASS", " taki "..player_class.M1);      -- Mianownik (kto, co?)
      msg = string.gsub(msg, "ako YOUR_CLASS", "ako "..player_class.M1);          -- Mianownik (kto, co?)
      msg = string.gsub(msg, " co sprowadza YOUR_CLASS", " co sprowadza "..player_class.B1);     -- Biernik (kogo, co?)
      msg = string.gsub(msg, " będę miał YOUR_CLASS", " będę miał "..player_class.B1);  -- Biernik (kogo, co?)
      msg = string.gsub(msg, "ego YOUR_CLASS", "ego "..player_class.B1);                -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS taki jak ", player_class.B1.." taki jak ");    -- Biernik (kogo, co?)
      msg = string.gsub(msg, " jak na YOUR_CLASS", " jak na "..player_class.B1);        -- Biernik (kogo, co?)
      msg = string.gsub(msg, "YOUR_CLASS", player_class.W1);                      -- Wołacz - pozostałe wystąpienia
   end
   
   return msg;
end


function QTR_ScrollFrame_OnMouseWheel(self, step)
   local newValue = self:GetVerticalScroll() - (step * 15);
   if (newValue < 0) then
      newValue = 0;
   elseif (newValue > self:GetVerticalScrollRange()) then
      newValue = self:GetVerticalScrollRange();
   end
   self:SetVerticalScroll(newValue);
end


function QTR_ShowHideStatystyka()
   if (Players_ver_Count < 1) then          -- liczba graczy w tablicy Players_ver
      QTR_STframe.count:SetText("1 ");
   else
      QTR_STframe.count:SetText(tostring(Players_ver_Count));
   end
   local tabelka1 = "|cFF00FF00Nazwa gracza|r";
   local tabelka2 = string.format("|cFF00FF00%6s %8s %12s %13s %13s|r", "Wersja", " Baza ", "Data bazy", "Gossip", "Data gossip");

   local alert = 0;
   table.sort(Players_ver);
   for Name,Value in pairs(Players_ver) do
      tabelka1 = tabelka1 .. "\n" .. Name;
      if (tonumber(Value.VERSION)>tonumber(string.sub(QTR_version,1,1)..string.sub(QTR_version,-2)) and (Value.VERSION==Version_max.ADDON_VER)) then
         Value.VERSION = "|cFFFFFF00"..Value.VERSION.."|r";    -- w kolorze żółtym
         alert = 4;
      end
      if (tonumber(Value.BASE)>tonumber(QTR_base) and (Value.BASE==Version_max.BASE_VER)) then
         Value.BASE = "|cFFFFFF00"..Value.BASE.."|r";          -- w kolorze żółtym
         alert = alert + 2;
      end
      if (tonumber(Value.GOSSIP)>tonumber(GS_base) and (Value.GOSSIP==Version_max.GOSSIP_VER)) then
         Value.GOSSIP = "|cFFFFFF00"..Value.GOSSIP.."|r";      -- w kolorze żółtym
         alert = alert + 1;
      end
      tabelka2 = tabelka2 .. "\n" .. string.format("%6s %9s   %-13s %-7s %12s", Value.VERSION, Value.BASE, Value.DATE, Value.GOSSIP, Value.DATE2);
   end
   if (alert > 3) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja dodatku: |cFFFFFF00" .. Version_max.ADDON_VER .. "|r");
   elseif (alert > 1 ) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja bazy tłumaczeń");
   elseif (alert > 0 ) then
      QTR_STframe.alert:SetText("Dostępna jest nowa wersja bazy GOSSIP");
   end
   QTR_STframe.tabela1:SetText(tabelka1);
   QTR_STframe.tabela2:SetText(tabelka2);
   QTR_STframe:Show();
end


function QTR_ShowHideUstawienia()         -- otwarcie przycisku Ustawienia głosowe
   QTR_SeTframeCheck1:SetValue(QTR_PS["voice1"]=="1");
   QTR_SeTframeCheck2:SetValue(QTR_PS["voice2"]=="1");
   QTR_SeTframeCheck3:SetValue(QTR_PS["voice3"]=="1");
   QTR_SeTframeCheck4:SetValue(QTR_PS["voice4"]=="1");
   QTR_SeTframeCheck5:SetValue(QTR_PS["voice5"]=="1");
   QTR_SeTframeCheck6:SetValue(QTR_PS["voice6"]=="1");
   QTR_SeTframeCheck7:SetValue(QTR_PS["voice7"]=="1");
   QTR_SeTframe:Show();
end


function QTR_ShowHideUstawieniaReklama()  -- otwarcie przycisku Ustawienia reklamowe
   QTRReklEditBox:SetText(QTR_PS["channel"]);
   QTRCheckText1:SetValue(QTR_PS["text1"]=="1");
   QTRCheckText2:SetValue(QTR_PS["text2"]=="1");
   QTR_SeRframe:Show();
end


QTR = CreateFrame("Frame");
QTR:SetScript("OnEvent", QTR_OnEvent);
QTR:RegisterEvent("ADDON_LOADED");
QTR:RegisterEvent("QUEST_ACCEPTED");
QTR:RegisterEvent("QUEST_DETAIL");
QTR:RegisterEvent("QUEST_PROGRESS");
QTR:RegisterEvent("QUEST_COMPLETE");
--  QTR:RegisterEvent("QUEST_LOG_UPDATE");
